/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.parser.IRStaticScope;
import org.jruby.parser.StaticScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IRScriptBody
extends IRScope {
    private List<IRClosure> beginBlocks;
    private List<IRClosure> endBlocks;

    public IRScriptBody(IRManager manager, String className, String sourceName, StaticScope staticScope) {
        super(manager, null, sourceName, sourceName, 0, staticScope);
        if (!this.getManager().isDryRun() && staticScope != null) {
            ((IRStaticScope)staticScope).setIRScope(this);
        }
    }

    @Override
    public IRScope getNearestModuleReferencingScope() {
        return this;
    }

    @Override
    public LocalVariable getImplicitBlockArg() {
        assert (false) : "A Script body never accepts block args";
        return null;
    }

    @Override
    public String getScopeName() {
        return "ScriptBody";
    }

    @Override
    public String toString() {
        return "Script: file: " + this.getFileName() + super.toString();
    }

    @Override
    public void recordBeginBlock(IRClosure beginBlockClosure) {
        if (this.beginBlocks == null) {
            this.beginBlocks = new ArrayList<IRClosure>();
        }
        this.beginBlocks.add(beginBlockClosure);
    }

    @Override
    public void recordEndBlock(IRClosure endBlockClosure) {
        if (this.endBlocks == null) {
            this.endBlocks = new ArrayList<IRClosure>();
        }
        this.endBlocks.add(endBlockClosure);
    }

    public List<IRClosure> getBeginBlocks() {
        return this.beginBlocks;
    }

    public List<IRClosure> getEndBlocks() {
        return this.endBlocks;
    }

    @Override
    public boolean isScriptScope() {
        return true;
    }
}

