/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketOption;
import jnr.unixsocket.UnixSocketChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SocketType {
    SOCKET(Sock.SOCK_STREAM){

        private Socket toSocket(Channel channel) {
            return ((SocketChannel)channel).socket();
        }

        public int getSoTimeout(Channel channel) throws IOException {
            return this.toSocket(channel).getSoTimeout();
        }

        public void setSoTimeout(Channel channel, int timeout2) throws IOException {
            this.toSocket(channel).setSoTimeout(timeout2);
        }

        public boolean getReuseAddress(Channel channel) throws IOException {
            return this.toSocket(channel).getReuseAddress();
        }

        public void setReuseAddress(Channel channel, boolean reuse) throws IOException {
            this.toSocket(channel).setReuseAddress(reuse);
        }

        public int getSendBufferSize(Channel channel) throws IOException {
            return this.toSocket(channel).getSendBufferSize();
        }

        public void setSendBufferSize(Channel channel, int size2) throws IOException {
            this.toSocket(channel).setSendBufferSize(size2);
        }

        public int getReceiveBufferSize(Channel channel) throws IOException {
            return this.toSocket(channel).getReceiveBufferSize();
        }

        public void setReceiveBufferSize(Channel channel, int i2) throws IOException {
            this.toSocket(channel).setReceiveBufferSize(i2);
        }

        public boolean getOOBInline(Channel channel) throws IOException {
            return this.toSocket(channel).getOOBInline();
        }

        public void setOOBInline(Channel channel, boolean b) throws IOException {
            this.toSocket(channel).setOOBInline(b);
        }

        public int getSoLinger(Channel channel) throws IOException {
            return this.toSocket(channel).getSoLinger();
        }

        public void setSoLinger(Channel channel, boolean b, int i2) throws IOException {
            this.toSocket(channel).setSoLinger(b, i2);
        }

        public boolean getKeepAlive(Channel channel) throws IOException {
            return this.toSocket(channel).getKeepAlive();
        }

        public void setKeepAlive(Channel channel, boolean b) throws IOException {
            this.toSocket(channel).setKeepAlive(b);
        }

        public boolean getTcpNoDelay(Channel channel) throws IOException {
            return this.toSocket(channel).getTcpNoDelay();
        }

        public void setTcpNoDelay(Channel channel, boolean b) throws IOException {
            this.toSocket(channel).setTcpNoDelay(b);
        }

        public SocketAddress getRemoteSocketAddress(Channel channel) {
            return this.toSocket(channel).getRemoteSocketAddress();
        }

        public SocketAddress getLocalSocketAddress(Channel channel) {
            return this.toSocket(channel).getLocalSocketAddress();
        }

        public void shutdownInput(Channel channel) throws IOException {
            this.toSocket(channel).shutdownInput();
        }

        public void shutdownOutput(Channel channel) throws IOException {
            this.toSocket(channel).shutdownOutput();
        }
    }
    ,
    SERVER(Sock.SOCK_STREAM){

        private ServerSocket toSocket(Channel channel) {
            return ((ServerSocketChannel)channel).socket();
        }

        public int getSoTimeout(Channel channel) throws IOException {
            return this.toSocket(channel).getSoTimeout();
        }

        public void setSoTimeout(Channel channel, int timeout2) throws IOException {
            this.toSocket(channel).setSoTimeout(timeout2);
        }

        public boolean getReuseAddress(Channel channel) throws IOException {
            return this.toSocket(channel).getReuseAddress();
        }

        public void setReuseAddress(Channel channel, boolean reuse) throws IOException {
            this.toSocket(channel).setReuseAddress(reuse);
        }

        public int getSendBufferSize(Channel channel) throws IOException {
            return 0;
        }

        public void setSendBufferSize(Channel channel, int size2) throws IOException {
        }

        public int getReceiveBufferSize(Channel channel) throws IOException {
            return this.toSocket(channel).getReceiveBufferSize();
        }

        public void setReceiveBufferSize(Channel channel, int i2) throws IOException {
            this.toSocket(channel).setReceiveBufferSize(i2);
        }

        public SocketAddress getLocalSocketAddress(Channel channel) {
            return this.toSocket(channel).getLocalSocketAddress();
        }
    }
    ,
    DATAGRAM(Sock.SOCK_DGRAM){

        private DatagramSocket toSocket(Channel channel) {
            return ((DatagramChannel)channel).socket();
        }

        public int getSoTimeout(Channel channel) throws IOException {
            return this.toSocket(channel).getSoTimeout();
        }

        public void setSoTimeout(Channel channel, int timeout2) throws IOException {
            this.toSocket(channel).setSoTimeout(timeout2);
        }

        public boolean getReuseAddress(Channel channel) throws IOException {
            return this.toSocket(channel).getReuseAddress();
        }

        public void setReuseAddress(Channel channel, boolean reuse) throws IOException {
            this.toSocket(channel).setReuseAddress(reuse);
        }

        public int getSendBufferSize(Channel channel) throws IOException {
            return this.toSocket(channel).getSendBufferSize();
        }

        public void setSendBufferSize(Channel channel, int size2) throws IOException {
            this.toSocket(channel).setSendBufferSize(size2);
        }

        public int getReceiveBufferSize(Channel channel) throws IOException {
            return this.toSocket(channel).getReceiveBufferSize();
        }

        public void setReceiveBufferSize(Channel channel, int i2) throws IOException {
            this.toSocket(channel).setReceiveBufferSize(i2);
        }

        public boolean getBroadcast(Channel channel) throws IOException {
            return this.toSocket(channel).getBroadcast();
        }

        public void setBroadcast(Channel channel, boolean b) throws IOException {
            this.toSocket(channel).setBroadcast(b);
        }

        public SocketAddress getRemoteSocketAddress(Channel channel) {
            return this.toSocket(channel).getRemoteSocketAddress();
        }

        public SocketAddress getLocalSocketAddress(Channel channel) {
            return this.toSocket(channel).getLocalSocketAddress();
        }
    }
    ,
    UNIX(Sock.SOCK_STREAM){

        private UnixSocketChannel toSocket(Channel channel) {
            return (UnixSocketChannel)channel;
        }

        public void shutdownInput(Channel channel) throws IOException {
            this.toSocket(channel).shutdownInput();
        }

        public void shutdownOutput(Channel channel) throws IOException {
            this.toSocket(channel).shutdownOutput();
        }
    }
    ,
    UNKNOWN(Sock.SOCK_STREAM);

    private final Sock sock;

    public static SocketType forChannel(Channel channel) {
        if (channel instanceof SocketChannel) {
            return SOCKET;
        }
        if (channel instanceof ServerSocketChannel) {
            return SERVER;
        }
        if (channel instanceof DatagramChannel) {
            return DATAGRAM;
        }
        if (channel instanceof UnixSocketChannel) {
            return UNIX;
        }
        return UNKNOWN;
    }

    public int getSoTimeout(Channel channel) throws IOException {
        return 0;
    }

    public void setSoTimeout(Channel channel, int timeout2) throws IOException {
    }

    public boolean getReuseAddress(Channel channel) throws IOException {
        return false;
    }

    public void setReuseAddress(Channel channel, boolean reuse) throws IOException {
    }

    public int getSendBufferSize(Channel channel) throws IOException {
        return 0;
    }

    public void setSendBufferSize(Channel channel, int size2) throws IOException {
    }

    public int getReceiveBufferSize(Channel channel) throws IOException {
        return 0;
    }

    public void setReceiveBufferSize(Channel channel, int i2) throws IOException {
    }

    public boolean getOOBInline(Channel channel) throws IOException {
        return false;
    }

    public void setOOBInline(Channel channel, boolean b) throws IOException {
    }

    public int getSoLinger(Channel channel) throws IOException {
        return 0;
    }

    public void setSoLinger(Channel channel, boolean b, int i2) throws IOException {
    }

    public boolean getKeepAlive(Channel channel) throws IOException {
        return false;
    }

    public void setKeepAlive(Channel channel, boolean b) throws IOException {
    }

    public boolean getTcpNoDelay(Channel channel) throws IOException {
        return false;
    }

    public void setTcpNoDelay(Channel channel, boolean b) throws IOException {
    }

    public boolean getBroadcast(Channel channel) throws IOException {
        return false;
    }

    public void setBroadcast(Channel channel, boolean b) throws IOException {
    }

    public void shutdownInput(Channel channel) throws IOException {
    }

    public void shutdownOutput(Channel channel) throws IOException {
    }

    public SocketAddress getRemoteSocketAddress(Channel channel) {
        return null;
    }

    public SocketAddress getLocalSocketAddress(Channel channel) {
        return null;
    }

    public Sock getSocketType() {
        return this.sock;
    }

    public int getSocketOption(Channel channel, SocketOption option) throws IOException {
        switch (option) {
            case SO_BROADCAST: {
                return this.getBroadcast(channel) ? 1 : 0;
            }
            case SO_KEEPALIVE: {
                return this.getKeepAlive(channel) ? 1 : 0;
            }
            case SO_LINGER: {
                int linger2 = this.getSoLinger(channel);
                return linger2 < 0 ? 0 : linger2;
            }
            case SO_OOBINLINE: {
                return this.getOOBInline(channel) ? 1 : 0;
            }
            case SO_RCVBUF: {
                return this.getReceiveBufferSize(channel);
            }
            case SO_REUSEADDR: {
                return this.getReuseAddress(channel) ? 1 : 0;
            }
            case SO_SNDBUF: {
                return this.getSendBufferSize(channel);
            }
            case SO_RCVTIMEO: 
            case SO_SNDTIMEO: {
                return this.getSoTimeout(channel);
            }
            case SO_TYPE: {
                return this.getSocketType().intValue();
            }
            case SO_RCVLOWAT: {
                return 1;
            }
            case SO_SNDLOWAT: {
                return 2048;
            }
            case SO_DEBUG: 
            case SO_ERROR: 
            case SO_DONTROUTE: 
            case SO_TIMESTAMP: {
                return 0;
            }
        }
        return 0;
    }

    public void setSocketOption(Channel channel, SocketOption option, int value2) throws IOException {
        switch (option) {
            case SO_BROADCAST: {
                this.setBroadcast(channel, SocketType.asBoolean(value2));
                break;
            }
            case SO_KEEPALIVE: {
                this.setKeepAlive(channel, SocketType.asBoolean(value2));
                break;
            }
            case SO_LINGER: {
                this.setSoLinger(channel, value2 <= 0, value2);
                break;
            }
            case SO_OOBINLINE: {
                this.setOOBInline(channel, SocketType.asBoolean(value2));
                break;
            }
            case SO_RCVBUF: {
                this.setReceiveBufferSize(channel, value2);
                break;
            }
            case SO_REUSEADDR: {
                this.setReuseAddress(channel, SocketType.asBoolean(value2));
                break;
            }
            case SO_SNDBUF: {
                this.setSendBufferSize(channel, value2);
                break;
            }
            case SO_RCVTIMEO: 
            case SO_SNDTIMEO: {
                this.setSoTimeout(channel, value2);
                break;
            }
        }
    }

    private static boolean asBoolean(int value2) {
        return value2 != 0;
    }

    private SocketType(Sock sock) {
        this.sock = sock;
    }
}

