/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class PKeyRSA
extends org.jruby.ext.openssl.PKey {
    private static final long serialVersionUID = 3675324750727019454L;
    private static ObjectAllocator PKEYRSA_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new PKeyRSA(runtime, klass);
        }
    };
    private volatile transient RSAPrivateCrtKey privKey;
    private volatile transient RSAPublicKey pubKey;
    private volatile transient BigInteger rsa_e;
    private volatile transient BigInteger rsa_n;
    private volatile transient BigInteger rsa_d;
    private volatile transient BigInteger rsa_p;
    private volatile transient BigInteger rsa_q;
    private volatile transient BigInteger rsa_dmp1;
    private volatile transient BigInteger rsa_dmq1;
    private volatile transient BigInteger rsa_iqmp;

    public static void createPKeyRSA(Ruby runtime, RubyModule mPKey) {
        RubyClass cRSA = mPKey.defineClassUnder("RSA", mPKey.getClass("PKey"), PKEYRSA_ALLOCATOR);
        RubyClass pkeyError = mPKey.getClass("PKeyError");
        mPKey.defineClassUnder("RSAError", pkeyError, pkeyError.getAllocator());
        cRSA.defineAnnotatedMethods(PKeyRSA.class);
        cRSA.setConstant("PKCS1_PADDING", runtime.newFixnum(1));
        cRSA.setConstant("SSLV23_PADDING", runtime.newFixnum(2));
        cRSA.setConstant("NO_PADDING", runtime.newFixnum(3));
        cRSA.setConstant("PKCS1_OAEP_PADDING", runtime.newFixnum(4));
    }

    public static RaiseException newRSAError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::PKey::RSAError", message2);
    }

    public PKeyRSA(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public PKeyRSA(Ruby runtime, RubyClass type2, RSAPrivateCrtKey privKey, RSAPublicKey pubKey) {
        super(runtime, type2);
        this.privKey = privKey;
        this.pubKey = pubKey;
    }

    public PKeyRSA(Ruby runtime, RubyClass type2, RSAPublicKey pubKey) {
        this(runtime, type2, null, pubKey);
    }

    PublicKey getPublicKey() {
        return this.pubKey;
    }

    PrivateKey getPrivateKey() {
        return this.privKey;
    }

    String getAlgorithm() {
        return "RSA";
    }

    @JRubyMethod(name={"generate"}, meta=true, rest=true)
    public static IRubyObject generate(IRubyObject recv2, IRubyObject[] args2) {
        BigInteger exp2 = RSAKeyGenParameterSpec.F4;
        if (Arity.checkArgumentCount(recv2.getRuntime(), args2, 1, 2) == 2) {
            exp2 = args2[1] instanceof RubyFixnum ? BigInteger.valueOf(RubyNumeric.num2long(args2[1])) : ((RubyBignum)args2[1]).getValue();
        }
        int keysize = RubyNumeric.fix2int(args2[0]);
        PKeyRSA rsa = new PKeyRSA(recv2.getRuntime(), (RubyClass)recv2);
        PKeyRSA.rsaGenerate(rsa, keysize, exp2);
        return rsa;
    }

    private static void rsaGenerate(PKeyRSA rsa, int keysize, BigInteger exp2) throws RaiseException {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(new RSAKeyGenParameterSpec(keysize, exp2), new SecureRandom());
            KeyPair pair = gen.generateKeyPair();
            rsa.privKey = (RSAPrivateCrtKey)pair.getPrivate();
            rsa.pubKey = (RSAPublicKey)pair.getPublic();
        }
        catch (Exception e) {
            throw PKeyRSA.newRSAError(rsa.getRuntime(), e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(frame=true, rest=true)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        IRubyObject pass2 = null;
        char[] passwd2 = null;
        if (Arity.checkArgumentCount(this.getRuntime(), args2, 0, 2) == 0) {
            this.privKey = null;
            this.pubKey = null;
            return this;
        }
        IRubyObject arg2 = args2[0];
        if (args2.length > 1) {
            pass2 = args2[1];
        }
        if (arg2 instanceof RubyFixnum) {
            int keysize = RubyNumeric.fix2int(arg2);
            BigInteger exp2 = RSAKeyGenParameterSpec.F4;
            if (null != pass2 && !pass2.isNil()) {
                exp2 = BigInteger.valueOf(RubyNumeric.num2long(pass2));
            }
            PKeyRSA.rsaGenerate(this, keysize, exp2);
            return this;
        }
        if (pass2 != null && !pass2.isNil()) {
            passwd2 = pass2.toString().toCharArray();
        }
        arg2 = OpenSSLImpl.to_der_if_possible(arg2);
        RubyString str = arg2.convertToString();
        Serializable val = null;
        KeyFactory fact = null;
        try {
            fact = KeyFactory.getInstance("RSA");
        }
        catch (Exception e) {
            throw this.getRuntime().newRuntimeError("unsupported key algorithm (RSA)");
        }
        if (null == val) {
            try {
                val = PEMInputOutput.readPrivateKey(new StringReader(str.toString()), passwd2);
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PEMInputOutput.readRSAPublicKey(new StringReader(str.toString()), passwd2);
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PEMInputOutput.readRSAPubKey(new StringReader(str.toString()));
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PKey.readRSAPrivateKey(str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PKey.readRSAPublicKey(str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = fact.generatePrivate(new PKCS8EncodedKeySpec(str.getBytes()));
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = fact.generatePublic(new X509EncodedKeySpec(str.getBytes()));
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "Neither PUB key nor PRIV key:");
        }
        if (val instanceof KeyPair) {
            PrivateKey privateKey = ((KeyPair)val).getPrivate();
            PublicKey publicKey = ((KeyPair)val).getPublic();
            if (!(privateKey instanceof RSAPrivateCrtKey)) throw PKeyRSA.newRSAError(this.getRuntime(), "Neither PUB key nor PRIV key:");
            this.privKey = (RSAPrivateCrtKey)privateKey;
            this.pubKey = (RSAPublicKey)publicKey;
            return this;
        } else if (val instanceof RSAPrivateCrtKey) {
            this.privKey = (RSAPrivateCrtKey)val;
            try {
                this.pubKey = (RSAPublicKey)fact.generatePublic(new RSAPublicKeySpec(this.privKey.getModulus(), this.privKey.getPublicExponent()));
                return this;
            }
            catch (Exception e) {
                throw PKeyRSA.newRSAError(this.getRuntime(), "Something rotten with private key");
            }
        } else {
            if (!(val instanceof RSAPublicKey)) throw PKeyRSA.newRSAError(this.getRuntime(), "Neither PUB key nor PRIV key:");
            this.pubKey = (RSAPublicKey)val;
            this.privKey = null;
        }
        return this;
    }

    @JRubyMethod(name={"public?"})
    public IRubyObject public_p() {
        return this.pubKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"private?"})
    public IRubyObject private_p() {
        return this.privKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            byte[] bytes2 = PKey.toDerRSAKey(this.pubKey, this.privKey);
            return RubyString.newString(this.getRuntime(), bytes2);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyRSA.newRSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyRSA.newRSAError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject public_key() {
        PKeyRSA val = new PKeyRSA(this.getRuntime(), this.getMetaClass().getRealClass());
        val.privKey = null;
        val.pubKey = this.pubKey;
        return val;
    }

    @JRubyMethod
    public IRubyObject params() {
        ThreadContext ctx = this.getRuntime().getCurrentContext();
        RubyHash hash2 = RubyHash.newHash(this.getRuntime());
        if (this.privKey != null) {
            hash2.op_aset(ctx, this.getRuntime().newString("iqmp"), BN.newBN(this.getRuntime(), this.privKey.getCrtCoefficient()));
            hash2.op_aset(ctx, this.getRuntime().newString("n"), BN.newBN(this.getRuntime(), this.privKey.getModulus()));
            hash2.op_aset(ctx, this.getRuntime().newString("d"), BN.newBN(this.getRuntime(), this.privKey.getPrivateExponent()));
            hash2.op_aset(ctx, this.getRuntime().newString("p"), BN.newBN(this.getRuntime(), this.privKey.getPrimeP()));
            hash2.op_aset(ctx, this.getRuntime().newString("e"), BN.newBN(this.getRuntime(), this.privKey.getPublicExponent()));
            hash2.op_aset(ctx, this.getRuntime().newString("q"), BN.newBN(this.getRuntime(), this.privKey.getPrimeQ()));
            hash2.op_aset(ctx, this.getRuntime().newString("dmq1"), BN.newBN(this.getRuntime(), this.privKey.getPrimeExponentQ()));
            hash2.op_aset(ctx, this.getRuntime().newString("dmp1"), BN.newBN(this.getRuntime(), this.privKey.getPrimeExponentP()));
        } else {
            hash2.op_aset(ctx, this.getRuntime().newString("iqmp"), BN.newBN(this.getRuntime(), BigInteger.ZERO));
            hash2.op_aset(ctx, this.getRuntime().newString("n"), BN.newBN(this.getRuntime(), this.pubKey.getModulus()));
            hash2.op_aset(ctx, this.getRuntime().newString("d"), BN.newBN(this.getRuntime(), BigInteger.ZERO));
            hash2.op_aset(ctx, this.getRuntime().newString("p"), BN.newBN(this.getRuntime(), BigInteger.ZERO));
            hash2.op_aset(ctx, this.getRuntime().newString("e"), BN.newBN(this.getRuntime(), this.pubKey.getPublicExponent()));
            hash2.op_aset(ctx, this.getRuntime().newString("q"), BN.newBN(this.getRuntime(), BigInteger.ZERO));
            hash2.op_aset(ctx, this.getRuntime().newString("dmq1"), BN.newBN(this.getRuntime(), BigInteger.ZERO));
            hash2.op_aset(ctx, this.getRuntime().newString("dmp1"), BN.newBN(this.getRuntime(), BigInteger.ZERO));
        }
        return hash2;
    }

    @JRubyMethod
    public IRubyObject to_text() {
        StringBuilder result2 = new StringBuilder();
        if (this.privKey != null) {
            int len = this.privKey.getModulus().bitLength();
            result2.append("Private-Key: (").append(len).append(" bit)").append("\n");
            result2.append("modulus:");
            PKeyRSA.addSplittedAndFormatted(result2, this.privKey.getModulus());
            result2.append("publicExponent: ").append(this.privKey.getPublicExponent()).append(" (0x").append(this.privKey.getPublicExponent().toString(16)).append(")\n");
            result2.append("privateExponent:");
            PKeyRSA.addSplittedAndFormatted(result2, this.privKey.getPrivateExponent());
            result2.append("prime1:");
            PKeyRSA.addSplittedAndFormatted(result2, this.privKey.getPrimeP());
            result2.append("prime2:");
            PKeyRSA.addSplittedAndFormatted(result2, this.privKey.getPrimeQ());
            result2.append("exponent1:");
            PKeyRSA.addSplittedAndFormatted(result2, this.privKey.getPrimeExponentP());
            result2.append("exponent2:");
            PKeyRSA.addSplittedAndFormatted(result2, this.privKey.getPrimeExponentQ());
            result2.append("coefficient:");
            PKeyRSA.addSplittedAndFormatted(result2, this.privKey.getCrtCoefficient());
        } else {
            int len = this.pubKey.getModulus().bitLength();
            result2.append("Modulus (").append(len).append(" bit):");
            PKeyRSA.addSplittedAndFormatted(result2, this.pubKey.getModulus());
            result2.append("Exponent: ").append(this.pubKey.getPublicExponent()).append(" (0x").append(this.pubKey.getPublicExponent().toString(16)).append(")\n");
        }
        return this.getRuntime().newString(result2.toString());
    }

    @JRubyMethod(name={"export", "to_pem", "to_s"}, rest=true)
    public IRubyObject export(IRubyObject[] args2) {
        StringWriter w = new StringWriter();
        Arity.checkArgumentCount(this.getRuntime(), args2, 0, 2);
        CipherSpec ciph = null;
        char[] passwd2 = null;
        if (args2.length > 0 && !args2[0].isNil()) {
            Cipher c = (Cipher)args2[0];
            ciph = new CipherSpec(c.getCipher(), c.getName(), c.getKeyLen() * 8);
            if (args2.length > 1 && !args2[1].isNil()) {
                passwd2 = args2[1].toString().toCharArray();
            }
        }
        try {
            if (this.privKey != null) {
                PEMInputOutput.writeRSAPrivateKey(w, this.privKey, ciph, passwd2);
            } else {
                PEMInputOutput.writeRSAPublicKey(w, this.pubKey);
            }
            w.close();
            return this.getRuntime().newString(w.toString());
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyRSA.newRSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyRSA.newRSAError(this.getRuntime(), ioe.getMessage());
        }
    }

    private String getPadding(int padding) {
        if (padding < 1 || padding > 4) {
            throw PKeyRSA.newRSAError(this.getRuntime(), null);
        }
        String p2 = "/ECB/PKCS1Padding";
        if (padding == 3) {
            p2 = "/ECB/NoPadding";
        } else if (padding == 4) {
            p2 = "/ECB/OAEPWithMD5AndMGF1Padding";
        } else if (padding == 2) {
            p2 = "/ECB/ISO9796-1Padding";
        }
        return p2;
    }

    @JRubyMethod(rest=true)
    public IRubyObject private_encrypt(IRubyObject[] args2) {
        int padding = 1;
        if (Arity.checkArgumentCount(this.getRuntime(), args2, 1, 2) == 2 && !args2[1].isNil()) {
            padding = RubyNumeric.fix2int(args2[1]);
        }
        String p2 = this.getPadding(padding);
        RubyString buffer = args2[0].convertToString();
        if (this.privKey == null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "private key needed.");
        }
        try {
            javax.crypto.Cipher engine = javax.crypto.Cipher.getInstance("RSA" + p2);
            engine.init(1, this.privKey);
            byte[] outp = engine.doFinal(buffer.getBytes());
            return RubyString.newString(this.getRuntime(), outp);
        }
        catch (GeneralSecurityException gse) {
            throw PKeyRSA.newRSAError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod(rest=true)
    public IRubyObject private_decrypt(IRubyObject[] args2) {
        int padding = 1;
        if (Arity.checkArgumentCount(this.getRuntime(), args2, 1, 2) == 2 && !args2[1].isNil()) {
            padding = RubyNumeric.fix2int(args2[1]);
        }
        String p2 = this.getPadding(padding);
        RubyString buffer = args2[0].convertToString();
        if (this.privKey == null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "private key needed.");
        }
        try {
            javax.crypto.Cipher engine = javax.crypto.Cipher.getInstance("RSA" + p2);
            engine.init(2, this.privKey);
            byte[] outp = engine.doFinal(buffer.getBytes());
            return RubyString.newString(this.getRuntime(), outp);
        }
        catch (GeneralSecurityException gse) {
            throw PKeyRSA.newRSAError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod(rest=true)
    public IRubyObject public_encrypt(IRubyObject[] args2) {
        int padding = 1;
        if (Arity.checkArgumentCount(this.getRuntime(), args2, 1, 2) == 2 && !args2[1].isNil()) {
            padding = RubyNumeric.fix2int(args2[1]);
        }
        String p2 = this.getPadding(padding);
        RubyString buffer = args2[0].convertToString();
        try {
            javax.crypto.Cipher engine = javax.crypto.Cipher.getInstance("RSA" + p2);
            engine.init(1, this.pubKey);
            byte[] outp = engine.doFinal(buffer.getBytes());
            return RubyString.newString(this.getRuntime(), outp);
        }
        catch (GeneralSecurityException gse) {
            throw PKeyRSA.newRSAError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod(rest=true)
    public IRubyObject public_decrypt(IRubyObject[] args2) {
        int padding = 1;
        if (Arity.checkArgumentCount(this.getRuntime(), args2, 1, 2) == 2 && !args2[1].isNil()) {
            padding = RubyNumeric.fix2int(args2[1]);
        }
        String p2 = this.getPadding(padding);
        RubyString buffer = args2[0].convertToString();
        try {
            javax.crypto.Cipher engine = javax.crypto.Cipher.getInstance("RSA" + p2);
            engine.init(2, this.pubKey);
            byte[] outp = engine.doFinal(buffer.getBytes());
            return RubyString.newString(this.getRuntime(), outp);
        }
        catch (GeneralSecurityException gse) {
            throw PKeyRSA.newRSAError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod(name={"d="})
    public synchronized IRubyObject set_d(IRubyObject value2) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_d = BN.getBigInteger(value2);
        this.generatePrivateKeyIfParams();
        return value2;
    }

    @JRubyMethod(name={"p="})
    public synchronized IRubyObject set_p(IRubyObject value2) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_p = BN.getBigInteger(value2);
        this.generatePrivateKeyIfParams();
        return value2;
    }

    @JRubyMethod(name={"q="})
    public synchronized IRubyObject set_q(IRubyObject value2) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_q = BN.getBigInteger(value2);
        this.generatePrivateKeyIfParams();
        return value2;
    }

    @JRubyMethod(name={"dmp1="})
    public synchronized IRubyObject set_dmp1(IRubyObject value2) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_dmp1 = BN.getBigInteger(value2);
        this.generatePrivateKeyIfParams();
        return value2;
    }

    @JRubyMethod(name={"dmq1="})
    public synchronized IRubyObject set_dmq1(IRubyObject value2) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_dmq1 = BN.getBigInteger(value2);
        this.generatePrivateKeyIfParams();
        return value2;
    }

    @JRubyMethod(name={"iqmp="})
    public synchronized IRubyObject set_iqmp(IRubyObject value2) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_iqmp = BN.getBigInteger(value2);
        this.generatePrivateKeyIfParams();
        return value2;
    }

    @JRubyMethod(name={"iqmp"})
    public synchronized IRubyObject get_iqmp() {
        BigInteger iqmp = null;
        iqmp = this.privKey != null ? this.privKey.getCrtCoefficient() : this.rsa_iqmp;
        if (iqmp != null) {
            return BN.newBN(this.getRuntime(), iqmp);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"dmp1"})
    public synchronized IRubyObject get_dmp1() {
        BigInteger dmp1 = null;
        dmp1 = this.privKey != null ? this.privKey.getPrimeExponentP() : this.rsa_dmp1;
        if (dmp1 != null) {
            return BN.newBN(this.getRuntime(), dmp1);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"dmq1"})
    public synchronized IRubyObject get_dmq1() {
        BigInteger dmq1 = null;
        dmq1 = this.privKey != null ? this.privKey.getPrimeExponentQ() : this.rsa_dmq1;
        if (dmq1 != null) {
            return BN.newBN(this.getRuntime(), dmq1);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"d"})
    public synchronized IRubyObject get_d() {
        BigInteger d = null;
        d = this.privKey != null ? this.privKey.getPrivateExponent() : this.rsa_d;
        if (d != null) {
            return BN.newBN(this.getRuntime(), d);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"p"})
    public synchronized IRubyObject get_p() {
        BigInteger p2 = null;
        p2 = this.privKey != null ? this.privKey.getPrimeP() : this.rsa_p;
        if (p2 != null) {
            return BN.newBN(this.getRuntime(), p2);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"q"})
    public synchronized IRubyObject get_q() {
        BigInteger q = null;
        q = this.privKey != null ? this.privKey.getPrimeQ() : this.rsa_q;
        if (q != null) {
            return BN.newBN(this.getRuntime(), q);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"e"})
    public synchronized IRubyObject get_e() {
        RSAPublicKey key2 = this.pubKey;
        BigInteger e = key2 != null ? key2.getPublicExponent() : (this.privKey != null ? this.privKey.getPublicExponent() : this.rsa_e);
        if (e != null) {
            return BN.newBN(this.getRuntime(), e);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"e="})
    public synchronized IRubyObject set_e(IRubyObject value2) {
        this.rsa_e = BN.getBigInteger(value2);
        if (this.privKey == null) {
            this.generatePrivateKeyIfParams();
        }
        if (this.pubKey == null) {
            this.generatePublicKeyIfParams();
        }
        return value2;
    }

    @JRubyMethod(name={"n"})
    public synchronized IRubyObject get_n() {
        RSAPublicKey key2 = this.pubKey;
        BigInteger n = key2 != null ? key2.getModulus() : (this.privKey != null ? this.privKey.getModulus() : this.rsa_n);
        if (n != null) {
            return BN.newBN(this.getRuntime(), n);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"n="})
    public synchronized IRubyObject set_n(IRubyObject value2) {
        this.rsa_n = BN.getBigInteger(value2);
        if (this.privKey == null) {
            this.generatePrivateKeyIfParams();
        }
        if (this.pubKey == null) {
            this.generatePublicKeyIfParams();
        }
        return value2;
    }

    private void generatePublicKeyIfParams() {
        BigInteger n;
        if (this.pubKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        BigInteger e = this.rsa_e;
        if (e != null && (n = this.rsa_n) != null) {
            KeyFactory fact;
            try {
                fact = KeyFactory.getInstance("RSA");
            }
            catch (Exception ex) {
                throw this.getRuntime().newLoadError("unsupported key algorithm (RSA)");
            }
            try {
                this.pubKey = (RSAPublicKey)fact.generatePublic(new RSAPublicKeySpec(n, e));
            }
            catch (InvalidKeySpecException ex) {
                throw PKeyRSA.newRSAError(this.getRuntime(), "invalid parameters");
            }
            this.rsa_e = null;
            this.rsa_n = null;
        }
    }

    private void generatePrivateKeyIfParams() {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        if (this.rsa_e != null && this.rsa_n != null && this.rsa_p != null && this.rsa_q != null && this.rsa_d != null && this.rsa_dmp1 != null && this.rsa_dmq1 != null && this.rsa_iqmp != null) {
            KeyFactory fact;
            try {
                fact = KeyFactory.getInstance("RSA");
            }
            catch (Exception ex) {
                throw this.getRuntime().newLoadError("unsupported key algorithm (RSA)");
            }
            try {
                this.privKey = (RSAPrivateCrtKey)fact.generatePrivate(new RSAPrivateCrtKeySpec(this.rsa_n, this.rsa_e, this.rsa_d, this.rsa_p, this.rsa_q, this.rsa_dmp1, this.rsa_dmq1, this.rsa_iqmp));
            }
            catch (InvalidKeySpecException ex) {
                throw PKeyRSA.newRSAError(this.getRuntime(), "invalid parameters");
            }
            this.rsa_n = null;
            this.rsa_e = null;
            this.rsa_d = null;
            this.rsa_p = null;
            this.rsa_q = null;
            this.rsa_dmp1 = null;
            this.rsa_dmq1 = null;
            this.rsa_iqmp = null;
        }
    }
}

