/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Arrays;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.MethodBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;

@JRubyClass(name={"Proc"})
public class RubyProc
extends RubyObject
implements DataType {
    private Block block = Block.NULL_BLOCK;
    private Block.Type type;
    private ISourcePosition sourcePosition;
    private static ObjectAllocator PROC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyProc instance = new RubyProc(runtime, runtime.getProc(), Block.Type.PROC);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    protected RubyProc(Ruby runtime, RubyClass rubyClass, Block.Type type2) {
        super(runtime, rubyClass);
        this.type = type2;
    }

    protected RubyProc(Ruby runtime, RubyClass rubyClass, Block.Type type2, ISourcePosition sourcePosition) {
        this(runtime, rubyClass, type2);
        this.sourcePosition = sourcePosition;
    }

    public static RubyClass createProcClass(Ruby runtime) {
        RubyClass procClass = runtime.defineClass("Proc", runtime.getObject(), PROC_ALLOCATOR);
        runtime.setProc(procClass);
        procClass.index = 33;
        procClass.setReifiedClass(RubyProc.class);
        procClass.defineAnnotatedMethods(RubyProc.class);
        return procClass;
    }

    public Block getBlock() {
        return this.block;
    }

    @Deprecated
    public static RubyProc newProc(Ruby runtime, Block.Type type2) {
        throw runtime.newRuntimeError("deprecated RubyProc.newProc with no block; do not use");
    }

    public static RubyProc newProc(Ruby runtime, Block block, Block.Type type2) {
        return RubyProc.newProc(runtime, block, type2, null);
    }

    public static RubyProc newProc(Ruby runtime, Block block, Block.Type type2, ISourcePosition sourcePosition) {
        RubyProc proc2 = new RubyProc(runtime, runtime.getProc(), type2, sourcePosition);
        proc2.setup(block);
        return proc2;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            block = context.getCurrentFrame().getBlock();
        }
        if (block.isGiven() && block.getProcObject() != null && block.getProcObject().getMetaClass() == recv2) {
            return block.getProcObject();
        }
        RubyProc obj = (RubyProc)((RubyClass)recv2).allocate();
        obj.setup(block);
        obj.callMethod(context, "initialize", args2, block);
        return obj;
    }

    private void setup(Block procBlock) {
        if (!procBlock.isGiven()) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        if (!this.isLambda() || procBlock == null) {
            // empty if block
        }
        this.block = procBlock.cloneBlock();
        if (this.isThread()) {
            StaticScope oldScope = this.block.getBody().getStaticScope();
            StaticScope newScope = this.getRuntime().getStaticScopeFactory().newBlockScope(oldScope.getEnclosingScope(), oldScope.getVariables());
            newScope.setBackrefLastlineScope(true);
            newScope.setPreviousCRefScope(oldScope.getPreviousCRefScope());
            newScope.setModule(oldScope.getModule());
            this.block.getBody().setStaticScope(newScope);
        }
        this.block.getBinding().setFile(this.block.getBody().getFile());
        this.block.getBinding().setLine(this.block.getBody().getLine());
        this.block.type = this.type;
        this.block.setProcObject(this);
    }

    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        RubyProc newProc = RubyProc.newProc(this.getRuntime(), this.block, this.type, this.sourcePosition);
        return newProc;
    }

    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        return RubyProc.newProc(this.getRuntime(), this.block, this.type, this.sourcePosition);
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        return this.getRuntime().newBoolean(other instanceof RubyProc && (this == other || this.block.equals(((RubyProc)other).block)));
    }

    @JRubyMethod(name={"to_s"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_s() {
        return RubyString.newString(this.getRuntime(), "#<Proc:0x" + Integer.toString(this.block.hashCode(), 16) + "@" + this.block.getBody().getFile() + ":" + (this.block.getBody().getLine() + 1) + ">");
    }

    @JRubyMethod(name={"to_s"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_s19() {
        StringBuilder sb = new StringBuilder("#<Proc:0x" + Integer.toString(this.block.hashCode(), 16) + "@" + this.block.getBody().getFile() + ":" + (this.block.getBody().getLine() + 1));
        if (this.isLambda()) {
            sb.append(" (lambda)");
        }
        sb.append(">");
        return RubyString.newString(this.getRuntime(), sb.toString());
    }

    @JRubyMethod(name={"binding"})
    public IRubyObject binding() {
        return this.getRuntime().newBinding(this.block.getBinding());
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.call(context, args2, null, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
        return this.call(context, args2, null, Block.NULL_BLOCK);
    }

    private IRubyObject[] prepareProcArgs(ThreadContext context, IRubyObject[] args2) {
        Arity arity2 = this.block.arity();
        if (arity2 != Arity.ONE_ARGUMENT && arity2.required() != 0 && (arity2.isFixed() || arity2 != Arity.OPTIONAL) && args2.length == 1 && args2[0].respondsTo("to_ary")) {
            args2 = args2[0].convertToArray().toJavaArray();
        }
        if (arity2.isFixed()) {
            ArrayList<IRubyObject> list2 = new ArrayList<IRubyObject>(Arrays.asList(args2));
            int required = arity2.required();
            if (required > args2.length) {
                for (int i2 = args2.length; i2 < required; ++i2) {
                    list2.add(context.runtime.getNil());
                }
                args2 = list2.toArray(args2);
            } else if (required < args2.length) {
                args2 = list2.subList(0, required).toArray(args2);
            }
        }
        return args2;
    }

    @JRubyMethod(name={"call", "[]", "yield", "==="}, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject call19(ThreadContext context, IRubyObject[] args2, Block blockCallArg) {
        if (this.isLambda()) {
            this.block.arity().checkArity(context.runtime, args2.length);
        }
        if (this.isProc()) {
            args2 = this.prepareProcArgs(context, args2);
        }
        return this.call(context, args2, null, blockCallArg);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, IRubyObject self, Block passedBlock) {
        assert (args2 != null);
        Block newBlock = this.block.cloneBlock();
        int jumpTarget = newBlock.getBinding().getFrame().getJumpTarget();
        try {
            if (self != null) {
                newBlock.getBinding().setSelf(self);
            }
            return newBlock.call(context, args2, passedBlock);
        }
        catch (JumpException.BreakJump bj) {
            return this.handleBreakJump(this.getRuntime(), newBlock, bj, jumpTarget);
        }
        catch (JumpException.ReturnJump rj) {
            return this.handleReturnJump(context, rj, jumpTarget);
        }
        catch (JumpException.RetryJump rj) {
            return this.handleRetryJump(this.getRuntime(), rj);
        }
    }

    private IRubyObject handleBreakJump(Ruby runtime, Block newBlock, JumpException.BreakJump bj, int jumpTarget) {
        switch (newBlock.type) {
            case LAMBDA: {
                if (bj.getTarget() == jumpTarget) {
                    return (IRubyObject)bj.getValue();
                }
                throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
            }
            case PROC: {
                if (!newBlock.isEscaped()) break;
                throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "break from proc-closure");
            }
        }
        throw bj;
    }

    private IRubyObject handleReturnJump(ThreadContext context, JumpException.ReturnJump rj, int jumpTarget) {
        int target = rj.getTarget();
        if (target == jumpTarget && this.isLambda()) {
            return (IRubyObject)rj.getValue();
        }
        if (this.isThread()) {
            throw rj;
        }
        if (target == jumpTarget && !context.isJumpTargetAlive(target, 0)) {
            throw context.runtime.newLocalJumpError(RubyLocalJumpError.Reason.RETURN, (IRubyObject)rj.getValue(), "unexpected return");
        }
        throw rj;
    }

    private IRubyObject handleRetryJump(Ruby runtime, JumpException.RetryJump rj) {
        throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.RETRY, (IRubyObject)rj.getValue(), "retry not supported outside rescue");
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.block.arity().getValue());
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc() {
        return this;
    }

    @JRubyMethod(name={"source_location"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject source_location(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.sourcePosition != null) {
            return runtime.newArray((IRubyObject)runtime.newString(this.sourcePosition.getFile()), (IRubyObject)runtime.newFixnum(this.sourcePosition.getLine() + 1));
        }
        if (this.block != null) {
            Binding binding2 = this.block.getBinding();
            return runtime.newArray((IRubyObject)runtime.newString(binding2.getFile()), (IRubyObject)runtime.newFixnum(binding2.getLine() + 1));
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"parameters"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject parameters(ThreadContext context) {
        BlockBody body = this.getBlock().getBody();
        if (body instanceof MethodBlock) {
            return ((MethodBlock)body).getMethod().parameters(context);
        }
        return RuntimeHelpers.parameterListToParameters(context.runtime, body.getParameterList(), this.isLambda());
    }

    @JRubyMethod(name={"lambda?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject lambda_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isLambda());
    }

    private boolean isLambda() {
        return this.type.equals((Object)Block.Type.LAMBDA);
    }

    private boolean isProc() {
        return this.type.equals((Object)Block.Type.PROC);
    }

    private boolean isThread() {
        return this.type.equals((Object)Block.Type.THREAD);
    }
}

