/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.enxio.channels.NativeSocketChannel;
import jnr.ffi.byref.IntByReference;
import jnr.unixsocket.Native;

public class UnixSocket {
    private final NativeSocketChannel channel;

    UnixSocket(NativeSocketChannel nativeSocketChannel) {
        this.channel = nativeSocketChannel;
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public final void setKeepAlive(boolean bl) {
        Native.setsockopt(this.channel.getFD(), SocketLevel.SOL_SOCKET, SocketOption.SO_KEEPALIVE, bl);
    }

    public final boolean getKeepAlive() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        IntByReference intByReference = new IntByReference(4);
        Native.libsocket().getsockopt(this.channel.getFD(), SocketLevel.SOL_SOCKET.intValue(), SocketOption.SO_KEEPALIVE.intValue(), byteBuffer, intByReference);
        return byteBuffer.getInt(0) != 0;
    }
}

