/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import jnr.ffi.NativeType;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.mapper.TypeMapper;
import jnr.ffi.provider.jffi.FromNativeType;
import jnr.ffi.provider.jffi.InvokerUtil;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.ToNativeType;
import jnr.ffi.util.EnumMapper;

final class ClosureUtil {
    private ClosureUtil() {
    }

    static ToNativeType getResultType(NativeRuntime runtime, Method m, TypeMapper typeMapper) {
        Annotation[] annotations2 = m.getAnnotations();
        ToNativeConverter converter = ClosureUtil.getToNativeConverter(m.getReturnType(), annotations2, typeMapper);
        Class<Object> javaClass = converter != null ? converter.nativeType() : m.getReturnType();
        NativeType nativeType = InvokerUtil.getNativeType(runtime, javaClass, annotations2);
        return new ToNativeType(m.getReturnType(), nativeType, annotations2, converter);
    }

    static FromNativeType getParameterType(NativeRuntime runtime, Method m, int idx, TypeMapper typeMapper) {
        Annotation[] annotations2 = m.getParameterAnnotations()[idx];
        Class<?> declaredJavaClass = m.getParameterTypes()[idx];
        FromNativeConverter converter = ClosureUtil.getFromNativeConverter(declaredJavaClass, annotations2, typeMapper);
        Class<Object> javaClass = converter != null ? converter.nativeType() : declaredJavaClass;
        NativeType nativeType = InvokerUtil.getNativeType(runtime, javaClass, annotations2);
        return new FromNativeType(declaredJavaClass, nativeType, annotations2, converter);
    }

    static Type getNativeResultType(NativeRuntime runtime, Method m, TypeMapper typeMapper) {
        ToNativeConverter converter = ClosureUtil.getToNativeConverter(m.getReturnType(), m.getAnnotations(), typeMapper);
        Class<Object> javaClass = converter != null ? converter.nativeType() : m.getReturnType();
        return InvokerUtil.jffiType(InvokerUtil.getNativeType(runtime, m.getReturnType(), m.getAnnotations()));
    }

    static Type getNativeParameterType(NativeRuntime runtime, Method m, int idx, TypeMapper typeMapper) {
        FromNativeConverter converter = ClosureUtil.getFromNativeConverter(m.getParameterTypes()[idx], m.getParameterAnnotations()[idx], typeMapper);
        Class<Object> javaClass = converter != null ? converter.nativeType() : m.getReturnType();
        return InvokerUtil.jffiType(InvokerUtil.getNativeType(runtime, m.getParameterTypes()[idx], m.getParameterAnnotations()[idx]));
    }

    static FromNativeConverter getFromNativeConverter(Class javaClass, Annotation[] annotations2, TypeMapper typeMapper) {
        FromNativeConverter conv2 = typeMapper.getFromNativeConverter(javaClass);
        if (conv2 != null) {
            return conv2;
        }
        if (Enum.class.isAssignableFrom(javaClass)) {
            return EnumMapper.getInstance(javaClass.asSubclass(Enum.class));
        }
        return null;
    }

    static ToNativeConverter getToNativeConverter(Class javaClass, Annotation[] annotations2, TypeMapper typeMapper) {
        ToNativeConverter conv2 = typeMapper.getToNativeConverter(javaClass);
        if (conv2 != null) {
            return conv2;
        }
        if (Enum.class.isAssignableFrom(javaClass)) {
            return EnumMapper.getInstance(javaClass.asSubclass(Enum.class));
        }
        return null;
    }
}

