/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledBlock19
extends ContextAwareBlockBody {
    protected final CompiledBlockCallback19 callback;
    protected final boolean hasMultipleArgsHead;
    protected final String[] parameterList;
    private final boolean needsSplat;

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self, Arity arity2, StaticScope scope, CompiledBlockCallback19 callback, boolean hasMultipleArgsHead, int argumentType) {
        Binding binding2 = context.currentBinding(self, Visibility.PUBLIC);
        CompiledBlock19 body = new CompiledBlock19(arity2, scope, callback, hasMultipleArgsHead, argumentType, EMPTY_PARAMETER_LIST);
        return new Block(body, binding2);
    }

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self, BlockBody body) {
        Binding binding2 = context.currentBinding(self, Visibility.PUBLIC);
        return new Block(body, binding2);
    }

    public static BlockBody newCompiledBlock(Arity arity2, StaticScope scope, CompiledBlockCallback19 callback, boolean hasMultipleArgsHead, int argumentType, String[] parameterList) {
        return new CompiledBlock19(arity2, scope, callback, hasMultipleArgsHead, argumentType, parameterList);
    }

    protected CompiledBlock19(Arity arity2, StaticScope scope, CompiledBlockCallback19 callback, boolean hasMultipleArgsHead, int argumentType, String[] parameterList) {
        super(scope, arity2, argumentType);
        this.callback = callback;
        this.hasMultipleArgsHead = hasMultipleArgsHead;
        this.parameterList = parameterList;
        this.needsSplat = RuntimeHelpers.needsSplat19(this.arity().required(), !this.arity().isFixed());
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        IRubyObject value2 = args2.length == 1 ? args2[0] : context.runtime.newArrayNoCopy(args2);
        return this.yield(context, value2, null, null, true, binding2, type2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, context.runtime.newArrayNoCopy(args2), null, null, true, binding2, type2, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, IRubyObject.NULL_ARRAY, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.yield(context, arg0, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, new IRubyObject[]{arg0, arg1}, binding2, type2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yieldSpecificInternal(context, new IRubyObject[]{arg0, arg1, arg2}, binding2, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject yieldSpecificInternal(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        IRubyObject iRubyObject;
        IRubyObject self = this.prepareSelf(binding2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            iRubyObject = this.callback.call(context, self, args2, Block.NULL_BLOCK);
            Object var11_10 = null;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject2;
            try {
                iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
            this.post(context, binding2, oldVis, lastFrame);
            return iRubyObject2;
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        IRubyObject iRubyObject;
        IRubyObject self = this.prepareSelf(binding2);
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, null, binding2);
        try {
            IRubyObject[] realArgs = this.setupBlockArg(context.runtime, value2, self);
            iRubyObject = this.callback.call(context, self, realArgs, Block.NULL_BLOCK);
            Object var11_12 = null;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject2;
            try {
                iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
            this.post(context, binding2, oldVis, lastFrame);
            return iRubyObject2;
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    public IRubyObject yield(ThreadContext context, IRubyObject args2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        return this.yield(context, args2, self, klass, aValue, binding2, type2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject args2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2, Block block) {
        IRubyObject iRubyObject;
        if (klass == null) {
            self = this.prepareSelf(binding2);
        }
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame lastFrame = this.pre(context, klass, binding2);
        try {
            IRubyObject[] realArgs = this.setupBlockArgs(args2, aValue);
            iRubyObject = this.callback.call(context, self, realArgs, block);
            Object var14_15 = null;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject2;
            try {
                iRubyObject2 = this.handleNextJump(context, nj, type2);
                Object var14_16 = null;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                this.post(context, binding2, oldVis, lastFrame);
                throw throwable;
            }
            this.post(context, binding2, oldVis, lastFrame);
            return iRubyObject2;
        }
        this.post(context, binding2, oldVis, lastFrame);
        return iRubyObject;
    }

    private IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self = binding2.getSelf();
        binding2.getFrame().setSelf(self);
        return self;
    }

    private IRubyObject handleNextJump(ThreadContext context, JumpException.NextJump nj, Block.Type type2) {
        return nj.getValue() == null ? context.runtime.getNil() : (IRubyObject)nj.getValue();
    }

    private IRubyObject[] setupBlockArg(Ruby ruby2, IRubyObject value2, IRubyObject self) {
        return this.setupBlockArgs(value2, false);
    }

    private IRubyObject[] setupBlockArgs(IRubyObject value2, boolean alreadyArray) {
        return RuntimeHelpers.restructureBlockArgs19(value2, this.needsSplat, alreadyArray);
    }

    public String getFile() {
        return this.callback.getFile();
    }

    public int getLine() {
        return this.callback.getLine();
    }

    public String[] getParameterList() {
        return this.parameterList;
    }
}

