/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.MethodHandle;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodLookupInstr
extends Instr
implements ResultInstr {
    private Operand methodHandle;
    private Variable result;

    public MethodLookupInstr(Variable result2, MethodHandle mh) {
        super(Operation.METHOD_LOOKUP);
        assert (result2 != null) : "MethodLookupInstr result is null";
        this.methodHandle = mh;
        this.result = result2;
    }

    public MethodLookupInstr(Variable dest, Operand methodName, Operand receiver2) {
        this(dest, new MethodHandle(methodName, receiver2));
    }

    public MethodHandle getMethodHandle() {
        return (MethodHandle)this.methodHandle;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.methodHandle};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.methodHandle = this.methodHandle.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.methodHandle + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new MethodLookupInstr(ii.getRenamedVariable(this.result), (MethodHandle)this.methodHandle.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        return this.methodHandle.retrieve(context, self, currDynScope, temp);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.MethodLookupInstr(this);
    }
}

