/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.netscape.NetscapeCertRequest;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.Base64;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class NetscapeSPKI
extends RubyObject {
    private static final long serialVersionUID = 3211242351810109432L;
    private static ObjectAllocator NETSCAPESPKI_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new NetscapeSPKI(runtime, klass);
        }
    };
    private IRubyObject public_key;
    private IRubyObject challenge;
    private NetscapeCertRequest cert;

    public static void createNetscapeSPKI(Ruby runtime, RubyModule ossl) {
        RubyModule mNetscape = ossl.defineModuleUnder("Netscape");
        RubyClass cSPKI = mNetscape.defineClassUnder("SPKI", runtime.getObject(), NETSCAPESPKI_ALLOCATOR);
        RubyClass openSSLError = ossl.getClass("OpenSSLError");
        mNetscape.defineClassUnder("SPKIError", openSSLError, openSSLError.getAllocator());
        cSPKI.defineAnnotatedMethods(NetscapeSPKI.class);
    }

    public NetscapeSPKI(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(name={"initialize"}, rest=true)
    public IRubyObject _initialize(IRubyObject[] args2) {
        if (args2.length > 0) {
            byte[] b = args2[0].convertToString().getBytes();
            final byte[] b2 = b = this.tryBase64Decode(b);
            String algo = null;
            byte[] enc = null;
            try {
                PublicKey pkey = (PublicKey)OpenSSLReal.getWithBCProvider(new OpenSSLReal.Callable(){

                    public Object call() throws GeneralSecurityException {
                        try {
                            NetscapeSPKI.this.cert = new NetscapeCertRequest(b2);
                            NetscapeSPKI.this.challenge = NetscapeSPKI.this.getRuntime().newString(NetscapeSPKI.this.cert.getChallenge());
                            return NetscapeSPKI.this.cert.getPublicKey();
                        }
                        catch (IOException ioe) {
                            throw new GeneralSecurityException(ioe.getMessage(), ioe);
                        }
                    }
                });
                algo = pkey.getAlgorithm();
                enc = pkey.getEncoded();
            }
            catch (GeneralSecurityException gse) {
                throw NetscapeSPKI.newSPKIError(this.getRuntime(), gse.getMessage());
            }
            if ("RSA".equalsIgnoreCase(algo)) {
                this.public_key = Utils.newRubyInstance(this.getRuntime(), "OpenSSL::PKey::RSA", RubyString.newString(this.getRuntime(), enc));
            } else if ("DSA".equalsIgnoreCase(algo)) {
                this.public_key = Utils.newRubyInstance(this.getRuntime(), "OpenSSL::PKey::DSA", RubyString.newString(this.getRuntime(), enc));
            } else {
                throw this.getRuntime().newLoadError("not implemented algo for public key: " + algo);
            }
        }
        return this;
    }

    private byte[] tryBase64Decode(byte[] b) {
        try {
            b = Base64.decode(b, 0, b.length, 0);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return b;
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            return RubyString.newString(this.getRuntime(), this.internalToDer());
        }
        catch (IOException ioe) {
            throw NetscapeSPKI.newSPKIError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        try {
            byte[] source2 = this.internalToDer();
            return this.getRuntime().newString(Base64.encodeBytes(source2, 0, source2.length, 0));
        }
        catch (IOException ioe) {
            throw NetscapeSPKI.newSPKIError(this.getRuntime(), ioe.getMessage());
        }
    }

    private byte[] internalToDer() throws IOException {
        DERSequence b = (DERSequence)this.cert.toASN1Object();
        DERObjectIdentifier encType = null;
        DERBitString publicKey = new DERBitString(((PKey)this.public_key).to_der().convertToString().getBytes());
        DERIA5String encodedChallenge = new DERIA5String(this.challenge.toString());
        DERObjectIdentifier sigAlg = null;
        DERBitString sig = null;
        encType = (DERObjectIdentifier)((DERSequence)((DERSequence)((DERSequence)b.getObjectAt(0)).getObjectAt(0)).getObjectAt(0)).getObjectAt(0);
        sigAlg = ((AlgorithmIdentifier)b.getObjectAt(1)).getObjectId();
        sig = (DERBitString)b.getObjectAt(2);
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        ASN1EncodableVector v1_2 = new ASN1EncodableVector();
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        ASN1EncodableVector v3 = new ASN1EncodableVector();
        ASN1EncodableVector v4 = new ASN1EncodableVector();
        v4.add(encType);
        v4.add(new DERNull());
        v3.add(new DERSequence(v4));
        v3.add(publicKey);
        v2.add(new DERSequence(v3));
        v2.add(encodedChallenge);
        v1.add(new DERSequence(v2));
        v1_2.add(sigAlg);
        v1_2.add(new DERNull());
        v1.add(new DERSequence(v1_2));
        v1.add(sig);
        return new DERSequence(v1).getEncoded();
    }

    @JRubyMethod
    public IRubyObject to_text() {
        System.err.println("WARNING: calling unimplemented method: to_text");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject public_key() {
        return this.public_key;
    }

    @JRubyMethod(name={"public_key="})
    public IRubyObject set_public_key(IRubyObject arg2) {
        this.public_key = arg2;
        return arg2;
    }

    @JRubyMethod
    public IRubyObject sign(final IRubyObject key2, IRubyObject digest2) {
        String keyAlg = ((PKey)key2).getAlgorithm();
        String digAlg = ((Digest)digest2).getShortAlgorithm();
        final DERObjectIdentifier alg = ASN1.getOIDLookup(this.getRuntime()).get(keyAlg.toLowerCase() + "-" + digAlg.toLowerCase());
        try {
            OpenSSLReal.doWithBCProvider(new OpenSSLReal.Runnable(){

                public void run() throws GeneralSecurityException {
                    NetscapeSPKI.this.cert = new NetscapeCertRequest(NetscapeSPKI.this.challenge.toString(), new AlgorithmIdentifier(alg), ((PKey)NetscapeSPKI.this.public_key).getPublicKey());
                    NetscapeSPKI.this.cert.sign(((PKey)key2).getPrivateKey());
                }
            });
        }
        catch (GeneralSecurityException gse) {
            throw NetscapeSPKI.newSPKIError(this.getRuntime(), gse.getMessage());
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject verify(IRubyObject pkey) {
        this.cert.setPublicKey(((PKey)pkey).getPublicKey());
        try {
            Boolean result2 = (Boolean)OpenSSLReal.getWithBCProvider(new OpenSSLReal.Callable(){

                public Boolean call() throws GeneralSecurityException {
                    return NetscapeSPKI.this.cert.verify(NetscapeSPKI.this.challenge.toString());
                }
            });
            return result2 != false ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        catch (GeneralSecurityException gse) {
            throw NetscapeSPKI.newSPKIError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject challenge() {
        return this.challenge;
    }

    @JRubyMethod(name={"challenge="})
    public IRubyObject set_challenge(IRubyObject arg2) {
        this.challenge = arg2;
        return arg2;
    }

    private static RaiseException newSPKIError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::Netscape::SPKIError", message2);
    }
}

