/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageData {
    private volatile Map<String, Integer[]> coverage;
    private final EventHook COVERAGE_HOOK = new EventHook(){

        public synchronized void eventHandler(ThreadContext context, String eventName, String file2, int line, String name2, IRubyObject type2) {
            Integer count2;
            if (CoverageData.this.coverage == null || line <= 0) {
                return;
            }
            Integer[] lines2 = (Integer[])CoverageData.this.coverage.get(file2);
            if (lines2 == null) {
                return;
            }
            if (lines2.length <= line) {
                Integer[] newLines = new Integer[line];
                System.arraycopy(lines2, 0, newLines, 0, lines2.length);
                lines2 = newLines;
                CoverageData.this.coverage.put(file2, lines2);
            }
            lines2[line - 1] = (count2 = lines2[line - 1]) == null ? Integer.valueOf(1) : Integer.valueOf(count2 + 1);
        }

        public boolean isInterestedInEvent(RubyEvent event) {
            return event == RubyEvent.LINE;
        }
    };

    public boolean isCoverageEnabled() {
        return this.coverage != null;
    }

    public synchronized void setCoverageEnabled(Ruby runtime, boolean enabled) {
        if (enabled) {
            this.coverage = new HashMap<String, Integer[]>();
            runtime.addEventHook(this.COVERAGE_HOOK);
        } else {
            this.coverage = null;
        }
    }

    public synchronized Map<String, Integer[]> resetCoverage(Ruby runtime) {
        Map<String, Integer[]> coverage2 = this.coverage;
        runtime.removeEventHook(this.COVERAGE_HOOK);
        this.coverage = null;
        return coverage2;
    }

    public synchronized Map<String, Integer[]> prepareCoverage(String filename2, Integer[] lines2) {
        assert (lines2 != null);
        Map<String, Integer[]> coverage2 = this.coverage;
        if (coverage2 != null) {
            coverage2.put(filename2, lines2);
        }
        return coverage2;
    }
}

