/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.log;

import java.io.PrintStream;
import org.jruby.util.log.Logger;
import org.jruby.util.log.ParameterizedWriter;

public class StandardErrorLogger
implements Logger {
    private final String loggerName;
    private boolean debug = false;
    private ParameterizedWriter writer;

    public StandardErrorLogger(String loggerName) {
        this.loggerName = loggerName;
        this.writer = new ParameterizedWriter(System.err);
    }

    public StandardErrorLogger(String loggerName, PrintStream stream) {
        this.loggerName = loggerName;
        this.writer = new ParameterizedWriter(stream);
    }

    public String getName() {
        return this.loggerName;
    }

    public void warn(String message2, Object ... args2) {
        this.write(message2, args2);
    }

    public void warn(Throwable throwable) {
        this.writeStackTrace(throwable);
    }

    public void warn(String message2, Throwable throwable) {
        this.write(message2, throwable);
    }

    public void error(String message2, Object ... args2) {
        this.write(message2, args2);
    }

    public void error(Throwable throwable) {
        this.writeStackTrace(throwable);
    }

    public void error(String message2, Throwable throwable) {
        this.write(message2, throwable);
    }

    public void info(String message2, Object ... args2) {
        this.write(message2, args2);
    }

    public void info(Throwable throwable) {
        this.writeStackTrace(throwable);
    }

    public void info(String message2, Throwable throwable) {
        this.write(message2, throwable);
    }

    public void debug(String message2, Object ... args2) {
        if (this.debug) {
            this.write(message2, args2);
        }
    }

    public void debug(Throwable throwable) {
        if (this.debug) {
            this.writeStackTrace(throwable);
        }
    }

    public void debug(String message2, Throwable throwable) {
        if (this.debug) {
            this.write(message2, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public void setDebugEnable(boolean debug) {
        this.debug = debug;
    }

    private void write(String message2, Object[] args2) {
        this.writer.write(message2, args2);
    }

    private void write(String message2, Throwable throwable) {
        this.writer.write(message2, new Object[0]);
        this.writeStackTrace(throwable);
    }

    private void writeStackTrace(Throwable throwable) {
        throwable.printStackTrace(this.writer.getStream());
    }
}

