/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RescueEQQInstr
extends Instr
implements ResultInstr {
    private Operand arg1;
    private Operand arg2;
    private Variable result;

    public RescueEQQInstr(Variable result2, Operand v1, Operand v2) {
        super(Operation.RESCUE_EQQ);
        assert (result2 != null) : "RescueEQQInstr result is null";
        this.arg1 = v1;
        this.arg2 = v2;
        this.result = result2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.arg1, this.arg2};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.arg1 = this.arg1.getSimplifiedOperand(valueMap, force);
        this.arg2 = this.arg2.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.arg1 + ", " + this.arg2 + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new RescueEQQInstr(ii.getRenamedVariable(this.result), this.arg1.cloneForInlining(ii), this.arg2.cloneForInlining(ii));
    }

    private boolean exceptionHandled(ThreadContext context, IRubyObject excType, Object excObj) {
        Class cls;
        RubyClass rubyClass;
        JavaClass javaClass;
        Ruby runtime = context.runtime;
        if (excObj instanceof IRubyObject) {
            if (!(excType instanceof RubyModule)) {
                throw runtime.newTypeError("class or module required for rescue clause. Found: " + excType);
            }
            return excType.callMethod(context, "===", (IRubyObject)excObj).isTrue();
        }
        if (runtime.getException().op_ge(excType).isTrue() || runtime.getObject() == excType) {
            return excType.callMethod(context, "===", JavaUtil.convertJavaToUsableRubyObject(runtime, excObj)).isTrue();
        }
        return excType instanceof RubyClass && excType.getInstanceVariables().hasInstanceVariable("@java_class") && (javaClass = (JavaClass)(rubyClass = (RubyClass)excType).getInstanceVariable("@java_class")) != null && (cls = javaClass.javaClass()).isInstance(excObj);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        boolean isUndefExc;
        Ruby runtime = context.runtime;
        IRubyObject excType = (IRubyObject)this.arg1.retrieve(context, self, currDynScope, temp);
        Object excObj = this.arg2.retrieve(context, self, currDynScope, temp);
        boolean bl = isUndefExc = excObj == UndefinedValue.UNDEFINED;
        if (excType instanceof RubyArray) {
            RubyArray testTypes = (RubyArray)excType;
            int n = testTypes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                boolean handled;
                IRubyObject testType = testTypes.eltInternal(i2);
                boolean bl2 = handled = isUndefExc ? testType.isTrue() : this.exceptionHandled(context, testType, excObj);
                if (!handled) continue;
                return runtime.newBoolean(true);
            }
            return runtime.newBoolean(false);
        }
        return isUndefExc ? excType : runtime.newBoolean(this.exceptionHandled(context, excType, excObj));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.RescueEQQInstr(this);
    }
}

