/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PutInstr
extends Instr {
    public final int VALUE = 0;
    public final int TARGET = 1;
    protected Operand[] operands;
    protected String ref;

    public PutInstr(Operation op, Operand target, String ref, Operand value2) {
        super(op);
        this.operands = new Operand[]{value2, target};
        this.ref = ref;
    }

    @Override
    public Operand[] getOperands() {
        return this.operands;
    }

    public String getRef() {
        return this.ref;
    }

    public Operand getTarget() {
        return this.operands[1];
    }

    public Operand getValue() {
        return this.operands[0];
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.operands[1] + (this.ref == null ? "" : ", " + this.ref) + ") = " + this.operands[0];
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.operands[0] = this.operands[0].getSimplifiedOperand(valueMap, force);
        this.operands[1] = this.operands[1].getSimplifiedOperand(valueMap, force);
    }
}

