/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.RubyThread;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class RubyRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger("RubyRunnable");
    private Ruby runtime;
    private RubyProc proc;
    private IRubyObject[] arguments;
    private RubyThread rubyThread;
    private Frame[] currentFrames;
    private Thread javaThread;
    private static boolean warnedAboutTC = false;

    public RubyRunnable(RubyThread rubyThread, IRubyObject[] args2, Frame[] frames, Block currentBlock) {
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        this.proc = this.runtime.newProc(Block.Type.THREAD, currentBlock);
        this.currentFrames = frames;
        this.arguments = args2;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    public Thread getJavaThread() {
        return this.javaThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block25: {
            ClassLoader oldContextClassLoader;
            ThreadContext context;
            block23: {
                this.javaThread = Thread.currentThread();
                context = this.runtime.getThreadService().registerNewThread(this.rubyThread);
                oldContextClassLoader = null;
                try {
                    oldContextClassLoader = this.javaThread.getContextClassLoader();
                    this.javaThread.setContextClassLoader(this.runtime.getJRubyClassLoader());
                }
                catch (SecurityException se) {
                    if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block23;
                    LOG.info("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.", new Object[0]);
                }
            }
            context.preRunThread(this.currentFrames);
            this.rubyThread.beforeStart();
            try {
                block24: {
                    IRubyObject result2 = this.proc.call(context, this.arguments);
                    this.rubyThread.cleanTerminate(result2);
                    Object var5_9 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.rubyThread.dispose();
                    try {
                        this.javaThread.setContextClassLoader(oldContextClassLoader);
                    }
                    catch (SecurityException se) {
                        if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block24;
                        LOG.info("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.", new Object[0]);
                    }
                }
                if (this.runtime.getInstanceConfig().isProfilingEntireRun()) {
                    this.runtime.printProfileData(context.getProfileData(), System.err);
                }
                break block25;
                {
                    catch (JumpException.ReturnJump rj) {
                        block26: {
                            if (this.runtime.is1_9()) {
                                this.rubyThread.exceptionRaised(rj.buildException(this.runtime));
                            } else {
                                this.rubyThread.exceptionRaised(this.runtime.newThreadError("return can't jump across threads"));
                            }
                            Object var5_10 = null;
                            this.runtime.getThreadService().setCritical(false);
                            this.rubyThread.dispose();
                            try {
                                this.javaThread.setContextClassLoader(oldContextClassLoader);
                            }
                            catch (SecurityException se) {
                                if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block26;
                                LOG.info("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.", new Object[0]);
                            }
                        }
                        if (this.runtime.getInstanceConfig().isProfilingEntireRun()) {
                            this.runtime.printProfileData(context.getProfileData(), System.err);
                        }
                        break block25;
                    }
                    catch (MainExitException mee) {
                        block27: {
                            this.runtime.getThreadService().getMainThread().kill();
                            Object var5_11 = null;
                            this.runtime.getThreadService().setCritical(false);
                            this.rubyThread.dispose();
                            try {
                                this.javaThread.setContextClassLoader(oldContextClassLoader);
                            }
                            catch (SecurityException se) {
                                if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block27;
                                LOG.info("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.", new Object[0]);
                            }
                        }
                        if (this.runtime.getInstanceConfig().isProfilingEntireRun()) {
                            this.runtime.printProfileData(context.getProfileData(), System.err);
                        }
                        break block25;
                    }
                    catch (Throwable t) {
                        block28: {
                            this.rubyThread.exceptionRaised(t);
                            Object var5_12 = null;
                            this.runtime.getThreadService().setCritical(false);
                            this.rubyThread.dispose();
                            try {
                                this.javaThread.setContextClassLoader(oldContextClassLoader);
                            }
                            catch (SecurityException se) {
                                if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block28;
                                LOG.info("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.", new Object[0]);
                            }
                        }
                        if (this.runtime.getInstanceConfig().isProfilingEntireRun()) {
                            this.runtime.printProfileData(context.getProfileData(), System.err);
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    block29: {
                        Object var5_13 = null;
                        this.runtime.getThreadService().setCritical(false);
                        this.rubyThread.dispose();
                        try {
                            this.javaThread.setContextClassLoader(oldContextClassLoader);
                        }
                        catch (SecurityException se) {
                            if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block29;
                            LOG.info("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.", new Object[0]);
                        }
                    }
                    if (this.runtime.getInstanceConfig().isProfilingEntireRun()) {
                        this.runtime.printProfileData(context.getProfileData(), System.err);
                    }
                    throw throwable;
                }
            }
            catch (ThreadKill threadKill) {
                // empty catch block
            }
        }
    }
}

