/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.CipherSpec;

public class EncContent {
    private int contentType;
    private CipherSpec cipher;
    private AlgorithmIdentifier algorithm;
    private ASN1OctetString encData;

    public final int getContentType() {
        return this.contentType;
    }

    public final void setContentType(int newContentType) {
        this.contentType = newContentType;
    }

    public final CipherSpec getCipher() {
        return this.cipher;
    }

    public final void setCipher(CipherSpec newCipher) {
        this.cipher = newCipher;
    }

    public final AlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    public final void setAlgorithm(AlgorithmIdentifier newAlgorithm) {
        this.algorithm = newAlgorithm;
    }

    public final ASN1OctetString getEncData() {
        return this.encData;
    }

    public final void setEncData(ASN1OctetString newEncData) {
        this.encData = newEncData;
    }

    public String toString() {
        return "#<EncContent contentType=" + this.contentType + " algorithm=" + (this.algorithm == null ? "null" : ASN1Registry.o2a(this.algorithm.getObjectId())) + " content=" + this.encData + ">";
    }

    public static EncContent fromASN1(DEREncodable content) {
        DERObject ee;
        ASN1Sequence sequence = (ASN1Sequence)content;
        DERObjectIdentifier contentType = (DERObjectIdentifier)sequence.getObjectAt(0);
        int nid = ASN1Registry.obj2nid(contentType);
        EncContent ec = new EncContent();
        ec.setContentType(nid);
        ec.setAlgorithm(AlgorithmIdentifier.getInstance(sequence.getObjectAt(1)));
        if (sequence.size() > 2 && sequence.getObjectAt(2) instanceof DERTaggedObject && ((DERTaggedObject)sequence.getObjectAt(2)).getTagNo() == 0 && !((ee = ((DERTaggedObject)sequence.getObjectAt(2)).getObject()) instanceof ASN1Sequence)) {
            ec.setEncData((ASN1OctetString)ee);
        }
        return ec;
    }

    public ASN1Encodable asASN1() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(ASN1Registry.nid2obj(this.contentType).toASN1Object());
        vector.add(this.algorithm.toASN1Object());
        if (this.encData != null) {
            vector.add(new DERTaggedObject(false, 0, this.encData));
        }
        return new DERSequence(vector);
    }
}

