/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.jffi.AbstractNumericMethodGenerator;
import org.jruby.ext.ffi.jffi.JITSignature;

final class FastIntMethodGenerator
extends AbstractNumericMethodGenerator {
    private static final int MAX_PARAMETERS = FastIntMethodGenerator.getMaximumFastIntParameters();
    private static final String[] signatures = FastIntMethodGenerator.buildSignatures(Integer.TYPE, MAX_PARAMETERS);
    private static final String[] methodNames = new String[]{"invokeI0", "invokeI1", "invokeI2", "invokeI3", "invokeI4", "invokeI5", "invokeI6"};

    FastIntMethodGenerator() {
    }

    String getInvokerMethodName(JITSignature signature) {
        int parameterCount = signature.getParameterCount();
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    String getInvokerSignature(int parameterCount) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    final Class getInvokerIntType() {
        return Integer.TYPE;
    }

    public boolean isSupported(JITSignature signature) {
        int parameterCount = signature.getParameterCount();
        if (!signature.getCallingConvention().equals((Object)CallingConvention.DEFAULT) || parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform = Platform.getPlatform();
        if (platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        if (!platform.getCPU().equals((Object)Platform.CPU.I386) && !platform.getCPU().equals((Object)Platform.CPU.X86_64)) {
            return false;
        }
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            if (FastIntMethodGenerator.isFastIntParameter(platform, signature.getParameterType(i2))) continue;
            return false;
        }
        return FastIntMethodGenerator.isFastIntResult(platform, signature.getResultType());
    }

    static final int getMaximumFastIntParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeI6", CallContext.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return 6;
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private static boolean isFastIntType(Platform platform, NativeType type2) {
        switch (type2) {
            case BOOL: 
            case CHAR: 
            case UCHAR: 
            case SHORT: 
            case USHORT: 
            case INT: 
            case UINT: {
                return true;
            }
            case LONG: 
            case ULONG: {
                return platform.longSize() == 32;
            }
        }
        return false;
    }

    static boolean isFastIntResult(Platform platform, NativeType type2) {
        switch (type2) {
            case VOID: {
                return true;
            }
            case POINTER: 
            case STRING: 
            case TRANSIENT_STRING: {
                return platform.addressSize() == 32;
            }
        }
        return FastIntMethodGenerator.isFastIntType(platform, type2);
    }

    static boolean isFastIntParameter(Platform platform, NativeType type2) {
        switch (type2) {
            case POINTER: 
            case STRING: 
            case TRANSIENT_STRING: 
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                return platform.addressSize() == 32;
            }
        }
        return FastIntMethodGenerator.isFastIntType(platform, type2);
    }
}

