/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.SwappedMemoryIO;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Pointer"}, parent="AbstractMemory")
public class Pointer
extends AbstractMemory {
    public static RubyClass createPointerClass(Ruby runtime, RubyModule module) {
        RubyClass result2 = module.defineClassUnder("Pointer", module.getClass("AbstractMemory"), PointerAllocator.INSTANCE);
        result2.defineAnnotatedMethods(Pointer.class);
        result2.defineAnnotatedConstants(Pointer.class);
        module.defineClassUnder("NullPointerError", runtime.getRuntimeError(), runtime.getRuntimeError().getAllocator());
        result2.setConstant("NULL", new Pointer(runtime, result2, new NullMemoryIO(runtime)));
        return result2;
    }

    public static final Pointer getNull(Ruby runtime) {
        return (Pointer)runtime.getFFI().pointerClass.getConstant("NULL");
    }

    Pointer(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz, runtime.getFFI().getNullMemoryIO(), 0L);
    }

    public Pointer(Ruby runtime, DirectMemoryIO io2) {
        this(runtime, Pointer.getPointerClass(runtime), io2);
    }

    public Pointer(Ruby runtime, DirectMemoryIO io2, long size2, int typeSize) {
        this(runtime, Pointer.getPointerClass(runtime), io2, size2, typeSize);
    }

    protected Pointer(Ruby runtime, RubyClass klass, DirectMemoryIO io2) {
        super(runtime, klass, io2, Long.MAX_VALUE);
    }

    protected Pointer(Ruby runtime, RubyClass klass, DirectMemoryIO io2, long size2) {
        super(runtime, klass, io2, size2);
    }

    protected Pointer(Ruby runtime, RubyClass klass, DirectMemoryIO io2, long size2, int typeSize) {
        super(runtime, klass, io2, size2, typeSize);
    }

    public static final RubyClass getPointerClass(Ruby runtime) {
        return runtime.getFFI().pointerClass;
    }

    public final AbstractMemory order(Ruby runtime, ByteOrder order2) {
        return new Pointer(runtime, order2.equals(this.getMemoryIO().order()) ? (DirectMemoryIO)this.getMemoryIO() : new SwappedMemoryIO(runtime, this.getMemoryIO()), this.size, this.typeSize);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject address2) {
        this.io = address2 instanceof Pointer ? ((Pointer)address2).getMemoryIO() : Factory.getInstance().wrapDirectMemory(context.runtime, RubyFixnum.num2long(address2));
        this.size = Long.MAX_VALUE;
        this.typeSize = 1;
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject type2, IRubyObject address2) {
        this.io = address2 instanceof Pointer ? ((Pointer)address2).getMemoryIO() : Factory.getInstance().wrapDirectMemory(context.runtime, RubyFixnum.num2long(address2));
        this.size = Long.MAX_VALUE;
        this.typeSize = Pointer.calculateTypeSize(context, type2);
        return this;
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this;
        }
        Pointer orig = (Pointer)other;
        this.typeSize = orig.typeSize;
        this.size = orig.size;
        this.setMemoryIO(orig.getMemoryIO().dup());
        return this;
    }

    @JRubyMethod(name={"null?"})
    public IRubyObject null_p(ThreadContext context) {
        return context.runtime.newBoolean(this.getMemoryIO().isNull());
    }

    @JRubyMethod(name={"to_s", "inspect"}, optional=1)
    public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
        String s2 = this.size != Long.MAX_VALUE ? String.format("#<%s address=0x%x size=%s>", this.getMetaClass().getName(), this.getAddress(), this.size) : String.format("#<%s address=0x%x>", this.getMetaClass().getName(), this.getAddress());
        return RubyString.newString(context.runtime, s2);
    }

    @JRubyMethod(name={"address", "to_i"})
    public IRubyObject address(ThreadContext context) {
        return context.runtime.newFixnum(this.getAddress());
    }

    public final long getAddress() {
        return ((DirectMemoryIO)this.getMemoryIO()).getAddress();
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return context.runtime.newBoolean(this == obj || this.getAddress() == 0L && obj.isNil() || obj instanceof Pointer && ((Pointer)obj).getAddress() == this.getAddress());
    }

    protected AbstractMemory slice(Ruby runtime, long offset2) {
        return new Pointer(runtime, Pointer.getPointerClass(runtime), (DirectMemoryIO)this.getMemoryIO().slice(offset2), this.size == Long.MAX_VALUE ? Long.MAX_VALUE : this.size - offset2, this.typeSize);
    }

    protected AbstractMemory slice(Ruby runtime, long offset2, long size2) {
        return new Pointer(runtime, Pointer.getPointerClass(runtime), (DirectMemoryIO)this.getMemoryIO().slice(offset2, size2), size2, this.typeSize);
    }

    protected Pointer getPointer(Ruby runtime, long offset2) {
        return new Pointer(runtime, Pointer.getPointerClass(runtime), this.getMemoryIO().getMemoryIO(offset2), Long.MAX_VALUE);
    }

    private static final class PointerAllocator
    implements ObjectAllocator {
        static final ObjectAllocator INSTANCE = new PointerAllocator();

        private PointerAllocator() {
        }

        public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
            return new Pointer(runtime, klazz);
        }
    }
}

