/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.isismtt.x509;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.x500.DirectoryString;

public class NamingAuthority
extends ASN1Encodable {
    public static final DERObjectIdentifier id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern = new DERObjectIdentifier(ISISMTTObjectIdentifiers.id_isismtt_at_namingAuthorities + ".1");
    private DERObjectIdentifier namingAuthorityId;
    private String namingAuthorityUrl;
    private DirectoryString namingAuthorityText;

    public static NamingAuthority getInstance(Object object) {
        if (object == null || object instanceof NamingAuthority) {
            return (NamingAuthority)object;
        }
        if (object instanceof ASN1Sequence) {
            return new NamingAuthority((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static NamingAuthority getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return NamingAuthority.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    private NamingAuthority(ASN1Sequence aSN1Sequence) {
        DEREncodable dEREncodable;
        if (aSN1Sequence.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        if (enumeration.hasMoreElements()) {
            dEREncodable = (DEREncodable)enumeration.nextElement();
            if (dEREncodable instanceof DERObjectIdentifier) {
                this.namingAuthorityId = (DERObjectIdentifier)dEREncodable;
            } else if (dEREncodable instanceof DERIA5String) {
                this.namingAuthorityUrl = DERIA5String.getInstance(dEREncodable).getString();
            } else if (dEREncodable instanceof ASN1String) {
                this.namingAuthorityText = DirectoryString.getInstance(dEREncodable);
            } else {
                throw new IllegalArgumentException("Bad object encountered: " + dEREncodable.getClass());
            }
        }
        if (enumeration.hasMoreElements()) {
            dEREncodable = (DEREncodable)enumeration.nextElement();
            if (dEREncodable instanceof DERIA5String) {
                this.namingAuthorityUrl = DERIA5String.getInstance(dEREncodable).getString();
            } else if (dEREncodable instanceof ASN1String) {
                this.namingAuthorityText = DirectoryString.getInstance(dEREncodable);
            } else {
                throw new IllegalArgumentException("Bad object encountered: " + dEREncodable.getClass());
            }
        }
        if (enumeration.hasMoreElements()) {
            dEREncodable = (DEREncodable)enumeration.nextElement();
            if (dEREncodable instanceof ASN1String) {
                this.namingAuthorityText = DirectoryString.getInstance(dEREncodable);
            } else {
                throw new IllegalArgumentException("Bad object encountered: " + dEREncodable.getClass());
            }
        }
    }

    public DERObjectIdentifier getNamingAuthorityId() {
        return this.namingAuthorityId;
    }

    public DirectoryString getNamingAuthorityText() {
        return this.namingAuthorityText;
    }

    public String getNamingAuthorityUrl() {
        return this.namingAuthorityUrl;
    }

    public NamingAuthority(DERObjectIdentifier dERObjectIdentifier, String string2, DirectoryString directoryString) {
        this.namingAuthorityId = dERObjectIdentifier;
        this.namingAuthorityUrl = string2;
        this.namingAuthorityText = directoryString;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.namingAuthorityId != null) {
            aSN1EncodableVector.add(this.namingAuthorityId);
        }
        if (this.namingAuthorityUrl != null) {
            aSN1EncodableVector.add(new DERIA5String(this.namingAuthorityUrl, true));
        }
        if (this.namingAuthorityText != null) {
            aSN1EncodableVector.add(this.namingAuthorityText);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

