/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.psych;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOOutputStream;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.emitter.EmitterException;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;

public class PsychEmitter
extends RubyObject {
    Emitter emitter;
    DumperOptions options = new DumperOptions();
    private static final Mark NULL_MARK = new Mark(null, 0, 0, 0, null, 0);

    public static void initPsychEmitter(Ruby runtime2, RubyModule psych2) {
        RubyClass psychEmitter = runtime2.defineClassUnder("Emitter", runtime2.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new PsychEmitter(runtime2, klazz);
            }
        }, psych2);
        psychEmitter.defineAnnotatedMethods(PsychEmitter.class);
    }

    public PsychEmitter(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject io2) {
        this.options = new DumperOptions();
        this.options.setIndent(2);
        this.emitter = new Emitter(new OutputStreamWriter(new IOOutputStream(io2)), this.options);
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject start_stream(ThreadContext context, IRubyObject encoding2) {
        StreamStartEvent event = new StreamStartEvent(NULL_MARK, NULL_MARK);
        this.emit(context, event);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_stream(ThreadContext context) {
        StreamEndEvent event = new StreamEndEvent(NULL_MARK, NULL_MARK);
        this.emit(context, event);
        return this;
    }

    @JRubyMethod
    public IRubyObject start_document(ThreadContext context, IRubyObject version, IRubyObject tags, IRubyObject implicit) {
        RubyArray tagsAry;
        Integer[] versionInts = new Integer[]{1, 1};
        boolean implicitBool = implicit.isTrue();
        HashMap<String, String> tagsMap = Collections.EMPTY_MAP;
        RubyArray versionAry = version.convertToArray();
        if (versionAry.size() == 2) {
            versionInts[0] = (int)versionAry.eltInternal(0).convertToInteger().getLongValue();
            versionInts[1] = (int)versionAry.eltInternal(1).convertToInteger().getLongValue();
        }
        if ((tagsAry = tags.convertToArray()).size() > 0) {
            tagsMap = new HashMap<String, String>(tagsAry.size());
            for (int i2 = 0; i2 < tagsAry.size(); ++i2) {
                RubyArray tagsTuple = tagsAry.eltInternal(i2).convertToArray();
                if (tagsTuple.size() != 2) {
                    throw context.runtime.newRuntimeError("tags tuple must be of length 2");
                }
                IRubyObject key2 = tagsTuple.eltInternal(0);
                IRubyObject value2 = tagsTuple.eltInternal(1);
                tagsMap.put(key2.asJavaString(), value2.asJavaString());
            }
        }
        DocumentStartEvent event = new DocumentStartEvent(NULL_MARK, NULL_MARK, implicitBool, versionInts, tagsMap);
        this.emit(context, event);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_document(ThreadContext context, IRubyObject implicit) {
        DocumentEndEvent event = new DocumentEndEvent(NULL_MARK, NULL_MARK, implicit.isTrue());
        this.emit(context, event);
        return this;
    }

    @JRubyMethod(required=6)
    public IRubyObject scalar(ThreadContext context, IRubyObject[] args2) {
        IRubyObject value2 = args2[0];
        IRubyObject anchor = args2[1];
        IRubyObject tag = args2[2];
        IRubyObject plain = args2[3];
        IRubyObject quoted = args2[4];
        IRubyObject style = args2[5];
        ScalarEvent event = new ScalarEvent(anchor.isNil() ? null : anchor.asJavaString(), tag.isNil() ? null : tag.asJavaString(), new ImplicitTuple(plain.isTrue(), quoted.isTrue()), value2.asJavaString(), NULL_MARK, NULL_MARK, Character.valueOf((char)style.convertToInteger().getLongValue()));
        this.emit(context, event);
        return this;
    }

    @JRubyMethod(required=4)
    public IRubyObject start_sequence(ThreadContext context, IRubyObject[] args2) {
        IRubyObject anchor = args2[0];
        IRubyObject tag = args2[1];
        IRubyObject implicit = args2[2];
        IRubyObject style = args2[3];
        SequenceStartEvent event = new SequenceStartEvent(anchor.isNil() ? null : anchor.asJavaString(), tag.isNil() ? null : tag.asJavaString(), implicit.isTrue(), NULL_MARK, NULL_MARK, style.convertToInteger().getLongValue() == 0L);
        this.emit(context, event);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_sequence(ThreadContext context) {
        SequenceEndEvent event = new SequenceEndEvent(NULL_MARK, NULL_MARK);
        this.emit(context, event);
        return this;
    }

    @JRubyMethod(required=4)
    public IRubyObject start_mapping(ThreadContext context, IRubyObject[] args2) {
        IRubyObject anchor = args2[0];
        IRubyObject tag = args2[1];
        IRubyObject implicit = args2[2];
        IRubyObject style = args2[3];
        MappingStartEvent event = new MappingStartEvent(anchor.isNil() ? null : anchor.asJavaString(), tag.isNil() ? null : tag.asJavaString(), implicit.isTrue(), NULL_MARK, NULL_MARK, style.convertToInteger().getLongValue() == 0L);
        this.emit(context, event);
        return this;
    }

    @JRubyMethod
    public IRubyObject end_mapping(ThreadContext context) {
        MappingEndEvent event = new MappingEndEvent(NULL_MARK, NULL_MARK);
        this.emit(context, event);
        return this;
    }

    @JRubyMethod
    public IRubyObject alias(ThreadContext context, IRubyObject anchor) {
        AliasEvent event = new AliasEvent(anchor.asJavaString(), NULL_MARK, NULL_MARK);
        this.emit(context, event);
        return this;
    }

    @JRubyMethod(name={"canonical="})
    public IRubyObject canonical_set(ThreadContext context, IRubyObject style) {
        this.options.setCanonical(style.isTrue());
        return style;
    }

    @JRubyMethod
    public IRubyObject canonical(ThreadContext context) {
        return context.runtime.newBoolean(this.options.isCanonical());
    }

    @JRubyMethod(name={"indentation="})
    public IRubyObject indentation_set(ThreadContext context, IRubyObject level2) {
        this.options.setIndent((int)level2.convertToInteger().getLongValue());
        return level2;
    }

    @JRubyMethod
    public IRubyObject indentation(ThreadContext context) {
        return context.runtime.newFixnum(this.options.getIndent());
    }

    private void emit(ThreadContext context, Event event) {
        try {
            this.emitter.emit(event);
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        catch (EmitterException ee) {
            throw context.runtime.newRuntimeError(ee.toString());
        }
    }
}

