/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import com.kenai.constantine.platform.Fcntl;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.ShellLauncher;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.STDIO;
import org.jruby.util.io.SelectBlob;
import org.jruby.util.io.Stream;

@JRubyClass(name={"IO"}, include={"Enumerable"})
public class RubyIO
extends RubyObject {
    private static ObjectAllocator IO_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyIO(runtime2, klass);
        }
    };
    private static String vendor;
    private static String msgEINTR;
    private static final ByteList NIL_BYTELIST;
    private static final ByteList RECURSIVE_BYTELIST;
    protected OpenFile openFile;
    protected List<RubyThread> blockingThreads;
    protected Encoding externalEncoding;
    protected Encoding internalEncoding;

    public RubyIO(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.openFile = new OpenFile();
    }

    public RubyIO(Ruby runtime2, OutputStream outputStream) {
        super(runtime2, runtime2.getIO());
        if (outputStream == null) {
            throw runtime2.newRuntimeError("Opening null stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.open(runtime2, new ChannelDescriptor(Channels.newChannel(outputStream))));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(66);
    }

    public RubyIO(Ruby runtime2, InputStream inputStream) {
        super(runtime2, runtime2.getIO());
        if (inputStream == null) {
            throw runtime2.newRuntimeError("Opening null stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.open(runtime2, new ChannelDescriptor(Channels.newChannel(inputStream))));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(1);
    }

    public RubyIO(Ruby runtime2, Channel channel) {
        super(runtime2, runtime2.getIO());
        if (channel == null) {
            throw runtime2.newRuntimeError("Opening null channelpo");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.open(runtime2, new ChannelDescriptor(channel)));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
    }

    public RubyIO(Ruby runtime2, ShellLauncher.POpenProcess process, ModeFlags modes) {
        super(runtime2, runtime2.getIO());
        this.openFile = new OpenFile();
        this.openFile.setMode(modes.getOpenFileFlags() | 8);
        this.openFile.setProcess(process);
        try {
            if (this.openFile.isReadable()) {
                ReadableByteChannel inChannel = process.getInput() != null ? process.getInput() : Channels.newChannel(process.getInputStream());
                ChannelDescriptor main2 = new ChannelDescriptor(inChannel);
                main2.setCanBeSeekable(false);
                this.openFile.setMainStream(ChannelStream.open(this.getRuntime(), main2));
            }
            if (this.openFile.isWritable() && process.hasOutput()) {
                WritableByteChannel outChannel = process.getOutput() != null ? process.getOutput() : Channels.newChannel(process.getOutputStream());
                ChannelDescriptor pipe2 = new ChannelDescriptor(outChannel);
                pipe2.setCanBeSeekable(false);
                if (this.openFile.getMainStream() != null) {
                    this.openFile.setPipeStream(ChannelStream.open(this.getRuntime(), pipe2));
                } else {
                    this.openFile.setMainStream(ChannelStream.open(this.getRuntime(), pipe2));
                }
            }
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
    }

    public RubyIO(Ruby runtime2, STDIO stdio) {
        super(runtime2, runtime2.getIO());
        this.openFile = new OpenFile();
        try {
            switch (stdio) {
                case IN: {
                    ChannelDescriptor descriptor = new ChannelDescriptor(runtime2.getIn(), new ModeFlags(ModeFlags.RDONLY), FileDescriptor.in);
                    runtime2.putFilenoMap(0, descriptor.getFileno());
                    Stream mainStream = ChannelStream.open(runtime2, descriptor);
                    this.openFile.setMainStream(mainStream);
                    break;
                }
                case OUT: {
                    ChannelDescriptor descriptor = new ChannelDescriptor((Channel)Channels.newChannel(runtime2.getOut()), new ModeFlags(ModeFlags.WRONLY | ModeFlags.APPEND), FileDescriptor.out);
                    runtime2.putFilenoMap(1, descriptor.getFileno());
                    Stream mainStream = ChannelStream.open(runtime2, descriptor);
                    this.openFile.setMainStream(mainStream);
                    this.openFile.getMainStream().setSync(true);
                    break;
                }
                case ERR: {
                    ChannelDescriptor descriptor = new ChannelDescriptor((Channel)Channels.newChannel(runtime2.getErr()), new ModeFlags(ModeFlags.WRONLY | ModeFlags.APPEND), FileDescriptor.err);
                    runtime2.putFilenoMap(2, descriptor.getFileno());
                    Stream mainStream = ChannelStream.open(runtime2, descriptor);
                    this.openFile.setMainStream(mainStream);
                    this.openFile.getMainStream().setSync(true);
                }
            }
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.openFile.setAutoclose(false);
    }

    public static RubyIO newIO(Ruby runtime2, Channel channel) {
        return new RubyIO(runtime2, channel);
    }

    public OpenFile getOpenFile() {
        return this.openFile;
    }

    protected OpenFile getOpenFileChecked() {
        this.openFile.checkClosed(this.getRuntime());
        return this.openFile;
    }

    public int getNativeTypeIndex() {
        return 26;
    }

    public static RubyClass createIOClass(Ruby runtime2) {
        RubyClass ioClass = runtime2.defineClass("IO", runtime2.getObject(), IO_ALLOCATOR);
        ioClass.index = 31;
        ioClass.setReifiedClass(RubyIO.class);
        ioClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyIO;
            }
        };
        ioClass.includeModule(runtime2.getEnumerable());
        ioClass.defineAnnotatedMethods(RubyIO.class);
        ioClass.fastSetConstant("SEEK_SET", runtime2.newFixnum(0));
        ioClass.fastSetConstant("SEEK_CUR", runtime2.newFixnum(1));
        ioClass.fastSetConstant("SEEK_END", runtime2.newFixnum(2));
        if (runtime2.is1_9()) {
            ioClass.defineModuleUnder("WaitReadable");
            ioClass.defineModuleUnder("WaitWritable");
        }
        return ioClass;
    }

    public OutputStream getOutStream() {
        try {
            return this.getOpenFileChecked().getMainStreamSafe().newOutputStream();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    public InputStream getInStream() {
        try {
            return this.getOpenFileChecked().getMainStreamSafe().newInputStream();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    public Channel getChannel() {
        try {
            return this.getOpenFileChecked().getMainStreamSafe().getChannel();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @Deprecated
    public Stream getHandler() throws BadDescriptorException {
        return this.getOpenFileChecked().getMainStreamSafe();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void reopenPath(Ruby runtime2, IRubyObject[] args2) {
        if (runtime2.is1_9() && !(args2[0] instanceof RubyString) && args2[0].respondsTo("to_path")) {
            args2[0] = args2[0].callMethod(runtime2.getCurrentContext(), "to_path");
        }
        RubyString pathString = args2[0].convertToString();
        try {
            ModeFlags modes;
            if (args2.length > 1) {
                RubyString modeString = args2[1].convertToString();
                modes = RubyIO.getIOModes(runtime2, ((Object)modeString).toString());
                this.openFile.setMode(modes.getOpenFileFlags());
            } else {
                modes = RubyIO.getIOModes(runtime2, "r");
            }
            String path2 = ((Object)pathString).toString();
            this.openFile.setPath(path2);
            if (this.openFile.getMainStream() == null) {
                try {
                    this.openFile.setMainStream(ChannelStream.fopen(runtime2, path2, modes));
                }
                catch (FileExistsException fee) {
                    throw runtime2.newErrnoEEXISTError(path2);
                }
                if (this.openFile.getPipeStream() == null) return;
                this.openFile.getPipeStream().fclose();
                this.openFile.setPipeStream(null);
                return;
            }
            this.openFile.getMainStreamSafe().freopen(runtime2, path2, RubyIO.getIOModes(runtime2, this.openFile.getModeAsString(runtime2)));
            if (this.openFile.getPipeStream() == null) return;
        }
        catch (PipeException pe) {
            throw runtime2.newErrnoEPIPEError();
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw runtime2.newErrnoEINVALError();
        }
    }

    protected void reopenIO(Ruby runtime2, RubyIO ios) {
        try {
            if (ios.openFile == this.openFile) {
                return;
            }
            OpenFile originalFile = ios.getOpenFileChecked();
            OpenFile selfFile = this.getOpenFileChecked();
            long pos2 = 0L;
            if (originalFile.isReadable()) {
                pos2 = originalFile.getMainStreamSafe().fgetpos();
            }
            if (originalFile.getPipeStream() != null) {
                originalFile.getPipeStream().fflush();
            } else if (originalFile.isWritable()) {
                originalFile.getMainStreamSafe().fflush();
            }
            if (selfFile.isWritable()) {
                selfFile.getWriteStreamSafe().fflush();
            }
            selfFile.setMode(originalFile.getMode());
            selfFile.setProcess(originalFile.getProcess());
            selfFile.setLineNumber(originalFile.getLineNumber());
            selfFile.setPath(originalFile.getPath());
            selfFile.setFinalizer(originalFile.getFinalizer());
            ChannelDescriptor selfDescriptor = selfFile.getMainStreamSafe().getDescriptor();
            ChannelDescriptor originalDescriptor = originalFile.getMainStreamSafe().getDescriptor();
            if (selfDescriptor.getChannel() != originalDescriptor.getChannel()) {
                if (runtime2.getFileno(selfDescriptor) >= 0 && runtime2.getFileno(selfDescriptor) <= 2) {
                    selfFile.getMainStreamSafe().clearerr();
                    originalDescriptor.dup2Into(selfDescriptor);
                } else {
                    Stream pipeFile = selfFile.getPipeStream();
                    int mode2 = selfFile.getMode();
                    selfFile.getMainStreamSafe().fclose();
                    selfFile.setPipeStream(null);
                    if (pipeFile != null) {
                        selfFile.setMainStream(ChannelStream.fdopen(runtime2, originalDescriptor, new ModeFlags()));
                        selfFile.setPipeStream(pipeFile);
                    } else {
                        selfFile.setMainStream(ChannelStream.open(runtime2, originalDescriptor.dup2(selfDescriptor.getFileno())));
                        selfFile.getMainStreamSafe().setSync(selfFile.getMainStreamSafe().isSync());
                    }
                    selfFile.setMode(mode2);
                }
                if (originalFile.isReadable() && pos2 >= 0L) {
                    selfFile.seek(pos2, 0);
                    originalFile.seek(pos2, 0);
                }
            }
            if (selfFile.getPipeStream() != null && selfDescriptor.getFileno() != selfFile.getPipeStream().getDescriptor().getFileno()) {
                int fd = selfFile.getPipeStream().getDescriptor().getFileno();
                if (originalFile.getPipeStream() == null) {
                    selfFile.getPipeStream().fclose();
                    selfFile.setPipeStream(null);
                } else if (fd != originalFile.getPipeStream().getDescriptor().getFileno()) {
                    selfFile.getPipeStream().fclose();
                    ChannelDescriptor newFD2 = originalFile.getPipeStream().getDescriptor().dup2(fd);
                    selfFile.setPipeStream(ChannelStream.fdopen(runtime2, newFD2, RubyIO.getIOModes(runtime2, "w")));
                }
            }
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newIOError("could not reopen: " + ex.getMessage());
        }
        catch (PipeException ex) {
            throw runtime2.newIOError("could not reopen: " + ex.getMessage());
        }
        catch (InvalidValueException ive) {
            throw runtime2.newErrnoEINVALError();
        }
    }

    @JRubyMethod(name={"reopen"}, required=1, optional=1)
    public IRubyObject reopen(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(args2[0], runtime2.getIO(), "to_io");
        if (!tmp.isNil()) {
            this.reopenIO(runtime2, (RubyIO)tmp);
        } else {
            this.reopenPath(runtime2, args2);
        }
        return this;
    }

    public static ModeFlags getIOModes(Ruby runtime2, String modesString) throws InvalidValueException {
        return new ModeFlags(RubyIO.getIOModesIntFromString(runtime2, modesString));
    }

    public static int getIOModesIntFromString(Ruby runtime2, String modesString) {
        int modes = 0;
        int length2 = modesString.length();
        if (length2 == 0) {
            throw runtime2.newArgumentError("illegal access mode");
        }
        switch (modesString.charAt(0)) {
            case 'r': {
                modes |= ModeFlags.RDONLY;
                break;
            }
            case 'a': {
                modes |= ModeFlags.APPEND | ModeFlags.WRONLY | ModeFlags.CREAT;
                break;
            }
            case 'w': {
                modes |= ModeFlags.WRONLY | ModeFlags.TRUNC | ModeFlags.CREAT;
                break;
            }
            default: {
                throw runtime2.newArgumentError("illegal access mode " + modesString);
            }
        }
        block11: for (int n = 1; n < length2; ++n) {
            switch (modesString.charAt(n)) {
                case 'b': {
                    modes |= ModeFlags.BINARY;
                    continue block11;
                }
                case '+': {
                    modes = modes & ~ModeFlags.ACCMODE | ModeFlags.RDWR;
                    continue block11;
                }
                case 't': {
                    continue block11;
                }
                case ':': {
                    break block11;
                }
                default: {
                    throw runtime2.newArgumentError("illegal access mode " + modesString);
                }
            }
        }
        return modes;
    }

    private ByteList separator(Ruby runtime2) {
        return this.separator(runtime2, runtime2.getRecordSeparatorVar().get());
    }

    private ByteList separator(Ruby runtime2, IRubyObject separatorValue) {
        ByteList separator;
        ByteList byteList = separator = separatorValue.isNil() ? null : separatorValue.convertToString().getByteList();
        if (separator != null) {
            Encoding internal;
            if (separator.getRealSize() == 0) {
                separator = Stream.PARAGRAPH_DELIMETER;
            }
            if (runtime2.is1_9() && (internal = this.getInternalEncoding(runtime2)) != null) {
                separator = RubyString.transcode(runtime2.getCurrentContext(), separator, internal, this.getExternalEncoding(runtime2), runtime2.getNil());
            }
        }
        return separator;
    }

    private ByteList getSeparatorFromArgs(Ruby runtime2, IRubyObject[] args2, int idx) {
        return this.separator(runtime2, args2.length > idx ? args2[idx] : runtime2.getRecordSeparatorVar().get());
    }

    private ByteList getSeparatorForGets(Ruby runtime2, IRubyObject[] args2) {
        return this.getSeparatorFromArgs(runtime2, args2, 0);
    }

    private IRubyObject getline(Ruby runtime2, ByteList separator, ByteListCache cache) {
        return this.getline(runtime2, separator, -1L, cache);
    }

    public IRubyObject getline(Ruby runtime2, ByteList separator) {
        return this.getline(runtime2, separator, -1L, null);
    }

    public IRubyObject getline(Ruby runtime2, ByteList separator, long limit2) {
        return this.getline(runtime2, separator, limit2, null);
    }

    private IRubyObject getline(Ruby runtime2, ByteList separator, long limit2, ByteListCache cache) {
        Encoding internal;
        IRubyObject result = this.getlineInner(runtime2, separator, limit2, cache);
        if (runtime2.is1_9() && !result.isNil() && (internal = this.getInternalEncoding(runtime2)) != null) {
            result = RubyString.newStringNoCopy(runtime2, RubyString.transcode(runtime2.getCurrentContext(), ((RubyString)result).getByteList(), this.getExternalEncoding(runtime2), internal, runtime2.getNil()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRubyObject getlineInner(Ruby runtime2, ByteList separator, long limit2, ByteListCache cache) {
        try {
            RubyString rubyString;
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime2);
            myOpenFile.setReadBuffered();
            boolean isParagraph = separator == Stream.PARAGRAPH_DELIMETER;
            ByteList byteList = separator = isParagraph ? Stream.PARAGRAPH_SEPARATOR : separator;
            if (isParagraph) {
                this.swallow(10);
            }
            if (separator == null && limit2 < 0L) {
                RubyString str = this.readAll();
                if (str.getByteList().length() == 0) {
                    return runtime2.getNil();
                }
                this.incrementLineno(runtime2, myOpenFile);
                return str;
            }
            if (limit2 == 0L) {
                if (runtime2.is1_9()) {
                    return RubyString.newEmptyString(runtime2, this.getExternalEncoding(runtime2));
                }
                return RubyString.newEmptyString(runtime2);
            }
            if (separator.length() == 1 && limit2 < 0L) {
                return this.getlineFast(runtime2, separator.get(0) & 0xFF, cache);
            }
            Stream readStream = myOpenFile.getMainStreamSafe();
            int c = -1;
            int n = -1;
            int newline = separator.get(separator.length() - 1) & 0xFF;
            ByteList buf = cache != null ? cache.allocate(0) : new ByteList(0);
            try {
                boolean update2 = false;
                boolean limitReached = false;
                while (true) {
                    block28: {
                        block32: {
                            block31: {
                                block30: {
                                    Object var17_22;
                                    this.readCheck(readStream);
                                    readStream.clearerr();
                                    try {
                                        try {
                                            runtime2.getCurrentContext().getThread().beforeBlockingCall();
                                            if (limit2 == -1L) {
                                                n = readStream.getline(buf, (byte)newline);
                                            } else if ((limit2 -= (long)(n = readStream.getline(buf, (byte)newline, limit2))) <= 0L) {
                                                limitReached = true;
                                                update2 = true;
                                                var17_22 = null;
                                                runtime2.getCurrentContext().getThread().afterBlockingCall();
                                                break block28;
                                            }
                                            c = buf.length() > 0 ? buf.get(buf.length() - 1) & 0xFF : -1;
                                        }
                                        catch (EOFException e) {
                                            n = -1;
                                            var17_22 = null;
                                            runtime2.getCurrentContext().getThread().afterBlockingCall();
                                            break block30;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var17_22 = null;
                                        runtime2.getCurrentContext().getThread().afterBlockingCall();
                                        throw throwable;
                                    }
                                    var17_22 = null;
                                    runtime2.getCurrentContext().getThread().afterBlockingCall();
                                }
                                if (n != 0) break block31;
                                this.waitReadable(readStream);
                                break block32;
                            }
                            if (n == -1) break block28;
                            update2 = true;
                        }
                        if (c != newline) continue;
                    }
                    if (n == -1 || limitReached || c == newline && buf.length() >= separator.length() && 0 == ByteList.memcmp(buf.getUnsafeBytes(), buf.getBegin() + buf.getRealSize() - separator.length(), separator.getUnsafeBytes(), separator.getBegin(), separator.getRealSize())) break;
                }
                if (isParagraph && c != -1) {
                    this.swallow(10);
                }
                if (!update2) {
                    IRubyObject iRubyObject = runtime2.getNil();
                    Object var19_24 = null;
                    if (cache == null) return iRubyObject;
                    cache.release(buf);
                    return iRubyObject;
                }
                this.incrementLineno(runtime2, myOpenFile);
                rubyString = this.makeString(runtime2, buf, cache != null);
            }
            catch (Throwable throwable) {
                Object var19_26 = null;
                if (cache != null) {
                    cache.release(buf);
                }
                throw throwable;
            }
            Object var19_25 = null;
            if (cache == null) return rubyString;
            cache.release(buf);
            return rubyString;
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (EOFException e) {
            return runtime2.getNil();
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    private Encoding getExternalEncoding(Ruby runtime2) {
        return this.externalEncoding != null ? this.externalEncoding : runtime2.getDefaultExternalEncoding();
    }

    private Encoding getInternalEncoding(Ruby runtime2) {
        return this.internalEncoding != null ? this.internalEncoding : runtime2.getDefaultInternalEncoding();
    }

    private RubyString makeString(Ruby runtime2, ByteList buffer, boolean isCached) {
        ByteList newBuf;
        ByteList byteList = newBuf = isCached ? new ByteList(buffer) : buffer;
        if (runtime2.is1_9()) {
            newBuf.setEncoding(this.getExternalEncoding(runtime2));
        }
        RubyString str = RubyString.newString(runtime2, newBuf);
        str.setTaint(true);
        return str;
    }

    private void incrementLineno(Ruby runtime2, OpenFile myOpenFile) {
        int lineno2 = myOpenFile.getLineNumber() + 1;
        myOpenFile.setLineNumber(lineno2);
        runtime2.setCurrentLine(lineno2);
        RubyArgsFile.setCurrentLineNumber(runtime2.getArgsFile(), lineno2);
    }

    protected boolean swallow(int term) throws IOException, BadDescriptorException {
        int c;
        Stream readStream = this.openFile.getMainStreamSafe();
        do {
            this.readCheck(readStream);
            try {
                c = readStream.fgetc();
            }
            catch (EOFException e) {
                c = -1;
            }
            if (c == term) continue;
            readStream.ungetc(c);
            return true;
        } while (c != -1);
        return false;
    }

    public static boolean restartSystemCall(Exception e) {
        return vendor.startsWith("Apple") && e.getMessage().equals(msgEINTR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject getlineFast(Ruby runtime2, int delim, ByteListCache cache) throws IOException, BadDescriptorException {
        ByteList buf;
        block12: {
            Stream readStream = this.openFile.getMainStreamSafe();
            int c = -1;
            buf = cache != null ? cache.allocate(0) : new ByteList(0);
            try {
                boolean update2 = false;
                do {
                    Object var11_12;
                    int n;
                    this.readCheck(readStream);
                    readStream.clearerr();
                    try {
                        try {
                            runtime2.getCurrentContext().getThread().beforeBlockingCall();
                            n = readStream.getline(buf, (byte)delim);
                            c = buf.length() > 0 ? buf.get(buf.length() - 1) & 0xFF : -1;
                        }
                        catch (EOFException e) {
                            n = -1;
                            var11_12 = null;
                            runtime2.getCurrentContext().getThread().afterBlockingCall();
                        }
                        var11_12 = null;
                        runtime2.getCurrentContext().getThread().afterBlockingCall();
                    }
                    catch (Throwable throwable) {
                        var11_12 = null;
                        runtime2.getCurrentContext().getThread().afterBlockingCall();
                        throw throwable;
                    }
                    if (n == 0) {
                        this.waitReadable(readStream);
                        continue;
                    }
                    if (n == -1) break;
                    update2 = true;
                } while (c != delim);
                if (update2) break block12;
                IRubyObject iRubyObject = runtime2.getNil();
                Object var13_14 = null;
                if (cache != null) {
                    cache.release(buf);
                }
                return iRubyObject;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var13_16 = null;
                    if (cache == null) break block13;
                    cache.release(buf);
                }
                throw throwable;
            }
        }
        this.incrementLineno(runtime2, this.openFile);
        RubyString rubyString = this.makeString(runtime2, buf, cache != null);
        Object var13_15 = null;
        if (cache != null) {
            cache.release(buf);
        }
        return rubyString;
    }

    @JRubyMethod(name={"new", "for_fd"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        if (block.isGiven()) {
            String className = klass.getName();
            context.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_NOT_ACCEPTED, className + "::new() does not take block; use " + className + "::open() instead", className + "::open()");
        }
        return klass.newInstance(context, args2, block);
    }

    private IRubyObject initializeCommon19(int fileno2, ModeFlags modes) {
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.getDescriptorByFileno(this.getRuntime().getFilenoExtMap(fileno2));
            if (descriptor == null) {
                throw this.getRuntime().newErrnoEBADFError();
            }
            descriptor.checkOpen();
            if (modes == null) {
                modes = descriptor.getOriginalModes();
            }
            if (this.openFile.isOpen()) {
                this.openFile.cleanup(this.getRuntime(), false);
            }
            this.openFile.setMode(modes.getOpenFileFlags());
            this.openFile.setMainStream(this.fdopen(descriptor, modes));
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ive) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, Block unusedBlock) {
        return this.initializeCommon19(RubyNumeric.fix2int(fileNumber), null);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, IRubyObject second, Block unusedBlock) {
        int fileno2 = RubyNumeric.fix2int(fileNumber);
        ModeFlags modes = second instanceof RubyHash ? this.parseOptions(context, second, null) : this.parseModes19(context, second);
        return this.initializeCommon19(fileno2, modes);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, IRubyObject modeValue, IRubyObject options2, Block unusedBlock) {
        int fileno2 = RubyNumeric.fix2int(fileNumber);
        ModeFlags modes = this.parseModes19(context, modeValue);
        modes = this.parseOptions(context, options2, modes);
        return this.initializeCommon19(fileno2, modes);
    }

    protected ModeFlags parseModes(IRubyObject arg2) {
        try {
            if (arg2 instanceof RubyFixnum) {
                return new ModeFlags(RubyFixnum.fix2long(arg2));
            }
            return RubyIO.getIOModes(this.getRuntime(), arg2.convertToString().toString());
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
    }

    protected ModeFlags parseModes19(ThreadContext context, IRubyObject arg2) {
        ModeFlags modes = this.parseModes(arg2);
        if (arg2 instanceof RubyString) {
            this.parseEncodingFromString(context, arg2, 1);
        }
        return modes;
    }

    private void parseEncodingFromString(ThreadContext context, IRubyObject arg2, int initialPosition) {
        RubyString modes19 = arg2.convertToString();
        if (modes19.toString().contains(":")) {
            Ruby runtime2 = context.getRuntime();
            IRubyObject[] fullEncoding = modes19.split(context, RubyString.newString(runtime2, ":")).toJavaArray();
            IRubyObject externalEncodingOption = fullEncoding[initialPosition];
            RubyString dash = runtime2.newString("-");
            if (dash.eql(externalEncodingOption)) {
                externalEncodingOption = runtime2.getEncodingService().getDefaultExternal();
            }
            if (fullEncoding.length > initialPosition + 1) {
                IRubyObject internalEncodingOption = fullEncoding[initialPosition + 1];
                if (dash.eql(internalEncodingOption)) {
                    internalEncodingOption = runtime2.getEncodingService().getDefaultInternal();
                }
                this.set_encoding(context, externalEncodingOption, internalEncodingOption);
            } else {
                this.set_encoding(context, externalEncodingOption);
            }
        }
    }

    @JRubyMethod(required=1, optional=1, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        int argCount = args2.length;
        int fileno2 = RubyNumeric.fix2int(args2[0]);
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.getDescriptorByFileno(this.getRuntime().getFilenoExtMap(fileno2));
            if (descriptor == null) {
                throw this.getRuntime().newErrnoEBADFError();
            }
            descriptor.checkOpen();
            ModeFlags modes = argCount == 2 ? (args2[1] instanceof RubyFixnum ? new ModeFlags(RubyFixnum.fix2long(args2[1])) : RubyIO.getIOModes(this.getRuntime(), args2[1].convertToString().toString())) : descriptor.getOriginalModes();
            if (this.openFile.isOpen()) {
                this.openFile.cleanup(this.getRuntime(), false);
            }
            this.openFile.setMode(modes.getOpenFileFlags());
            this.openFile.setMainStream(this.fdopen(descriptor, modes));
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ive) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    protected Stream fdopen(ChannelDescriptor existingDescriptor, ModeFlags modes) throws InvalidValueException {
        if (existingDescriptor == null) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return ChannelStream.fdopen(this.getRuntime(), existingDescriptor, modes);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject external_encoding(ThreadContext context) {
        return this.externalEncoding != null ? context.getRuntime().getEncodingService().getEncoding(this.externalEncoding) : context.getRuntime().getNil();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject internal_encoding(ThreadContext context) {
        return this.internalEncoding != null ? context.getRuntime().getEncodingService().getEncoding(this.internalEncoding) : context.getRuntime().getNil();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString) {
        this.setExternalEncoding(context, encodingString);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding) {
        this.setExternalEncoding(context, encodingString);
        this.setInternalEncoding(context, internalEncoding);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding, IRubyObject options2) {
        this.setExternalEncoding(context, encodingString);
        this.setInternalEncoding(context, internalEncoding);
        return context.getRuntime().getNil();
    }

    private void setExternalEncoding(ThreadContext context, IRubyObject encoding2) {
        this.externalEncoding = this.getEncodingCommon(context, encoding2);
    }

    private void setInternalEncoding(ThreadContext context, IRubyObject encoding2) {
        Encoding internalEncodingOption = this.getEncodingCommon(context, encoding2);
        if (internalEncodingOption == this.externalEncoding) {
            context.getRuntime().getWarnings().warn("Ignoring internal encoding " + encoding2 + ": it is identical to external encoding " + this.external_encoding(context));
        } else {
            this.internalEncoding = internalEncodingOption;
        }
    }

    private Encoding getEncodingCommon(ThreadContext context, IRubyObject encoding2) {
        if (encoding2 instanceof RubyEncoding) {
            return ((RubyEncoding)encoding2).getEncoding();
        }
        return context.getRuntime().getEncodingService().getEncodingFromObject(encoding2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=2, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyClass klass = (RubyClass)recv2;
        RubyIO io2 = (RubyIO)klass.newInstance(context, args2, block);
        if (block.isGiven()) {
            IRubyObject iRubyObject;
            block8: {
                try {
                    iRubyObject = block.yield(context, io2);
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var9_9 = null;
                        try {
                            io2.getMetaClass().finvoke(context, (IRubyObject)io2, "close", IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
                        }
                        catch (RaiseException re) {
                            RubyException rubyEx = re.getException();
                            if (rubyEx.kind_of_p(context, runtime2.getStandardError()).isTrue()) {
                                runtime2.getGlobalVariables().clear("$!");
                                break block9;
                            }
                            throw re;
                        }
                    }
                    throw throwable;
                }
                try {
                    io2.getMetaClass().finvoke(context, (IRubyObject)io2, "close", IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
                }
                catch (RaiseException re) {
                    RubyException rubyEx = re.getException();
                    if (rubyEx.kind_of_p(context, runtime2.getStandardError()).isTrue()) {
                        runtime2.getGlobalVariables().clear("$!");
                        break block8;
                    }
                    throw re;
                }
            }
            return iRubyObject;
        }
        return io2;
    }

    @JRubyMethod(required=1, optional=2, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject sysopen(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString pathString = args2[0].convertToString();
        return RubyIO.sysopenCommon(recv2, args2, block, pathString);
    }

    @JRubyMethod(name={"sysopen"}, required=1, optional=2, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject sysopen19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject pathString = !(args2[0] instanceof RubyString) && args2[0].respondsTo("to_path") ? args2[0].callMethod(context, "to_path") : args2[0].convertToString();
        return RubyIO.sysopenCommon(recv2, args2, block, pathString);
    }

    private static IRubyObject sysopenCommon(IRubyObject recv2, IRubyObject[] args2, Block block, IRubyObject pathString) {
        Ruby runtime2 = recv2.getRuntime();
        runtime2.checkSafeString(pathString);
        String path2 = pathString.toString();
        ModeFlags modes = null;
        int perms = -1;
        try {
            if (args2.length > 1) {
                RubyString modeString = args2[1].convertToString();
                modes = RubyIO.getIOModes(runtime2, ((Object)modeString).toString());
            } else {
                modes = RubyIO.getIOModes(runtime2, "r");
            }
            if (args2.length > 2) {
                RubyInteger permsInt = args2.length >= 3 ? args2[2].convertToInteger() : null;
                perms = RubyNumeric.fix2int(permsInt);
            }
        }
        catch (InvalidValueException e) {
            throw runtime2.newErrnoEINVALError();
        }
        int fileno2 = -1;
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.open(runtime2.getCurrentDirectory(), path2, modes, perms, runtime2.getPosix(), runtime2.getJRubyClassLoader());
            fileno2 = descriptor.getFileno();
        }
        catch (FileNotFoundException fnfe) {
            throw runtime2.newErrnoENOENTError(path2);
        }
        catch (DirectoryAsFileException dafe) {
            throw runtime2.newErrnoEISDirError(path2);
        }
        catch (FileExistsException fee) {
            throw runtime2.newErrnoEEXISTError(path2);
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
        return runtime2.newFixnum(fileno2);
    }

    public boolean isAutoclose() {
        return this.openFile.isAutoclose();
    }

    public void setAutoclose(boolean autoclose2) {
        this.openFile.setAutoclose(autoclose2);
    }

    @JRubyMethod
    public IRubyObject autoclose(ThreadContext context) {
        return context.runtime.newBoolean(this.isAutoclose());
    }

    @JRubyMethod(name={"autoclose="})
    public IRubyObject autoclose_set(ThreadContext context, IRubyObject autoclose2) {
        this.setAutoclose(autoclose2.isTrue());
        return context.nil;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        if (this.isClosed()) {
            throw this.getRuntime().newIOError("closed stream");
        }
        Ruby runtime2 = this.getRuntime();
        if (this.getExternalEncoding(runtime2) == USASCIIEncoding.INSTANCE) {
            this.externalEncoding = ASCIIEncoding.INSTANCE;
        }
        this.openFile.setBinmode();
        return this;
    }

    @JRubyMethod(name={"binmode?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_binmode(ThreadContext context) {
        return RubyBoolean.newBoolean(context.getRuntime(), this.openFile.isBinmode());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        try {
            try {
                RubyString string2 = obj.asString();
                OpenFile myOpenFile = this.getOpenFileChecked();
                myOpenFile.checkWritable(runtime2);
                Stream writeStream = myOpenFile.getWriteStream();
                if (myOpenFile.isWriteBuffered()) {
                    runtime2.getWarnings().warn(IRubyWarnings.ID.SYSWRITE_BUFFERED_IO, "syswrite for buffered IO", new Object[0]);
                }
                if (!writeStream.getDescriptor().isWritable()) {
                    myOpenFile.checkClosed(runtime2);
                }
                context.getThread().beforeBlockingCall();
                int read2 = writeStream.getDescriptor().write(string2.getByteList());
                if (read2 == -1) {
                    // empty if block
                }
                RubyFixnum rubyFixnum = runtime2.newFixnum(read2);
                Object var10_12 = null;
                context.getThread().afterBlockingCall();
                return rubyFixnum;
            }
            catch (InvalidValueException ex) {
                throw runtime2.newErrnoEINVALError();
            }
            catch (BadDescriptorException e) {
                throw runtime2.newErrnoEBADFError();
            }
            catch (IOException e) {
                throw runtime2.newSystemCallError(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            context.getThread().afterBlockingCall();
            throw throwable;
        }
    }

    @JRubyMethod(name={"write_nonblock"}, required=1)
    public IRubyObject write_nonblock(ThreadContext context, IRubyObject obj) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.checkWritable(context.getRuntime());
            RubyString str = obj.asString();
            if (str.getByteList().length() == 0) {
                return context.getRuntime().newFixnum(0);
            }
            if (myOpenFile.isWriteBuffered()) {
                context.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYSWRITE_BUFFERED_IO, "write_nonblock for buffered IO", new Object[0]);
            }
            int written = myOpenFile.getWriteStream().getDescriptor().write(str.getByteList());
            return context.getRuntime().newFixnum(written);
        }
        catch (IOException ex) {
            throw context.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        runtime2.secure(4);
        RubyString str = obj.asString();
        if (str.getByteList().length() == 0) {
            return runtime2.newFixnum(0);
        }
        try {
            try {
                OpenFile myOpenFile = this.getOpenFileChecked();
                myOpenFile.checkWritable(runtime2);
                context.getThread().beforeBlockingCall();
                int written = this.fwrite(str.getByteList());
                if (written == -1) {
                    // empty if block
                }
                if (!myOpenFile.isSync()) {
                    myOpenFile.setWriteBuffered();
                }
                RubyFixnum rubyFixnum = runtime2.newFixnum(written);
                Object var9_11 = null;
                context.getThread().afterBlockingCall();
                return rubyFixnum;
            }
            catch (IOException ex) {
                throw runtime2.newIOErrorFromException(ex);
            }
            catch (BadDescriptorException ex) {
                throw runtime2.newErrnoEBADFError();
            }
            catch (InvalidValueException ex) {
                throw runtime2.newErrnoEINVALError();
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            context.getThread().afterBlockingCall();
            throw throwable;
        }
    }

    private boolean waitWritable(Stream stream) {
        Channel ch = stream.getChannel();
        if (ch instanceof SelectableChannel) {
            this.getRuntime().getCurrentContext().getThread().select(ch, this, 4);
            return true;
        }
        return false;
    }

    private boolean waitReadable(Stream stream) {
        if (stream.readDataBuffered()) {
            return true;
        }
        Channel ch = stream.getChannel();
        if (ch instanceof SelectableChannel) {
            this.getRuntime().getCurrentContext().getThread().select(ch, this, 1);
            return true;
        }
        return false;
    }

    protected int fwrite(ByteList buffer) {
        int offset2 = 0;
        boolean eagain = false;
        Stream writeStream = this.openFile.getWriteStream();
        int len = buffer.length();
        int n = len;
        if (n <= 0) {
            return n;
        }
        try {
            if (this.openFile.isSync()) {
                this.openFile.fflush(writeStream);
                while (offset2 < len) {
                    int l = n;
                    int r = writeStream.getDescriptor().write(buffer, offset2, l);
                    if (r == len) {
                        return len;
                    }
                    if (0 <= r) {
                        offset2 += r;
                        n -= r;
                        eagain = true;
                    }
                    if (eagain && this.waitWritable(writeStream)) {
                        this.openFile.checkClosed(this.getRuntime());
                        if (offset2 >= buffer.length()) {
                            return -1;
                        }
                        eagain = false;
                        continue;
                    }
                    return -1;
                }
            }
            return writeStream.fwrite(buffer);
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_append(ThreadContext context, IRubyObject anObject) {
        this.callMethod(context, "write", anObject);
        return this;
    }

    @JRubyMethod(name={"fileno"}, alias={"to_i"})
    public RubyFixnum fileno(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        try {
            return runtime2.newFixnum(runtime2.getFileno(this.getOpenFileChecked().getMainStreamSafe().getDescriptor()));
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"lineno"})
    public RubyFixnum lineno(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public RubyFixnum lineno_set(ThreadContext context, IRubyObject newLineNumber) {
        this.getOpenFileChecked().setLineNumber(RubyNumeric.fix2int(newLineNumber));
        return context.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"sync"})
    public RubyBoolean sync(ThreadContext context) {
        try {
            return context.getRuntime().newBoolean(this.getOpenFileChecked().getMainStreamSafe().isSync());
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid(ThreadContext context) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (myOpenFile.getProcess() == null) {
            return context.getRuntime().getNil();
        }
        long pid2 = myOpenFile.getPid();
        return context.getRuntime().newFixnum(pid2);
    }

    @JRubyMethod(name={"pos", "tell"})
    public RubyFixnum pos(ThreadContext context) {
        try {
            return context.getRuntime().newFixnum(this.getOpenFileChecked().getMainStreamSafe().fgetpos());
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException bde) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"pos="}, required=1)
    public RubyFixnum pos_set(ThreadContext context, IRubyObject newPosition) {
        long offset2 = RubyNumeric.num2long(newPosition);
        if (offset2 < 0L) {
            throw context.getRuntime().newSystemCallError("Negative seek offset");
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.getMainStreamSafe().lseek(offset2, 0);
            myOpenFile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException e) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOErrorFromException(e);
        }
        return context.getRuntime().newFixnum(offset2);
    }

    @JRubyMethod(name={"print"}, rest=true, reads={FrameField.LASTLINE})
    public IRubyObject print(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.print(context, this, args2);
    }

    public static IRubyObject print(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{context.getCurrentScope().getLastLine(context.getRuntime())};
        }
        Ruby runtime2 = context.getRuntime();
        IRubyObject fs = runtime2.getGlobalVariables().get("$,");
        IRubyObject rs = runtime2.getGlobalVariables().get("$\\");
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (i2 > 0 && !fs.isNil()) {
                maybeIO.callMethod(context, "write", fs);
            }
            if (args2[i2].isNil()) {
                maybeIO.callMethod(context, "write", runtime2.newString("nil"));
                continue;
            }
            maybeIO.callMethod(context, "write", args2[i2]);
        }
        if (!rs.isNil()) {
            maybeIO.callMethod(context, "write", rs);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        this.callMethod(context, "write", RubyKernel.sprintf(context, this, args2));
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1, backtrace=true)
    public IRubyObject putc(ThreadContext context, IRubyObject object) {
        return RubyIO.putc(context, this, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRubyObject putc(ThreadContext context, IRubyObject maybeIO, IRubyObject object) {
        byte c = RubyNumeric.num2chr(object);
        if (maybeIO instanceof RubyIO) {
            RubyIO io2 = (RubyIO)maybeIO;
            try {
                OpenFile myOpenFile = io2.getOpenFileChecked();
                myOpenFile.checkWritable(context.getRuntime());
                Stream writeStream = myOpenFile.getWriteStream();
                writeStream.fputc(c);
                if (!myOpenFile.isSync()) return object;
                myOpenFile.fflush(writeStream);
                return object;
            }
            catch (IOException ex) {
                throw context.getRuntime().newIOErrorFromException(ex);
            }
            catch (BadDescriptorException e) {
                throw context.getRuntime().newErrnoEBADFError();
            }
            catch (InvalidValueException ex) {
                throw context.getRuntime().newErrnoEINVALError();
            }
        } else {
            maybeIO.callMethod(context, "write", RubyString.newStringNoCopy(context.getRuntime(), new byte[]{c}));
        }
        return object;
    }

    public RubyFixnum seek(ThreadContext context, IRubyObject[] args2) {
        long offset2 = RubyNumeric.num2long(args2[0]);
        int whence = 0;
        if (args2.length > 1) {
            whence = RubyNumeric.fix2int(args2[1].convertToInteger());
        }
        return this.doSeek(context, offset2, whence);
    }

    @JRubyMethod(name={"seek"})
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0) {
        long offset2 = RubyNumeric.num2long(arg0);
        int whence = 0;
        return this.doSeek(context, offset2, whence);
    }

    @JRubyMethod(name={"seek"})
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        long offset2 = RubyNumeric.num2long(arg0);
        int whence = RubyNumeric.fix2int(arg1.convertToInteger());
        return this.doSeek(context, offset2, whence);
    }

    private RubyFixnum doSeek(ThreadContext context, long offset2, int whence) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.seek(offset2, whence);
            myOpenFile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOErrorFromException(e);
        }
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"sysseek"}, required=1, optional=1)
    public RubyFixnum sysseek(ThreadContext context, IRubyObject[] args2) {
        long pos2;
        long offset2 = RubyNumeric.num2long(args2[0]);
        int whence = 0;
        if (args2.length > 1) {
            whence = RubyNumeric.fix2int(args2[1].convertToInteger());
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            if (myOpenFile.isReadable() && myOpenFile.isReadBuffered()) {
                throw context.getRuntime().newIOError("sysseek for buffered IO");
            }
            if (myOpenFile.isWritable() && myOpenFile.isWriteBuffered()) {
                context.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYSSEEK_BUFFERED_IO, "sysseek for buffered IO", new Object[0]);
            }
            pos2 = myOpenFile.getMainStreamSafe().getDescriptor().lseek(offset2, whence);
            myOpenFile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOErrorFromException(e);
        }
        return context.getRuntime().newFixnum(pos2);
    }

    @JRubyMethod(name={"rewind"})
    public RubyFixnum rewind(ThreadContext context) {
        OpenFile myOpenfile = this.getOpenFileChecked();
        try {
            myOpenfile.getMainStreamSafe().lseek(0L, 0);
            myOpenfile.getMainStreamSafe().clearerr();
        }
        catch (BadDescriptorException e) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOErrorFromException(e);
        }
        myOpenfile.setLineNumber(0);
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"fsync"})
    public RubyFixnum fsync(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(runtime2);
            Stream writeStream = myOpenFile.getWriteStream();
            writeStream.fflush();
            writeStream.sync();
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        return RubyFixnum.zero(runtime2);
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject sync_set(IRubyObject newSync) {
        try {
            this.getOpenFileChecked().setSync(newSync.isTrue());
            this.getOpenFileChecked().getMainStreamSafe().setSync(newSync.isTrue());
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return this;
    }

    @JRubyMethod(name={"eof?", "eof"})
    public RubyBoolean eof_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime2);
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStreamSafe().feof()) {
                return runtime2.getTrue();
            }
            if (myOpenFile.getMainStreamSafe().readDataBuffered()) {
                return runtime2.getFalse();
            }
            this.readCheck(myOpenFile.getMainStreamSafe());
            this.waitReadable(myOpenFile.getMainStreamSafe());
            myOpenFile.getMainStreamSafe().clearerr();
            int c = myOpenFile.getMainStreamSafe().fgetc();
            if (c != -1) {
                myOpenFile.getMainStreamSafe().ungetc(c);
                return runtime2.getFalse();
            }
            myOpenFile.checkClosed(runtime2);
            myOpenFile.getMainStreamSafe().clearerr();
            return runtime2.getTrue();
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"tty?", "isatty"})
    public RubyBoolean tty_p(ThreadContext context) {
        try {
            return context.getRuntime().newBoolean(context.getRuntime().getPosix().isatty(this.getOpenFileChecked().getMainStreamSafe().getDescriptor().getFileDescriptor()));
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        Ruby runtime2 = this.getRuntime();
        if (this == original) {
            return this;
        }
        RubyIO originalIO = (RubyIO)TypeConverter.convertToTypeWithCheck(original, runtime2.getIO(), "to_io");
        OpenFile originalFile = originalIO.getOpenFileChecked();
        OpenFile newFile = this.openFile;
        try {
            if (originalFile.getPipeStream() != null) {
                originalFile.getPipeStream().fflush();
                originalFile.getMainStreamSafe().lseek(0L, 1);
            } else if (originalFile.isWritable()) {
                originalFile.getMainStreamSafe().fflush();
            } else {
                originalFile.getMainStreamSafe().lseek(0L, 1);
            }
            newFile.setMode(originalFile.getMode());
            newFile.setProcess(originalFile.getProcess());
            newFile.setLineNumber(originalFile.getLineNumber());
            newFile.setPath(originalFile.getPath());
            newFile.setFinalizer(originalFile.getFinalizer());
            ModeFlags modes = newFile.isReadable() ? (newFile.isWritable() ? (newFile.getPipeStream() != null ? new ModeFlags(ModeFlags.RDONLY) : new ModeFlags(ModeFlags.RDWR)) : new ModeFlags(ModeFlags.RDONLY)) : (newFile.isWritable() ? new ModeFlags(ModeFlags.WRONLY) : originalFile.getMainStreamSafe().getModes());
            ChannelDescriptor descriptor = originalFile.getMainStreamSafe().getDescriptor().dup();
            newFile.setMainStream(ChannelStream.fdopen(runtime2, descriptor, modes));
            newFile.getMainStream().setSync(originalFile.getMainStreamSafe().isSync());
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newIOError("could not init copy: " + ex);
        }
        catch (PipeException ex) {
            throw runtime2.newIOError("could not init copy: " + ex);
        }
        catch (InvalidValueException ex) {
            throw runtime2.newIOError("could not init copy: " + ex);
        }
        return this;
    }

    @JRubyMethod(name={"closed?"})
    public RubyBoolean closed_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isClosed());
    }

    public boolean isClosed() {
        return this.openFile.getMainStream() == null && this.openFile.getPipeStream() == null;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        Ruby runtime2 = this.getRuntime();
        if (runtime2.getSafeLevel() >= 4 && this.isTaint()) {
            throw runtime2.newSecurityError("Insecure: can't close");
        }
        this.openFile.checkClosed(runtime2);
        return this.close2(runtime2);
    }

    protected IRubyObject close2(Ruby runtime2) {
        if (this.openFile == null) {
            return runtime2.getNil();
        }
        this.interruptBlockingThreads();
        this.openFile.cleanup(runtime2, true);
        if (this.openFile.getProcess() != null) {
            RubyIO.obliterateProcess(this.openFile.getProcess());
            RubyProcess.RubyStatus processResult = RubyProcess.RubyStatus.newProcessStatus(runtime2, this.openFile.getProcess().exitValue(), this.openFile.getPid());
            runtime2.getCurrentContext().setLastExitStatus(processResult);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write(ThreadContext context) {
        try {
            if (context.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
                throw context.getRuntime().newSecurityError("Insecure: can't close");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isReadable()) {
                throw context.getRuntime().newIOError("closing non-duplex IO for writing");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getPipeStream().fclose();
                myOpenFile.setPipeStream(null);
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFD);
            }
        }
        catch (BadDescriptorException bde) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @JRubyMethod(name={"close_read"})
    public IRubyObject close_read(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        try {
            if (runtime2.getSafeLevel() >= 4 && this.isTaint()) {
                throw runtime2.newSecurityError("Insecure: can't close");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isWritable()) {
                throw runtime2.newIOError("closing non-duplex IO for reading");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getMainStreamSafe().fclose();
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFE);
                myOpenFile.setMainStream(myOpenFile.getPipeStream());
                myOpenFile.setPipeStream(null);
            }
        }
        catch (BadDescriptorException bde) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
        return this;
    }

    @JRubyMethod(name={"flush"})
    public RubyIO flush() {
        try {
            this.getOpenFileChecked().getWriteStream().fflush();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        return this;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gets(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject result = this.getline(runtime2, this.separator(runtime2, runtime2.getRecordSeparatorVar().get()));
        if (!result.isNil()) {
            context.getCurrentScope().setLastLine(result);
        }
        return result;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gets(ThreadContext context, IRubyObject separatorArg) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject result = this.getline(runtime2, this.separator(runtime2, separatorArg));
        if (!result.isNil()) {
            context.getCurrentScope().setLastLine(result);
        }
        return result;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gets19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject result = this.getline(runtime2, this.separator(runtime2));
        if (!result.isNil()) {
            context.getCurrentScope().setLastLine(result);
        }
        return result;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gets19(ThreadContext context, IRubyObject arg2) {
        ByteList separator;
        Ruby runtime2 = context.getRuntime();
        long limit2 = -1L;
        if (arg2 instanceof RubyInteger) {
            limit2 = RubyInteger.fix2long(arg2);
            separator = this.separator(runtime2);
        } else {
            separator = this.separator(runtime2, arg2);
        }
        IRubyObject result = this.getline(runtime2, separator, limit2);
        if (!result.isNil()) {
            context.getCurrentScope().setLastLine(result);
        }
        return result;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gets19(ThreadContext context, IRubyObject separator, IRubyObject limit_arg) {
        Ruby runtime2 = context.getRuntime();
        long limit2 = limit_arg.isNil() ? -1L : RubyNumeric.fix2long(limit_arg);
        IRubyObject result = this.getline(runtime2, this.separator(runtime2, separator), limit2);
        if (!result.isNil()) {
            context.getCurrentScope().setLastLine(result);
        }
        return result;
    }

    public boolean getBlocking() {
        try {
            return ((ChannelStream)this.openFile.getMainStreamSafe()).isBlocking();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd) {
        return this.ctl(context.getRuntime(), cmd, null);
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd, IRubyObject arg2) {
        return this.ctl(context.getRuntime(), cmd, arg2);
    }

    @JRubyMethod(name={"ioctl"}, required=1, optional=1)
    public IRubyObject ioctl(ThreadContext context, IRubyObject[] args2) {
        IRubyObject cmd = args2[0];
        IRubyObject arg2 = args2.length == 2 ? args2[1] : context.getRuntime().getNil();
        return this.ctl(context.getRuntime(), cmd, arg2);
    }

    public IRubyObject ctl(Ruby runtime2, IRubyObject cmd, IRubyObject arg2) {
        block12: {
            long realCmd = cmd.convertToInteger().getLongValue();
            long nArg = 0L;
            if (arg2 == null || arg2.isNil() || arg2 == runtime2.getFalse()) {
                nArg = 0L;
            } else if (arg2 instanceof RubyFixnum) {
                nArg = RubyFixnum.fix2long(arg2);
            } else if (arg2 == runtime2.getTrue()) {
                nArg = 1L;
            } else {
                throw runtime2.newNotImplementedError("JRuby does not support string for second fcntl/ioctl argument yet");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            try {
                if (realCmd == 1L) break block12;
                if (realCmd == (long)Fcntl.F_SETFL.value() || realCmd == (long)Fcntl.F_SETFD.value()) {
                    if ((nArg & 1L) != 1L) {
                        boolean block = (nArg & (long)ModeFlags.NONBLOCK) != (long)ModeFlags.NONBLOCK;
                        myOpenFile.getMainStreamSafe().setBlocking(block);
                    }
                    break block12;
                }
                if (realCmd == (long)Fcntl.F_GETFL.value()) {
                    return myOpenFile.getMainStreamSafe().isBlocking() ? RubyFixnum.zero(runtime2) : RubyFixnum.newFixnum(runtime2, ModeFlags.NONBLOCK);
                }
                throw runtime2.newNotImplementedError("JRuby only supports F_SETFL and F_GETFL with NONBLOCK for fcntl/ioctl");
            }
            catch (BadDescriptorException e) {
                throw runtime2.newErrnoEBADFError();
            }
            catch (IOException e) {
                throw runtime2.newIOErrorFromException(e);
            }
        }
        return runtime2.newFixnum(0);
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.puts(context, this, args2);
    }

    public static IRubyObject puts(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        if (args2.length == 0) {
            return RubyIO.writeSeparator(context, maybeIO);
        }
        return RubyIO.putsArray(context, maybeIO, args2);
    }

    private static IRubyObject writeSeparator(ThreadContext context, IRubyObject maybeIO) {
        Ruby runtime2 = context.getRuntime();
        assert (runtime2.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime2.getGlobalVariables().getDefaultSeparator();
        RubyIO.write(context, maybeIO, separator.getByteList());
        return runtime2.getNil();
    }

    private static IRubyObject putsArray(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        assert (runtime2.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime2.getGlobalVariables().getDefaultSeparator();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            ByteList line;
            if (args2[i2].isNil()) {
                line = RubyIO.getNilByteList(runtime2);
            } else if (runtime2.isInspecting(args2[i2])) {
                line = RECURSIVE_BYTELIST;
            } else {
                if (args2[i2] instanceof RubyArray) {
                    RubyIO.inspectPuts(context, maybeIO, (RubyArray)args2[i2]);
                    continue;
                }
                line = args2[i2].asString().getByteList();
            }
            RubyIO.write(context, maybeIO, line);
            if (line.length() != 0 && line.endsWith(separator.getByteList())) continue;
            RubyIO.write(context, maybeIO, separator.getByteList());
        }
        return runtime2.getNil();
    }

    protected void write(ThreadContext context, ByteList byteList) {
        this.callMethod(context, "write", (IRubyObject)RubyString.newStringShared(context.getRuntime(), byteList));
    }

    protected static void write(ThreadContext context, IRubyObject maybeIO, ByteList byteList) {
        maybeIO.callMethod(context, "write", RubyString.newStringShared(context.getRuntime(), byteList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject inspectPuts(ThreadContext context, IRubyObject maybeIO, RubyArray array) {
        try {
            context.getRuntime().registerInspecting(array);
            IRubyObject iRubyObject = RubyIO.putsArray(context, maybeIO, array.toJavaArray());
            Object var5_4 = null;
            context.getRuntime().unregisterInspecting(array);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.getRuntime().unregisterInspecting(array);
            throw throwable;
        }
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context) {
        IRubyObject line = this.gets(context);
        if (line.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context, IRubyObject separator) {
        IRubyObject line = this.gets(context, separator);
        if (line.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"getc", "getbyte"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject getc() {
        int c = this.getcCommon();
        if (c == -1) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(c);
    }

    private ByteList fromEncodedBytes(Ruby runtime2, Encoding enc, int value2) {
        int n;
        try {
            n = value2 < 0 ? 0 : enc.codeToMbcLength(value2);
        }
        catch (EncodingException ee) {
            n = 0;
        }
        if (n <= 0) {
            throw runtime2.newRangeError(this.toString() + " out of char range");
        }
        ByteList bytes2 = new ByteList(n);
        enc.codeToMbc(value2, bytes2.getUnsafeBytes(), 0);
        bytes2.setRealSize(n);
        return bytes2;
    }

    @JRubyMethod(name={"readchar"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject readchar19(ThreadContext context) {
        IRubyObject value2 = this.getc19(context);
        if (value2.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return value2;
    }

    @JRubyMethod(name={"getbyte"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getbyte19(ThreadContext context) {
        return this.getc();
    }

    @JRubyMethod(name={"getc"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getc19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        int c = this.getcCommon();
        if (c == -1) {
            return runtime2.getNil();
        }
        Encoding external = this.getExternalEncoding(runtime2);
        ByteList bytes2 = this.fromEncodedBytes(runtime2, external, c);
        Encoding internal = this.getInternalEncoding(runtime2);
        if (internal != null) {
            bytes2 = RubyString.transcode(context, bytes2, external, internal, runtime2.getNil());
        }
        return RubyString.newStringNoCopy(runtime2, bytes2, external, 0);
    }

    public int getcCommon() {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            myOpenFile.setReadBuffered();
            Stream stream = myOpenFile.getMainStreamSafe();
            this.readCheck(stream);
            this.waitReadable(stream);
            stream.clearerr();
            return myOpenFile.getMainStreamSafe().fgetc();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
    }

    private void readCheck(Stream stream) {
        if (!stream.readDataBuffered()) {
            this.openFile.checkClosed(this.getRuntime());
        }
    }

    @JRubyMethod(name={"ungetc"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject ungetc(IRubyObject number) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (!myOpenFile.isReadBuffered()) {
            throw this.getRuntime().newIOError("unread stream");
        }
        return this.ungetcCommon(number, myOpenFile);
    }

    @JRubyMethod(name={"ungetc"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject ungetc19(IRubyObject number) {
        Ruby runtime2 = this.getRuntime();
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (!myOpenFile.isReadBuffered()) {
            return runtime2.getNil();
        }
        if (number instanceof RubyString) {
            RubyString str = (RubyString)number;
            if (str.isEmpty()) {
                return runtime2.getNil();
            }
            int c = str.getEncoding().mbcToCode(str.getBytes(), 0, 1);
            number = runtime2.newFixnum(c);
        }
        return this.ungetcCommon(number, myOpenFile);
    }

    private IRubyObject ungetcCommon(IRubyObject number, OpenFile myOpenFile) {
        int ch = RubyNumeric.fix2int(number);
        try {
            myOpenFile.checkReadable(this.getRuntime());
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStreamSafe().ungetc(ch) == -1 && ch != -1) {
                throw this.getRuntime().newIOError("ungetc failed");
            }
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"read_nonblock"}, required=1, optional=1, backtrace=true)
    public IRubyObject read_nonblock(ThreadContext context, IRubyObject[] args2) {
        RubyString str;
        IRubyObject value2 = this.getPartial(context, args2, true);
        if (value2.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        if (value2 instanceof RubyString && (str = (RubyString)value2).isEmpty()) {
            Ruby ruby2 = context.getRuntime();
            RaiseException eagain = ruby2.newErrnoEAGAINError("");
            if (ruby2.is1_9()) {
                eagain.getException().extend(new IRubyObject[]{ruby2.getIO().getConstant("WaitReadable")});
            }
            throw eagain;
        }
        return value2;
    }

    @JRubyMethod(name={"readpartial"}, required=1, optional=1)
    public IRubyObject readpartial(ThreadContext context, IRubyObject[] args2) {
        IRubyObject value2 = this.getPartial(context, args2, false);
        if (value2.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return value2;
    }

    private IRubyObject getPartial(ThreadContext context, IRubyObject[] args2, boolean isNonblocking) {
        Ruby runtime2 = context.getRuntime();
        int length2 = RubyNumeric.fix2int(args2[0]);
        if (length2 < 0) {
            throw runtime2.newArgumentError("negative length " + length2 + " given");
        }
        IRubyObject stringArg = args2.length > 1 ? args2[1] : runtime2.getNil();
        RubyString string2 = stringArg.isNil() ? RubyString.newEmptyString(runtime2) : stringArg.convertToString();
        string2.empty();
        string2.setTaint(true);
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime2);
            if (length2 == 0) {
                return string2;
            }
            if (!(myOpenFile.getMainStreamSafe() instanceof ChannelStream)) {
                throw runtime2.newNotImplementedError("readpartial only works with Nio based handlers");
            }
            ChannelStream stream = (ChannelStream)myOpenFile.getMainStreamSafe();
            ByteList buf = null;
            if (isNonblocking) {
                buf = stream.readnonblock(length2);
            } else {
                while (!(buf != null && buf.length() != 0 || stream.feof())) {
                    this.waitReadable(stream);
                    buf = stream.readpartial(length2);
                }
            }
            boolean empty2 = buf == null || buf.length() == 0;
            ByteList newBuf = empty2 ? ByteList.EMPTY_BYTELIST.dup() : buf;
            string2.view(newBuf);
            if (stream.feof() && empty2) {
                return runtime2.getNil();
            }
            return string2;
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException e) {
            throw runtime2.newEOFError(e.getMessage());
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"sysread"}, required=1, optional=1)
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args2) {
        int len = (int)RubyNumeric.num2long(args2[0]);
        if (len < 0) {
            throw this.getRuntime().newArgumentError("Negative size");
        }
        try {
            RubyString str;
            if (args2.length == 1 || args2[1].isNil()) {
                if (len == 0) {
                    return RubyString.newEmptyString(this.getRuntime());
                }
                ByteList buffer = new ByteList(len);
                str = RubyString.newString(this.getRuntime(), buffer);
            } else {
                str = args2[1].convertToString();
                str.modify(len);
                if (len == 0) {
                    return str;
                }
                ByteList buffer = str.getByteList();
                buffer.length(0);
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            if (myOpenFile.getMainStreamSafe().readDataBuffered()) {
                throw this.getRuntime().newIOError("sysread for buffered IO");
            }
            this.waitReadable(myOpenFile.getMainStreamSafe());
            myOpenFile.checkClosed(this.getRuntime());
            int bytesRead = myOpenFile.getMainStreamSafe().getDescriptor().read(len, str.getByteList());
            if (bytesRead == -1 || bytesRead == 0 && len > 0) {
                throw this.getRuntime().newEOFError();
            }
            str.setTaint(true);
            return str;
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            this.synthesizeSystemCallError(e);
            return null;
        }
    }

    private void synthesizeSystemCallError(IOException e) {
        String errorMessage = e.getMessage();
        if ("File not open".equals(errorMessage)) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        if ("An established connection was aborted by the software in your host machine".equals(errorMessage)) {
            throw this.getRuntime().newErrnoECONNABORTEDError();
        }
        throw this.getRuntime().newSystemCallError(e.getMessage());
    }

    public IRubyObject read(IRubyObject[] args2) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        switch (args2.length) {
            case 0: {
                return this.read(context);
            }
            case 1: {
                return this.read(context, args2[0]);
            }
            case 2: {
                return this.read(context, args2[0], args2[1]);
            }
        }
        throw this.getRuntime().newArgumentError(args2.length, 2);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.checkReadable(runtime2);
            myOpenFile.setReadBuffered();
            return this.readAll();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException ex) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject arg0) {
        if (arg0.isNil()) {
            return this.read(context);
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        int length2 = RubyNumeric.num2int(arg0);
        if (length2 < 0) {
            throw this.getRuntime().newArgumentError("negative length " + length2 + " given");
        }
        RubyString str = RubyString.newEmptyString(this.getRuntime());
        return this.readNotAll(context, myOpenFile, length2, str);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (arg0.isNil()) {
            try {
                myOpenFile.checkReadable(this.getRuntime());
                myOpenFile.setReadBuffered();
                if (arg1.isNil()) {
                    return this.readAll();
                }
                return this.readAll(arg1.convertToString());
            }
            catch (InvalidValueException ex) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (EOFException ex) {
                throw this.getRuntime().newEOFError();
            }
            catch (IOException ex) {
                throw this.getRuntime().newIOErrorFromException(ex);
            }
            catch (BadDescriptorException ex) {
                throw this.getRuntime().newErrnoEBADFError();
            }
        }
        int length2 = RubyNumeric.num2int(arg0);
        if (length2 < 0) {
            throw this.getRuntime().newArgumentError("negative length " + length2 + " given");
        }
        if (arg1.isNil()) {
            return this.readNotAll(context, myOpenFile, length2);
        }
        return this.readNotAll(context, myOpenFile, length2, arg1.convertToString());
    }

    private IRubyObject readNotAll(ThreadContext context, OpenFile myOpenFile, int length2, RubyString str) {
        Ruby runtime2 = context.getRuntime();
        str.empty();
        try {
            ByteList newBuffer = this.readNotAllCommon(context, myOpenFile, length2);
            if (RubyIO.emptyBufferOrEOF(newBuffer, myOpenFile)) {
                return runtime2.getNil();
            }
            str.setValue(newBuffer);
            str.setTaint(true);
            return str;
        }
        catch (EOFException ex) {
            throw runtime2.newEOFError();
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newErrnoEBADFError();
        }
    }

    private IRubyObject readNotAll(ThreadContext context, OpenFile myOpenFile, int length2) {
        Ruby runtime2 = context.getRuntime();
        try {
            ByteList newBuffer = this.readNotAllCommon(context, myOpenFile, length2);
            if (RubyIO.emptyBufferOrEOF(newBuffer, myOpenFile)) {
                return runtime2.getNil();
            }
            RubyString str = RubyString.newString(runtime2, newBuffer);
            str.setTaint(true);
            return str;
        }
        catch (EOFException ex) {
            throw runtime2.newEOFError();
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newErrnoEBADFError();
        }
    }

    private ByteList readNotAllCommon(ThreadContext context, OpenFile myOpenFile, int length2) {
        Ruby runtime2 = context.getRuntime();
        try {
            myOpenFile.checkReadable(runtime2);
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStreamSafe().feof()) {
                return null;
            }
            this.readCheck(myOpenFile.getMainStreamSafe());
            ByteList newBuffer = this.fread(context.getThread(), length2);
            return newBuffer;
        }
        catch (EOFException ex) {
            throw runtime2.newEOFError();
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newErrnoEBADFError();
        }
    }

    protected static boolean emptyBufferOrEOF(ByteList buffer, OpenFile myOpenFile) throws BadDescriptorException, IOException {
        if (buffer == null) {
            return true;
        }
        if (buffer.length() == 0) {
            if (myOpenFile.getMainStreamSafe() == null) {
                return true;
            }
            if (myOpenFile.getMainStreamSafe().feof()) {
                return true;
            }
        }
        return false;
    }

    protected RubyString readAll(RubyString str) throws BadDescriptorException, EOFException, IOException {
        Ruby runtime2 = this.getRuntime();
        ByteList buf = this.readAllCommon(runtime2);
        if (buf == null) {
            str.empty();
        } else {
            str.setValue(buf);
        }
        str.setTaint(true);
        return str;
    }

    protected RubyString readAll() throws BadDescriptorException, EOFException, IOException {
        Ruby runtime2 = this.getRuntime();
        ByteList buf = this.readAllCommon(runtime2);
        RubyString str = buf == null ? RubyString.newEmptyString(runtime2) : RubyString.newString(runtime2, buf);
        str.setTaint(true);
        return str;
    }

    protected ByteList readAllCommon(Ruby runtime2) throws BadDescriptorException, EOFException, IOException {
        ByteList buf;
        block9: {
            buf = null;
            ChannelDescriptor descriptor = this.openFile.getMainStreamSafe().getDescriptor();
            try {
                if (descriptor.isSeekable() && descriptor.getChannel() instanceof FileChannel) {
                    buf = this.openFile.getMainStreamSafe().readall();
                    break block9;
                }
                if (descriptor == null) {
                    buf = null;
                    break block9;
                }
                RubyThread thread = runtime2.getCurrentContext().getThread();
                try {
                    while (true) {
                        Stream stream = this.openFile.getMainStreamSafe();
                        this.readCheck(stream);
                        this.openFile.checkReadable(runtime2);
                        ByteList read2 = this.fread(thread, 4096);
                        if (read2.length() != 0) {
                            if (buf == null) {
                                buf = read2;
                                continue;
                            }
                            buf.append(read2);
                            continue;
                        }
                        break;
                    }
                }
                catch (InvalidValueException ex) {
                    throw runtime2.newErrnoEINVALError();
                }
            }
            catch (NonReadableChannelException ex) {
                throw runtime2.newIOError("not opened for reading");
            }
        }
        return buf;
    }

    private ByteList fread(RubyThread thread, int length2) throws IOException, BadDescriptorException {
        Stream stream = this.openFile.getMainStreamSafe();
        int rest2 = length2;
        this.waitReadable(stream);
        ByteList buf = this.blockingFRead(stream, thread, length2);
        if (buf != null) {
            rest2 -= buf.length();
        }
        while (rest2 > 0) {
            this.waitReadable(stream);
            this.openFile.checkClosed(this.getRuntime());
            stream.clearerr();
            ByteList newBuffer = this.blockingFRead(stream, thread, rest2);
            if (newBuffer == null) break;
            int len = newBuffer.length();
            if (len == 0) continue;
            if (buf == null) {
                buf = newBuffer;
            } else {
                buf.append(newBuffer);
            }
            rest2 -= len;
        }
        if (buf == null) {
            return ByteList.EMPTY_BYTELIST.dup();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteList blockingFRead(Stream stream, RubyThread thread, int length2) throws IOException, BadDescriptorException {
        try {
            thread.beforeBlockingCall();
            ByteList byteList = stream.fread(length2);
            Object var6_5 = null;
            thread.afterBlockingCall();
            return byteList;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            thread.afterBlockingCall();
            throw throwable;
        }
    }

    @JRubyMethod(name={"readchar"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod
    public IRubyObject stat(ThreadContext context) {
        this.openFile.checkClosed(context.getRuntime());
        try {
            return context.getRuntime().newFileStat(this.getOpenFileChecked().getMainStreamSafe().getDescriptor().getFileDescriptor());
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    public IRubyObject each_byteInternal(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            while (true) {
                myOpenFile.checkReadable(runtime2);
                myOpenFile.setReadBuffered();
                this.waitReadable(myOpenFile.getMainStream());
                int c = myOpenFile.getMainStreamSafe().fgetc();
                if (c == -1) break;
                assert (c < 256);
                block.yield(context, this.getRuntime().newFixnum(c));
            }
            return this;
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (EOFException e) {
            return runtime2.getNil();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    @JRubyMethod
    public IRubyObject each_byte(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byteInternal(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_byte");
    }

    @JRubyMethod(name={"bytes"})
    public IRubyObject bytes(ThreadContext context) {
        return RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_byte");
    }

    @JRubyMethod(name={"lines"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject lines(ThreadContext context, Block block) {
        return RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_line");
    }

    @JRubyMethod(name={"lines"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject lines19(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_line");
        }
        return this.each_lineInternal(context, NULL_ARRAY, block);
    }

    public IRubyObject each_charInternal(ThreadContext context, Block block) {
        IRubyObject ch;
        Ruby runtime2 = context.getRuntime();
        while (!(ch = this.getc()).isNil()) {
            byte c = (byte)RubyNumeric.fix2int(ch);
            int n = runtime2.getKCode().getEncoding().length(c);
            RubyString str = runtime2.newString();
            if (runtime2.is1_9()) {
                str.setEncoding(this.getExternalEncoding(runtime2));
            }
            str.setTaint(true);
            str.cat(c);
            while (--n > 0) {
                ch = this.getc();
                if (ch.isNil()) {
                    block.yield(context, str);
                    return this;
                }
                c = (byte)RubyNumeric.fix2int(ch);
                str.cat(c);
            }
            block.yield(context, str);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_char(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_char");
    }

    @JRubyMethod
    public IRubyObject chars(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charInternal(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "chars");
    }

    @JRubyMethod
    public IRubyObject codepoints(ThreadContext context, Block block) {
        return this.eachCodePointCommon(context, block, "codepoints");
    }

    @JRubyMethod
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        return this.eachCodePointCommon(context, block, "each_codepoint");
    }

    private IRubyObject eachCharCommon(ThreadContext context, Block block, String methodName) {
        return block.isGiven() ? this.each_char(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, methodName);
    }

    private IRubyObject eachCodePointCommon(ThreadContext context, Block block, String methodName) {
        IRubyObject ch;
        Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, this, methodName);
        }
        while (!(ch = this.getc()).isNil()) {
            block.yield(context, ch);
        }
        return this;
    }

    public RubyIO each_lineInternal(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        ByteList separator = this.getSeparatorForGets(runtime2, args2);
        ByteListCache cache = new ByteListCache();
        IRubyObject line = this.getline(runtime2, separator);
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.getline(runtime2, separator, cache);
        }
        return this;
    }

    @JRubyMethod(optional=1)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.each_lineInternal(context, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "each", args2);
    }

    @JRubyMethod(optional=1)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.each_lineInternal(context, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "each_line", args2);
    }

    @JRubyMethod(optional=1)
    public RubyArray readlines(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line;
        IRubyObject[] iRubyObjectArray;
        Ruby runtime2 = context.getRuntime();
        if (args2.length > 0) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args2[0];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArgs = iRubyObjectArray;
        ByteList separator = this.getSeparatorForGets(runtime2, separatorArgs);
        RubyArray result = runtime2.newArray();
        while (!(line = this.getline(runtime2, separator)).isNil()) {
            result.append(line);
        }
        return result;
    }

    @JRubyMethod(name={"to_io"})
    public RubyIO to_io() {
        return this;
    }

    public String toString() {
        try {
            return "RubyIO(" + this.openFile.getMode() + ", " + this.getRuntime().getFileno(this.openFile.getMainStreamSafe().getDescriptor()) + ")";
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject foreachInternal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyString filename2 = args2[0].convertToString();
        runtime2.checkSafeString(filename2);
        RubyIO io2 = (RubyIO)RubyFile.open(context, runtime2.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
        ByteListCache cache = new ByteListCache();
        if (!io2.isNil()) {
            try {
                ByteList separator = io2.getSeparatorFromArgs(runtime2, args2, 1);
                IRubyObject str = io2.getline(runtime2, separator, cache);
                while (!str.isNil()) {
                    block.yield(context, str);
                    str = io2.getline(runtime2, separator, cache);
                    if (!runtime2.is1_9()) continue;
                    separator = io2.getSeparatorFromArgs(runtime2, args2, 1);
                }
                Object var11_10 = null;
                io2.close();
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                io2.close();
                throw throwable;
            }
            {
            }
        }
        return runtime2.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject foreachInternal19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyIO io2;
        Ruby runtime2 = context.getRuntime();
        RubyString filename2 = args2[0].convertToString();
        runtime2.checkSafeString(filename2);
        boolean hasOptions = false;
        switch (args2.length) {
            case 1: {
                io2 = (RubyIO)RubyFile.open(context, runtime2.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
                break;
            }
            case 2: {
                if (args2[1] instanceof RubyHash) {
                    io2 = (RubyIO)RubyFile.open(context, runtime2.getFile(), new IRubyObject[]{filename2, args2[1]}, Block.NULL_BLOCK);
                    args2 = new IRubyObject[]{args2[0]};
                    break;
                }
                io2 = (RubyIO)RubyFile.open(context, runtime2.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
                break;
            }
            case 3: {
                if (args2[1] instanceof RubyHash) {
                    io2 = (RubyIO)RubyFile.open(context, runtime2.getFile(), new IRubyObject[]{filename2, args2[2]}, Block.NULL_BLOCK);
                    args2 = new IRubyObject[]{args2[0], args2[1]};
                    break;
                }
                io2 = (RubyIO)RubyFile.open(context, runtime2.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
                break;
            }
            default: {
                Arity.checkArgumentCount(runtime2, args2.length, 1, 3);
                throw runtime2.newRuntimeError("invalid argument count in IO.foreach: " + args2.length);
            }
        }
        ByteListCache cache = new ByteListCache();
        if (!io2.isNil()) {
            try {
                ByteList separator = io2.getSeparatorFromArgs(runtime2, args2, 1);
                IRubyObject str = io2.getline(runtime2, separator, cache);
                while (!str.isNil()) {
                    block.yield(context, str);
                    str = io2.getline(runtime2, separator, cache);
                    if (!runtime2.is1_9()) continue;
                    separator = io2.getSeparatorFromArgs(runtime2, args2, 1);
                }
                Object var12_11 = null;
                io2.close();
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                io2.close();
                throw throwable;
            }
            {
            }
        }
        return runtime2.getNil();
    }

    @JRubyMethod(required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "foreach", args2);
        }
        if (!(args2[0] instanceof RubyString) && args2[0].respondsTo("to_path")) {
            args2[0] = args2[0].callMethod(context, "to_path");
        }
        return RubyIO.foreachInternal(context, recv2, args2, block);
    }

    @JRubyMethod(name={"foreach"}, required=1, optional=2, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject foreach19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "foreach", args2);
        }
        if (!(args2[0] instanceof RubyString) && args2[0].respondsTo("to_path")) {
            args2[0] = args2[0].callMethod(context, "to_path");
        }
        return RubyIO.foreachInternal19(context, recv2, args2, block);
    }

    public static RubyIO convertToIO(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyIO) {
            return (RubyIO)obj;
        }
        return (RubyIO)TypeConverter.convertToType(obj, context.getRuntime().getIO(), "to_io");
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, meta=true)
    public static IRubyObject select(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.select_static(context, context.getRuntime(), args2);
    }

    public static IRubyObject select_static(ThreadContext context, Ruby runtime2, IRubyObject[] args2) {
        return new SelectBlob().goForIt(context, runtime2, args2);
    }

    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                throw context.getRuntime().newArgumentError(0, 1);
            }
            case 1: {
                return RubyIO.readStatic(context, recv2, args2[0]);
            }
            case 2: {
                return RubyIO.readStatic(context, recv2, args2[0], args2[1]);
            }
            case 3: {
                return RubyIO.readStatic(context, recv2, args2[0], args2[1], args2[2]);
            }
        }
        throw context.getRuntime().newArgumentError(args2.length, 3);
    }

    private static RubyIO newFile(ThreadContext context, IRubyObject recv2, IRubyObject ... args2) {
        return (RubyIO)RubyKernel.open(context, recv2, args2, Block.NULL_BLOCK);
    }

    public static void failIfDirectory(Ruby runtime2, RubyString pathStr) {
        if (RubyFileTest.directory_p(runtime2, (IRubyObject)pathStr).isTrue()) {
            if (Platform.IS_WINDOWS) {
                throw runtime2.newErrnoEACCESError(pathStr.asJavaString());
            }
            throw runtime2.newErrnoEISDirError(pathStr.asJavaString());
        }
    }

    @Deprecated
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block unusedBlock) {
        return RubyIO.readStatic(context, recv2, path2);
    }

    @Deprecated
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2) {
        return RubyIO.readStatic(context, recv2, path2, length2);
    }

    @Deprecated
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2, IRubyObject offset2) {
        return RubyIO.readStatic(context, recv2, path2, length2, offset2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject readStatic(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        IRubyObject iRubyObject;
        RubyString pathStr = path2.convertToString();
        Ruby runtime2 = context.getRuntime();
        RubyIO.failIfDirectory(runtime2, pathStr);
        RubyIO file2 = RubyIO.newFile(context, recv2, pathStr);
        try {
            iRubyObject = file2.read(context);
            Object var8_7 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject readStatic(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2) {
        IRubyObject iRubyObject;
        RubyString pathStr = path2.convertToString();
        Ruby runtime2 = context.getRuntime();
        RubyIO.failIfDirectory(runtime2, pathStr);
        RubyIO file2 = RubyIO.newFile(context, recv2, pathStr);
        try {
            iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            Object var9_8 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject readStatic(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2, IRubyObject offset2) {
        IRubyObject iRubyObject;
        RubyString pathStr = path2.convertToString();
        Ruby runtime2 = context.getRuntime();
        RubyIO.failIfDirectory(runtime2, pathStr);
        RubyIO file2 = RubyIO.newFile(context, recv2, pathStr);
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            Object var10_9 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject read19(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2, IRubyObject offset2, RubyHash options2) {
        IRubyObject iRubyObject;
        RubyString pathStr = RubyFile.get_path(context, path2);
        Ruby runtime2 = context.getRuntime();
        RubyIO.failIfDirectory(runtime2, pathStr);
        RubyIO file2 = RubyIO.newFile(context, recv2, pathStr);
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            Object var11_10 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, required=1, optional=2, compat=CompatVersion.RUBY1_9)
    public static IRubyObject binread(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject iRubyObject;
        IRubyObject nil = context.getRuntime().getNil();
        IRubyObject path2 = args2[0];
        IRubyObject length2 = nil;
        IRubyObject offset2 = nil;
        Ruby runtime2 = context.runtime;
        if (args2.length > 2) {
            offset2 = args2[2];
            length2 = args2[1];
        } else if (args2.length > 1) {
            length2 = args2[1];
        }
        RubyIO file2 = (RubyIO)RuntimeHelpers.invoke(context, (IRubyObject)runtime2.getFile(), "new", path2, (IRubyObject)runtime2.newString("rb:ASCII-8BIT"));
        try {
            if (!offset2.isNil()) {
                file2.seek(context, offset2);
            }
            iRubyObject = !length2.isNil() ? file2.read(context, length2) : file2.read(context);
            Object var11_10 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            file2.close();
            throw throwable;
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"read"}, meta=true, required=1, optional=3, compat=CompatVersion.RUBY1_9)
    public static IRubyObject read19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        IRubyObject nil = context.getRuntime().getNil();
        IRubyObject path2 = args2[0];
        IRubyObject length2 = nil;
        IRubyObject offset2 = nil;
        RubyHash options2 = null;
        if (args2.length > 3) {
            if (!(args2[3] instanceof RubyHash)) {
                throw context.getRuntime().newTypeError("Must be a hash");
            }
            options2 = (RubyHash)args2[3];
            offset2 = args2[2];
            length2 = args2[1];
        } else if (args2.length > 2) {
            if (args2[2] instanceof RubyHash) {
                options2 = (RubyHash)args2[2];
            } else {
                offset2 = args2[2];
            }
            length2 = args2[1];
        } else if (args2.length > 1) {
            if (args2[1] instanceof RubyHash) {
                options2 = (RubyHash)args2[1];
            } else {
                length2 = args2[1];
            }
        }
        return RubyIO.read19(context, recv2, path2, length2, offset2, options2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"readlines"}, required=1, optional=1, meta=true)
    public static RubyArray readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        RubyArray rubyArray;
        IRubyObject[] iRubyObjectArray;
        int count2 = args2.length;
        IRubyObject[] fileArguments = new IRubyObject[]{args2[0].convertToString()};
        if (count2 >= 2) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args2[1];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArguments = iRubyObjectArray;
        RubyIO file2 = (RubyIO)RubyKernel.open(context, recv2, fileArguments, Block.NULL_BLOCK);
        try {
            rubyArray = file2.readlines(context, separatorArguments);
            Object var10_9 = null;
            file2.close();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            file2.close();
            throw throwable;
        }
        return rubyArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"popen"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject popen(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyString cmdObj = null;
        if (Platform.IS_WINDOWS) {
            String[] tokens = args2[0].convertToString().toString().split(" ", 2);
            String commandString = tokens[0].replace('/', '\\') + (tokens.length > 1 ? ' ' + tokens[1] : "");
            cmdObj = runtime2.newString(commandString);
        } else {
            cmdObj = args2[0].convertToString();
        }
        runtime2.checkSafeString(cmdObj);
        if ("-".equals(((Object)cmdObj).toString())) {
            throw runtime2.newNotImplementedError("popen(\"-\") is unimplemented");
        }
        try {
            IRubyObject iRubyObject;
            int mode2 = args2.length == 1 ? ModeFlags.RDONLY : (args2[1] instanceof RubyFixnum ? RubyFixnum.num2int(args2[1]) : RubyIO.getIOModesIntFromString(runtime2, args2[1].convertToString().toString()));
            ModeFlags modes = new ModeFlags(mode2);
            ShellLauncher.POpenProcess process = ShellLauncher.popen(runtime2, cmdObj, modes);
            if (System.getProperty("java.specification.version", "").equals("1.5")) {
                ShellLauncher.POpenProcess pOpenProcess = process;
                synchronized (pOpenProcess) {
                    try {
                        process.wait(100L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            RubyIO io2 = new RubyIO(runtime2, process, modes);
            if (!block.isGiven()) {
                return io2;
            }
            try {
                iRubyObject = block.yield(context, io2);
                Object var13_15 = null;
                if (io2.openFile.isOpen()) {
                    io2.close();
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (io2.openFile.isOpen()) {
                    io2.close();
                }
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, process.waitFor(), ShellLauncher.getPidFromProcess(process)));
                throw throwable;
            }
            context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, process.waitFor(), ShellLauncher.getPidFromProcess(process)));
            return iRubyObject;
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime2.newThreadError("unexpected interrupt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"popen"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject popen19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        String commandString;
        Ruby runtime2 = context.getRuntime();
        IRubyObject[] cmdPlusArgs = null;
        RubyHash env = null;
        Object opts = null;
        IRubyObject cmdObj = null;
        IRubyObject arg0 = args2[0].checkArrayType();
        if (!arg0.isNil()) {
            ArrayList<IRubyObject> argList = new ArrayList<IRubyObject>(Arrays.asList(((RubyArray)arg0).toJavaArray()));
            if (argList.isEmpty()) {
                throw runtime2.newArgumentError("wrong number of arguments");
            }
            if (argList.get(0) instanceof RubyHash) {
                env = (RubyHash)argList.remove(0);
            }
            if (argList.isEmpty()) {
                throw runtime2.newArgumentError("wrong number of arguments");
            }
            if (argList.size() > 1 && argList.get(argList.size() - 1) instanceof RubyHash) {
                env = (RubyHash)argList.get(argList.size() - 1);
            }
            cmdPlusArgs = argList.toArray(new IRubyObject[argList.size()]);
            if (Platform.IS_WINDOWS) {
                commandString = cmdPlusArgs[0].convertToString().toString().replace('/', '\\');
                cmdPlusArgs[0] = runtime2.newString(commandString);
            } else {
                cmdPlusArgs[0] = cmdPlusArgs[0].convertToString();
            }
            cmdObj = cmdPlusArgs[0];
        } else if (Platform.IS_WINDOWS) {
            String[] tokens = args2[0].convertToString().toString().split(" ", 2);
            commandString = tokens[0].replace('/', '\\') + (tokens.length > 1 ? ' ' + tokens[1] : "");
            cmdObj = runtime2.newString(commandString);
        } else {
            cmdObj = args2[0].convertToString();
        }
        runtime2.checkSafeString(cmdObj);
        if ("-".equals(((Object)cmdObj).toString())) {
            throw runtime2.newNotImplementedError("popen(\"-\") is unimplemented");
        }
        try {
            IRubyObject iRubyObject;
            int mode2 = args2.length == 1 ? ModeFlags.RDONLY : (args2[1] instanceof RubyFixnum ? RubyFixnum.num2int(args2[1]) : RubyIO.getIOModesIntFromString(runtime2, args2[1].convertToString().toString()));
            ModeFlags modes = new ModeFlags(mode2);
            ShellLauncher.POpenProcess process = cmdPlusArgs == null ? ShellLauncher.popen(runtime2, cmdObj, modes) : ShellLauncher.popen(runtime2, cmdPlusArgs, env, modes);
            if (System.getProperty("java.specification.version", "").equals("1.5")) {
                ShellLauncher.POpenProcess pOpenProcess = process;
                synchronized (pOpenProcess) {
                    try {
                        process.wait(100L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            RubyIO io2 = new RubyIO(runtime2, process, modes);
            if (!block.isGiven()) {
                return io2;
            }
            try {
                iRubyObject = block.yield(context, io2);
                Object var17_19 = null;
                if (io2.openFile.isOpen()) {
                    io2.close();
                }
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                if (io2.openFile.isOpen()) {
                    io2.close();
                }
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, process.waitFor(), ShellLauncher.getPidFromProcess(process)));
                throw throwable;
            }
            context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, process.waitFor(), ShellLauncher.getPidFromProcess(process)));
            return iRubyObject;
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime2.newThreadError("unexpected interrupt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject popen3(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            POpenTuple tuple = RubyIO.popenSpecial(context, args2);
            RubyArray yieldArgs = RubyArray.newArrayLight(runtime2, tuple.output, tuple.input, tuple.error);
            if (!block.isGiven()) {
                return yieldArgs;
            }
            try {
                iRubyObject = block.yield(context, yieldArgs);
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                RubyIO.cleanupPOpen(tuple);
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
                throw throwable;
            }
            RubyIO.cleanupPOpen(tuple);
            context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
            return iRubyObject;
        }
        catch (InterruptedException e) {
            throw runtime2.newThreadError("unexpected interrupt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject popen4(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            IRubyObject iRubyObject;
            POpenTuple tuple = RubyIO.popenSpecial(context, args2);
            RubyArray yieldArgs = RubyArray.newArrayLight(runtime2, runtime2.newFixnum(ShellLauncher.getPidFromProcess(tuple.process)), tuple.output, tuple.input, tuple.error);
            if (!block.isGiven()) {
                return yieldArgs;
            }
            try {
                iRubyObject = block.yield(context, yieldArgs);
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                RubyIO.cleanupPOpen(tuple);
                context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
                throw throwable;
            }
            RubyIO.cleanupPOpen(tuple);
            context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, tuple.process.waitFor(), ShellLauncher.getPidFromProcess(tuple.process)));
            return iRubyObject;
        }
        catch (InterruptedException e) {
            throw runtime2.newThreadError("unexpected interrupt");
        }
    }

    private static void cleanupPOpen(POpenTuple tuple) {
        if (tuple.input.openFile.isOpen()) {
            tuple.input.close();
        }
        if (tuple.output.openFile.isOpen()) {
            tuple.output.close();
        }
        if (tuple.error.openFile.isOpen()) {
            tuple.error.close();
        }
    }

    public static POpenTuple popenSpecial(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        try {
            ShellLauncher.POpenProcess process = ShellLauncher.popen3(runtime2, args2, false);
            RubyIO input = process.getInput() != null ? new RubyIO(runtime2, process.getInput()) : new RubyIO(runtime2, process.getInputStream());
            RubyIO output = process.getOutput() != null ? new RubyIO(runtime2, process.getOutput()) : new RubyIO(runtime2, process.getOutputStream());
            RubyIO error2 = process.getError() != null ? new RubyIO(runtime2, process.getError()) : new RubyIO(runtime2, process.getErrorStream());
            input.getOpenFile().getMainStreamSafe().getDescriptor().setCanBeSeekable(false);
            output.getOpenFile().getMainStreamSafe().getDescriptor().setCanBeSeekable(false);
            error2.getOpenFile().getMainStreamSafe().getDescriptor().setCanBeSeekable(false);
            return new POpenTuple(input, output, error2, process);
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"pipe"}, meta=true)
    public static IRubyObject pipe(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        try {
            Pipe pipe2 = Pipe.open();
            RubyIO source2 = new RubyIO(runtime2, pipe2.source());
            RubyIO sink = new RubyIO(runtime2, pipe2.sink());
            sink.openFile.getMainStreamSafe().setSync(true);
            return runtime2.newArrayNoCopy(source2, sink);
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @JRubyMethod(name={"copy_stream"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject copy_stream(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        Object v0;
        Ruby runtime2 = context.getRuntime();
        RubyIO io1 = null;
        RubyIO io2 = null;
        if (arg1 instanceof RubyString) {
            io1 = (RubyIO)RubyFile.open(context, runtime2.getFile(), new IRubyObject[]{arg1}, Block.NULL_BLOCK);
        } else if (arg1 instanceof RubyIO) {
            io1 = (RubyIO)arg1;
        } else {
            throw runtime2.newTypeError("Should be String or IO");
        }
        if (arg2 instanceof RubyString) {
            io2 = (RubyIO)RubyFile.open(context, runtime2.getFile(), new IRubyObject[]{arg2, runtime2.newString("w")}, Block.NULL_BLOCK);
        } else if (arg2 instanceof RubyIO) {
            io2 = (RubyIO)arg2;
        } else {
            throw runtime2.newTypeError("Should be String or IO");
        }
        ChannelDescriptor d1 = io1.openFile.getMainStreamSafe().getDescriptor();
        if (!d1.isSeekable()) {
            throw context.getRuntime().newTypeError("only supports file-to-file copy");
        }
        ChannelDescriptor d2 = io2.openFile.getMainStreamSafe().getDescriptor();
        if (!d2.isSeekable()) {
            throw context.getRuntime().newTypeError("only supports file-to-file copy");
        }
        FileChannel f1 = (FileChannel)d1.getChannel();
        FileChannel f2 = (FileChannel)d2.getChannel();
        long size2 = f1.size();
        f1.transferTo(f2.position(), size2, f2);
        RubyFixnum rubyFixnum = context.getRuntime().newFixnum(size2);
        Object var16_14 = null;
        try {
            if (io1 != null) {
                io1.close();
            }
            v0 = null;
        }
        catch (Throwable throwable) {
            Object var18_18;
            v0 = var18_18 = null;
        }
        if (io2 != null) {
            io2.close();
        }
        return rubyFixnum;
        {
            catch (IOException ioe) {
                try {
                    try {
                        throw runtime2.newIOErrorFromException(ioe);
                    }
                    catch (BadDescriptorException e) {
                        throw runtime2.newErrnoEBADFError();
                    }
                }
                catch (Throwable throwable) {
                    block24: {
                        Object v1;
                        Object var16_15 = null;
                        try {
                            if (io1 != null) {
                                io1.close();
                            }
                            v1 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var18_19;
                            v1 = var18_19 = null;
                        }
                        if (io2 == null) break block24;
                        io2.close();
                    }
                    throw throwable;
                }
            }
        }
    }

    @JRubyMethod(name={"try_convert"}, meta=true, backtrace=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject tryConvert(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return arg2.respondsTo("to_io") ? RubyIO.convertToIO(context, arg2) : context.getRuntime().getNil();
    }

    private static ByteList getNilByteList(Ruby runtime2) {
        return runtime2.is1_9() ? ByteList.EMPTY_BYTELIST : NIL_BYTELIST;
    }

    public synchronized void addBlockingThread(RubyThread thread) {
        if (this.blockingThreads == null) {
            this.blockingThreads = new ArrayList<RubyThread>(1);
        }
        this.blockingThreads.add(thread);
    }

    public synchronized void removeBlockingThread(RubyThread thread) {
        if (this.blockingThreads == null) {
            return;
        }
        for (int i2 = 0; i2 < this.blockingThreads.size(); ++i2) {
            if (this.blockingThreads.get(i2) != thread) continue;
            this.blockingThreads.remove(i2);
        }
    }

    protected synchronized void interruptBlockingThreads() {
        if (this.blockingThreads == null) {
            return;
        }
        for (int i2 = 0; i2 < this.blockingThreads.size(); ++i2) {
            RubyThread thread = this.blockingThreads.get(i2);
            thread.raise(new IRubyObject[]{this.getRuntime().newIOError("stream closed").getException()}, Block.NULL_BLOCK);
        }
    }

    protected ModeFlags parseOptions(ThreadContext context, IRubyObject options2, ModeFlags modes) {
        IRubyObject encoding2;
        Ruby runtime2 = context.getRuntime();
        RubyHash rubyOptions = (RubyHash)options2;
        IRubyObject internalEncodingOption = rubyOptions.fastARef(runtime2.newSymbol("internal_encoding"));
        IRubyObject externalEncodingOption = rubyOptions.fastARef(runtime2.newSymbol("external_encoding"));
        RubyString dash = runtime2.newString("-");
        if (externalEncodingOption != null && !externalEncodingOption.isNil()) {
            if (dash.eql(externalEncodingOption)) {
                externalEncodingOption = runtime2.getEncodingService().getDefaultExternal();
            }
            this.setExternalEncoding(context, externalEncodingOption);
        }
        if (internalEncodingOption != null && !internalEncodingOption.isNil()) {
            if (dash.eql(internalEncodingOption)) {
                internalEncodingOption = runtime2.getEncodingService().getDefaultInternal();
            }
            this.setInternalEncoding(context, internalEncodingOption);
        }
        if ((encoding2 = rubyOptions.fastARef(runtime2.newSymbol("encoding"))) != null && !encoding2.isNil()) {
            if (externalEncodingOption != null && !externalEncodingOption.isNil()) {
                runtime2.getWarnings().warn("Ignoring encoding parameter '" + encoding2 + "': external_encoding is used");
            } else if (internalEncodingOption != null && !internalEncodingOption.isNil()) {
                runtime2.getWarnings().warn("Ignoring encoding parameter '" + encoding2 + "': internal_encoding is used");
            } else {
                this.parseEncodingFromString(context, encoding2, 0);
            }
        }
        if (rubyOptions.containsKey(runtime2.newSymbol("mode"))) {
            modes = this.parseModes19(context, rubyOptions.fastARef(runtime2.newSymbol("mode")).asString());
        }
        return modes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obliterateProcess(Process process) {
        int i2 = 0;
        Object waitLock = new Object();
        while (true) {
            if (i2 >= 1000) {
                throw new RuntimeException("could not shut down process: " + process);
            }
            process.destroy();
            try {
                process.exitValue();
                break;
            }
            catch (IllegalThreadStateException itse) {
                ++i2;
                Object object = waitLock;
                synchronized (object) {
                    try {
                        waitLock.wait(1L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Deprecated
    public void registerDescriptor(ChannelDescriptor descriptor, boolean isRetained) {
    }

    @Deprecated
    public void registerDescriptor(ChannelDescriptor descriptor) {
    }

    @Deprecated
    public void unregisterDescriptor(int aFileno) {
    }

    @Deprecated
    public ChannelDescriptor getDescriptorByFileno(int aFileno) {
        return ChannelDescriptor.getDescriptorByFileno(aFileno);
    }

    @Deprecated
    public static int getNewFileno() {
        return ChannelDescriptor.getNewFileno();
    }

    @Deprecated
    public boolean writeDataBuffered() {
        return this.openFile.getMainStream().writeDataBuffered();
    }

    @Deprecated
    public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        return args2.length == 0 ? this.gets(context) : this.gets(context, args2[0]);
    }

    @Deprecated
    public IRubyObject readline(ThreadContext context, IRubyObject[] args2) {
        return args2.length == 0 ? this.readline(context) : this.readline(context, args2[0]);
    }

    static {
        String v = SafePropertyAccessor.getProperty("java.vendor");
        vendor = v == null ? "" : v;
        msgEINTR = "Interrupted system call";
        NIL_BYTELIST = ByteList.create("nil");
        RECURSIVE_BYTELIST = ByteList.create("[...]");
    }

    private static class ByteListCache {
        private byte[] buffer = new byte[0];

        private ByteListCache() {
        }

        public void release(ByteList l) {
            this.buffer = l.getUnsafeBytes();
        }

        public ByteList allocate(int size2) {
            ByteList l = new ByteList(this.buffer, 0, size2, false);
            return l;
        }
    }

    private static class POpenTuple {
        public final RubyIO input;
        public final RubyIO output;
        public final RubyIO error;
        public final Process process;

        public POpenTuple(RubyIO i2, RubyIO o, RubyIO e, Process p2) {
            this.input = i2;
            this.output = o;
            this.error = e;
            this.process = p2;
        }
    }
}

