/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import org.jruby.RubyString;
import org.jruby.cext.Cleaner;
import org.jruby.cext.Native;

public final class RString
extends Cleaner {
    private final long address;

    private RString(RubyString str, long address2) {
        super(str);
        this.address = address2;
    }

    static RString newRString(RubyString str, long address2) {
        RString rstring = new RString(str, address2);
        Cleaner.register(rstring);
        return rstring;
    }

    static RString valueOf(RubyString str) {
        RString rstring = str.getRString();
        if (rstring != null) {
            return rstring;
        }
        rstring = RString.newRString(str, Native.newRString());
        str.setRString(rstring);
        return rstring;
    }

    final long address() {
        return this.address;
    }

    void dispose() {
        Native.freeRString(this.address);
    }
}

