/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Numeric;
import org.jruby.util.TypeCoercer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Fixnum"}, parent="Integer", include={"Precision"})
public class RubyFixnum
extends RubyInteger {
    private final long value;
    private static final int BIT_SIZE = 64;
    public static final long SIGN_BIT = Long.MIN_VALUE;
    public static final long MAX = Long.MAX_VALUE;
    public static final long MIN = Long.MIN_VALUE;
    public static final long MAX_MARSHAL_FIXNUM = 0x3FFFFFFFL;
    public static final long MIN_MARSHAL_FIXNUM = -1073741824L;
    public static final int CACHE_OFFSET = 128;
    private static final Map<Class, TypeCoercer> JAVA_COERCERS = new HashMap<Class, TypeCoercer>();

    public static RubyClass createFixnumClass(Ruby runtime2) {
        RubyClass fixnum = runtime2.defineClass("Fixnum", runtime2.getInteger(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setFixnum(fixnum);
        fixnum.index = 1;
        fixnum.setReifiedClass(RubyFixnum.class);
        fixnum.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyFixnum;
            }
        };
        if (!runtime2.is1_9()) {
            fixnum.includeModule(runtime2.getPrecision());
        }
        fixnum.defineAnnotatedMethods(RubyFixnum.class);
        for (int i2 = 0; i2 < runtime2.fixnumCache.length; ++i2) {
            runtime2.fixnumCache[i2] = new RubyFixnum(fixnum, (long)(i2 - 128));
        }
        return fixnum;
    }

    private static IRubyObject fixCoerce(IRubyObject x) {
        while (!((x = x.convertToInteger()) instanceof RubyFixnum) && !(x instanceof RubyBignum)) {
        }
        return x;
    }

    public RubyFixnum(Ruby runtime2) {
        this(runtime2, 0L);
    }

    public RubyFixnum(Ruby runtime2, long value2) {
        super(runtime2.getFixnum());
        this.value = value2;
    }

    private RubyFixnum(RubyClass klazz, long value2) {
        super(klazz);
        this.value = value2;
    }

    @Override
    public int getNativeTypeIndex() {
        return 1;
    }

    @Override
    public final boolean eql(IRubyObject other) {
        return other instanceof RubyFixnum && this.value == ((RubyFixnum)other).value;
    }

    @Override
    public IRubyObject equal_p(ThreadContext context, IRubyObject obj) {
        return context.getRuntime().newBoolean(this == obj || this.eql(obj));
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    @Override
    public Class<?> getJavaClass() {
        return Long.TYPE;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    public static RubyFixnum newFixnum(Ruby runtime2, long value2) {
        if (RubyFixnum.isInCacheRange(value2)) {
            return runtime2.fixnumCache[(int)value2 + 128];
        }
        return new RubyFixnum(runtime2, value2);
    }

    private static boolean isInCacheRange(long value2) {
        return value2 <= 127L && value2 >= -128L;
    }

    public RubyFixnum newFixnum(long newValue) {
        return RubyFixnum.newFixnum(this.getRuntime(), newValue);
    }

    public static RubyFixnum zero(Ruby runtime2) {
        return runtime2.fixnumCache[128];
    }

    public static RubyFixnum one(Ruby runtime2) {
        return runtime2.fixnumCache[129];
    }

    public static RubyFixnum two(Ruby runtime2) {
        return runtime2.fixnumCache[130];
    }

    public static RubyFixnum three(Ruby runtime2) {
        return runtime2.fixnumCache[131];
    }

    public static RubyFixnum four(Ruby runtime2) {
        return runtime2.fixnumCache[132];
    }

    public static RubyFixnum five(Ruby runtime2) {
        return runtime2.fixnumCache[133];
    }

    public static RubyFixnum minus_one(Ruby runtime2) {
        return runtime2.fixnumCache[127];
    }

    @Override
    public RubyFixnum hash() {
        return this.newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubyFixnum) {
            RubyFixnum num = (RubyFixnum)other;
            if (num.value == this.value) {
                return true;
            }
        }
        return false;
    }

    @Override
    @JRubyMethod
    public IRubyObject times(ThreadContext context, Block block) {
        if (block.isGiven()) {
            Ruby runtime2 = context.getRuntime();
            long lvalue = this.value;
            if (block.getBody().getArgumentType() == 0) {
                IRubyObject nil = runtime2.getNil();
                for (long i2 = 0L; i2 < lvalue; ++i2) {
                    block.yield(context, nil);
                }
            } else {
                for (long i3 = 0L; i3 < lvalue; ++i3) {
                    block.yield(context, RubyFixnum.newFixnum(runtime2, i3));
                }
            }
            return this;
        }
        return RubyEnumerator.enumeratorize(context.getRuntime(), this, "times");
    }

    public RubyString to_s(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.to_s();
            }
            case 1: {
                return this.to_s(args2[0]);
            }
        }
        throw this.getRuntime().newArgumentError(args2.length, 1);
    }

    @Override
    @JRubyMethod
    public RubyString to_s() {
        int base = 10;
        return this.getRuntime().newString(ConvertBytes.longToByteList(this.value, base));
    }

    @JRubyMethod
    public RubyString to_s(IRubyObject arg0) {
        int base = RubyFixnum.num2int(arg0);
        if (base < 2 || base > 36) {
            throw this.getRuntime().newArgumentError("illegal radix " + base);
        }
        return this.getRuntime().newString(ConvertBytes.longToByteList(this.value, base));
    }

    @JRubyMethod
    public IRubyObject id2name() {
        RubySymbol symbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        if (symbol != null) {
            return this.getRuntime().newString(symbol.asJavaString());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject to_sym() {
        RubySymbol symbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        return symbol != null ? symbol : this.getRuntime().getNil();
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        if (this.value == Long.MIN_VALUE) {
            return RubyBignum.newBignum(this.getRuntime(), BigInteger.valueOf(this.value).negate());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.addFixnum(context, (RubyFixnum)other);
        }
        return this.addOther(context, other);
    }

    public IRubyObject op_plus(ThreadContext context, long otherValue) {
        long result = this.value + otherValue;
        if (RubyFixnum.additionOverflowed(this.value, otherValue, result)) {
            return this.addAsBignum(context, otherValue);
        }
        return RubyFixnum.newFixnum(context.getRuntime(), result);
    }

    private IRubyObject addFixnum(ThreadContext context, RubyFixnum other) {
        long otherValue = other.value;
        long result = this.value + otherValue;
        if (RubyFixnum.additionOverflowed(this.value, otherValue, result)) {
            return this.addAsBignum(context, other);
        }
        return RubyFixnum.newFixnum(context.getRuntime(), result);
    }

    private static boolean additionOverflowed(long original, long other, long result) {
        return ((original ^ other ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result) & Long.MIN_VALUE) != 0L;
    }

    private static boolean subtractionOverflowed(long original, long other, long result) {
        return ((original ^ (other ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result) & Long.MIN_VALUE) != 0L;
    }

    private IRubyObject addAsBignum(ThreadContext context, RubyFixnum other) {
        return RubyBignum.newBignum(context.getRuntime(), this.value).op_plus(context, other);
    }

    private IRubyObject addAsBignum(ThreadContext context, long other) {
        return RubyBignum.newBignum(context.getRuntime(), this.value).op_plus(context, other);
    }

    private IRubyObject addOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_plus(context, this);
        }
        if (other instanceof RubyFloat) {
            return context.getRuntime().newFloat((double)this.value + ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin(context, "+", other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.subtractFixnum(context, (RubyFixnum)other);
        }
        return this.subtractOther(context, other);
    }

    public IRubyObject op_minus(ThreadContext context, long otherValue) {
        long result = this.value - otherValue;
        if (RubyFixnum.subtractionOverflowed(this.value, otherValue, result)) {
            return this.subtractAsBignum(context, otherValue);
        }
        return RubyFixnum.newFixnum(context.getRuntime(), result);
    }

    private IRubyObject subtractFixnum(ThreadContext context, RubyFixnum other) {
        long otherValue = other.value;
        long result = this.value - otherValue;
        if (RubyFixnum.subtractionOverflowed(this.value, otherValue, result)) {
            return this.subtractAsBignum(context, other);
        }
        return RubyFixnum.newFixnum(context.getRuntime(), result);
    }

    private IRubyObject subtractAsBignum(ThreadContext context, RubyFixnum other) {
        return RubyBignum.newBignum(context.getRuntime(), this.value).op_minus(context, other);
    }

    private IRubyObject subtractAsBignum(ThreadContext context, long other) {
        return RubyBignum.newBignum(context.getRuntime(), this.value).op_minus(context, other);
    }

    private IRubyObject subtractOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(context.getRuntime(), this.value).op_minus(context, other);
        }
        if (other instanceof RubyFloat) {
            return context.getRuntime().newFloat((double)this.value - ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin(context, "-", other);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.multiplyFixnum(context, other);
        }
        return this.multiplyOther(context, other);
    }

    private IRubyObject multiplyFixnum(ThreadContext context, IRubyObject other) {
        return this.op_mul(context, ((RubyFixnum)other).value);
    }

    private IRubyObject multiplyOther(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_mul(context, this);
        }
        if (other instanceof RubyFloat) {
            return runtime2.newFloat((double)this.value * ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin(context, "*", other);
    }

    public IRubyObject op_mul(ThreadContext context, long otherValue) {
        Ruby runtime2 = context.getRuntime();
        long result = this.value * otherValue;
        if (this.value != 0L && result / this.value != otherValue) {
            return RubyBignum.newBignum(runtime2, this.value).op_mul(context, otherValue);
        }
        return RubyFixnum.newFixnum(runtime2, result);
    }

    @JRubyMethod(name={"div"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject div_div(ThreadContext context, IRubyObject other) {
        return this.idiv(context, other, "div");
    }

    @JRubyMethod(name={"div"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject div_div19(ThreadContext context, IRubyObject other) {
        this.checkZeroDivisionError(context, other);
        return this.div_div(context, other);
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        return this.idiv(context, other, "/");
    }

    public IRubyObject op_div(ThreadContext context, long other) {
        return this.idiv(context, other, "/");
    }

    @JRubyMethod(name={"odd?"}, compat=CompatVersion.RUBY1_9)
    public RubyBoolean odd_p() {
        if (this.value % 2L != 0L) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"even?"}, compat=CompatVersion.RUBY1_9)
    public RubyBoolean even_p() {
        if (this.value % 2L == 0L) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject pred() {
        return this.getRuntime().newFixnum(this.value - 1L);
    }

    public IRubyObject idiv(ThreadContext context, IRubyObject other, String method2) {
        if (other instanceof RubyFixnum) {
            return this.idivLong(context, this.value, ((RubyFixnum)other).value);
        }
        return this.coerceBin(context, method2, other);
    }

    public IRubyObject idiv(ThreadContext context, long y, String method2) {
        long x = this.value;
        return this.idivLong(context, x, y);
    }

    private IRubyObject idivLong(ThreadContext context, long x, long y) {
        if (y == 0L) {
            throw context.getRuntime().newZeroDivisionError();
        }
        long div2 = x / y;
        long mod = x % y;
        if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
            --div2;
        }
        return context.getRuntime().newFixnum(div2);
    }

    @JRubyMethod(name={"%", "modulo"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.moduloFixnum(context, (RubyFixnum)other);
        }
        return this.coerceBin(context, "%", other);
    }

    public IRubyObject op_mod(ThreadContext context, long other) {
        return this.moduloFixnum(context, other);
    }

    @JRubyMethod(name={"%", "modulo"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_mod19(ThreadContext context, IRubyObject other) {
        if (context.runtime.is1_9()) {
            this.checkZeroDivisionError(context, other);
        }
        return this.op_mod(context, other);
    }

    private IRubyObject moduloFixnum(ThreadContext context, RubyFixnum other) {
        return this.moduloFixnum(context, other.value);
    }

    private IRubyObject moduloFixnum(ThreadContext context, long other) {
        long x = this.value;
        long y = other;
        if (y == 0L) {
            throw context.getRuntime().newZeroDivisionError();
        }
        long mod = x % y;
        if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
            mod += y;
        }
        return context.getRuntime().newFixnum(mod);
    }

    @Override
    @JRubyMethod(name={"divmod"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.divmodFixnum(context, other);
        }
        return this.coerceBin(context, "divmod", other);
    }

    @Override
    @JRubyMethod(name={"divmod"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject divmod19(ThreadContext context, IRubyObject other) {
        this.checkZeroDivisionError(context, other);
        return this.divmod(context, other);
    }

    private IRubyObject divmodFixnum(ThreadContext context, IRubyObject other) {
        long x = this.value;
        long y = ((RubyFixnum)other).value;
        Ruby runtime2 = context.getRuntime();
        if (y == 0L) {
            throw runtime2.newZeroDivisionError();
        }
        long div2 = x / y;
        long mod = x % y;
        if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
            --div2;
            mod += y;
        }
        RubyFixnum fixDiv = RubyFixnum.newFixnum(runtime2, div2);
        RubyFixnum fixMod = RubyFixnum.newFixnum(runtime2, mod);
        return RubyArray.newArray(runtime2, fixDiv, fixMod);
    }

    @Override
    @JRubyMethod(name={"quo"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject quo(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyFloat.newFloat(context.getRuntime(), (double)this.value / (double)((RubyFixnum)other).value);
        }
        return this.coerceBin(context, "quo", other);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.powerFixnum(context, ((RubyFixnum)other).value);
        }
        return this.powerOther(context, other);
    }

    public IRubyObject op_pow(ThreadContext context, long other) {
        return this.powerFixnum(context, other);
    }

    private IRubyObject powerFixnum(ThreadContext context, long other) {
        Ruby runtime2 = context.getRuntime();
        if (other == 0L) {
            return RubyFixnum.one(runtime2);
        }
        if (other == 1L) {
            return this;
        }
        if (other > 0L) {
            return RubyBignum.newBignum(runtime2, this.value).op_pow(context, other);
        }
        return RubyFloat.newFloat(runtime2, Math.pow(this.value, other));
    }

    private IRubyObject powerOther(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(runtime2, Math.pow(this.value, ((RubyFloat)other).getDoubleValue()));
        }
        return this.coerceBin(context, "**", other);
    }

    @JRubyMethod(name={"**"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_pow_19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double d_other = ((RubyNumeric)other).getDoubleValue();
            if (this.value < 0L && d_other != (double)Math.round(d_other)) {
                return RubyComplex.newComplexRaw(this.getRuntime(), this).callMethod(context, "**", other);
            }
            if (other instanceof RubyFixnum) {
                return this.powerFixnum19(context, other);
            }
        }
        return this.powerOther19(context, other);
    }

    private IRubyObject powerOther19(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        long a = this.value;
        if (other instanceof RubyBignum) {
            if (other.callMethod(context, "<", RubyFixnum.zero(runtime2)).isTrue()) {
                return RubyRational.newRationalRaw(runtime2, this).callMethod(context, "**", other);
            }
            if (a == 0L) {
                return RubyFixnum.zero(runtime2);
            }
            if (a == 1L) {
                return RubyFixnum.one(runtime2);
            }
            if (a == -1L) {
                return ((RubyBignum)other).even_p(context).isTrue() ? RubyFixnum.one(runtime2) : RubyFixnum.minus_one(runtime2);
            }
            RubyBignum.newBignum(runtime2, RubyBignum.fix2big(this)).op_pow(context, other);
        } else if (other instanceof RubyFloat) {
            double b = ((RubyFloat)other).getValue();
            if (b == 0.0 || a == 1L) {
                return runtime2.newFloat(1.0);
            }
            if (a == 0L) {
                return runtime2.newFloat(b < 0.0 ? Double.POSITIVE_INFINITY : 0.0);
            }
            return RubyFloat.newFloat(runtime2, Math.pow(a, b));
        }
        return this.coerceBin(context, "**", other);
    }

    private IRubyObject powerFixnum19(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        long a = this.value;
        long b = ((RubyFixnum)other).value;
        if (b < 0L) {
            return RubyRational.newRationalRaw(runtime2, this).callMethod(context, "**", other);
        }
        if (b == 0L) {
            return RubyFixnum.one(runtime2);
        }
        if (b == 1L) {
            return this;
        }
        if (a == 0L) {
            return b > 0L ? RubyFixnum.zero(runtime2) : RubyNumeric.dbl2num(runtime2, Double.POSITIVE_INFINITY);
        }
        if (a == 1L) {
            return RubyFixnum.one(runtime2);
        }
        if (a == -1L) {
            return b % 2L == 0L ? RubyFixnum.one(runtime2) : RubyFixnum.minus_one(runtime2);
        }
        return Numeric.int_pow(context, a, b);
    }

    @Override
    @JRubyMethod
    public IRubyObject abs(ThreadContext context) {
        if (this.value < 0L) {
            if (this.value == Long.MIN_VALUE) {
                return RubyBignum.newBignum(context.getRuntime(), BigInteger.valueOf(this.value).negate());
            }
            return RubyFixnum.newFixnum(context.getRuntime(), -this.value);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"magnitude"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @Override
    @JRubyMethod(name={"=="}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_equal(context, ((RubyFixnum)other).value);
        }
        return super.op_num_equal(context, other);
    }

    public IRubyObject op_equal(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context.getRuntime(), this.value == other);
    }

    public boolean fastEqual(RubyFixnum other) {
        return this.value == other.value;
    }

    @JRubyMethod(name={"=="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_equal(context, ((RubyFixnum)other).value);
        }
        return this.op_equalOther(context, other);
    }

    private IRubyObject op_equalOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context.getRuntime(), BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()) == 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context.getRuntime(), (double)this.value == ((RubyFloat)other).getDoubleValue());
        }
        return super.op_num_equal(context, other);
    }

    @Override
    public final int compareTo(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            return this.value == otherValue ? 0 : (this.value > otherValue ? 1 : -1);
        }
        return this.compareToOther(other);
    }

    private int compareToOther(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue());
        }
        if (other instanceof RubyFloat) {
            return Double.compare(this.value, ((RubyFloat)other).getDoubleValue());
        }
        return (int)this.coerceCmp(this.getRuntime().getCurrentContext(), "<=>", other).convertToInteger().getLongValue();
    }

    @Override
    @JRubyMethod(name={"<=>"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_cmp(context, ((RubyFixnum)other).value);
        }
        return this.coerceCmp(context, "<=>", other);
    }

    public IRubyObject op_cmp(ThreadContext context, long other) {
        Ruby runtime2 = context.runtime;
        return this.value == other ? RubyFixnum.zero(runtime2) : (this.value > other ? RubyFixnum.one(runtime2) : RubyFixnum.minus_one(runtime2));
    }

    @JRubyMethod(name={"<=>"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_cmp19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_cmp(context, ((RubyFixnum)other).value);
        }
        return this.compareOther(context, other);
    }

    private IRubyObject compareOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyFixnum.newFixnum(context.getRuntime(), BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()));
        }
        if (other instanceof RubyFloat) {
            return RubyFixnum.dbl_cmp(context.getRuntime(), this.value, ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceCmp(context, "<=>", other);
    }

    @JRubyMethod(name={">"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context.getRuntime(), this.value > ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(context, ">", other);
    }

    public IRubyObject op_gt(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context.getRuntime(), this.value > other);
    }

    @JRubyMethod(name={">"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_gt19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context.getRuntime(), this.value > ((RubyFixnum)other).value);
        }
        return this.op_gtOther(context, other);
    }

    private IRubyObject op_gtOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context.getRuntime(), BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()) > 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context.getRuntime(), (double)this.value > ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceRelOp(context, ">", other);
    }

    @JRubyMethod(name={">="}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context.getRuntime(), this.value >= ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(context, ">=", other);
    }

    public IRubyObject op_ge(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context.getRuntime(), this.value >= other);
    }

    @JRubyMethod(name={">="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_ge19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context.getRuntime(), this.value >= ((RubyFixnum)other).value);
        }
        return this.op_geOther(context, other);
    }

    private IRubyObject op_geOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context.getRuntime(), BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()) >= 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context.getRuntime(), (double)this.value >= ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceRelOp(context, ">=", other);
    }

    @JRubyMethod(name={"<"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context.getRuntime(), this.value < ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(context, "<", other);
    }

    public IRubyObject op_lt(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context.getRuntime(), this.value < other);
    }

    @JRubyMethod(name={"<"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_lt19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context.getRuntime(), this.value < ((RubyFixnum)other).value);
        }
        return this.op_ltOther(context, other);
    }

    private IRubyObject op_ltOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context.getRuntime(), BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()) < 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context.getRuntime(), (double)this.value < ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceRelOp(context, "<", other);
    }

    @JRubyMethod(name={"<="}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context.getRuntime(), this.value <= ((RubyFixnum)other).value);
        }
        return this.coerceRelOp(context, "<=", other);
    }

    public IRubyObject op_le(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context.getRuntime(), this.value <= other);
    }

    @JRubyMethod(name={"<="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_le19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context.getRuntime(), this.value <= ((RubyFixnum)other).value);
        }
        return this.op_leOther(context, other);
    }

    private IRubyObject op_leOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context.getRuntime(), BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()) <= 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context.getRuntime(), (double)this.value <= ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceRelOp(context, "<=", other);
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_neg() {
        return this.newFixnum(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @JRubyMethod(name={"&"})
    public IRubyObject op_and(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || (other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(context.getRuntime(), this.value & ((RubyFixnum)other).value);
        }
        return ((RubyBignum)other).op_and(context, this);
    }

    @JRubyMethod(name={"|"})
    public IRubyObject op_or(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || (other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(context.getRuntime(), this.value | ((RubyFixnum)other).value);
        }
        return ((RubyBignum)other).op_or(context, this);
    }

    @JRubyMethod(name={"^"})
    public IRubyObject op_xor(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || (other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(context.getRuntime(), this.value ^ ((RubyFixnum)other).value);
        }
        return ((RubyBignum)other).op_xor(context, this);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject other) {
        long otherValue;
        if (!(other instanceof RubyFixnum) && !((other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum)) {
            RubyBignum big = (RubyBignum)other;
            RubyInteger tryFix = RubyBignum.bignorm(this.getRuntime(), big.getValue());
            if (!(tryFix instanceof RubyFixnum)) {
                return big.getValue().signum() == 0 || this.value >= 0L ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
            }
        }
        if ((otherValue = RubyFixnum.fix2long(other)) < 0L) {
            return RubyFixnum.zero(this.getRuntime());
        }
        if (63L < otherValue) {
            return this.value < 0L ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.zero(this.getRuntime());
        }
        return (this.value & 1L << (int)otherValue) == 0L ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject op_lshift(IRubyObject other) {
        if (!(other instanceof RubyFixnum)) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_lshift(other);
        }
        long width = ((RubyFixnum)other).getLongValue();
        return width < 0L ? this.rshift(-width) : this.lshift(width);
    }

    private IRubyObject lshift(long width) {
        if (width > 63L || (-1L << (int)(64L - width - 1L) & this.value) != 0L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_lshift(RubyFixnum.newFixnum(this.getRuntime(), width));
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value << (int)width);
    }

    @JRubyMethod(name={">>"})
    public IRubyObject op_rshift(IRubyObject other) {
        if (!(other instanceof RubyFixnum)) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_rshift(other);
        }
        long width = ((RubyFixnum)other).getLongValue();
        if (width == 0L) {
            return this;
        }
        return width < 0L ? this.lshift(-width) : this.rshift(width);
    }

    private IRubyObject rshift(long width) {
        if (width >= 63L) {
            return this.value < 0L ? RubyFixnum.minus_one(this.getRuntime()) : RubyFixnum.zero(this.getRuntime());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value >> (int)width);
    }

    @JRubyMethod
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.value);
    }

    @JRubyMethod
    public IRubyObject size() {
        return this.newFixnum(8L);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0L);
    }

    @Override
    @JRubyMethod
    public IRubyObject id() {
        if (this.value <= 0x3FFFFFFFFFFFFFFFL && this.value >= -4611686018427387904L) {
            return this.newFixnum(2L * this.value + 1L);
        }
        return super.id();
    }

    @Override
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    @Override
    public String asJavaString() {
        Ruby runtime2 = this.getRuntime();
        if (runtime2.is1_9()) {
            throw runtime2.newTypeError(this.inspect().toString() + " is not a symbol");
        }
        runtime2.getWarnings().warn(IRubyWarnings.ID.FIXNUMS_NOT_SYMBOLS, "do not use Fixnums as Symbols", new Object[0]);
        RubySymbol symbol = RubySymbol.getSymbolLong(runtime2, this.value);
        if (symbol == null) {
            throw runtime2.newArgumentError("" + this.value + " is not a symbol");
        }
        return symbol.asJavaString();
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream input) throws IOException {
        return input.getRuntime().newFixnum(input.unmarshalInt());
    }

    @JRubyMethod(name={"induced_from"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject induced_from(IRubyObject recv2, IRubyObject other) {
        return RubyNumeric.num2fix(other);
    }

    private static Object coerceToJavaType(Ruby ruby2, RubyFixnum self, Class javaClass) {
        if (!Number.class.isAssignableFrom(javaClass)) {
            throw ruby2.newTypeError(javaClass.getCanonicalName() + " is not a numeric type");
        }
        TypeCoercer coercer = JAVA_COERCERS.get(javaClass);
        if (coercer == null) {
            throw ruby2.newTypeError("Cannot coerce Fixnum to " + javaClass.getCanonicalName());
        }
        return coercer.coerce(self);
    }

    private void checkZeroDivisionError(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFloat && ((RubyFloat)other).getDoubleValue() == 0.0) {
            throw context.getRuntime().newZeroDivisionError();
        }
    }

    static {
        TypeCoercer intCoercer = new TypeCoercer(){

            public Object coerce(IRubyObject self) {
                RubyFixnum fixnum = (RubyFixnum)self;
                if (fixnum.value > Integer.MAX_VALUE) {
                    throw self.getRuntime().newRangeError("Fixnum " + fixnum.value + " is too large for Java int");
                }
                return (int)fixnum.value;
            }
        };
        JAVA_COERCERS.put(Integer.TYPE, intCoercer);
        JAVA_COERCERS.put(Integer.class, intCoercer);
    }
}

