/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyContinuation;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.ast.executable.RuntimeCache;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.libraries.FiberLibrary;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.profile.IProfileData;
import org.jruby.runtime.profile.ProfileData;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.util.JavaNameMangler;

public final class ThreadContext {
    private static final int INITIAL_SIZE = 10;
    private static final int INITIAL_FRAMES_SIZE = 10;
    private static final int CALL_POLL_COUNT = 4095;
    public final Ruby runtime;
    public final IRubyObject nil;
    public final RuntimeCache runtimeCache;
    private boolean isWithinTrace;
    private boolean isWithinDefined;
    private RubyThread thread;
    private FiberLibrary.Fiber fiber;
    private RubyModule[] parentStack = new RubyModule[10];
    private int parentIndex = -1;
    private Frame[] frameStack = new Frame[10];
    private int frameIndex = -1;
    private Backtrace[] backtrace = new Backtrace[10];
    private int backtraceIndex = -1;
    private DynamicScope[] scopeStack = new DynamicScope[10];
    private int scopeIndex = -1;
    private static final RubyContinuation.Continuation[] EMPTY_CATCHTARGET_STACK = new RubyContinuation.Continuation[0];
    private RubyContinuation.Continuation[] catchStack = EMPTY_CATCHTARGET_STACK;
    private int catchIndex = -1;
    private boolean isProfiling = false;
    private IProfileData profileData;
    private int rubyFrameDelta = 0;
    private boolean eventHooksEnabled = true;
    CallType lastCallType;
    Visibility lastVisibility;
    IRubyObject lastExitStatus;
    public int callNumber = 0;
    public static final Map<String, FrameType> INTERPRETED_FRAMES = new HashMap<String, FrameType>();
    private int currentMethodSerial = 0;

    public static ThreadContext newContext(Ruby runtime2) {
        ThreadContext context = new ThreadContext(runtime2);
        return context;
    }

    private ThreadContext(Ruby runtime2) {
        this.runtime = runtime2;
        this.nil = runtime2.getNil();
        if (runtime2.getInstanceConfig().isProfilingEntireRun()) {
            this.startProfiling();
        }
        this.runtimeCache = runtime2.getRuntimeCache();
        LocalStaticScope topStaticScope = new LocalStaticScope(null);
        this.pushScope(new ManyVarsDynamicScope(topStaticScope, null));
        Frame[] stack = this.frameStack;
        int length2 = stack.length;
        for (int i = 0; i < length2; ++i) {
            stack[i] = new Frame();
        }
        Backtrace[] stack2 = this.backtrace;
        int length22 = stack2.length;
        for (int i = 0; i < length22; ++i) {
            stack2[i] = new Backtrace();
        }
        ThreadContext.pushBacktrace(this, "", "", "", 0);
        ThreadContext.pushBacktrace(this, "", "", "", 0);
    }

    protected void finalize() throws Throwable {
        this.thread.dispose();
    }

    public final Ruby getRuntime() {
        return this.runtime;
    }

    public IRubyObject getErrorInfo() {
        return this.thread.getErrorInfo();
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.thread.setErrorInfo(errorInfo);
        return errorInfo;
    }

    public JumpException.ReturnJump returnJump(IRubyObject value2) {
        return new JumpException.ReturnJump(this.getFrameJumpTarget(), value2);
    }

    public void setLastCallStatus(CallType callType) {
        this.lastCallType = callType;
    }

    public CallType getLastCallType() {
        return this.lastCallType;
    }

    public void setLastVisibility(Visibility visibility) {
        this.lastVisibility = visibility;
    }

    public Visibility getLastVisibility() {
        return this.lastVisibility;
    }

    public void setLastCallStatusAndVisibility(CallType callType, Visibility visibility) {
        this.lastCallType = callType;
        this.lastVisibility = visibility;
    }

    public IRubyObject getLastExitStatus() {
        return this.lastExitStatus;
    }

    public void setLastExitStatus(IRubyObject lastExitStatus) {
        this.lastExitStatus = lastExitStatus;
    }

    public void printScope() {
        System.out.println("SCOPE STACK:");
        for (int i = 0; i <= this.scopeIndex; ++i) {
            System.out.println(this.scopeStack[i]);
        }
    }

    public DynamicScope getCurrentScope() {
        return this.scopeStack[this.scopeIndex];
    }

    public DynamicScope getPreviousScope() {
        return this.scopeStack[this.scopeIndex - 1];
    }

    private void expandFramesIfNecessary() {
        int newSize = this.frameStack.length * 2;
        this.frameStack = this.fillNewFrameStack(new Frame[newSize], newSize);
    }

    private Frame[] fillNewFrameStack(Frame[] newFrameStack, int newSize) {
        System.arraycopy(this.frameStack, 0, newFrameStack, 0, this.frameStack.length);
        for (int i = this.frameStack.length; i < newSize; ++i) {
            newFrameStack[i] = new Frame();
        }
        return newFrameStack;
    }

    private void expandParentsIfNecessary() {
        int newSize = this.parentStack.length * 2;
        RubyModule[] newParentStack = new RubyModule[newSize];
        System.arraycopy(this.parentStack, 0, newParentStack, 0, this.parentStack.length);
        this.parentStack = newParentStack;
    }

    public void pushScope(DynamicScope scope) {
        int index2 = ++this.scopeIndex;
        DynamicScope[] stack = this.scopeStack;
        stack[index2] = scope;
        if (index2 + 1 == stack.length) {
            this.expandScopesIfNecessary();
        }
    }

    public void popScope() {
        this.scopeStack[this.scopeIndex--] = null;
    }

    private void expandScopesIfNecessary() {
        int newSize = this.scopeStack.length * 2;
        DynamicScope[] newScopeStack = new DynamicScope[newSize];
        System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
        this.scopeStack = newScopeStack;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public void setThread(RubyThread thread) {
        this.thread = thread;
        if (thread != null) {
            thread.setContext(this);
        }
    }

    public FiberLibrary.Fiber getFiber() {
        return this.fiber;
    }

    public void setFiber(FiberLibrary.Fiber fiber) {
        this.fiber = fiber;
    }

    private void expandCatchIfNecessary() {
        int newSize = this.catchStack.length * 2;
        if (newSize == 0) {
            newSize = 1;
        }
        RubyContinuation.Continuation[] newCatchStack = new RubyContinuation.Continuation[newSize];
        System.arraycopy(this.catchStack, 0, newCatchStack, 0, this.catchStack.length);
        this.catchStack = newCatchStack;
    }

    public void pushCatch(RubyContinuation.Continuation catchTarget) {
        int index2;
        if ((index2 = ++this.catchIndex) == this.catchStack.length) {
            this.expandCatchIfNecessary();
        }
        this.catchStack[index2] = catchTarget;
    }

    public void popCatch() {
        --this.catchIndex;
    }

    public RubyContinuation.Continuation getActiveCatch(Object tag) {
        for (int i = this.catchIndex; i >= 0; --i) {
            RubyContinuation.Continuation c = this.catchStack[i];
            if (!(this.runtime.is1_9() ? c.tag == tag : c.tag.equals(tag))) continue;
            return c;
        }
        return null;
    }

    private void pushFrameCopy() {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        Frame currentFrame = stack[index2 - 1];
        stack[index2].updateFrame(currentFrame);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private Frame pushFrame(Frame frame) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2] = frame;
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
        return frame;
    }

    private void pushCallFrame(RubyModule clazz, String name2, IRubyObject self, Block block) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrame(clazz, self, name2, block, this.callNumber);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushEvalFrame(IRubyObject self) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrameForEval(self, this.callNumber);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushBacktraceFrame(String name2) {
        this.pushFrame(name2);
    }

    private void pushFrame(String name2) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrame(name2);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    public void pushFrame() {
        int index2;
        Frame[] stack = this.frameStack;
        if ((index2 = ++this.frameIndex) + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    public void popFrame() {
        Frame frame = this.frameStack[this.frameIndex--];
        frame.clear();
    }

    private void popFrameReal(Frame oldFrame) {
        this.frameStack[this.frameIndex--] = oldFrame;
    }

    public Frame getCurrentFrame() {
        return this.frameStack[this.frameIndex];
    }

    public int getRubyFrameDelta() {
        return this.rubyFrameDelta;
    }

    public void setRubyFrameDelta(int newDelta) {
        this.rubyFrameDelta = newDelta;
    }

    public Frame getCurrentRubyFrame() {
        return this.frameStack[this.frameIndex - this.rubyFrameDelta];
    }

    public Frame getNextFrame() {
        int index2 = this.frameIndex;
        Frame[] stack = this.frameStack;
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
        return stack[index2 + 1];
    }

    public Frame getPreviousFrame() {
        int index2 = this.frameIndex;
        return index2 < 1 ? null : this.frameStack[index2 - 1];
    }

    public int getFrameCount() {
        return this.frameIndex + 1;
    }

    public Frame[] getFrames(int delta) {
        int top = this.frameIndex + delta;
        Frame[] frames = new Frame[top + 1];
        for (int i = 0; i <= top; ++i) {
            frames[i] = this.frameStack[i].duplicateForBacktrace();
        }
        return frames;
    }

    private static void expandBacktraceIfNecessary(ThreadContext context) {
        int newSize = context.backtrace.length * 2;
        context.backtrace = ThreadContext.fillNewBacktrace(context, new Backtrace[newSize], newSize);
    }

    private static Backtrace[] fillNewBacktrace(ThreadContext context, Backtrace[] newBacktrace, int newSize) {
        System.arraycopy(context.backtrace, 0, newBacktrace, 0, context.backtrace.length);
        for (int i = context.backtrace.length; i < newSize; ++i) {
            newBacktrace[i] = new Backtrace();
        }
        return newBacktrace;
    }

    public static void pushBacktrace(ThreadContext context, String klass, String method2, ISourcePosition position) {
        int index2 = ++context.backtraceIndex;
        Backtrace[] stack = context.backtrace;
        Backtrace.update(stack[index2], klass, method2, position);
        if (index2 + 1 == stack.length) {
            ThreadContext.expandBacktraceIfNecessary(context);
        }
    }

    public static void pushBacktrace(ThreadContext context, String klass, String method2, String file2, int line) {
        int index2 = ++context.backtraceIndex;
        Backtrace[] stack = context.backtrace;
        Backtrace.update(stack[index2], klass, method2, file2, line);
        if (index2 + 1 == stack.length) {
            ThreadContext.expandBacktraceIfNecessary(context);
        }
    }

    public static void popBacktrace(ThreadContext context) {
        --context.backtraceIndex;
    }

    public boolean isJumpTargetAlive(int target, int skipFrames) {
        for (int i = this.frameIndex - skipFrames; i >= 0; --i) {
            if (this.frameStack[i].getJumpTarget() != target) continue;
            return true;
        }
        return false;
    }

    public String getFrameName() {
        return this.getCurrentFrame().getName();
    }

    public IRubyObject getFrameSelf() {
        return this.getCurrentFrame().getSelf();
    }

    public int getFrameJumpTarget() {
        return this.getCurrentFrame().getJumpTarget();
    }

    public RubyModule getFrameKlazz() {
        return this.getCurrentFrame().getKlazz();
    }

    public Block getFrameBlock() {
        return this.getCurrentFrame().getBlock();
    }

    public String getFile() {
        return this.backtrace[this.backtraceIndex].filename;
    }

    public int getLine() {
        return this.backtrace[this.backtraceIndex].line;
    }

    public void setFile(String file2) {
        this.backtrace[this.backtraceIndex].filename = file2;
    }

    public void setLine(int line) {
        this.backtrace[this.backtraceIndex].line = line;
    }

    public void setFileAndLine(String file2, int line) {
        this.backtrace[this.backtraceIndex].filename = file2;
        this.backtrace[this.backtraceIndex].line = line;
    }

    public void setFileAndLine(ISourcePosition position) {
        this.backtrace[this.backtraceIndex].filename = position.getFile();
        this.backtrace[this.backtraceIndex].line = position.getStartLine();
    }

    public Visibility getCurrentVisibility() {
        return this.getCurrentFrame().getVisibility();
    }

    public Visibility getPreviousVisibility() {
        return this.getPreviousFrame().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.getCurrentFrame().setVisibility(visibility);
    }

    public void pollThreadEvents() {
        this.thread.pollThreadEvents(this);
    }

    public int getCurrentTarget() {
        return this.callNumber;
    }

    public void callThreadPoll() {
        if ((this.callNumber++ & 0xFFF) == 0) {
            this.pollThreadEvents();
        }
    }

    public static void callThreadPoll(ThreadContext context) {
        if ((context.callNumber++ & 0xFFF) == 0) {
            context.pollThreadEvents();
        }
    }

    public void trace(RubyEvent event, String name2, RubyModule implClass) {
        this.trace(event, name2, implClass, this.backtrace[this.backtraceIndex].filename, this.backtrace[this.backtraceIndex].line);
    }

    public void trace(RubyEvent event, String name2, RubyModule implClass, String file2, int line) {
        this.runtime.callEventHooks(this, event, file2, line, name2, implClass);
    }

    public void pushRubyClass(RubyModule currentModule) {
        int index2 = ++this.parentIndex;
        RubyModule[] stack = this.parentStack;
        stack[index2] = currentModule;
        if (index2 + 1 == stack.length) {
            this.expandParentsIfNecessary();
        }
    }

    public RubyModule popRubyClass() {
        int index2 = this.parentIndex;
        RubyModule[] stack = this.parentStack;
        RubyModule ret = stack[index2];
        stack[index2] = null;
        this.parentIndex = index2 - 1;
        return ret;
    }

    public RubyModule getRubyClass() {
        assert (this.parentIndex != -1) : "Trying to get RubyClass from empty stack";
        RubyModule parentModule = this.parentStack[this.parentIndex];
        return parentModule.getNonIncludedClass();
    }

    public RubyModule getPreviousRubyClass() {
        assert (this.parentIndex != 0) : "Trying to get RubyClass from too-shallow stack";
        RubyModule parentModule = this.parentStack[this.parentIndex - 1];
        return parentModule.getNonIncludedClass();
    }

    public boolean getConstantDefined(String internedName) {
        IRubyObject value2 = this.getConstant(internedName);
        return value2 != null;
    }

    public IRubyObject getConstant(String internedName) {
        return this.getCurrentScope().getStaticScope().getConstant(this.runtime, internedName, this.runtime.getObject());
    }

    public IRubyObject setConstantInCurrent(String internedName, IRubyObject result) {
        RubyModule module = this.getCurrentScope().getStaticScope().getModule();
        if (module != null) {
            module.fastSetConstant(internedName, result);
            return result;
        }
        throw this.runtime.newTypeError("no class/module to define constant");
    }

    public IRubyObject setConstantInModule(String internedName, IRubyObject target, IRubyObject result) {
        if (!(target instanceof RubyModule)) {
            throw this.runtime.newTypeError(target.toString() + " is not a class/module");
        }
        RubyModule module = (RubyModule)target;
        module.fastSetConstant(internedName, result);
        return result;
    }

    public IRubyObject setConstantInObject(String internedName, IRubyObject result) {
        this.runtime.getObject().fastSetConstant(internedName, result);
        return result;
    }

    private static void addBackTraceElement(Ruby runtime2, RubyArray backtrace2, RubyStackTraceElement element) {
        RubyString str = RubyString.newString(runtime2, element.getFileName() + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'");
        backtrace2.append(str);
    }

    public IRubyObject createCallerBacktrace(Ruby runtime2, int level2) {
        RubyStackTraceElement[] trace = this.gatherCallerBacktrace(level2);
        block0: for (int i = 0; i < trace.length; ++i) {
            RubyStackTraceElement element = trace[i];
            String classDotMethod = element.getClassName() + "." + element.getMethodName();
            if (!runtime2.getBoundMethods().containsKey(classDotMethod)) continue;
            String rubyName = runtime2.getBoundMethods().get(classDotMethod);
            RubyStackTraceElement rubyElement = null;
            for (int j = i; j < trace.length; ++j) {
                rubyElement = trace[j];
                if (rubyElement.getFileName().endsWith(".java")) continue;
                trace[i] = new RubyStackTraceElement(element.getClassName(), rubyName, rubyElement.getFileName(), rubyElement.getLineNumber(), rubyElement.isBinding(), rubyElement.getFrameType());
                continue block0;
            }
        }
        RubyArray backtrace2 = runtime2.newArray(trace.length - level2);
        for (int i = level2; i < trace.length; ++i) {
            ThreadContext.addBackTraceElement(runtime2, backtrace2, trace[i]);
        }
        return backtrace2;
    }

    public RubyStackTraceElement[] gatherCallerBacktrace(int level2) {
        Thread nativeThread = this.thread.getNativeThread();
        if (nativeThread == null) {
            return new RubyStackTraceElement[0];
        }
        Backtrace[] copy = new Backtrace[this.backtraceIndex + 1];
        System.arraycopy(this.backtrace, 0, copy, 0, this.backtraceIndex + 1);
        RubyStackTraceElement[] trace = ThreadContext.gatherHybridBacktrace(this.runtime, copy, nativeThread.getStackTrace(), false);
        return trace;
    }

    public Frame[] createBacktrace(int level2, boolean nativeException) {
        Frame[] traceFrames;
        int traceSize = this.frameIndex - level2 + 1;
        if (traceSize <= 0) {
            return null;
        }
        if (nativeException) {
            traceFrames = new Frame[traceSize + 1];
            traceFrames[traceSize] = this.frameStack[this.frameIndex];
        } else {
            traceFrames = new Frame[traceSize];
        }
        System.arraycopy(this.frameStack, 0, traceFrames, 0, traceSize);
        return traceFrames;
    }

    public boolean isEventHooksEnabled() {
        return this.eventHooksEnabled;
    }

    public void setEventHooksEnabled(boolean flag) {
        this.eventHooksEnabled = flag;
    }

    public Backtrace[] createBacktrace2(int level2, boolean nativeException) {
        Backtrace[] newTrace = new Backtrace[this.backtraceIndex + 1];
        for (int i = 0; i <= this.backtraceIndex; ++i) {
            newTrace[i] = this.backtrace[i].clone();
        }
        return newTrace;
    }

    private static String createRubyBacktraceString(StackTraceElement element) {
        return element.getFileName() + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'";
    }

    public static String createRawBacktraceStringFromThrowable(Throwable t) {
        StackTraceElement[] javaStackTrace = t.getStackTrace();
        StringBuffer buffer = new StringBuffer();
        if (javaStackTrace != null && javaStackTrace.length > 0) {
            StackTraceElement element = javaStackTrace[0];
            buffer.append(ThreadContext.createRubyBacktraceString(element)).append(": ").append(t.toString()).append("\n");
            for (int i = 1; i < javaStackTrace.length; ++i) {
                element = javaStackTrace[i];
                buffer.append("\tfrom ").append(ThreadContext.createRubyBacktraceString(element));
                if (i + 1 >= javaStackTrace.length) continue;
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public static RubyStackTraceElement[] gatherRawBacktrace(Ruby runtime2, StackTraceElement[] stackTrace) {
        ArrayList<RubyStackTraceElement> trace = new ArrayList<RubyStackTraceElement>(stackTrace.length);
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            trace.add(new RubyStackTraceElement(element));
        }
        RubyStackTraceElement[] rubyStackTrace = new RubyStackTraceElement[trace.size()];
        return trace.toArray(rubyStackTrace);
    }

    private Frame pushFrameForBlock(Binding binding2) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding2.getFrame());
        f.setVisibility(binding2.getVisibility());
        return lastFrame;
    }

    private Frame pushFrameForEval(Binding binding2) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding2.getFrame());
        f.setVisibility(binding2.getVisibility());
        return lastFrame;
    }

    public static RubyStackTraceElement[] gatherHybridBacktrace(Ruby runtime2, Backtrace[] backtraceFrames, StackTraceElement[] stackTrace, boolean fullTrace) {
        int rubyFrameIndex;
        ArrayList<RubyStackTraceElement> trace = new ArrayList<RubyStackTraceElement>(stackTrace.length);
        int n = rubyFrameIndex = backtraceFrames == null ? -1 : backtraceFrames.length - 1;
        if (stackTrace == null) {
            return null;
        }
        for (int i = 0; i < stackTrace.length; ++i) {
            String classMethod;
            FrameType frameType;
            StackTraceElement element = stackTrace[i];
            if (element.getFileName() != null && (element.getFileName().endsWith(".rb") || element.getFileName().equals("-e") || element.getClassName().startsWith("rubyjit") || element.getMethodName().contains("$RUBY$") || element.getMethodName().contains("__file__"))) {
                if (element.getLineNumber() == -1) continue;
                String methodName = element.getMethodName();
                String className = element.getClassName();
                if (className.startsWith("rubyjit")) {
                    methodName = className.substring("rubyjit".length() + 1, className.lastIndexOf("_"));
                    methodName = JavaNameMangler.demangleMethodName(methodName);
                    trace.add(new RubyStackTraceElement(className, methodName, element.getFileName(), element.getLineNumber(), false));
                    if (!element.getMethodName().contains("$RUBY$SYNTHETIC")) continue;
                    while (element.getMethodName().indexOf("$RUBY$SYNTHETIC") != -1) {
                        element = stackTrace[++i];
                    }
                    continue;
                }
                int RUBYindex = methodName.indexOf("$RUBY$");
                if (RUBYindex >= 0) {
                    if ((methodName = methodName.substring(RUBYindex)).startsWith("$RUBY$SYNTHETIC")) {
                        methodName = methodName.substring("$RUBY$SYNTHETIC".length());
                        if ((methodName = JavaNameMangler.demangleMethodName(methodName)) == "__file__") {
                            methodName = "(root)";
                        }
                        trace.add(new RubyStackTraceElement(className, methodName, element.getFileName(), element.getLineNumber(), false));
                        while (element.getMethodName().indexOf("$RUBY$SYNTHETIC") != -1) {
                            element = stackTrace[++i];
                        }
                        continue;
                    }
                    methodName = methodName.substring("$RUBY$".length());
                    methodName = JavaNameMangler.demangleMethodName(methodName);
                    trace.add(new RubyStackTraceElement(className, methodName, element.getFileName(), element.getLineNumber(), false));
                    continue;
                }
                if (methodName.equals("__file__")) {
                    methodName = "(root)";
                    trace.add(new RubyStackTraceElement(className, methodName, element.getFileName(), element.getLineNumber(), false));
                    continue;
                }
            }
            String dotClassMethod = element.getClassName() + "." + element.getMethodName();
            if (fullTrace || runtime2.getBoundMethods().containsKey(dotClassMethod)) {
                String filename2 = element.getFileName();
                int lastDot = element.getClassName().lastIndexOf(46);
                if (lastDot != -1) {
                    filename2 = element.getClassName().substring(0, lastDot + 1).replaceAll("\\.", "/") + filename2;
                }
                trace.add(new RubyStackTraceElement(element.getClassName(), element.getMethodName(), filename2, element.getLineNumber(), false));
                if (!fullTrace) continue;
            }
            if ((frameType = INTERPRETED_FRAMES.get(classMethod = element.getClassName() + "." + element.getMethodName())) == null || rubyFrameIndex < 0) continue;
            Backtrace rubyElement = backtraceFrames[rubyFrameIndex];
            trace.add(new RubyStackTraceElement(rubyElement.klass, rubyElement.method, rubyElement.filename, rubyElement.line + 1, false));
            --rubyFrameIndex;
        }
        RubyStackTraceElement[] rubyStackTrace = new RubyStackTraceElement[trace.size()];
        return trace.toArray(rubyStackTrace);
    }

    public void preAdoptThread() {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.getCurrentFrame().setSelf(this.runtime.getTopSelf());
    }

    public void preCompiledClass(RubyModule type2, StaticScope staticScope) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        staticScope.setModule(type2);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
    }

    public void preCompiledClassDummyScope(RubyModule type2, StaticScope staticScope) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        staticScope.setModule(type2);
        this.pushScope(staticScope.getDummyScope());
    }

    public void postCompiledClass() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preScopeNode(StaticScope staticScope) {
        this.pushScope(DynamicScope.newDynamicScope(staticScope, this.getCurrentScope()));
    }

    public void postScopeNode() {
        this.popScope();
    }

    public void preClassEval(StaticScope staticScope, RubyModule type2) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        this.pushScope(DynamicScope.newDynamicScope(staticScope, null));
    }

    public void postClassEval() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preBsfApply(String[] names2) {
        LocalStaticScope staticScope = new LocalStaticScope(null);
        staticScope.setVariables(names2);
        this.pushFrame();
    }

    public void postBsfApply() {
        this.popFrame();
    }

    public void preMethodFrameAndScope(RubyModule clazz, String name2, IRubyObject self, Block block, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushCallFrame(clazz, name2, self, block);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void preMethodFrameAndDummyScope(RubyModule clazz, String name2, IRubyObject self, Block block, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushCallFrame(clazz, name2, self, block);
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void preMethodNoFrameAndDummyScope(RubyModule clazz, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void postMethodFrameAndScope() {
        this.popRubyClass();
        this.popScope();
        this.popFrame();
    }

    public void preMethodFrameOnly(RubyModule clazz, String name2, IRubyObject self, Block block) {
        this.pushRubyClass(clazz);
        this.pushCallFrame(clazz, name2, self, block);
    }

    public void postMethodFrameOnly() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preMethodScopeOnly(RubyModule clazz, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void postMethodScopeOnly() {
        this.popRubyClass();
        this.popScope();
    }

    public void preMethodBacktraceAndScope(String name2, RubyModule clazz, StaticScope staticScope) {
        this.preMethodScopeOnly(clazz, staticScope);
    }

    public void postMethodBacktraceAndScope() {
        this.postMethodScopeOnly();
    }

    public void preMethodBacktraceOnly(String name2) {
    }

    public void preMethodBacktraceDummyScope(RubyModule clazz, String name2, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void postMethodBacktraceOnly() {
    }

    public void postMethodBacktraceDummyScope() {
        this.popRubyClass();
        this.popScope();
    }

    public void prepareTopLevel(RubyClass objectClass, IRubyObject topSelf) {
        this.pushFrame();
        this.setCurrentVisibility(Visibility.PRIVATE);
        this.pushRubyClass(objectClass);
        Frame frame = this.getCurrentFrame();
        frame.setSelf(topSelf);
        this.getCurrentScope().getStaticScope().setModule(objectClass);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self, String name2) {
        this.pushRubyClass(rubyClass);
        this.pushEvalFrame(self);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self) {
        this.pushRubyClass(rubyClass);
        this.pushEvalFrame(self);
    }

    public void postNodeEval() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preExecuteUnder(RubyModule executeUnderClass, Block block) {
        Frame frame = this.getCurrentFrame();
        this.pushRubyClass(executeUnderClass);
        DynamicScope scope = this.getCurrentScope();
        BlockStaticScope sScope = new BlockStaticScope(scope.getStaticScope());
        sScope.setModule(executeUnderClass);
        this.pushScope(DynamicScope.newDynamicScope(sScope, scope));
        this.pushCallFrame(frame.getKlazz(), frame.getName(), frame.getSelf(), block);
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postExecuteUnder() {
        this.popFrame();
        this.popScope();
        this.popRubyClass();
    }

    public void preMproc() {
        this.pushFrame();
    }

    public void postMproc() {
        this.popFrame();
    }

    public void preRunThread(Frame[] currentFrames) {
        for (Frame frame : currentFrames) {
            this.pushFrame(frame);
        }
    }

    public void preTrace() {
        this.setWithinTrace(true);
        this.pushFrame();
    }

    public void postTrace() {
        this.popFrame();
        this.setWithinTrace(false);
    }

    public Frame preForBlock(Binding binding2, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(binding2.getDynamicScope());
        return lastFrame;
    }

    public Frame preYieldSpecificBlock(Binding binding2, StaticScope scope, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(DynamicScope.newDynamicScope(scope, binding2.getDynamicScope()));
        return lastFrame;
    }

    public Frame preYieldLightBlock(Binding binding2, DynamicScope emptyScope, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(emptyScope);
        return lastFrame;
    }

    public Frame preYieldNoScope(Binding binding2, RubyModule klass) {
        this.pushRubyClass(klass != null ? klass : binding2.getKlass());
        return this.pushFrameForBlock(binding2);
    }

    public void preEvalScriptlet(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postEvalScriptlet() {
        this.popScope();
    }

    public Frame preEvalWithBinding(Binding binding2) {
        binding2.getFrame().setIsBindingFrame(true);
        Frame lastFrame = this.pushFrameForEval(binding2);
        this.pushRubyClass(binding2.getKlass());
        return lastFrame;
    }

    public void postEvalWithBinding(Binding binding2, Frame lastFrame) {
        binding2.getFrame().setIsBindingFrame(false);
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYield(Binding binding2, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldLight(Binding binding2, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldNoScope(Frame lastFrame) {
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void preScopedBody(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postScopedBody() {
        this.popScope();
    }

    public boolean isWithinTrace() {
        return this.isWithinTrace;
    }

    public void setWithinTrace(boolean isWithinTrace) {
        this.isWithinTrace = isWithinTrace;
    }

    public boolean isWithinDefined() {
        return this.isWithinDefined;
    }

    public void setWithinDefined(boolean isWithinDefined) {
        this.isWithinDefined = isWithinDefined;
    }

    public Binding currentBinding() {
        Frame frame = this.getCurrentFrame();
        return new Binding(frame, this.getRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, frame.getVisibility(), this.getRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self, Visibility visibility) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, visibility, this.getRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self, DynamicScope scope) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, frame.getVisibility(), this.getRubyClass(), scope, this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self, Visibility visibility, DynamicScope scope) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, visibility, this.getRubyClass(), scope, this.backtrace[this.backtraceIndex].clone());
    }

    public Binding previousBinding() {
        Frame frame = this.getPreviousFrame();
        return new Binding(frame, this.getPreviousRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public Binding previousBinding(IRubyObject self) {
        Frame frame = this.getPreviousFrame();
        return new Binding(self, frame, frame.getVisibility(), this.getPreviousRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public IProfileData getProfileData() {
        if (this.profileData == null) {
            this.profileData = new ProfileData(this);
        }
        return this.profileData;
    }

    public int profileEnter(int nextMethod) {
        int previousMethodSerial = this.currentMethodSerial;
        this.currentMethodSerial = nextMethod;
        if (this.isProfiling) {
            this.getProfileData().profileEnter(nextMethod);
        }
        return previousMethodSerial;
    }

    public int profileExit(int nextMethod, long startTime) {
        int previousMethodSerial = this.currentMethodSerial;
        this.currentMethodSerial = nextMethod;
        if (this.isProfiling) {
            this.getProfileData().profileExit(nextMethod, startTime);
        }
        return previousMethodSerial;
    }

    public void startProfiling() {
        this.isProfiling = true;
    }

    public void stopProfiling() {
        this.isProfiling = false;
    }

    public boolean isProfiling() {
        return this.isProfiling;
    }

    static {
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".INTERPRET_METHOD", FrameType.METHOD);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".INTERPRET_EVAL", FrameType.EVAL);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".INTERPRET_CLASS", FrameType.CLASS);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".INTERPRET_BLOCK", FrameType.BLOCK);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".INTERPRET_ROOT", FrameType.ROOT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FrameType {
        METHOD,
        BLOCK,
        EVAL,
        CLASS,
        ROOT;

    }

    public static class RubyStackTraceElement {
        private final StackTraceElement element;
        private final boolean binding;
        private final FrameType frameType;

        public RubyStackTraceElement(StackTraceElement element) {
            this.element = element;
            this.binding = false;
            this.frameType = FrameType.METHOD;
        }

        public RubyStackTraceElement(String cls, String method2, String file2, int line, boolean binding2) {
            this(cls, method2, file2, line, binding2, FrameType.METHOD);
        }

        public RubyStackTraceElement(String cls, String method2, String file2, int line, boolean binding2, FrameType frameType) {
            this.element = new StackTraceElement(cls, method2, file2, line);
            this.binding = binding2;
            this.frameType = frameType;
        }

        public StackTraceElement getElement() {
            return this.element;
        }

        public boolean isBinding() {
            return this.binding;
        }

        public String getClassName() {
            return this.element.getClassName();
        }

        public String getFileName() {
            return this.element.getFileName();
        }

        public int getLineNumber() {
            return this.element.getLineNumber();
        }

        public String getMethodName() {
            return this.element.getMethodName();
        }

        public FrameType getFrameType() {
            return this.frameType;
        }

        public String toString() {
            return this.element.toString();
        }
    }

    public static class Backtrace {
        public String klass;
        public String method;
        public String filename;
        public int line;

        public Backtrace() {
        }

        public Backtrace(String klass, String method2, String filename2, int line) {
            this.method = method2;
            this.filename = filename2;
            this.line = line;
            this.klass = klass;
        }

        public String toString() {
            return this.klass + "#" + this.method + " at " + this.filename + ":" + this.line;
        }

        public Backtrace clone() {
            return new Backtrace(this.klass, this.method, this.filename, this.line);
        }

        public static void update(Backtrace backtrace2, String klass, String method2, ISourcePosition position) {
            backtrace2.method = method2;
            backtrace2.filename = position.getFile();
            backtrace2.line = position.getLine();
            backtrace2.klass = klass;
        }

        public static void update(Backtrace backtrace2, String klass, String method2, String file2, int line) {
            backtrace2.method = method2;
            backtrace2.filename = file2;
            backtrace2.line = line;
            backtrace2.klass = klass;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename2) {
            this.filename = filename2;
        }

        public String getKlass() {
            return this.klass;
        }

        public void setKlass(String klass) {
            this.klass = klass;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method2) {
            this.method = method2;
        }
    }
}

