/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.Constant;
import org.jruby.runtime.builtin.IRubyObject;

public class Argv
extends AbstractVariable {
    private static String pattern = "ARGV";

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            return new Argv(receiver2, name2, javaObject);
        }
        return null;
    }

    private Argv(RubyObject receiver2, String name2, Object ... javaObjects) {
        super(receiver2, name2, false);
        assert (javaObjects != null);
        this.javaObject = javaObjects[0];
        this.javaType = this.javaObject == null ? null : (javaObjects.length > 1 ? (Class)javaObjects[1] : this.javaObject.getClass());
    }

    private void updateArgvByJavaObject() {
        RubyArray ary = RubyArray.newArray(this.receiver.getRuntime());
        if (this.javaObject instanceof Collection) {
            ary.addAll((Collection)this.javaObject);
        } else if (this.javaObject instanceof String[]) {
            for (String s : (String[])this.javaObject) {
                ary.add(s);
            }
        }
        this.irubyObject = ary;
    }

    Argv(IRubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, true, irubyObject);
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.Argv;
    }

    public static boolean isValidName(Object name2) {
        return Argv.isValidName(pattern, name2);
    }

    public void inject() {
        this.updateArgvByJavaObject();
        RubyModule rubyModule = this.getRubyClass(this.receiver.getRuntime());
        if (rubyModule == null) {
            rubyModule = this.receiver.getRuntime().getCurrentContext().getRubyClass();
        }
        if (rubyModule == null) {
            return;
        }
        rubyModule.storeConstant(this.name, this.irubyObject);
        this.receiver.getRuntime().incrementConstantGeneration();
        this.fromRuby = true;
    }

    public void remove() {
        this.javaObject = new ArrayList();
        this.inject();
    }

    public static void retrieve(RubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        Argv.updateARGV(receiver2, vars);
    }

    private static void updateARGV(IRubyObject receiver2, BiVariableMap vars) {
        String name2 = "ARGV".intern();
        IRubyObject argv = receiver2.getRuntime().getTopSelf().getMetaClass().fastGetConstant(name2);
        if (argv == null || argv instanceof RubyNil) {
            return;
        }
        if (vars.containsKey(name2)) {
            BiVariable var = vars.getVariable((RubyObject)receiver2.getRuntime().getTopSelf(), name2);
            var.setRubyObject(argv);
        } else {
            Constant var = new Constant(receiver2.getRuntime().getTopSelf(), name2, argv);
            var.markInitialized();
            vars.update(name2, var);
        }
    }

    public static void retrieveByKey(RubyObject receiver2, BiVariableMap vars, String key2) {
        assert (key2.equals("ARGV"));
        Argv.updateARGV(receiver2, vars);
    }

    public Object getJavaObject() {
        if (this.irubyObject == null || !this.fromRuby) {
            return this.javaObject;
        }
        RubyArray ary = (RubyArray)this.irubyObject;
        if (this.javaType == null) {
            this.javaObject = new ArrayList();
            ((ArrayList)this.javaObject).addAll(ary);
            return this.javaObject;
        }
        if (this.javaType == String[].class) {
            this.javaObject = new String[ary.size()];
            for (int i = 0; i < ary.size(); ++i) {
                ((String[])this.javaObject)[i] = (String)ary.get(i);
            }
            return this.javaObject;
        }
        if (this.javaObject instanceof List) {
            try {
                ((List)this.javaObject).clear();
                ((List)this.javaObject).addAll(ary);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return this.javaObject;
        }
        return null;
    }
}

