/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.Set;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.dataflow.DataFlowConstants;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.BindingStorePlacementNode;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;

public class BindingStorePlacementProblem
extends DataFlowProblem {
    private Set<Variable> _usedVars = new HashSet<Variable>();
    private Set<Variable> _defVars = new HashSet<Variable>();

    public BindingStorePlacementProblem() {
        super(DataFlowProblem.DF_Direction.FORWARD);
    }

    public String getName() {
        return "Binding Stores Placement Analysis";
    }

    public FlowGraphNode buildFlowGraphNode(BasicBlock bb) {
        return new BindingStorePlacementNode(this, bb);
    }

    public String getDataFlowVarsForOutput() {
        return "";
    }

    public void recordUsedVar(Variable v) {
        this._usedVars.add(v);
    }

    public void recordDefVar(Variable v) {
        this._defVars.add(v);
    }

    public boolean scopeDefinesVariable(Variable v) {
        if (this._defVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getCFG().getScope().getClosures()) {
            BindingStorePlacementProblem nestedProblem = (BindingStorePlacementProblem)cl.getCFG().getDataFlowSolution(DataFlowConstants.BSP_NAME);
            if (!nestedProblem.scopeDefinesVariable(v)) continue;
            return true;
        }
        return false;
    }

    public boolean scopeUsesVariable(Variable v) {
        if (this._usedVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getCFG().getScope().getClosures()) {
            BindingStorePlacementProblem nestedProblem = (BindingStorePlacementProblem)cl.getCFG().getDataFlowSolution(DataFlowConstants.BSP_NAME);
            if (!nestedProblem.scopeUsesVariable(v)) continue;
            return true;
        }
        return false;
    }

    public void addStoreAndBindingAllocInstructions() {
        for (FlowGraphNode n : this._fgNodes) {
            BindingStorePlacementNode bspn = (BindingStorePlacementNode)n;
            bspn.addStoreAndBindingAllocInstructions();
        }
    }
}

