/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.IRScript;
import org.jruby.compiler.ir.compiler_pass.CompilerPass;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.PutConstInstr;
import org.jruby.compiler.ir.operands.ClassMetaObject;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.ModuleMetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.RenamedVariable;
import org.jruby.compiler.ir.operands.TemporaryClosureVariable;
import org.jruby.compiler.ir.operands.TemporaryVariable;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.parser.StaticScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IRScopeImpl
implements IRScope {
    Operand container;
    RubyModule containerModule;
    IRScope lexicalParent;
    private String name;
    public final List<IRModule> modules = new ArrayList<IRModule>();
    public final List<IRClass> classes = new ArrayList<IRClass>();
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, Operand> constants = new HashMap<String, Operand>();
    private int nextClosureIndex = 0;
    private Map<String, Integer> nextVarIndex = new HashMap<String, Integer>();
    private StaticScope staticScope;

    public IRScopeImpl(IRScope lexicalParent, Operand container, String name2, StaticScope staticScope) {
        this.lexicalParent = lexicalParent;
        this.container = container;
        this.name = name2;
        this.staticScope = staticScope;
    }

    public void setContainer(Operand o) {
        this.container = o;
    }

    @Override
    public Operand getContainer() {
        return this.container;
    }

    public RubyModule getContainerModule() {
        return this.containerModule;
    }

    public void setContainerModule(RubyModule containerModule) {
        this.containerModule = containerModule;
    }

    @Override
    public IRScope getLexicalParent() {
        return this.lexicalParent;
    }

    @Override
    public IRModule getNearestModule() {
        IRScope current2;
        for (current2 = this.lexicalParent; current2 != null && !(current2 instanceof IRModule) && !(current2 instanceof IRScript); current2 = current2.getLexicalParent()) {
        }
        if (current2 instanceof IRScript) {
            current2 = ((IRScript)current2).getRootClass();
        }
        return (IRModule)current2;
    }

    @Override
    public int getNextClosureId() {
        ++this.nextClosureIndex;
        return this.nextClosureIndex;
    }

    public Variable getNewTemporaryClosureVariable(int closureId) {
        return new TemporaryClosureVariable(closureId, this.allocateNextPrefixedName("%cl_" + closureId));
    }

    @Override
    public Variable getNewTemporaryVariable() {
        return new TemporaryVariable(this.allocateNextPrefixedName("%v"));
    }

    public Variable getNewInlineVariable() {
        return new RenamedVariable("%i", this.allocateNextPrefixedName("%i"));
    }

    @Override
    public int getTemporaryVariableSize() {
        return this.getPrefixCountSize("%v");
    }

    @Override
    public int getRenamedVariableSize() {
        return this.getPrefixCountSize("%i");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public abstract String getScopeName();

    @Override
    public Label getNewLabel(String prefix) {
        return new Label(prefix + "_" + this.allocateNextPrefixedName(prefix));
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel("LBL");
    }

    private int allocateNextPrefixedName(String prefix) {
        int index2 = this.getPrefixCountSize(prefix);
        this.nextVarIndex.put(prefix, index2 + 1);
        return index2;
    }

    protected int getPrefixCountSize(String prefix) {
        Integer index2 = this.nextVarIndex.get(prefix);
        if (index2 == null) {
            return 0;
        }
        return index2;
    }

    @Override
    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    public void addModule(IRModule m) {
        this.setConstantValue(m.getName(), new ModuleMetaObject(m));
        this.modules.add(m);
    }

    @Override
    public void addClass(IRClass c) {
        this.setConstantValue(c.getName(), new ClassMetaObject(c));
        this.classes.add(c);
    }

    @Override
    public void addInstr(Instr i) {
        throw new RuntimeException("Encountered instruction add in a non-execution scope!");
    }

    @Override
    public void recordMethodAlias(String newName, String oldName) {
        this.aliases.put(oldName, newName);
    }

    @Override
    public String unaliasMethodName(String name2) {
        String n = name2;
        String a = null;
        do {
            if ((a = this.aliases.get(n)) == null) continue;
            n = a;
        } while (a != null);
        return n;
    }

    public List<Instr> getInstrs() {
        return null;
    }

    @Override
    public Operand getConstantValue(String constRef) {
        Operand cv = this.constants.get(constRef);
        Operand p2 = this.container;
        if (cv == null && p2 != null && p2 instanceof MetaObject) {
            if (((MetaObject)p2).scope == null) {
                IRClass coreClass = IRModule.getCoreClass(constRef);
                return coreClass != null ? new ClassMetaObject(coreClass) : null;
            }
            cv = ((MetaObject)p2).scope.getConstantValue(constRef);
        }
        return cv;
    }

    @Override
    public void setConstantValue(String constRef, Operand val) {
        if (val.isConstant()) {
            this.constants.put(constRef, val);
        }
        if (this instanceof IRModule) {
            ((IRModule)this).getRootMethod().addInstr(new PutConstInstr(this, constRef, val));
        }
    }

    public Map getConstants() {
        return Collections.unmodifiableMap(this.constants);
    }

    public String toString() {
        return this.getScopeName() + " " + this.getName() + (this.constants.isEmpty() ? "" : "\n  constants: " + this.constants);
    }

    protected void runCompilerPassOnNestedScopes(CompilerPass p2) {
        for (IRModule m : this.modules) {
            m.runCompilerPass(p2);
        }
        for (IRClass c : this.classes) {
            c.runCompilerPass(p2);
        }
    }

    @Override
    public void runCompilerPass(CompilerPass p2) {
        boolean isPreOrder = p2.isPreOrder();
        if (isPreOrder) {
            p2.run(this);
        }
        this.runCompilerPassOnNestedScopes(p2);
        if (!isPreOrder) {
            p2.run(this);
        }
    }

    public String toStringInstrs() {
        return "";
    }

    public String toStringVariables() {
        return "";
    }
}

