/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.environment.OSEnvironment;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.Constants;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ReadonlyGlobalVariable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.KCode;
import org.jruby.util.RegexpOptions;
import org.jruby.util.io.STDIO;

public class RubyGlobal {
    public static void createGlobals(ThreadContext context, Ruby runtime2) {
        runtime2.defineGlobalConstant("TOPLEVEL_BINDING", runtime2.newBinding());
        runtime2.defineGlobalConstant("TRUE", runtime2.getTrue());
        runtime2.defineGlobalConstant("FALSE", runtime2.getFalse());
        runtime2.defineGlobalConstant("NIL", runtime2.getNil());
        RubyArray argvArray = runtime2.newArray();
        String[] argv = runtime2.getInstanceConfig().getArgv();
        for (int i = 0; i < argv.length; ++i) {
            argvArray.append(RubyString.newStringShared(runtime2, argv[i].getBytes()));
        }
        runtime2.defineGlobalConstant("ARGV", argvArray);
        runtime2.getGlobalVariables().defineReadonly("$*", new ValueAccessor(argvArray));
        ValueAccessor d = new ValueAccessor(runtime2.newString(runtime2.getInstanceConfig().displayedFileName()));
        runtime2.getGlobalVariables().define("$PROGRAM_NAME", d);
        runtime2.getGlobalVariables().define("$0", d);
        IRubyObject version = null;
        RubyFixnum patchlevel = null;
        IRubyObject release = runtime2.newString("2011-02-09").freeze(context);
        IRubyObject platform = runtime2.newString("java").freeze(context);
        IRubyObject engine = runtime2.newString("jruby").freeze(context);
        switch (runtime2.getInstanceConfig().getCompatVersion()) {
            case RUBY1_8: {
                version = runtime2.newString("1.8.7").freeze(context);
                patchlevel = runtime2.newFixnum(Constants.RUBY_PATCHLEVEL);
                break;
            }
            case RUBY1_9: {
                version = runtime2.newString("1.9.2").freeze(context);
                patchlevel = runtime2.newFixnum(Constants.RUBY1_9_PATCHLEVEL);
            }
        }
        runtime2.defineGlobalConstant("RUBY_VERSION", version);
        runtime2.defineGlobalConstant("RUBY_PATCHLEVEL", patchlevel);
        runtime2.defineGlobalConstant("RUBY_RELEASE_DATE", release);
        runtime2.defineGlobalConstant("RUBY_PLATFORM", platform);
        runtime2.defineGlobalConstant("RUBY_ENGINE", engine);
        IRubyObject description = runtime2.newString(runtime2.getInstanceConfig().getVersionString()).freeze(context);
        runtime2.defineGlobalConstant("RUBY_DESCRIPTION", description);
        IRubyObject copyright = runtime2.newString(runtime2.getInstanceConfig().getCopyrightString()).freeze(context);
        runtime2.defineGlobalConstant("RUBY_COPYRIGHT", copyright);
        runtime2.defineGlobalConstant("VERSION", version);
        runtime2.defineGlobalConstant("RELEASE_DATE", release);
        runtime2.defineGlobalConstant("PLATFORM", platform);
        IRubyObject jrubyVersion = runtime2.newString("1.6.0.RC2").freeze(context);
        IRubyObject jrubyRevision = runtime2.newString(Constants.REVISION).freeze(context);
        runtime2.defineGlobalConstant("JRUBY_VERSION", jrubyVersion);
        runtime2.defineGlobalConstant("JRUBY_REVISION", jrubyRevision);
        if (runtime2.is1_9()) {
            runtime2.defineGlobalConstant("RUBY_REVISION", runtime2.newFixnum(Constants.RUBY1_9_REVISION));
        }
        KCodeGlobalVariable kcodeGV = new KCodeGlobalVariable(runtime2, "$KCODE", runtime2.newString("NONE"));
        runtime2.defineVariable(kcodeGV);
        runtime2.defineVariable(new GlobalVariable.Copy(runtime2, "$-K", kcodeGV));
        IRubyObject defaultRS = runtime2.newString(runtime2.getInstanceConfig().getRecordSeparator()).freeze(context);
        StringGlobalVariable rs = new StringGlobalVariable(runtime2, "$/", defaultRS);
        runtime2.defineVariable(rs);
        runtime2.setRecordSeparatorVar(rs);
        runtime2.getGlobalVariables().setDefaultSeparator(defaultRS);
        runtime2.defineVariable(new StringGlobalVariable(runtime2, "$\\", runtime2.getNil()));
        runtime2.defineVariable(new StringGlobalVariable(runtime2, "$,", runtime2.getNil()));
        runtime2.defineVariable(new LineNumberGlobalVariable(runtime2, "$."));
        runtime2.defineVariable(new LastlineGlobalVariable(runtime2, "$_"));
        runtime2.defineVariable(new LastExitStatusVariable(runtime2, "$?"));
        runtime2.defineVariable(new ErrorInfoGlobalVariable(runtime2, "$!", runtime2.getNil()));
        runtime2.defineVariable(new NonEffectiveGlobalVariable(runtime2, "$=", runtime2.getFalse()));
        if (runtime2.getInstanceConfig().getInputFieldSeparator() == null) {
            runtime2.defineVariable(new GlobalVariable(runtime2, "$;", runtime2.getNil()));
        } else {
            runtime2.defineVariable(new GlobalVariable(runtime2, "$;", RubyRegexp.newRegexp(runtime2, runtime2.getInstanceConfig().getInputFieldSeparator(), new RegexpOptions())));
        }
        Boolean verbose = runtime2.getInstanceConfig().getVerbose();
        IRubyObject verboseValue = null;
        verboseValue = verbose == null ? runtime2.getNil() : (verbose == Boolean.TRUE ? runtime2.getTrue() : runtime2.getFalse());
        runtime2.defineVariable(new VerboseGlobalVariable(runtime2, "$VERBOSE", verboseValue));
        RubyBoolean debug = runtime2.newBoolean(runtime2.getInstanceConfig().isDebug());
        runtime2.defineVariable(new DebugGlobalVariable(runtime2, "$DEBUG", debug));
        runtime2.defineVariable(new DebugGlobalVariable(runtime2, "$-d", debug));
        runtime2.defineVariable(new SafeGlobalVariable(runtime2, "$SAFE"));
        runtime2.defineVariable(new BacktraceGlobalVariable(runtime2, "$@"));
        RubyIO stdin = new RubyIO(runtime2, STDIO.IN);
        RubyIO stdout = new RubyIO(runtime2, STDIO.OUT);
        RubyIO stderr = new RubyIO(runtime2, STDIO.ERR);
        runtime2.defineVariable(new InputGlobalVariable(runtime2, "$stdin", stdin));
        runtime2.defineVariable(new OutputGlobalVariable(runtime2, "$stdout", stdout));
        runtime2.getGlobalVariables().alias("$>", "$stdout");
        runtime2.getGlobalVariables().alias("$defout", "$stdout");
        runtime2.defineVariable(new OutputGlobalVariable(runtime2, "$stderr", stderr));
        runtime2.getGlobalVariables().alias("$deferr", "$stderr");
        runtime2.defineGlobalConstant("STDIN", stdin);
        runtime2.defineGlobalConstant("STDOUT", stdout);
        runtime2.defineGlobalConstant("STDERR", stderr);
        runtime2.defineVariable(new LoadedFeatures(runtime2, "$\""));
        runtime2.defineVariable(new LoadedFeatures(runtime2, "$LOADED_FEATURES"));
        runtime2.defineVariable(new LoadPath(runtime2, "$:"));
        runtime2.defineVariable(new LoadPath(runtime2, "$-I"));
        runtime2.defineVariable(new LoadPath(runtime2, "$LOAD_PATH"));
        runtime2.defineVariable(new MatchMatchGlobalVariable(runtime2, "$&"));
        runtime2.defineVariable(new PreMatchGlobalVariable(runtime2, "$`"));
        runtime2.defineVariable(new PostMatchGlobalVariable(runtime2, "$'"));
        runtime2.defineVariable(new LastMatchGlobalVariable(runtime2, "$+"));
        runtime2.defineVariable(new BackRefGlobalVariable(runtime2, "$~"));
        runtime2.getGlobalVariables().defineReadonly("$$", new PidAccessor(runtime2));
        RubyGlobal.defineGlobalEnvConstants(runtime2);
        if (runtime2.getGlobalVariables().get("$*").isNil()) {
            runtime2.getGlobalVariables().defineReadonly("$*", new ValueAccessor(runtime2.newArray()));
        }
        runtime2.getGlobalVariables().defineReadonly("$-p", new ValueAccessor(runtime2.newBoolean(runtime2.getInstanceConfig().isAssumePrinting())));
        runtime2.getGlobalVariables().defineReadonly("$-a", new ValueAccessor(runtime2.newBoolean(runtime2.getInstanceConfig().isSplit())));
        runtime2.getGlobalVariables().defineReadonly("$-l", new ValueAccessor(runtime2.newBoolean(runtime2.getInstanceConfig().isProcessLineEnds())));
        RubyArgsFile.initArgsFile(runtime2);
    }

    private static void defineGlobalEnvConstants(Ruby runtime2) {
        HashMap environmentVariableMap = null;
        OSEnvironment environment = new OSEnvironment();
        environmentVariableMap = environment.getEnvironmentVariableMap(runtime2);
        if (environmentVariableMap == null) {
            environmentVariableMap = new HashMap();
        }
        CaseInsensitiveStringOnlyRubyHash h1 = new CaseInsensitiveStringOnlyRubyHash(runtime2, environmentVariableMap, runtime2.getNil());
        h1.getSingletonClass().defineAnnotatedMethods(CaseInsensitiveStringOnlyRubyHash.class);
        runtime2.defineGlobalConstant("ENV", h1);
        Map systemProps = environment.getSystemPropertiesMap(runtime2);
        runtime2.defineGlobalConstant("ENV_JAVA", new StringOnlyRubyHash(runtime2, systemProps, runtime2.getNil()));
    }

    private static final class PidAccessor
    implements IAccessor {
        private final Ruby runtime;
        private IRubyObject pid = null;

        public PidAccessor(Ruby runtime2) {
            this.runtime = runtime2;
        }

        public IRubyObject getValue() {
            return this.pid != null ? this.pid : (this.pid = this.runtime.newFixnum(this.runtime.getPosix().getpid()));
        }

        public IRubyObject setValue(IRubyObject newValue) {
            throw this.runtime.newRuntimeError("cannot assign to $$");
        }
    }

    private static class LoadedFeatures
    extends ReadonlyGlobalVariable {
        public LoadedFeatures(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadedFeatures();
        }
    }

    private static class LoadPath
    extends ReadonlyGlobalVariable {
        public LoadPath(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadPath();
        }
    }

    public static class OutputGlobalVariable
    extends GlobalVariable {
        public OutputGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        public IRubyObject set(IRubyObject value2) {
            if (value2 == this.get()) {
                return value2;
            }
            if (value2 instanceof RubyIO) {
                RubyIO io2 = (RubyIO)value2;
                io2.getHandler().setSync(true);
            }
            if (!value2.respondsTo("write")) {
                throw this.runtime.newTypeError(this.name() + " must have write method, " + value2.getType().getName() + " given");
            }
            return super.set(value2);
        }
    }

    public static class InputGlobalVariable
    extends GlobalVariable {
        public InputGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        public IRubyObject set(IRubyObject value2) {
            if (value2 == this.get()) {
                return value2;
            }
            return super.set(value2);
        }
    }

    private static class LastlineGlobalVariable
    extends GlobalVariable {
        public LastlineGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        public IRubyObject get() {
            return RuntimeHelpers.getLastLine(this.runtime, this.runtime.getCurrentContext());
        }

        public IRubyObject set(IRubyObject value2) {
            RuntimeHelpers.setLastLine(this.runtime, this.runtime.getCurrentContext(), value2);
            return value2;
        }
    }

    private static class BacktraceGlobalVariable
    extends GlobalVariable {
        public BacktraceGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        public IRubyObject get() {
            IRubyObject backtrace2;
            IRubyObject errorInfo = this.runtime.getGlobalVariables().get("$!");
            IRubyObject iRubyObject = backtrace2 = errorInfo.isNil() ? this.runtime.getNil() : errorInfo.callMethod(errorInfo.getRuntime().getCurrentContext(), "backtrace");
            if (!(backtrace2 instanceof RubyArray)) {
                backtrace2 = this.runtime.getNil();
            }
            return backtrace2;
        }

        public IRubyObject set(IRubyObject value2) {
            if (this.runtime.getGlobalVariables().get("$!").isNil()) {
                throw this.runtime.newArgumentError("$! not set.");
            }
            this.runtime.getGlobalVariables().get("$!").callMethod(value2.getRuntime().getCurrentContext(), "set_backtrace", value2);
            return value2;
        }
    }

    private static class DebugGlobalVariable
    extends GlobalVariable {
        public DebugGlobalVariable(Ruby runtime2, String name2, IRubyObject initialValue) {
            super(runtime2, name2, initialValue);
            this.set(initialValue);
        }

        public IRubyObject get() {
            return this.runtime.getDebug();
        }

        public IRubyObject set(IRubyObject newValue) {
            if (newValue.isNil()) {
                this.runtime.setDebug(newValue);
            } else {
                this.runtime.setDebug(this.runtime.newBoolean(newValue.isTrue()));
            }
            return newValue;
        }
    }

    private static class VerboseGlobalVariable
    extends GlobalVariable {
        public VerboseGlobalVariable(Ruby runtime2, String name2, IRubyObject initialValue) {
            super(runtime2, name2, initialValue);
            this.set(initialValue);
        }

        public IRubyObject get() {
            return this.runtime.getVerbose();
        }

        public IRubyObject set(IRubyObject newValue) {
            if (newValue.isNil()) {
                this.runtime.setVerbose(newValue);
            } else {
                this.runtime.setVerbose(this.runtime.newBoolean(newValue.isTrue()));
            }
            return newValue;
        }
    }

    private static class SafeGlobalVariable
    extends GlobalVariable {
        public SafeGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        public IRubyObject get() {
            return this.runtime.newFixnum(this.runtime.getSafeLevel());
        }

        public IRubyObject set(IRubyObject value2) {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.SAFE_NOT_SUPPORTED, "SAFE levels are not supported in JRuby", new Object[0]);
            return RubyFixnum.newFixnum(this.runtime, this.runtime.getSafeLevel());
        }
    }

    public static class KCodeGlobalVariable
    extends GlobalVariable {
        public KCodeGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        public IRubyObject get() {
            return this.runtime.getKCode().kcode(this.runtime);
        }

        public IRubyObject set(IRubyObject value2) {
            this.runtime.setKCode(KCode.create(this.runtime, value2.convertToString().toString()));
            return value2;
        }
    }

    public static class StringGlobalVariable
    extends GlobalVariable {
        public StringGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        public IRubyObject set(IRubyObject value2) {
            if (!value2.isNil() && !(value2 instanceof RubyString)) {
                throw this.runtime.newTypeError("value of " + this.name() + " must be a String");
            }
            return super.set(value2);
        }
    }

    private static class ErrorInfoGlobalVariable
    extends GlobalVariable {
        public ErrorInfoGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, null);
            this.set(value2);
        }

        public IRubyObject set(IRubyObject value2) {
            if (!(value2.isNil() || this.runtime.getException().isInstance(value2) || JavaUtil.isJavaObject(value2) && JavaUtil.unwrapJavaObject(value2) instanceof Throwable)) {
                throw this.runtime.newTypeError("assigning non-exception to $!");
            }
            return this.runtime.getCurrentContext().setErrorInfo(value2);
        }

        public IRubyObject get() {
            return this.runtime.getCurrentContext().getErrorInfo();
        }
    }

    private static class LineNumberGlobalVariable
    extends GlobalVariable {
        public LineNumberGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        public IRubyObject set(IRubyObject value2) {
            int line = (int)value2.convertToInteger().getLongValue();
            this.runtime.setCurrentLine(line);
            RubyArgsFile.setCurrentLineNumber(this.runtime.getArgsFile(), line);
            return value2;
        }

        public IRubyObject get() {
            return this.runtime.newFixnum(this.runtime.getCurrentLine());
        }
    }

    private static class BackRefGlobalVariable
    extends GlobalVariable {
        public BackRefGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        public IRubyObject get() {
            return RuntimeHelpers.getBackref(this.runtime, this.runtime.getCurrentContext());
        }

        public IRubyObject set(IRubyObject value2) {
            RuntimeHelpers.setBackref(this.runtime, this.runtime.getCurrentContext(), value2);
            return value2;
        }
    }

    private static class LastMatchGlobalVariable
    extends GlobalVariable {
        public LastMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.match_last(this.runtime.getCurrentContext().getCurrentScope().getBackRef(this.runtime));
        }
    }

    private static class PostMatchGlobalVariable
    extends GlobalVariable {
        public PostMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.match_post(this.runtime.getCurrentContext().getCurrentScope().getBackRef(this.runtime));
        }
    }

    private static class PreMatchGlobalVariable
    extends GlobalVariable {
        public PreMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.match_pre(this.runtime.getCurrentContext().getCurrentScope().getBackRef(this.runtime));
        }
    }

    private static class MatchMatchGlobalVariable
    extends GlobalVariable {
        public MatchMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.last_match(this.runtime.getCurrentContext().getCurrentScope().getBackRef(this.runtime));
        }
    }

    private static class LastExitStatusVariable
    extends GlobalVariable {
        public LastExitStatusVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        public IRubyObject get() {
            IRubyObject lastExitStatus = this.runtime.getCurrentContext().getLastExitStatus();
            return lastExitStatus == null ? this.runtime.getNil() : lastExitStatus;
        }

        public IRubyObject set(IRubyObject lastExitStatus) {
            throw this.runtime.newNameError("$? is a read-only variable", "$?");
        }
    }

    private static class NonEffectiveGlobalVariable
    extends GlobalVariable {
        public NonEffectiveGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        public IRubyObject set(IRubyObject value2) {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective; ignored", this.name);
            return value2;
        }

        public IRubyObject get() {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective", this.name);
            return this.runtime.getFalse();
        }
    }

    public static class StringOnlyRubyHash
    extends RubyHash {
        public StringOnlyRubyHash(Ruby runtime2, Map valueMap, IRubyObject defaultValue) {
            super(runtime2, valueMap, defaultValue);
        }

        public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
            return this.case_aware_op_aref(context, key2, true);
        }

        public RubyHash to_hash() {
            Ruby runtime2 = this.getRuntime();
            RubyHash hash2 = RubyHash.newHash(runtime2);
            hash2.replace(runtime2.getCurrentContext(), this);
            return hash2;
        }

        public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.case_aware_op_aset(context, key2, value2, true);
        }

        public IRubyObject op_aset19(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.op_aset(context, key2, value2);
        }

        protected IRubyObject case_aware_op_aref(ThreadContext context, IRubyObject key2, boolean caseSensitive) {
            if (!caseSensitive) {
                key2 = this.getCorrectKey(key2, context);
            }
            return super.op_aref(context, key2);
        }

        protected IRubyObject case_aware_op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2, boolean caseSensitive) {
            if (!key2.respondsTo("to_str")) {
                throw this.getRuntime().newTypeError("can't convert " + key2.getMetaClass() + " into String");
            }
            if (!value2.respondsTo("to_str") && !value2.isNil()) {
                throw this.getRuntime().newTypeError("can't convert " + value2.getMetaClass() + " into String");
            }
            if (!caseSensitive) {
                key2 = this.getCorrectKey(key2, context);
            }
            if (value2.isNil()) {
                return super.delete(context, key2, Block.NULL_BLOCK);
            }
            return super.op_aset(context, RuntimeHelpers.invoke(context, key2, "to_str"), value2.isNil() ? this.getRuntime().getNil() : RuntimeHelpers.invoke(context, value2, "to_str"));
        }

        private RubyString getCorrectKey(IRubyObject key2, ThreadContext context) {
            RubyString originalKey;
            RubyString actualKey = originalKey = key2.convertToString();
            Ruby runtime2 = context.getRuntime();
            if (Platform.IS_WINDOWS) {
                RubyArray keys2 = super.keys();
                for (int i = 0; i < keys2.size(); ++i) {
                    RubyString candidateKey = keys2.eltInternal(i).convertToString();
                    if (!candidateKey.casecmp(context, originalKey).op_equal(context, RubyFixnum.zero(runtime2)).isTrue()) continue;
                    actualKey = candidateKey;
                    break;
                }
            }
            return actualKey;
        }
    }

    public static class CaseInsensitiveStringOnlyRubyHash
    extends StringOnlyRubyHash {
        public CaseInsensitiveStringOnlyRubyHash(Ruby runtime2, Map valueMap, IRubyObject defaultValue) {
            super(runtime2, valueMap, defaultValue);
        }

        public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
            return this.case_aware_op_aref(context, key2, false);
        }

        public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.case_aware_op_aset(context, key2, value2, false);
        }

        @JRubyMethod
        public IRubyObject to_s() {
            return this.getRuntime().newString("ENV");
        }
    }
}

