/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.SimpleSampler;

public class Main {
    private final RubyInstanceConfig config;

    public Main(RubyInstanceConfig config) {
        this(config, false);
    }

    public Main(final InputStream in, final PrintStream out, final PrintStream err) {
        this(new RubyInstanceConfig(){
            {
                this.setInput(in);
                this.setOutput(out);
                this.setError(err);
            }
        });
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    private Main(RubyInstanceConfig config, boolean hardExit) {
        this.config = config;
        config.setHardExit(hardExit);
    }

    private Main(boolean hardExit) {
        this(new RubyInstanceConfig(), hardExit);
    }

    public static void main(String[] args2) {
        Main.doGCJCheck();
        Main main2 = new Main(true);
        try {
            Status status2 = main2.run(args2);
            if (status2.isExit()) {
                System.exit(status2.getStatus());
            }
        }
        catch (RaiseException rj) {
            System.exit(Main.handleRaiseException(rj));
        }
        catch (Throwable t) {
            System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t));
            while ((t = t.getCause()) != null) {
                System.err.println("Caused by:");
                System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t));
            }
            System.exit(1);
        }
    }

    public Status run(String[] args2) {
        try {
            this.config.processArguments(args2);
            return this.run();
        }
        catch (MainExitException mee) {
            return this.handleMainExit(mee);
        }
        catch (OutOfMemoryError oome) {
            return this.handleOutOfMemory(oome);
        }
        catch (StackOverflowError soe) {
            return this.handleStackOverflow(soe);
        }
        catch (UnsupportedClassVersionError ucve) {
            return this.handleUnsupportedClassVersion(ucve);
        }
        catch (ThreadKill kill2) {
            return new Status();
        }
    }

    @Deprecated
    public Status run() {
        return this.internalRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status internalRun() {
        Ruby runtime2;
        String filename2;
        InputStream in;
        block7: {
            block6: {
                this.doShowVersion();
                this.doShowCopyright();
                if (!this.config.shouldRunInterpreter()) {
                    this.doPrintUsage(false);
                    this.doPrintProperties();
                    return new Status();
                }
                in = this.config.getScriptSource();
                filename2 = this.config.displayedFileName();
                this.doProcessArguments(in);
                runtime2 = Ruby.newInstance(this.config);
                try {
                    this.doSetContextClassLoader(runtime2);
                    if (in != null) break block6;
                    Status status2 = new Status();
                    Object var6_7 = null;
                    runtime2.tearDown();
                    return status2;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    runtime2.tearDown();
                    throw throwable;
                }
            }
            if (this.config.isxFlag() && !this.config.hasShebangLine()) {
                throw new MainExitException(1, "jruby: no Ruby script found in input (LoadError)");
            }
            if (!this.config.isShouldCheckSyntax()) break block7;
            Status status3 = this.doCheckSyntax(runtime2, in, filename2);
            Object var6_8 = null;
            runtime2.tearDown();
            return status3;
        }
        Status status4 = this.doRunFromMain(runtime2, in, filename2);
        Object var6_9 = null;
        runtime2.tearDown();
        return status4;
    }

    private Status handleUnsupportedClassVersion(UnsupportedClassVersionError ucve) {
        this.config.getError().println("Error: Some library (perhaps JRuby) was built with a later JVM version.");
        this.config.getError().println("Please use libraries built with the version you intend to use or an earlier one.");
        if (this.config.isVerbose()) {
            this.config.getError().println("Exception trace follows:");
            ucve.printStackTrace();
        } else {
            this.config.getError().println("Specify -w for full UnsupportedClassVersionError stack trace");
        }
        return new Status(1);
    }

    private Status handleStackOverflow(StackOverflowError soe) {
        System.gc();
        String stackMax = SafePropertyAccessor.getProperty("jruby.stack.max");
        String message2 = "";
        if (stackMax != null) {
            message2 = " of " + stackMax;
        }
        this.config.getError().println("Error: Your application used more stack memory than the safety cap" + message2 + ".");
        this.config.getError().println("Specify -J-Xss####k to increase it (#### = cap size in KB).");
        if (this.config.isVerbose()) {
            this.config.getError().println("Exception trace follows:");
            soe.printStackTrace();
        } else {
            this.config.getError().println("Specify -w for full StackOverflowError stack trace");
        }
        return new Status(1);
    }

    private Status handleOutOfMemory(OutOfMemoryError oome) {
        System.gc();
        String memoryMax = SafePropertyAccessor.getProperty("jruby.memory.max");
        String message2 = "";
        if (memoryMax != null) {
            message2 = " of " + memoryMax;
        }
        this.config.getError().println("Error: Your application used more memory than the safety cap" + message2 + ".");
        this.config.getError().println("Specify -J-Xmx####m to increase it (#### = cap size in MB).");
        if (this.config.isVerbose()) {
            this.config.getError().println("Exception trace follows:");
            oome.printStackTrace();
        } else {
            this.config.getError().println("Specify -w for full OutOfMemoryError stack trace");
        }
        return new Status(1);
    }

    private Status handleMainExit(MainExitException mee) {
        if (!mee.isAborted()) {
            this.config.getOutput().println(mee.getMessage());
            if (mee.isUsageError()) {
                this.doPrintUsage(true);
            }
        }
        return new Status(mee.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Status doRunFromMain(Ruby runtime2, InputStream in, String filename2) {
        long now = -1L;
        try {
            if (this.config.isBenchmarking()) {
                now = System.currentTimeMillis();
            }
            if (this.config.isSamplingEnabled()) {
                SimpleSampler.startSampleThread();
            }
            this.doCheckSecurityManager();
            try {
                runtime2.runFromMain(in, filename2);
                Object var7_5 = null;
                if (this.config.isBenchmarking()) {
                    this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
                }
                if (!this.config.isSamplingEnabled()) return new Status();
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (this.config.isBenchmarking()) {
                    this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
                }
                if (!this.config.isSamplingEnabled()) throw throwable;
                SimpleSampler.report();
                throw throwable;
            }
            SimpleSampler.report();
            return new Status();
        }
        catch (RaiseException rj) {
            return new Status(Main.handleRaiseException(rj));
        }
    }

    private Status doCheckSyntax(Ruby runtime2, InputStream in, String filename2) throws RaiseException {
        int status2 = 0;
        try {
            runtime2.parseFromMain(in, filename2);
            this.config.getOutput().println("Syntax OK for " + filename2);
        }
        catch (RaiseException re) {
            status2 = -1;
            if (re.getException().getMetaClass().getBaseName().equals("SyntaxError")) {
                this.config.getOutput().println("SyntaxError in " + re.getException().message(runtime2.getCurrentContext()));
            }
            throw re;
        }
        if (this.config.getArgv().length > 0) {
            for (String arg2 : this.config.getArgv()) {
                File argFile = new File(arg2);
                if (argFile.exists()) {
                    try {
                        runtime2.parseFromMain(new FileInputStream(argFile), arg2);
                        this.config.getOutput().println("Syntax OK for " + arg2);
                        continue;
                    }
                    catch (FileNotFoundException fnfe) {
                        status2 = -1;
                        this.config.getOutput().println("File not found: " + arg2);
                        continue;
                    }
                    catch (RaiseException re) {
                        status2 = -1;
                        if (re.getException().getMetaClass().getBaseName().equals("SyntaxError")) {
                            this.config.getOutput().println("SyntaxError in " + re.getException().message(runtime2.getCurrentContext()));
                            continue;
                        }
                        throw re;
                    }
                }
                status2 = -1;
                this.config.getOutput().println("File not found: " + arg2);
            }
        }
        return new Status(status2);
    }

    private void doSetContextClassLoader(Ruby runtime2) {
        block2: {
            try {
                Thread.currentThread().setContextClassLoader(runtime2.getJRubyClassLoader());
            }
            catch (SecurityException se) {
                if (!runtime2.getInstanceConfig().isVerbose()) break block2;
                this.config.getError().println("WARNING: Security restrictions disallowed setting context classloader for main thread.");
            }
        }
    }

    private void doProcessArguments(InputStream in) {
        String[] args2 = this.config.parseShebangOptions(in);
        if (args2.length > 0) {
            this.config.processArguments(args2);
        }
    }

    private void doPrintProperties() {
        if (this.config.shouldPrintProperties()) {
            this.config.getOutput().print(this.config.getPropertyHelp());
        }
    }

    private void doPrintUsage(boolean force) {
        if (this.config.shouldPrintUsage() || force) {
            this.config.getOutput().print(this.config.getBasicUsageHelp());
        }
    }

    private void doShowCopyright() {
        if (this.config.isShowCopyright()) {
            this.config.getOutput().println(this.config.getCopyrightString());
        }
    }

    private void doShowVersion() {
        if (this.config.isShowVersion()) {
            this.config.getOutput().println(this.config.getVersionString());
        }
    }

    private static void doGCJCheck() {
        if (Platform.IS_GCJ) {
            System.err.println("Fatal: GCJ (GNU Compiler for Java) is not supported by JRuby.");
            System.exit(1);
        }
    }

    private void doCheckSecurityManager() {
        if (Main.class.getClassLoader() == null && System.getSecurityManager() != null) {
            System.err.println("Warning: security manager and JRuby running from boot classpath.\nRun from jruby.jar or set env VERIFY_JRUBY=true to enable security.");
        }
    }

    private static int handleRaiseException(RaiseException rj) {
        RubyException raisedException = rj.getException();
        Ruby runtime2 = raisedException.getRuntime();
        if (runtime2.getSystemExit().isInstance(raisedException)) {
            IRubyObject status2 = raisedException.callMethod(runtime2.getCurrentContext(), "status");
            if (status2 != null && !status2.isNil()) {
                return RubyNumeric.fix2int(status2);
            }
            return 0;
        }
        System.err.print(RubyInstanceConfig.TRACE_TYPE.printBacktrace(raisedException));
        return 1;
    }

    public static class Status {
        private boolean isExit = false;
        private int status = 0;

        Status(int status2) {
            this.isExit = true;
            this.status = status2;
        }

        Status() {
        }

        public boolean isExit() {
            return this.isExit;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

