/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.InstanceVariable;
import org.jruby.runtime.builtin.IRubyObject;

public class Constant
extends AbstractVariable {
    private static String pattern = "[A-Z]([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";
    private boolean initialized = false;

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            return new Constant(receiver2, name2, javaObject);
        }
        return null;
    }

    private Constant(RubyObject receiver2, String name2, Object ... javaObject) {
        super(receiver2, name2, false, javaObject);
    }

    Constant(IRubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, true, irubyObject);
    }

    void markInitialized() {
        this.initialized = true;
    }

    public static void retrieve(RubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        Constant.updateARGV(receiver2, vars);
        Constant.updateConstantsOfSuperClass(receiver2, vars);
        Constant.updateConstants(receiver2, vars);
        RubyObject topSelf = (RubyObject)receiver2.getRuntime().getTopSelf();
        Constant.updateConstants(topSelf, vars);
    }

    private static void updateARGV(IRubyObject receiver2, BiVariableMap vars) {
        String name2 = "ARGV".intern();
        IRubyObject argv = receiver2.getRuntime().getTopSelf().getMetaClass().fastGetConstant(name2);
        if (argv == null || argv instanceof RubyNil) {
            return;
        }
        if (vars.containsKey(name2)) {
            BiVariable var = vars.getVariable((RubyObject)receiver2.getRuntime().getTopSelf(), name2);
            var.setRubyObject(argv);
        } else {
            Constant var = new Constant(receiver2.getRuntime().getTopSelf(), name2, argv);
            var.markInitialized();
            vars.update(name2, var);
        }
    }

    private static void updateConstantsOfSuperClass(RubyObject receiver2, BiVariableMap vars) {
        Map<String, IRubyObject> map = receiver2.getRuntime().getTopSelf().getMetaClass().getSuperClass().getConstantMap();
        List<BiVariable> variables = vars.getVariables();
        for (BiVariable variable : variables) {
            if (variable.getType() != BiVariable.Type.Constant || !map.containsKey(variable.getName())) continue;
            IRubyObject value2 = map.get(variable.getName());
            variable.setRubyObject(value2);
        }
    }

    private static void updateConstants(RubyObject receiver2, BiVariableMap vars) {
        Collection<String> names2 = receiver2.getMetaClass().getConstantNames();
        for (String name2 : names2) {
            IRubyObject value2 = receiver2.getMetaClass().getConstant(name2);
            BiVariable var = null;
            List<String> savedNames = vars.getNames();
            for (int i = 0; i < savedNames.size(); ++i) {
                if (!name2.equals(savedNames.get(i))) continue;
                var = vars.getVariables().get(i);
                if (receiver2 == var.getReceiver()) {
                    var.setRubyObject(value2);
                    continue;
                }
                var = null;
            }
            if (var != null) continue;
            var = new Constant((IRubyObject)receiver2, name2, value2);
            ((Constant)var).markInitialized();
            vars.update(name2, var);
        }
    }

    public static void retrieveByKey(RubyObject receiver2, BiVariableMap vars, String key2) {
        if ("ARGV".equals(key2)) {
            Constant.updateARGV(receiver2, vars);
            return;
        }
        IRubyObject value2 = null;
        if (receiver2.getMetaClass().getConstantNames().contains(key2)) {
            value2 = receiver2.getMetaClass().getConstant(key2);
        } else if (receiver2.getRuntime().getTopSelf().getMetaClass().getConstantNames().contains(key2)) {
            value2 = receiver2.getRuntime().getTopSelf().getMetaClass().getConstant(key2);
        } else if (receiver2.getRuntime().getTopSelf().getMetaClass().getSuperClass().getConstantNames().contains(key2)) {
            value2 = receiver2.getRuntime().getTopSelf().getMetaClass().getSuperClass().getConstant(key2);
        }
        if (value2 == null) {
            return;
        }
        BiVariable var = vars.getVariable(receiver2, key2);
        if (var != null) {
            var.setRubyObject(value2);
        } else {
            var = new InstanceVariable((IRubyObject)receiver2, key2, value2);
            vars.update(key2, var);
        }
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.Constant;
    }

    public static boolean isValidName(Object name2) {
        return Constant.isValidName(pattern, name2);
    }

    public void inject() {
        if (this.fromRuby) {
            return;
        }
        RubyModule rubyModule = this.getRubyClass(this.receiver.getRuntime());
        if (rubyModule == null) {
            rubyModule = this.receiver.getRuntime().getCurrentContext().getRubyClass();
        }
        if (rubyModule == null) {
            return;
        }
        rubyModule.storeConstant(this.name, this.irubyObject);
        this.receiver.getRuntime().incrementConstantGeneration();
        this.initialized = true;
    }

    public void remove(Ruby runtime2) {
    }
}

