/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.dataflow.DataFlowConstants;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.BindingStorePlacementProblem;
import org.jruby.compiler.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.compiler.ir.instructions.AllocateBindingInstr;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.ClosureReturnInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.StoreToBindingInstr;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;

public class BindingStorePlacementNode
extends FlowGraphNode {
    Set<Variable> _inDirtyVars;
    Set<Variable> _outDirtyVars;
    boolean _inBindingAllocated;
    boolean _outBindingAllocated;

    public BindingStorePlacementNode(DataFlowProblem prob, BasicBlock n) {
        super(prob, n);
    }

    public void init() {
        this._inDirtyVars = new HashSet<Variable>();
        this._outDirtyVars = new HashSet<Variable>();
        if (this._prob.getCFG().getScope() instanceof IRClosure) {
            this._outBindingAllocated = true;
            this._inBindingAllocated = true;
        } else {
            this._outBindingAllocated = false;
            this._inBindingAllocated = false;
        }
    }

    public void buildDataFlowVars(Instr i) {
        BindingStorePlacementProblem bsp = (BindingStorePlacementProblem)this._prob;
        for (Variable v : i.getUsedVariables()) {
            if (!(v instanceof LocalVariable)) continue;
            bsp.recordUsedVar(v);
        }
        Variable v = i.getResult();
        if (v != null && v instanceof LocalVariable) {
            bsp.recordDefVar(v);
        }
    }

    public void initSolnForNode() {
    }

    public void compute_MEET(CFG.CFG_Edge edge, FlowGraphNode pred2) {
        BindingStorePlacementNode n = (BindingStorePlacementNode)pred2;
        this._inDirtyVars.addAll(n._outDirtyVars);
        this._inBindingAllocated = this._inBindingAllocated && n._outBindingAllocated;
    }

    public boolean applyTransferFunction() {
        boolean bindingAllocated = this._inBindingAllocated;
        BindingStorePlacementProblem bsp = (BindingStorePlacementProblem)this._prob;
        HashSet<Variable> dirtyVars = new HashSet<Variable>(this._inDirtyVars);
        for (Instr i : this._bb.getInstrs()) {
            Variable v;
            if (i.operation == Operation.BINDING_LOAD) continue;
            if (i instanceof CallInstr) {
                CallInstr call2 = (CallInstr)i;
                Operand o = call2.getClosureArg();
                if (o != null && o instanceof MetaObject) {
                    bindingAllocated = true;
                    IRClosure cl = (IRClosure)((MetaObject)o).scope;
                    CFG cl_cfg = cl.getCFG();
                    BindingStorePlacementProblem cl_bsp = new BindingStorePlacementProblem();
                    cl_bsp.setup(cl_cfg);
                    cl_bsp.compute_MOP_Solution();
                    cl_cfg.setDataFlowSolution(cl_bsp.getName(), cl_bsp);
                    boolean spillAllVars = call2.canBeEval() || call2.canCaptureCallersBinding();
                    HashSet<Variable> newDirtyVars = new HashSet<Variable>(dirtyVars);
                    for (Variable v2 : dirtyVars) {
                        if (!spillAllVars && !cl_bsp.scopeUsesVariable(v2) && !cl_bsp.scopeDefinesVariable(v2)) continue;
                        newDirtyVars.remove(v2);
                    }
                    dirtyVars = newDirtyVars;
                } else if (call2.requiresBinding()) {
                    dirtyVars.clear();
                    bindingAllocated = true;
                }
            }
            if ((v = i.getResult()) != null && v instanceof LocalVariable) {
                dirtyVars.add(v);
            }
            if (!i.operation.isReturn()) continue;
            dirtyVars.clear();
        }
        CFG cfg = this._prob.getCFG();
        if (this._bb == cfg.getExitBB()) {
            dirtyVars.clear();
        }
        if (((Object)this._outDirtyVars).equals(dirtyVars) && this._outBindingAllocated == bindingAllocated) {
            return false;
        }
        this._outDirtyVars = dirtyVars;
        this._outBindingAllocated = bindingAllocated;
        return true;
    }

    public String toString() {
        return "";
    }

    public void addStoreAndBindingAllocInstructions() {
        BindingStorePlacementProblem bsp = (BindingStorePlacementProblem)this._prob;
        IRExecutionScope s = bsp.getCFG().getScope();
        ListIterator<Instr> instrs = this._bb.getInstrs().listIterator();
        HashSet<Variable> dirtyVars = new HashSet<Variable>(this._inDirtyVars);
        boolean bindingAllocated = this._inBindingAllocated;
        while (instrs.hasNext()) {
            Variable v;
            Instr i = instrs.next();
            if (i.operation == Operation.BINDING_LOAD) continue;
            if (i instanceof CallInstr) {
                CallInstr call2 = (CallInstr)i;
                Operand o = call2.getClosureArg();
                if (o != null && o instanceof MetaObject) {
                    CFG cl_cfg = ((IRClosure)((MetaObject)o).scope).getCFG();
                    BindingStorePlacementProblem cl_bsp = (BindingStorePlacementProblem)cl_cfg.getDataFlowSolution(bsp.getName());
                    instrs.previous();
                    if (!bindingAllocated) {
                        instrs.add(new AllocateBindingInstr(s));
                        bindingAllocated = true;
                    }
                    boolean spillAllVars = call2.canBeEval() || call2.canCaptureCallersBinding();
                    HashSet<Variable> newDirtyVars = new HashSet<Variable>(dirtyVars);
                    for (Variable v2 : dirtyVars) {
                        if (spillAllVars || cl_bsp.scopeUsesVariable(v2)) {
                            instrs.add(new StoreToBindingInstr(s, v2.getName(), v2));
                            newDirtyVars.remove(v2);
                            continue;
                        }
                        if (!cl_bsp.scopeDefinesVariable(v2)) continue;
                        newDirtyVars.remove(v2);
                    }
                    dirtyVars = newDirtyVars;
                    instrs.next();
                    ((BindingStorePlacementProblem)cl_cfg.getDataFlowSolution(bsp.getName())).addStoreAndBindingAllocInstructions();
                } else if (call2.requiresBinding()) {
                    instrs.previous();
                    if (!bindingAllocated) {
                        instrs.add(new AllocateBindingInstr(s));
                        bindingAllocated = true;
                    }
                    for (Variable v3 : dirtyVars) {
                        instrs.add(new StoreToBindingInstr(s, v3.getName(), v3));
                    }
                    instrs.next();
                    dirtyVars.clear();
                }
            } else if (i instanceof ClosureReturnInstr) {
                LiveVariablesProblem lvp = (LiveVariablesProblem)bsp.getCFG().getDataFlowSolution(DataFlowConstants.LVP_NAME);
                dirtyVars.retainAll(lvp.getVarsLiveOnExit());
                instrs.previous();
                for (Variable v4 : dirtyVars) {
                    instrs.add(new StoreToBindingInstr(s, v4.getName(), v4));
                }
                instrs.next();
            }
            if ((v = i.getResult()) == null || !(v instanceof LocalVariable)) continue;
            dirtyVars.add(v);
        }
    }
}

