/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.List;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.IdUtil;

@JRubyClass(name={"Object"}, include={"Kernel"})
public class RubyObject
extends RubyBasicObject {
    public static final ObjectAllocator OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyObject(runtime2, klass);
        }
    };
    public static final ObjectAllocator REIFYING_OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            this.reifyAncestors(klass);
            return klass.allocate();
        }

        public void reifyAncestors(RubyClass klass) {
            if (klass.getAllocator() == this) {
                this.reifyAncestors(klass.getSuperClass().getRealClass());
                klass.reify();
            }
        }
    };
    private static final MethodsCollector methodsCollector = new MethodsCollector(){

        public RubyArray instanceMethods(RubyClass rubyClass, IRubyObject[] args2) {
            return rubyClass.instance_methods(args2);
        }
    };
    private static final MethodsCollector methodsCollector19 = new MethodsCollector(){

        public RubyArray instanceMethods(RubyClass rubyClass, IRubyObject[] args2) {
            return rubyClass.instance_methods19(args2);
        }
    };

    public RubyObject(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    public RubyObject(RubyClass metaClass) {
        super(metaClass);
    }

    protected RubyObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime2, metaClass, useObjectSpace, canBeTainted);
    }

    protected RubyObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace) {
        super(runtime2, metaClass, useObjectSpace);
    }

    public static RubyClass createObjectClass(Ruby runtime2, RubyClass objectClass) {
        objectClass.index = 14;
        objectClass.setReifiedClass(RubyObject.class);
        objectClass.defineAnnotatedMethods(ObjectMethods.class);
        return objectClass;
    }

    public void attachToObjectSpace() {
        this.getRuntime().getObjectSpace().add(this);
    }

    public int getNativeTypeIndex() {
        return 14;
    }

    public static void puts(Object obj) {
        System.out.println(obj.toString());
    }

    public boolean equals(Object other) {
        return other == this || other instanceof IRubyObject && this.callMethod(this.getRuntime().getCurrentContext(), "==", (IRubyObject)other).isTrue();
    }

    public String toString() {
        RubyString rubyString = RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this, "to_s").convertToString();
        return rubyString.getUnicodeValue();
    }

    protected void checkFrozen() {
        this.testFrozen();
    }

    public final void callInit(IRubyObject[] args2, Block block) {
        RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "initialize", args2, block);
    }

    public final void callInit(Block block) {
        RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "initialize", block);
    }

    public final void callInit(IRubyObject arg0, Block block) {
        RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "initialize", arg0, block);
    }

    public final void callInit(IRubyObject arg0, IRubyObject arg1, Block block) {
        RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "initialize", arg0, arg1, block);
    }

    public final void callInit(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "initialize", arg0, arg1, arg2, block);
    }

    @Deprecated
    public final IRubyObject convertToType(RubyClass target, int convertMethodIndex) {
        throw new RuntimeException("Not supported; use the String versions");
    }

    @Deprecated
    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject[] args2, Block block) {
        int line;
        String file2;
        if (block.isGiven()) {
            if (args2.length > 0) {
                throw this.getRuntime().newArgumentError(args2.length, 0);
            }
            return this.yieldUnder(context, mod, block);
        }
        if (args2.length == 0) {
            throw this.getRuntime().newArgumentError("block not supplied");
        }
        if (args2.length > 3) {
            String lastFuncName = context.getFrameName();
            throw this.getRuntime().newArgumentError("wrong number of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        RubyString evalStr = args2[0] instanceof RubyString ? (RubyString)args2[0] : args2[0].convertToString();
        if (args2.length > 1) {
            file2 = args2[1].convertToString().asJavaString();
            line = args2.length > 2 ? (int)(args2[2].convertToInteger().getLongValue() - 1L) : 0;
        } else {
            file2 = "(eval)";
            line = 0;
        }
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    @JRubyMethod(name={"=="}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return super.op_equal_19(context, obj);
    }

    @JRubyMethod(name={"equal?"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject equal_p(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject obj) {
        return this == obj ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return context.getRuntime().newBoolean(RubyObject.equalInternal(context, this, other));
    }

    @JRubyMethod(name={"<=>"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (this == other || this.callMethod(context, "==", other).isTrue()) {
            return RubyFixnum.zero(runtime2);
        }
        return runtime2.getNil();
    }

    protected static DynamicMethod _op_equal(ThreadContext context, RubyClass metaclass) {
        if (metaclass.index >= 38) {
            return metaclass.searchMethod("==");
        }
        return context.runtimeCache.getMethod(context, metaclass, metaclass.index * 2, "==");
    }

    protected static DynamicMethod _eql(ThreadContext context, RubyClass metaclass) {
        if (metaclass.index >= 38) {
            return metaclass.searchMethod("eql?");
        }
        return context.runtimeCache.getMethod(context, metaclass, metaclass.index * 3, "eql?");
    }

    protected static boolean equalInternal(ThreadContext context, IRubyObject a, IRubyObject b) {
        if (a == b) {
            return true;
        }
        if (a instanceof RubySymbol) {
            return false;
        }
        if (a instanceof RubyFixnum && b instanceof RubyFixnum) {
            return ((RubyFixnum)a).fastEqual((RubyFixnum)b);
        }
        if (a instanceof RubyFloat && b instanceof RubyFloat) {
            return ((RubyFloat)a).fastEqual((RubyFloat)b);
        }
        RubyClass metaclass = RuntimeHelpers.metaclass(a);
        return RubyObject._op_equal(context, metaclass).call(context, a, (RubyModule)metaclass, "==", b).isTrue();
    }

    protected static boolean eqlInternal(ThreadContext context, IRubyObject a, IRubyObject b) {
        if (a == b) {
            return true;
        }
        if (a instanceof RubySymbol) {
            return false;
        }
        if (a instanceof RubyNumeric) {
            if (a.getClass() != b.getClass()) {
                return false;
            }
            return RubyObject.equalInternal(context, a, b);
        }
        RubyClass metaclass = RuntimeHelpers.metaclass(a);
        return RubyObject._eql(context, metaclass).call(context, a, (RubyModule)metaclass, "eql?", b).isTrue();
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != original.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("initialize_copy should take same class object");
        }
        return this;
    }

    @JRubyMethod(name={"respond_to?"}, compat=CompatVersion.RUBY1_8)
    public RubyBoolean respond_to_p(IRubyObject mname) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, true));
    }

    @JRubyMethod(name={"respond_to?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject respond_to_p19(IRubyObject mname) {
        String name2 = mname.asJavaString();
        IRubyObject respond = this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, true));
        if (!respond.isTrue()) {
            respond = this.callMethod("respond_to_missing?", mname, this.getRuntime().getFalse());
            respond = this.getRuntime().newBoolean(respond.isTrue());
        }
        return respond;
    }

    @JRubyMethod(name={"respond_to?"}, compat=CompatVersion.RUBY1_8)
    public RubyBoolean respond_to_p(IRubyObject mname, IRubyObject includePrivate) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, !includePrivate.isTrue()));
    }

    @JRubyMethod(name={"respond_to?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject respond_to_p19(IRubyObject mname, IRubyObject includePrivate) {
        String name2 = mname.asJavaString();
        IRubyObject respond = this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, !includePrivate.isTrue()));
        if (!respond.isTrue()) {
            respond = this.callMethod("respond_to_missing?", mname, includePrivate);
            respond = this.getRuntime().newBoolean(respond.isTrue());
        }
        return respond;
    }

    @JRubyMethod(name={"object_id", "__id__"})
    public IRubyObject id() {
        return super.id();
    }

    @JRubyMethod(name={"id"})
    public IRubyObject id_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#id will be deprecated; use Object#object_id", "Object#id", "Object#object_id");
        return this.id();
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(super.hashCode());
    }

    public int hashCode() {
        IRubyObject hashValue = this.callMethod(this.getRuntime().getCurrentContext(), "hash");
        if (hashValue instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return this.nonFixnumHashCode(hashValue);
    }

    private int nonFixnumHashCode(IRubyObject hashValue) {
        Ruby runtime2 = this.getRuntime();
        if (runtime2.is1_9()) {
            RubyInteger integer = hashValue.convertToInteger();
            if (integer instanceof RubyBignum) {
                return integer.getBigIntegerValue().intValue();
            }
            return (int)integer.getLongValue();
        }
        if ((hashValue = hashValue.callMethod(runtime2.getCurrentContext(), "%", RubyFixnum.newFixnum(runtime2, 0x2000000BL))) instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return System.identityHashCode(hashValue);
    }

    @JRubyMethod(name={"class"})
    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    @JRubyMethod(name={"type"})
    public RubyClass type_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#type is deprecated; use Object#class", "Object#type", "Object#class");
        return this.type();
    }

    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        return super.rbClone();
    }

    @JRubyMethod
    public IRubyObject dup() {
        return super.dup();
    }

    @JRubyMethod(name={"display"}, optional=1)
    public IRubyObject display(ThreadContext context, IRubyObject[] args2) {
        IRubyObject port = args2.length == 0 ? context.getRuntime().getGlobalVariables().get("$>") : args2[0];
        port.callMethod(context, "write", this);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"tainted?"})
    public RubyBoolean tainted_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isTaint());
    }

    @JRubyMethod(name={"taint"})
    public IRubyObject taint(ThreadContext context) {
        this.taint(context.getRuntime());
        return this;
    }

    @JRubyMethod(name={"untaint"})
    public IRubyObject untaint(ThreadContext context) {
        context.getRuntime().secure(3);
        if (this.isTaint()) {
            this.testFrozen();
            this.setTaint(false);
        }
        return this;
    }

    @JRubyMethod(name={"freeze"})
    public IRubyObject freeze(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if ((this.flags & 4) == 0 && (runtime2.is1_9() || !this.isImmediate())) {
            if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
                throw runtime2.newSecurityError("Insecure: can't freeze object");
            }
            this.flags |= 4;
        }
        return this;
    }

    @JRubyMethod(name={"frozen?"})
    public RubyBoolean frozen_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isFrozen());
    }

    @JRubyMethod(name={"untrusted?"}, compat=CompatVersion.RUBY1_9)
    public RubyBoolean untrusted_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isUntrusted());
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject untrust(ThreadContext context) {
        if (!this.isUntrusted() && !this.isImmediate()) {
            this.checkFrozen();
            this.flags |= 0x10;
        }
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject trust(ThreadContext context) {
        if (this.isUntrusted() && !this.isImmediate()) {
            this.checkFrozen();
            this.flags &= 0xFFFFFFEF;
        }
        return this;
    }

    static RubyString inspect(ThreadContext context, IRubyObject object) {
        return RubyString.objAsString(context, object.callMethod(context, "inspect"));
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        return super.inspect();
    }

    @JRubyMethod(name={"instance_of?"}, required=1)
    public RubyBoolean instance_of_p(ThreadContext context, IRubyObject type2) {
        if (this.type() == type2) {
            return context.getRuntime().getTrue();
        }
        if (!(type2 instanceof RubyModule)) {
            throw context.getRuntime().newTypeError("class or module required");
        }
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"kind_of?", "is_a?"}, required=1)
    public RubyBoolean kind_of_p(ThreadContext context, IRubyObject type2) {
        if (!(type2 instanceof RubyModule)) {
            throw context.getRuntime().newTypeError("class or module required");
        }
        return context.getRuntime().newBoolean(((RubyModule)type2).isInstance(this));
    }

    @JRubyMethod(name={"methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject methods(ThreadContext context, IRubyObject[] args2) {
        return this.methods(context, args2, false);
    }

    @JRubyMethod(name={"methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject methods19(ThreadContext context, IRubyObject[] args2) {
        return this.methods(context, args2, true);
    }

    public IRubyObject methods(ThreadContext context, IRubyObject[] args2, boolean useSymbols) {
        boolean all = args2.length == 1 ? args2[0].isTrue() : true;
        Ruby runtime2 = this.getRuntime();
        RubyArray methods2 = runtime2.newArray();
        HashSet<String> seen = new HashSet<String>();
        if (this.getMetaClass().isSingleton()) {
            this.getMetaClass().populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, true, useSymbols, false);
            if (all) {
                this.getMetaClass().getSuperClass().populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, true, useSymbols, true);
            }
        } else if (all) {
            this.getMetaClass().populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, true, useSymbols, true);
        }
        return methods2;
    }

    @JRubyMethod(name={"public_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject public_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().public_instance_methods(this.trueIfNoArgument(context, args2));
    }

    @JRubyMethod(name={"public_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject public_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().public_instance_methods19(this.trueIfNoArgument(context, args2));
    }

    @JRubyMethod(name={"protected_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject protected_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().protected_instance_methods(this.trueIfNoArgument(context, args2));
    }

    @JRubyMethod(name={"protected_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject protected_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().protected_instance_methods19(this.trueIfNoArgument(context, args2));
    }

    @JRubyMethod(name={"private_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject private_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().private_instance_methods(this.trueIfNoArgument(context, args2));
    }

    @JRubyMethod(name={"private_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject private_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().private_instance_methods19(this.trueIfNoArgument(context, args2));
    }

    private IRubyObject[] trueIfNoArgument(ThreadContext context, IRubyObject[] args2) {
        IRubyObject[] iRubyObjectArray;
        if (args2.length == 0) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = context.getRuntime().getTrue();
        } else {
            iRubyObjectArray = args2;
        }
        return iRubyObjectArray;
    }

    @JRubyMethod(name={"singleton_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public RubyArray singleton_methods(ThreadContext context, IRubyObject[] args2) {
        return this.singletonMethods(context, args2, methodsCollector);
    }

    @JRubyMethod(name={"singleton_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyArray singleton_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.singletonMethods(context, args2, methodsCollector19);
    }

    public RubyArray singletonMethods(ThreadContext context, IRubyObject[] args2, MethodsCollector collect2) {
        RubyArray singletonMethods;
        boolean all = true;
        if (args2.length == 1) {
            all = args2[0].isTrue();
        }
        if (this.getMetaClass().isSingleton()) {
            IRubyObject[] methodsArgs = new IRubyObject[]{context.getRuntime().getFalse()};
            singletonMethods = collect2.instanceMethods(this.getMetaClass(), methodsArgs);
            if (all) {
                RubyClass superClass = this.getMetaClass().getSuperClass();
                while (superClass.isSingleton() || superClass.isIncluded()) {
                    singletonMethods.concat(collect2.instanceMethods(superClass, methodsArgs));
                    superClass = superClass.getSuperClass();
                }
            }
        } else {
            singletonMethods = context.getRuntime().newEmptyArray();
        }
        return singletonMethods;
    }

    @JRubyMethod(name={"method"}, required=1)
    public IRubyObject method(IRubyObject symbol) {
        return this.getMetaClass().newMethod(this, symbol.asJavaString(), true, null);
    }

    @JRubyMethod(name={"method"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject method19(IRubyObject symbol) {
        return this.getMetaClass().newMethod(this, symbol.asJavaString(), true, null, true);
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.anyToString();
    }

    @JRubyMethod(name={"to_a"}, visibility=Visibility.PUBLIC, compat=CompatVersion.RUBY1_8)
    public RubyArray to_a() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "default 'to_a' will be obsolete", "to_a");
        return this.getRuntime().newArray((IRubyObject)this);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject instance_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), block);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, block);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, block);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, arg2, block);
    }

    @JRubyMethod(optional=3, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject instance_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw context.getRuntime().newArgumentError("block not supplied");
        }
        RubyClass klazz = this.isImmediate() ? context.getRuntime().getDummy() : this.getSingletonClass();
        return this.yieldUnder(context, klazz, args2, block);
    }

    @JRubyMethod(name={"extend"}, required=1, rest=true)
    public IRubyObject extend(IRubyObject[] args2) {
        Ruby runtime2 = this.getRuntime();
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].isModule()) continue;
            throw runtime2.newTypeError(args2[i], runtime2.getModule());
        }
        ThreadContext context = runtime2.getCurrentContext();
        for (int i = args2.length - 1; i >= 0; --i) {
            args2[i].callMethod(context, "extend_object", this);
            args2[i].callMethod(context, "extended", this);
        }
        return this;
    }

    public IRubyObject initialize() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"send", "__send__"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject send(ThreadContext context, Block block) {
        throw context.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod(name={"send", "__send__"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject send(ThreadContext context, IRubyObject arg0, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, block);
    }

    @JRubyMethod(name={"send", "__send__"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, block);
    }

    @JRubyMethod(name={"send", "__send__"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, arg2, block);
    }

    @JRubyMethod(name={"send", "__send__"}, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject send(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject[] newArgs;
        String name2 = args2[0].asJavaString();
        int newArgsLength = args2.length - 1;
        if (newArgsLength == 0) {
            newArgs = IRubyObject.NULL_ARRAY;
        } else {
            newArgs = new IRubyObject[newArgsLength];
            System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
        }
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, newArgs, block);
    }

    @JRubyMethod(name={"send"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject send19(ThreadContext context, Block block) {
        return super.send19(context, block);
    }

    @JRubyMethod(name={"send"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, Block block) {
        return super.send19(context, arg0, block);
    }

    @JRubyMethod(name={"send"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return super.send19(context, arg0, arg1, block);
    }

    @JRubyMethod(name={"send"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return super.send19(context, arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"send"}, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject send19(ThreadContext context, IRubyObject[] args2, Block block) {
        return super.send19(context, args2, block);
    }

    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p(ThreadContext context) {
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"=~"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_match(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"=~"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_match19(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"!~"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_not_match(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().newBoolean(!this.callMethod(context, "=~", arg2).isTrue());
    }

    @JRubyMethod(name={"instance_variable_defined?"}, required=1)
    public IRubyObject instance_variable_defined_p(ThreadContext context, IRubyObject name2) {
        if (this.variableTableContains(this.validateInstanceVariable(name2.asJavaString()))) {
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"instance_variable_get"}, required=1)
    public IRubyObject instance_variable_get(ThreadContext context, IRubyObject name2) {
        Object value2 = this.variableTableFetch(this.validateInstanceVariable(name2.asJavaString()));
        if (value2 != null) {
            return (IRubyObject)value2;
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"instance_variable_set"}, required=2)
    public IRubyObject instance_variable_set(IRubyObject name2, IRubyObject value2) {
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableStore(this.validateInstanceVariable(name2.asJavaString()), value2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject remove_instance_variable(ThreadContext context, IRubyObject name2, Block block) {
        this.ensureInstanceVariablesSettable();
        IRubyObject value2 = (IRubyObject)this.variableTableRemove(this.validateInstanceVariable(name2.asJavaString()));
        if (value2 != null) {
            return value2;
        }
        throw context.getRuntime().newNameError("instance variable " + name2.asJavaString() + " not defined", name2.asJavaString());
    }

    @JRubyMethod(name={"instance_variables"})
    public RubyArray instance_variables(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        List<String> nameList = this.getInstanceVariableNameList();
        RubyArray array = runtime2.newArray(nameList.size());
        for (String name2 : nameList) {
            array.append(runtime2.newString(name2));
        }
        return array;
    }

    @JRubyMethod(name={"instance_variables"}, compat=CompatVersion.RUBY1_9)
    public RubyArray instance_variables19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        List<String> nameList = this.getInstanceVariableNameList();
        RubyArray array = runtime2.newArray(nameList.size());
        for (String name2 : nameList) {
            array.append(runtime2.newSymbol(name2));
        }
        return array;
    }

    protected String validateInstanceVariable(String name2) {
        if (IdUtil.isValidInstanceVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`" + name2 + "' is not allowable as an instance variable name", name2);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        List<String> names2 = this.getInstanceVariableNameList();
        out.writeInt(names2.size());
        for (String name2 : names2) {
            out.writeObject(name2);
            out.writeObject(this.getInstanceVariables().getInstanceVariable(name2));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int ivarCount = in.readInt();
        for (int i = 0; i < ivarCount; ++i) {
            this.setInstanceVariable((String)in.readObject(), (IRubyObject)in.readObject());
        }
    }

    private static abstract class MethodsCollector {
        private MethodsCollector() {
        }

        public abstract RubyArray instanceMethods(RubyClass var1, IRubyObject[] var2);
    }

    public static class ObjectMethods {
        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
        public static IRubyObject initialize(IRubyObject self) {
            return self.getRuntime().getNil();
        }

        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, rest=true, compat=CompatVersion.RUBY1_9)
        public static IRubyObject initialize19(IRubyObject self, IRubyObject[] args2) {
            return self.getRuntime().getNil();
        }
    }

    public static class Data
    extends RubyObject
    implements DataType {
        public Data(Ruby runtime2, RubyClass metaClass, Object data) {
            super(runtime2, metaClass);
            this.dataWrapStruct(data);
        }

        public Data(RubyClass metaClass, Object data) {
            super(metaClass);
            this.dataWrapStruct(data);
        }
    }
}

