/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.SimpleSampler;

public class Main {
    private boolean hasPrintedUsage = false;
    private final RubyInstanceConfig config;

    public Main(RubyInstanceConfig config) {
        this(config, false);
    }

    private Main(RubyInstanceConfig config, boolean hardExit) {
        this.config = config;
        config.setHardExit(hardExit);
    }

    public Main(final InputStream in, final PrintStream out, final PrintStream err) {
        this(new RubyInstanceConfig(){
            {
                this.setInput(in);
                this.setOutput(out);
                this.setError(err);
            }
        });
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    private Main(boolean hardExit) {
        this(new RubyInstanceConfig(), hardExit);
    }

    public static void main(String[] args2) {
        if (Platform.IS_GCJ) {
            System.err.println("Fatal: GCJ (GNU Compiler for Java) is not supported by JRuby.");
            System.exit(1);
        }
        Main main2 = new Main(true);
        try {
            Status status2 = main2.run(args2);
            if (status2.isExit()) {
                System.exit(status2.getStatus());
            }
        }
        catch (RaiseException rj) {
            RubyException raisedException = rj.getException();
            Ruby runtime2 = raisedException.getRuntime();
            if (runtime2.getSystemExit().isInstance(raisedException)) {
                IRubyObject status3 = raisedException.callMethod(runtime2.getCurrentContext(), "status");
                if (status3 != null && !status3.isNil()) {
                    System.exit(RubyNumeric.fix2int(status3));
                }
            } else {
                rj.printStackTrace(System.err);
                System.exit(1);
            }
        }
        catch (Throwable t) {
            System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t));
            while ((t = t.getCause()) != null) {
                System.err.println("Caused by:");
                System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t));
            }
            System.exit(1);
        }
    }

    public Status run(String[] args2) {
        try {
            this.config.processArguments(args2);
            return this.run();
        }
        catch (MainExitException mee) {
            if (!mee.isAborted()) {
                this.config.getOutput().println(mee.getMessage());
                if (mee.isUsageError()) {
                    this.printUsage();
                }
            }
            return new Status(mee.getStatus());
        }
        catch (OutOfMemoryError oome) {
            System.gc();
            String memoryMax = SafePropertyAccessor.getProperty("jruby.memory.max");
            String message2 = "";
            if (memoryMax != null) {
                message2 = " of " + memoryMax;
            }
            this.config.getError().println("Error: Your application used more memory than the safety cap" + message2 + ".");
            this.config.getError().println("Specify -J-Xmx####m to increase it (#### = cap size in MB).");
            if (this.config.isVerbose()) {
                this.config.getError().println("Exception trace follows:");
                oome.printStackTrace();
            } else {
                this.config.getError().println("Specify -w for full OutOfMemoryError stack trace");
            }
            return new Status(1);
        }
        catch (StackOverflowError soe) {
            System.gc();
            String stackMax = SafePropertyAccessor.getProperty("jruby.stack.max");
            String message3 = "";
            if (stackMax != null) {
                message3 = " of " + stackMax;
            }
            this.config.getError().println("Error: Your application used more stack memory than the safety cap" + message3 + ".");
            this.config.getError().println("Specify -J-Xss####k to increase it (#### = cap size in KB).");
            if (this.config.isVerbose()) {
                this.config.getError().println("Exception trace follows:");
                soe.printStackTrace();
            } else {
                this.config.getError().println("Specify -w for full StackOverflowError stack trace");
            }
            return new Status(1);
        }
        catch (UnsupportedClassVersionError ucve) {
            this.config.getError().println("Error: Some library (perhaps JRuby) was built with a later JVM version.");
            this.config.getError().println("Please use libraries built with the version you intend to use or an earlier one.");
            if (this.config.isVerbose()) {
                this.config.getError().println("Exception trace follows:");
                ucve.printStackTrace();
            } else {
                this.config.getError().println("Specify -w for full UnsupportedClassVersionError stack trace");
            }
            return new Status(1);
        }
        catch (ThreadKill kill2) {
            return new Status();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status run() {
        Status status2;
        if (this.config.isShowVersion()) {
            this.showVersion();
        }
        if (this.config.isShowCopyright()) {
            this.showCopyright();
        }
        if (!this.config.shouldRunInterpreter()) {
            if (this.config.shouldPrintUsage()) {
                this.printUsage();
            }
            if (!this.config.shouldPrintProperties()) return new Status();
            this.printProperties();
            return new Status();
        }
        InputStream in = this.config.getScriptSource();
        String filename2 = this.config.displayedFileName();
        String[] args2 = this.parseShebangOptions(in);
        if (args2.length > 0) {
            this.config.processArguments(args2);
        }
        Ruby runtime2 = Ruby.newInstance(this.config);
        try {
            block31: {
                block30: {
                    try {
                        Thread.currentThread().setContextClassLoader(runtime2.getJRubyClassLoader());
                    }
                    catch (SecurityException se) {
                        if (!runtime2.getInstanceConfig().isVerbose()) break block30;
                        this.config.getError().println("WARNING: Security restrictions disallowed setting context classloader for main thread.");
                    }
                }
                if (in != null) {
                    if (this.config.isxFlag() && !this.config.hasShebangLine()) {
                        throw new MainExitException(1, "jruby: no Ruby script found in input (LoadError)");
                    }
                    if (this.config.isShouldCheckSyntax()) {
                        int status3 = 0;
                        try {
                            runtime2.parseFromMain(in, filename2);
                            this.config.getOutput().println("Syntax OK for " + filename2);
                        }
                        catch (RaiseException re) {
                            status3 = -1;
                            if (!re.getException().getMetaClass().getBaseName().equals("SyntaxError")) throw re;
                            this.config.getOutput().println("SyntaxError in " + re.getException().message(runtime2.getCurrentContext()));
                        }
                        if (this.config.getArgv().length > 0) {
                            for (String arg2 : this.config.getArgv()) {
                                File argFile = new File(arg2);
                                if (argFile.exists()) {
                                    try {
                                        runtime2.parseFromMain(new FileInputStream(argFile), arg2);
                                        this.config.getOutput().println("Syntax OK for " + arg2);
                                    }
                                    catch (FileNotFoundException fnfe) {
                                        status3 = -1;
                                        this.config.getOutput().println("File not found: " + arg2);
                                    }
                                    catch (RaiseException re) {
                                        status3 = -1;
                                        if (!re.getException().getMetaClass().getBaseName().equals("SyntaxError")) throw re;
                                        this.config.getOutput().println("SyntaxError in " + re.getException().message(runtime2.getCurrentContext()));
                                    }
                                    continue;
                                }
                                status3 = -1;
                                this.config.getOutput().println("File not found: " + arg2);
                            }
                        }
                        Status status4 = new Status(status3);
                        Object var17_23 = null;
                        runtime2.tearDown();
                        return status4;
                    }
                    long now = -1L;
                    try {
                        if (this.config.isBenchmarking()) {
                            now = System.currentTimeMillis();
                        }
                        if (this.config.isSamplingEnabled()) {
                            SimpleSampler.startSampleThread();
                        }
                        try {
                            runtime2.runFromMain(in, filename2);
                            Object var15_30 = null;
                            if (this.config.isBenchmarking()) {
                                this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
                            }
                            if (!this.config.isSamplingEnabled()) break block31;
                        }
                        catch (Throwable throwable) {
                            Object var15_31 = null;
                            if (this.config.isBenchmarking()) {
                                this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
                            }
                            if (!this.config.isSamplingEnabled()) throw throwable;
                            SimpleSampler.report();
                            throw throwable;
                        }
                        SimpleSampler.report();
                    }
                    catch (RaiseException rj) {
                        RubyException raisedException = rj.getException();
                        if (!runtime2.getSystemExit().isInstance(raisedException)) {
                            runtime2.printError(raisedException);
                            Status status5 = new Status(1);
                            Object var17_26 = null;
                            runtime2.tearDown();
                            return status5;
                        }
                        IRubyObject status6 = raisedException.callMethod(runtime2.getCurrentContext(), "status");
                        if (status6 != null && !status6.isNil()) {
                            Status status7 = new Status(RubyNumeric.fix2int(status6));
                            Object var17_24 = null;
                            runtime2.tearDown();
                            return status7;
                        }
                        Status status8 = new Status(0);
                        Object var17_25 = null;
                        runtime2.tearDown();
                        return status8;
                    }
                }
            }
            status2 = new Status();
        }
        catch (Throwable throwable) {
            Object var17_28 = null;
            runtime2.tearDown();
            throw throwable;
        }
        Object var17_27 = null;
        runtime2.tearDown();
        return status2;
    }

    private void showVersion() {
        this.config.getOutput().println(this.config.getVersionString());
    }

    private void showCopyright() {
        this.config.getOutput().println(this.config.getCopyrightString());
    }

    public void printUsage() {
        if (!this.hasPrintedUsage) {
            this.config.getOutput().print(this.config.getBasicUsageHelp());
            this.hasPrintedUsage = true;
        }
    }

    public void printProperties() {
        this.config.getOutput().print(this.config.getPropertyHelp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String[] parseShebangOptions(InputStream in) {
        String[] result;
        block15: {
            block14: {
                BufferedReader reader = null;
                result = new String[]{};
                if (in == null) {
                    return result;
                }
                in.mark(1024);
                reader = new BufferedReader(new InputStreamReader(in, "iso-8859-1"), 8192);
                String firstLine = reader.readLine();
                if (this.config.isxFlag()) {
                    while (firstLine != null && !this.isShebangLine(firstLine)) {
                        firstLine = reader.readLine();
                    }
                }
                boolean usesEnv = false;
                if (firstLine.length() > 2 && firstLine.charAt(0) == '#' && firstLine.charAt(1) == '!') {
                    int i;
                    String[] options2 = firstLine.substring(2).split("\\s+");
                    for (i = 0; i < options2.length; ++i) {
                        String basename2;
                        if (i == 0 && options2[i].endsWith("/env")) {
                            usesEnv = true;
                            continue;
                        }
                        if (!(usesEnv && options2[i].indexOf(61) > 0 || usesEnv && options2[i].startsWith("-") || (basename2 = new File(options2[i]).getName()).indexOf("ruby") <= 0)) break;
                    }
                    this.config.setHasShebangLine(true);
                    System.arraycopy(options2, i, result, 0, options2.length - i);
                    break block14;
                }
                this.config.setHasShebangLine(false);
            }
            Object var10_10 = null;
            try {
                in.reset();
            }
            catch (IOException ex2) {}
            break block15;
            {
                catch (Exception ex) {
                    Object var10_11 = null;
                    try {
                        in.reset();
                    }
                    catch (IOException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    in.reset();
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    protected boolean isShebangLine(String line) {
        return line.length() > 2 && line.charAt(0) == '#' && line.charAt(1) == '!';
    }

    public static class Status {
        private boolean isExit = false;
        private int status = 0;

        Status(int status2) {
            this.isExit = true;
            this.status = status2;
        }

        Status() {
        }

        public boolean isExit() {
            return this.isExit;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

