/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings;

import org.jcodings.Encoding;
import org.jcodings.exception.InternalException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.util.CaseInsensitiveBytesHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingDB {
    private static String[] builtin = new String[]{"ASCII-8BIT", "ASCII", "Big5", "BIG5", "CP949", "CP949", "Emacs-Mule", "EmacsMule", "EUC-JP", "EUCJP", "EUC-KR", "EUCKR", "EUC-TW", "EUCTW", "GB18030", "GB18030", "GBK", "GBK", "ISO-8859-1", "ISO8859_1", "ISO-8859-2", "ISO8859_2", "ISO-8859-3", "ISO8859_3", "ISO-8859-4", "ISO8859_4", "ISO-8859-5", "ISO8859_5", "ISO-8859-6", "ISO8859_6", "ISO-8859-7", "ISO8859_7", "ISO-8859-8", "ISO8859_8", "ISO-8859-9", "ISO8859_9", "ISO-8859-10", "ISO8859_10", "ISO-8859-11", "ISO8859_11", "ISO-8859-13", "ISO8859_13", "ISO-8859-14", "ISO8859_14", "ISO-8859-15", "ISO8859_15", "ISO-8859-16", "ISO8859_16", "KOI8-R", "KOI8R", "KOI8-U", "KOI8U", "Shift_JIS", "SJIS", "US-ASCII", "USASCII", "UTF-8", "UTF8", "UTF-16BE", "UTF16BE", "UTF-16LE", "UTF16LE", "UTF-32BE", "UTF32BE", "UTF-32LE", "UTF32LE", "Windows-1251", "CP1251", "GB2312", "EUCKR"};
    static Entry ascii;
    static final CaseInsensitiveBytesHash<Entry> encodings;
    static final CaseInsensitiveBytesHash<Entry> aliases;

    static void boot() {
        EncodingDB.declareBuiltins();
        ascii = encodings.get("ASCII-8BIT".getBytes());
        EncodingDB.alias("BINARY", "ASCII-8BIT");
        EncodingDB.replicate("IBM437", "ASCII-8BIT");
        EncodingDB.alias("CP437", "IBM437");
        EncodingDB.replicate("IBM737", "ASCII-8BIT");
        EncodingDB.alias("CP737", "IBM737");
        EncodingDB.replicate("IBM775", "ASCII-8BIT");
        EncodingDB.alias("CP775", "IBM775");
        EncodingDB.replicate("CP850", "ASCII-8BIT");
        EncodingDB.alias("IBM850", "CP850");
        EncodingDB.replicate("IBM852", "ASCII-8BIT");
        EncodingDB.replicate("CP852", "IBM852");
        EncodingDB.replicate("IBM855", "ASCII-8BIT");
        EncodingDB.replicate("CP855", "IBM855");
        EncodingDB.replicate("IBM857", "ASCII-8BIT");
        EncodingDB.alias("CP857", "IBM857");
        EncodingDB.replicate("IBM860", "ASCII-8BIT");
        EncodingDB.alias("CP860", "IBM860");
        EncodingDB.replicate("IBM861", "ASCII-8BIT");
        EncodingDB.alias("CP861", "IBM861");
        EncodingDB.replicate("IBM862", "ASCII-8BIT");
        EncodingDB.alias("CP862", "IBM862");
        EncodingDB.replicate("IBM863", "ASCII-8BIT");
        EncodingDB.alias("CP863", "IBM863");
        EncodingDB.replicate("IBM864", "ASCII-8BIT");
        EncodingDB.alias("CP864", "IBM864");
        EncodingDB.replicate("IBM865", "ASCII-8BIT");
        EncodingDB.alias("CP865", "IBM865");
        EncodingDB.replicate("IBM866", "ASCII-8BIT");
        EncodingDB.alias("CP866", "IBM866");
        EncodingDB.replicate("IBM869", "ASCII-8BIT");
        EncodingDB.alias("CP869", "IBM869");
        EncodingDB.replicate("Windows-1258", "ASCII-8BIT");
        EncodingDB.alias("CP1258", "Windows-1258");
        EncodingDB.replicate("GB1988", "ASCII-8BIT");
        EncodingDB.replicate("macCentEuro", "ASCII-8BIT");
        EncodingDB.replicate("macCroatian", "ASCII-8BIT");
        EncodingDB.replicate("macCyrillic", "ASCII-8BIT");
        EncodingDB.replicate("macGreek", "ASCII-8BIT");
        EncodingDB.replicate("macIceland", "ASCII-8BIT");
        EncodingDB.replicate("macRoman", "ASCII-8BIT");
        EncodingDB.replicate("macRomania", "ASCII-8BIT");
        EncodingDB.replicate("macThai", "ASCII-8BIT");
        EncodingDB.replicate("macTurkish", "ASCII-8BIT");
        EncodingDB.replicate("macUkraine", "ASCII-8BIT");
        EncodingDB.alias("CP950", "BIG5");
        EncodingDB.replicate("stateless-ISO-2022-JP", "Emacs-Mule");
        EncodingDB.alias("eucJP", "EUC-JP");
        EncodingDB.replicate("eucJP-ms", "EUC-JP");
        EncodingDB.alias("euc-jp-ms", "eucJP-ms");
        EncodingDB.replicate("CP51932", "EUC-JP");
        EncodingDB.alias("eucKR", "EUC-KR");
        EncodingDB.alias("eucTW", "EUC-TW");
        EncodingDB.alias("EUC-CN", "GB2312");
        EncodingDB.alias("eucCN", "GB2312");
        EncodingDB.replicate("GB12345", "GB2312");
        EncodingDB.alias("CP936", "GBK");
        EncodingDB.dummy("ISO-2022-JP");
        EncodingDB.alias("ISO2022-JP", "ISO-2022-JP");
        EncodingDB.replicate("ISO-2022-JP-2", "ISO-2022-JP");
        EncodingDB.alias("ISO2022-JP2", "ISO-2022-JP-2");
        EncodingDB.alias("ISO8859-1", "ISO-8859-1");
        EncodingDB.replicate("Windows-1252", "ISO-8859-1");
        EncodingDB.alias("CP1252", "Windows-1252");
        EncodingDB.alias("ISO8859-2", "ISO-8859-2");
        EncodingDB.replicate("Windows-1250", "ISO-8859-2");
        EncodingDB.alias("CP1250", "Windows-1250");
        EncodingDB.alias("ISO8859-3", "ISO-8859-3");
        EncodingDB.alias("ISO8859-4", "ISO-8859-4");
        EncodingDB.alias("ISO8859-5", "ISO-8859-5");
        EncodingDB.alias("ISO8859-6", "ISO-8859-6");
        EncodingDB.replicate("Windows-1256", "ISO-8859-6");
        EncodingDB.alias("CP1256", "Windows-1256");
        EncodingDB.alias("ISO8859-7", "ISO-8859-7");
        EncodingDB.replicate("Windows-1253", "ISO-8859-7");
        EncodingDB.alias("CP1253", "Windows-1253");
        EncodingDB.alias("ISO8859-8", "ISO-8859-8");
        EncodingDB.replicate("Windows-1255", "ISO-8859-8");
        EncodingDB.alias("CP1255", "Windows-1255");
        EncodingDB.alias("ISO8859-9", "ISO-8859-9");
        EncodingDB.replicate("Windows-1254", "ISO-8859-9");
        EncodingDB.alias("CP1254", "Windows-1254");
        EncodingDB.alias("ISO8859-10", "ISO-8859-10");
        EncodingDB.alias("ISO8859-11", "ISO-8859-11");
        EncodingDB.replicate("TIS-620", "ISO-8859-11");
        EncodingDB.replicate("Windows-874", "ISO-8859-11");
        EncodingDB.alias("CP874", "Windows-874");
        EncodingDB.alias("ISO8859-13", "ISO-8859-13");
        EncodingDB.replicate("Windows-1257", "ISO-8859-13");
        EncodingDB.alias("CP1257", "Windows-1257");
        EncodingDB.alias("ISO8859-14", "ISO-8859-14");
        EncodingDB.alias("ISO8859-15", "ISO-8859-15");
        EncodingDB.alias("ISO8859-16", "ISO-8859-16");
        EncodingDB.alias("CP878", "KOI8-R");
        EncodingDB.alias("SJIS", "Shift_JIS");
        EncodingDB.replicate("Windows-31J", "Shift_JIS");
        EncodingDB.alias("CP932", "Windows-31J");
        EncodingDB.alias("csWindows31J", "Windows-31J");
        EncodingDB.replicate("MacJapanese", "Shift_JIS");
        EncodingDB.alias("MacJapan", "MacJapanese");
        EncodingDB.alias("ASCII", "US-ASCII");
        EncodingDB.alias("ANSI_X3.4-1968", "US-ASCII");
        EncodingDB.alias("646", "US-ASCII");
        EncodingDB.dummy("UTF-7");
        EncodingDB.alias("CP65000", "UTF-7");
        EncodingDB.alias("CP65001", "UTF-8");
        EncodingDB.replicate("UTF8-MAC", "UTF-8");
        EncodingDB.alias("UTF-8-MAC", "UTF8-MAC");
        EncodingDB.alias("UCS-2BE", "UTF-16BE");
        EncodingDB.alias("UCS-4BE", "UTF-32BE");
        EncodingDB.alias("UCS-4LE", "UTF-32LE");
        EncodingDB.alias("CP1251", "Windows-1251");
    }

    public static final CaseInsensitiveBytesHash<Entry> getEncodings() {
        return encodings;
    }

    public static final CaseInsensitiveBytesHash<Entry> getAliases() {
        return aliases;
    }

    public static void declare(String name2, String encodingClass) {
        byte[] bytes2 = name2.getBytes();
        if (encodings.get(bytes2) != null) {
            throw new InternalException("encoding already registerd <%n>", name2);
        }
        encodings.putDirect(bytes2, new Entry(encodingClass));
    }

    public static void alias(String alias2, String original) {
        byte[] origBytes = original.getBytes();
        Entry originalEntry = encodings.get(origBytes);
        if (originalEntry == null) {
            throw new InternalException("no such encoding <%n>", original);
        }
        byte[] aliasBytes = alias2.getBytes();
        if (aliases.get(aliasBytes) != null) {
            throw new InternalException("encoding alias already registerd <%n>", alias2);
        }
        aliases.putDirect(aliasBytes, originalEntry);
    }

    public static void replicate(String replica, String original) {
        byte[] origBytes = original.getBytes();
        Entry originalEntry = encodings.get(origBytes);
        if (originalEntry == null) {
            throw new InternalException("no such encoding <%n>", original);
        }
        byte[] replicaBytes = replica.getBytes();
        if (encodings.get(replicaBytes) != null) {
            throw new InternalException("encoding replica already registerd <%n>", replica);
        }
        encodings.putDirect(replicaBytes, new Entry(replicaBytes, originalEntry));
    }

    public static void dummy(String name2) {
        byte[] bytes2 = name2.getBytes();
        if (encodings.get(bytes2) != null) {
            throw new InternalException("encoding already registerd <%n>", name2);
        }
        encodings.putDirect(bytes2, new Entry(bytes2));
    }

    static void declareBuiltins() {
        for (int i = 0; i < builtin.length / 2; ++i) {
            EncodingDB.declare(builtin[i << 1], builtin[(i << 1) + 1]);
        }
        builtin = null;
    }

    static {
        encodings = new CaseInsensitiveBytesHash(builtin.length);
        aliases = new CaseInsensitiveBytesHash(builtin.length);
        EncodingDB.boot();
    }

    public static final class Entry {
        private static int count;
        private final Entry base;
        private Encoding encoding;
        private final String encodingClass;
        private final int index;
        private final boolean isDummy;
        private final byte[] name;

        private Entry(byte[] name2, String encodingClass, Entry base, boolean isDummy) {
            this.name = name2;
            this.encodingClass = encodingClass;
            this.base = base;
            this.isDummy = isDummy;
            this.index = count++;
        }

        Entry(String encodingClass) {
            this(null, encodingClass, null, false);
        }

        Entry(byte[] name2, Entry base) {
            this(name2, base.encodingClass, base, false);
        }

        Entry(byte[] name2) {
            this(name2, EncodingDB.ascii.encodingClass, ascii, true);
        }

        public int hashCode() {
            return this.encodingClass.hashCode();
        }

        public Entry getBase() {
            return this.base;
        }

        public Encoding getEncoding() {
            if (this.encoding == null) {
                this.encoding = this.name == null ? Encoding.load(this.encodingClass) : (this.isDummy ? ASCIIEncoding.DUMMY.replicate(this.name) : Encoding.load(this.encodingClass).replicate(this.name));
            }
            return this.encoding;
        }

        public String getEncodingClass() {
            return this.encodingClass;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isDummy() {
            return this.isDummy;
        }
    }
}

