/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.List;
import org.jruby.util.io.SelectorFactory;

public class SelectorPool {
    private final List<SoftReference<Selector>> pool = new ArrayList<SoftReference<Selector>>();
    private final ReferenceQueue queue = new ReferenceQueue();

    public synchronized Selector get() throws IOException {
        return this.retrieveFromPool();
    }

    public synchronized void put(Selector selector) {
        this.returnToPool(selector);
    }

    private Selector retrieveFromPool() throws IOException {
        this.clean();
        Selector selector = null;
        while (!this.pool.isEmpty() && selector == null) {
            Reference ref = this.pool.remove(this.pool.size() - 1);
            selector = (Selector)ref.get();
        }
        if (selector != null) {
            return selector;
        }
        return SelectorFactory.openWithRetryFrom(null, SelectorProvider.provider());
    }

    private void returnToPool(Selector selector) {
        this.clean();
        this.pool.add(new SoftReference<Selector>(selector, this.queue));
    }

    private void clean() {
        Reference ref;
        while ((ref = this.queue.poll()) != null) {
            this.pool.remove((SoftReference)ref);
        }
    }
}

