/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.util.ObjectProxyCache;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.WeakIdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSupport {
    private static final Map<String, Class> PRIMITIVE_CLASSES = new HashMap<String, Class>();
    private final Ruby runtime;
    private final ObjectProxyCache<IRubyObject, RubyClass> objectProxyCache = new ObjectProxyCache<IRubyObject, RubyClass>(ObjectProxyCache.ReferenceType.WEAK){

        @Override
        public IRubyObject allocateProxy(Object javaObject, RubyClass clazz) {
            return Java.allocateProxy(javaObject, clazz);
        }
    };
    private boolean active;
    private final ConcurrentHashMap<Class, JavaClass> javaClassCache = new ConcurrentHashMap(128);
    private final Map matchCache = Collections.synchronizedMap(new HashMap(128));
    private Callback concreteProxyCallback;
    private RubyModule javaModule;
    private RubyModule javaUtilitiesModule;
    private RubyModule javaArrayUtilitiesModule;
    private RubyClass javaObjectClass;
    private JavaClass objectJavaClass;
    private RubyClass javaClassClass;
    private RubyClass javaArrayClass;
    private RubyClass javaProxyClass;
    private RubyClass javaFieldClass;
    private RubyClass javaMethodClass;
    private RubyClass javaConstructorClass;
    private RubyModule javaInterfaceTemplate;
    private RubyModule packageModuleTemplate;
    private RubyClass arrayProxyClass;
    private RubyClass concreteProxyClass;
    private final Map<String, JavaClass> nameClassMap = new HashMap<String, JavaClass>();
    private final Map<Object, Object[]> javaObjectVariables = new WeakIdentityHashMap();

    public static Class getPrimitiveClass(String primitiveType) {
        return PRIMITIVE_CLASSES.get(primitiveType);
    }

    public JavaSupport(Ruby ruby2) {
        this.runtime = ruby2;
    }

    final Map getMatchCache() {
        return this.matchCache;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private Class loadJavaClass(String className) throws ClassNotFoundException {
        Class primitiveClass = PRIMITIVE_CLASSES.get(className);
        if (primitiveClass == null) {
            if (!Ruby.isSecurityRestricted()) {
                return Class.forName(className, false, this.runtime.getJRubyClassLoader());
            }
            return Class.forName(className, false, Ruby.getClassLoader());
        }
        return primitiveClass;
    }

    public Class loadJavaClassVerbose(String className) {
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException cnfExcptn) {
            throw this.runtime.newNameError("cannot load Java class " + className, className, cnfExcptn);
        }
        catch (ExceptionInInitializerError eiie) {
            throw this.runtime.newNameError("cannot initialize Java class " + className, className, eiie);
        }
        catch (LinkageError le) {
            throw this.runtime.newNameError("cannot link Java class " + className + ", probable missing dependency: " + le.getLocalizedMessage(), className, le);
        }
        catch (SecurityException se) {
            throw this.runtime.newNameError("security exception loading Java class " + className, className, se);
        }
    }

    public Class loadJavaClassQuiet(String className) {
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException cnfExcptn) {
            throw this.runtime.newNameError("cannot load Java class " + className, className, cnfExcptn, false);
        }
        catch (ExceptionInInitializerError eiie) {
            throw this.runtime.newNameError("cannot initialize Java class " + className, className, eiie, false);
        }
        catch (LinkageError le) {
            throw this.runtime.newNameError("cannot link Java class " + className, className, le, false);
        }
        catch (SecurityException se) {
            throw this.runtime.newNameError("security: cannot load Java class " + className, className, se, false);
        }
    }

    public JavaClass getJavaClassFromCache(Class clazz) {
        return this.javaClassCache.get(clazz);
    }

    public void putJavaClassIntoCache(JavaClass clazz) {
        this.javaClassCache.put(clazz.javaClass(), clazz);
    }

    public void handleNativeException(Throwable exception2, Member target) {
        if (exception2 instanceof RaiseException) {
            throw (RaiseException)exception2;
        }
        throw this.createRaiseException(exception2, target);
    }

    private RaiseException createRaiseException(Throwable exception2, Member target) {
        RaiseException re = RaiseException.createNativeRaiseException(this.runtime, exception2, target);
        return re;
    }

    public ObjectProxyCache<IRubyObject, RubyClass> getObjectProxyCache() {
        return this.objectProxyCache;
    }

    public Map<String, JavaClass> getNameClassMap() {
        return this.nameClassMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaObjectVariable(Object o, int i, Object v) {
        Map<Object, Object[]> map = this.javaObjectVariables;
        synchronized (map) {
            Object[] vars = this.javaObjectVariables.get(o);
            if (vars == null) {
                vars = new Object[i + 1];
                this.javaObjectVariables.put(o, vars);
            } else if (vars.length <= i) {
                Object[] newVars = new Object[i + 1];
                System.arraycopy(vars, 0, newVars, 0, vars.length);
                this.javaObjectVariables.put(o, newVars);
                vars = newVars;
            }
            vars[i] = v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getJavaObjectVariable(Object o, int i) {
        if (i == -1) {
            return null;
        }
        Map<Object, Object[]> map = this.javaObjectVariables;
        synchronized (map) {
            Object[] vars = this.javaObjectVariables.get(o);
            if (vars == null || vars.length <= i) {
                return null;
            }
            return vars[i];
        }
    }

    public RubyModule getJavaModule() {
        RubyModule module = this.javaModule;
        if (module != null) {
            return module;
        }
        this.javaModule = this.runtime.fastGetModule("Java");
        return this.javaModule;
    }

    public RubyModule getJavaUtilitiesModule() {
        RubyModule module = this.javaUtilitiesModule;
        if (module != null) {
            return module;
        }
        this.javaUtilitiesModule = this.runtime.fastGetModule("JavaUtilities");
        return this.javaUtilitiesModule;
    }

    public RubyModule getJavaArrayUtilitiesModule() {
        RubyModule module = this.javaArrayUtilitiesModule;
        if (module != null) {
            return module;
        }
        this.javaArrayUtilitiesModule = this.runtime.fastGetModule("JavaArrayUtilities");
        return this.javaArrayUtilitiesModule;
    }

    public RubyClass getJavaObjectClass() {
        RubyClass clazz = this.javaObjectClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaObjectClass = this.getJavaModule().fastGetClass("JavaObject");
        return this.javaObjectClass;
    }

    public JavaClass getObjectJavaClass() {
        return this.objectJavaClass;
    }

    public void setObjectJavaClass(JavaClass objectJavaClass) {
        this.objectJavaClass = objectJavaClass;
    }

    public RubyClass getJavaArrayClass() {
        RubyClass clazz = this.javaArrayClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaArrayClass = this.getJavaModule().fastGetClass("JavaArray");
        return this.javaArrayClass;
    }

    public RubyClass getJavaClassClass() {
        RubyClass clazz = this.javaClassClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaClassClass = this.getJavaModule().fastGetClass("JavaClass");
        return this.javaClassClass;
    }

    public RubyModule getJavaInterfaceTemplate() {
        RubyModule module = this.javaInterfaceTemplate;
        if (module != null) {
            return module;
        }
        this.javaInterfaceTemplate = this.runtime.fastGetModule("JavaInterfaceTemplate");
        return this.javaInterfaceTemplate;
    }

    public RubyModule getPackageModuleTemplate() {
        RubyModule module = this.packageModuleTemplate;
        if (module != null) {
            return module;
        }
        this.packageModuleTemplate = this.runtime.fastGetModule("JavaPackageModuleTemplate");
        return this.packageModuleTemplate;
    }

    public RubyClass getJavaProxyClass() {
        RubyClass clazz = this.javaProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaProxyClass = this.runtime.fastGetClass("JavaProxy");
        return this.javaProxyClass;
    }

    public RubyClass getConcreteProxyClass() {
        RubyClass clazz = this.concreteProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.concreteProxyClass = this.runtime.fastGetClass("ConcreteJavaProxy");
        return this.concreteProxyClass;
    }

    public RubyClass getArrayProxyClass() {
        RubyClass clazz = this.arrayProxyClass;
        if (clazz != null) {
            return clazz;
        }
        this.arrayProxyClass = this.runtime.fastGetClass("ArrayJavaProxy");
        return this.arrayProxyClass;
    }

    public RubyClass getJavaFieldClass() {
        RubyClass clazz = this.javaFieldClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaFieldClass = this.getJavaModule().fastGetClass("JavaField");
        return this.javaFieldClass;
    }

    public RubyClass getJavaMethodClass() {
        RubyClass clazz = this.javaMethodClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaMethodClass = this.getJavaModule().fastGetClass("JavaMethod");
        return this.javaMethodClass;
    }

    public RubyClass getJavaConstructorClass() {
        RubyClass clazz = this.javaConstructorClass;
        if (clazz != null) {
            return clazz;
        }
        this.javaConstructorClass = this.getJavaModule().fastGetClass("JavaConstructor");
        return this.javaConstructorClass;
    }

    static {
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
    }
}

