/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Iterator;
import org.jruby.IncludedModuleWrapper;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyGC;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.func.Function1;

@JRubyModule(name={"ObjectSpace"})
public class RubyObjectSpace {
    public static RubyModule createObjectSpaceModule(Ruby runtime2) {
        RubyModule objectSpaceModule = runtime2.defineModule("ObjectSpace");
        runtime2.setObjectSpaceModule(objectSpaceModule);
        objectSpaceModule.defineAnnotatedMethods(RubyObjectSpace.class);
        return objectSpaceModule;
    }

    @JRubyMethod(name={"define_finalizer"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject define_finalizer(IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        IRubyObject finalizer = null;
        if (args2.length == 2) {
            finalizer = args2[1];
            if (!finalizer.respondsTo("call")) {
                throw runtime2.newArgumentError("wrong type argument " + finalizer.getType() + " (should be callable)");
            }
        } else {
            finalizer = runtime2.newProc(Block.Type.PROC, block);
        }
        IRubyObject obj = args2[0];
        runtime2.getObjectSpace().addFinalizer(obj, finalizer);
        return runtime2.newArray((IRubyObject)runtime2.newFixnum(runtime2.getSafeLevel()), finalizer);
    }

    @JRubyMethod(name={"undefine_finalizer"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject undefine_finalizer(IRubyObject recv2, IRubyObject arg1, Block block) {
        recv2.getRuntime().getObjectSpace().removeFinalizers(RubyNumeric.fix2long(arg1.id()));
        return recv2;
    }

    @JRubyMethod(name={"_id2ref"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject id2ref(IRubyObject recv2, IRubyObject id2) {
        Ruby runtime2 = id2.getRuntime();
        if (!(id2 instanceof RubyFixnum)) {
            throw recv2.getRuntime().newTypeError(id2, recv2.getRuntime().getFixnum());
        }
        RubyFixnum idFixnum = (RubyFixnum)id2;
        long longId = idFixnum.getLongValue();
        if (longId == 0L) {
            return runtime2.getFalse();
        }
        if (longId == 2L) {
            return runtime2.getTrue();
        }
        if (longId == 4L) {
            return runtime2.getNil();
        }
        if (longId % 2L != 0L) {
            return runtime2.newFixnum((longId - 1L) / 2L);
        }
        if (runtime2.isObjectSpaceEnabled()) {
            IRubyObject object = runtime2.getObjectSpace().id2ref(longId);
            if (object == null) {
                return runtime2.getNil();
            }
            return object;
        }
        runtime2.getWarnings().warn("ObjectSpace is disabled; _id2ref only supports immediates, pass -X+O to enable");
        return runtime2.getNil();
    }

    public static IRubyObject each_object(final ThreadContext context, IRubyObject recv2, IRubyObject[] args2, final Block block) {
        RubyModule tmpClass;
        if (args2.length == 0) {
            tmpClass = recv2.getRuntime().getObject();
        } else {
            if (!(args2[0] instanceof RubyModule)) {
                throw recv2.getRuntime().newTypeError("class or module required");
            }
            tmpClass = (RubyModule)args2[0];
        }
        final RubyClass rubyClass = tmpClass;
        Ruby runtime2 = recv2.getRuntime();
        final int[] count2 = new int[]{0};
        if (rubyClass == runtime2.getClassClass() || rubyClass == runtime2.getModule()) {
            runtime2.eachModule(new Function1<Object, IRubyObject>(){

                @Override
                public Object apply(IRubyObject arg1) {
                    if (!(!rubyClass.isInstance(arg1) || arg1 instanceof IncludedModuleWrapper || arg1 instanceof RubyClass && ((RubyClass)arg1).isSingleton())) {
                        count2[0] = count2[0] + 1;
                        block.yield(context, arg1);
                    }
                    return null;
                }
            });
        } else {
            if (!runtime2.isObjectSpaceEnabled()) {
                throw runtime2.newRuntimeError("ObjectSpace is disabled; each_object will only work with Class, pass -X+O to enable");
            }
            Iterator iter = recv2.getRuntime().getObjectSpace().iterator(rubyClass);
            IRubyObject obj = null;
            while ((obj = (IRubyObject)iter.next()) != null) {
                count2[0] = count2[0] + 1;
                block.yield(context, obj);
            }
        }
        return recv2.getRuntime().newFixnum(count2[0]);
    }

    @JRubyMethod(name={"each_object"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject each_object19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyObjectSpace.each_object(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "each_object", args2);
    }

    @JRubyMethod(name={"garbage_collect"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject garbage_collect(ThreadContext context, IRubyObject recv2) {
        return RubyGC.start(context, recv2);
    }
}

