/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;

public abstract class PageManager {
    public static final int PROT_EXEC = 4;
    public static final int PROT_READ = 1;
    public static final int PROT_WRITE = 2;

    public static final PageManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public final long pageSize() {
        return Foreign.getInstance().pageSize();
    }

    public abstract long allocatePages(int var1, int var2);

    public abstract void freePages(long var1, int var3);

    public abstract void protectPages(long var1, int var3, int var4);

    static final class Windows
    extends PageManager {
        public long allocatePages(int npages, int protection) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void freePages(long address2, int npages) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void protectPages(long address2, int npages, int protection) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static final class Unix
    extends PageManager {
        Unix() {
        }

        public long allocatePages(int npages, int protection) {
            long sz = (long)npages * this.pageSize();
            return Foreign.getInstance().mmap(0L, sz, protection, 258, -1, 0L);
        }

        public void freePages(long address2, int npages) {
            Foreign.getInstance().munmap(address2, (long)npages * this.pageSize());
        }

        public void protectPages(long address2, int npages, int protection) {
            Foreign.getInstance().mprotect(address2, (long)npages * this.pageSize(), protection);
        }
    }

    private static final class SingletonHolder {
        public static final PageManager INSTANCE = Platform.getPlatform().getOS() == Platform.OS.WINDOWS ? new Windows() : new Unix();

        private SingletonHolder() {
        }
    }
}

