/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.IR_Loop;
import org.jruby.compiler.ir.IR_Method;
import org.jruby.compiler.ir.IR_Module;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.compiler_pass.CompilerPass;
import org.jruby.compiler.ir.instructions.DEFINE_CLASS_METHOD_Instr;
import org.jruby.compiler.ir.instructions.DEFINE_INSTANCE_METHOD_Instr;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.instructions.PUT_CONST_Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.CFG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IR_ScopeImpl
implements IR_Scope {
    Operand _parent;
    List<IR_Instr> _instrs;
    private Map<String, Operand> _constMap;
    private Map<String, Integer> _nextVarIndex;
    private Stack<IR_Loop> _loopStack;
    private CFG _cfg;
    private int _nextMethodIndex;
    public final List<IR_Module> _modules = new ArrayList<IR_Module>();
    public final List<IR_Class> _classes = new ArrayList<IR_Class>();
    public final List<IR_Method> _methods = new ArrayList<IR_Method>();

    private void init(Operand parent, IR_Scope lexicalParent) {
        this._parent = parent;
        this._instrs = new ArrayList<IR_Instr>();
        this._nextVarIndex = new HashMap<String, Integer>();
        this._constMap = new HashMap<String, Operand>();
        this._loopStack = new Stack();
        this._nextMethodIndex = 0;
    }

    public IR_ScopeImpl(IR_Scope parent, IR_Scope lexicalParent) {
        this.init(new MetaObject(parent), lexicalParent);
    }

    public IR_ScopeImpl(Operand parent, IR_Scope lexicalParent) {
        this.init(parent, lexicalParent);
    }

    @Override
    public Operand getParent() {
        return this._parent;
    }

    @Override
    public Variable getNewVariable(String prefix) {
        Integer idx;
        if (prefix == null) {
            prefix = "%v_";
        }
        if (!prefix.startsWith("%")) {
            prefix = prefix + "%";
        }
        if ((idx = this._nextVarIndex.get(prefix)) == null) {
            idx = 0;
        }
        this._nextVarIndex.put(prefix, idx + 1);
        return new Variable(prefix + idx);
    }

    @Override
    public Variable getNewVariable() {
        return this.getNewVariable("%v_");
    }

    @Override
    public Label getNewLabel(String lblPrefix) {
        Integer idx = this._nextVarIndex.get(lblPrefix);
        if (idx == null) {
            idx = 0;
        }
        this._nextVarIndex.put(lblPrefix, idx + 1);
        return new Label(lblPrefix + idx);
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel("LBL_");
    }

    public int getAndIncrementMethodIndex() {
        ++this._nextMethodIndex;
        return this._nextMethodIndex;
    }

    @Override
    public Variable getSelf() {
        return new Variable("self");
    }

    @Override
    public void addModule(IR_Module m) {
        this.setConstantValue(m._name, new MetaObject(m));
        this._modules.add(m);
    }

    @Override
    public void addClass(IR_Class c) {
        this.setConstantValue(c._name, new MetaObject(c));
        this._classes.add(c);
    }

    @Override
    public void addMethod(IR_Method m) {
        this._methods.add(m);
        if (this instanceof IR_Method && ((IR_Method)this).isAClassRootMethod()) {
            IR_Class c = (IR_Class)((MetaObject)this._parent)._scope;
            this.addInstr(m._isInstanceMethod ? new DEFINE_INSTANCE_METHOD_Instr(c, m) : new DEFINE_CLASS_METHOD_Instr(c, m));
        } else if (m._isInstanceMethod && this instanceof IR_Class) {
            IR_Class c = (IR_Class)this;
            this.addInstr(new DEFINE_INSTANCE_METHOD_Instr(c, m));
        } else if (!m._isInstanceMethod && this instanceof IR_Module) {
            IR_Module c = (IR_Module)this;
            this.addInstr(new DEFINE_CLASS_METHOD_Instr(c, m));
        } else {
            throw new RuntimeException("Encountered method add in a non-class scope!");
        }
    }

    @Override
    public void addInstr(IR_Instr i) {
        this._instrs.add(i);
    }

    public List<IR_Instr> getInstrs() {
        return this._instrs;
    }

    @Override
    public CFG buildCFG() {
        this._cfg = new CFG(this);
        this._cfg.build(this._instrs);
        return this._cfg;
    }

    @Override
    public CFG getCFG() {
        return this._cfg;
    }

    @Override
    public Operand getConstantValue(String constRef) {
        Operand cv = this._constMap.get(constRef);
        Operand p2 = this._parent;
        if (cv == null && p2 != null && p2 instanceof MetaObject) {
            cv = ((MetaObject)p2)._scope.getConstantValue(constRef);
        }
        return cv;
    }

    @Override
    public void setConstantValue(String constRef, Operand val) {
        if (val.isConstant()) {
            this._constMap.put(constRef, val);
        }
        this.addInstr(new PUT_CONST_Instr(this, constRef, val));
    }

    public Map getConstants() {
        return Collections.unmodifiableMap(this._constMap);
    }

    @Override
    public void startLoop(IR_Loop l) {
        this._loopStack.push(l);
    }

    @Override
    public void endLoop(IR_Loop l) {
        this._loopStack.pop();
    }

    @Override
    public IR_Loop getCurrentLoop() {
        return this._loopStack.peek();
    }

    public String toString() {
        return this._constMap.isEmpty() ? "" : "\n  constants: " + this._constMap;
    }

    @Override
    public void runCompilerPass(CompilerPass p2) {
        boolean isPreOrder = p2.isPreOrder();
        if (isPreOrder) {
            p2.run(this);
        }
        if (!this._modules.isEmpty()) {
            for (IR_Module m : this._modules) {
                m.runCompilerPass(p2);
            }
        }
        if (!this._classes.isEmpty()) {
            for (IR_Class c : this._classes) {
                c.runCompilerPass(p2);
            }
        }
        if (!this._methods.isEmpty()) {
            for (IR_Method meth : this._methods) {
                meth.runCompilerPass(p2);
            }
        }
        if (!isPreOrder) {
            p2.run(this);
        }
    }

    public String toStringInstrs() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (IR_Instr instr : this._instrs) {
            if (i > 0) {
                b.append("\n");
            }
            b.append("  " + i++ + "\t");
            if (instr.isDead()) {
                b.append("[DEAD]");
            }
            b.append(instr);
        }
        return b.toString();
    }

    public String toStringVariables() {
        int i;
        StringBuilder sb = new StringBuilder();
        HashMap<Variable, Integer> ends = new HashMap<Variable, Integer>();
        HashMap<Variable, Integer> starts = new HashMap<Variable, Integer>();
        TreeSet<Variable> variables = new TreeSet<Variable>();
        for (i = this._instrs.size() - 1; i >= 0; --i) {
            IR_Instr instr = this._instrs.get(i);
            Variable var = instr._result;
            if (var != null) {
                variables.add(var);
                starts.put(var, i);
            }
            for (Operand operand : instr.getOperands()) {
                if (operand == null || !(operand instanceof Variable) || ends.get((Variable)operand) != null) continue;
                ends.put((Variable)operand, i);
                variables.add((Variable)operand);
            }
        }
        i = 0;
        for (Variable var : variables) {
            Integer end2 = (Integer)ends.get(var);
            if (end2 == null) continue;
            if (i > 0) {
                sb.append("\n");
            }
            ++i;
            sb.append("    " + var + ": " + starts.get(var) + "-" + end2);
        }
        return sb.toString();
    }
}

