/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.invokers.InstanceFieldGetter;
import org.jruby.java.invokers.InstanceFieldSetter;
import org.jruby.java.invokers.InstanceMethodInvoker;
import org.jruby.java.invokers.StaticMethodInvoker;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProxy
extends RubyObject {
    protected final RubyClass.VariableAccessor objectAccessor;
    private Object object;

    public JavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
        this.objectAccessor = klazz.getVariableAccessorForWrite("__wrap_struct__");
    }

    @Override
    public Object dataGetStruct() {
        return this.objectAccessor.get(this);
    }

    @Override
    public void dataWrapStruct(Object object) {
        this.objectAccessor.set(this, object);
        this.object = ((JavaObject)object).getValue();
    }

    public Object getObject() {
        if (this.object == null) {
            this.object = ((JavaObject)this.dataGetStruct()).getValue();
        }
        return this.object;
    }

    private JavaObject getJavaObject() {
        return (JavaObject)this.dataGetStruct();
    }

    public static RubyClass createJavaProxy(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyClass javaProxy = runtime2.defineClass("JavaProxy", runtime2.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new JavaProxy(runtime2, klazz);
            }
        });
        RubyClass singleton = javaProxy.getSingletonClass();
        singleton.addReadWriteAttribute(context, "java_class");
        javaProxy.defineAnnotatedMethods(JavaProxy.class);
        javaProxy.includeModule(runtime2.fastGetModule("JavaProxyMethods"));
        return javaProxy;
    }

    @JRubyMethod(frame=true, meta=true)
    public static IRubyObject inherited(ThreadContext context, IRubyObject recv2, IRubyObject subclass) {
        IRubyObject subJavaClass = RuntimeHelpers.invoke(context, subclass, "java_class");
        if (subJavaClass.isNil()) {
            subJavaClass = RuntimeHelpers.invoke(context, recv2, "java_class");
            RuntimeHelpers.invoke(context, subclass, "java_class=", subJavaClass);
        }
        return RuntimeHelpers.invokeSuper(context, recv2, subclass, Block.NULL_BLOCK);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject singleton_class(IRubyObject recv2) {
        return ((RubyClass)recv2).getSingletonClass();
    }

    @JRubyMethod(name={"[]"}, meta=true, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject javaClass = RuntimeHelpers.invoke(context, recv2, "java_class");
        if (args2.length > 0) {
            IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
            newArgs[0] = javaClass;
            System.arraycopy(args2, 0, newArgs, 1, args2.length);
            return context.getRuntime().fastGetClass("ArrayJavaProxyCreator").newInstance(context, newArgs, Block.NULL_BLOCK);
        }
        return Java.get_proxy_class(javaClass, RuntimeHelpers.invoke(context, javaClass, "array_class"));
    }

    private static Class<?> getJavaClass(ThreadContext context, RubyModule module) {
        try {
            IRubyObject jClass = RuntimeHelpers.invoke(context, module, "java_class");
            return !(jClass instanceof JavaClass) ? null : ((JavaClass)jClass).javaClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Map<String, String> getFieldListFromArgs(IRubyObject[] args2) {
        final HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i] instanceof RubyHash) {
                ((RubyHash)args2[i]).visitAll(new RubyHash.Visitor(){

                    public void visit(IRubyObject key2, IRubyObject value2) {
                        map.put(key2.asString().toString(), value2.asString().toString());
                    }
                });
                continue;
            }
            String value2 = args2[i].asString().toString();
            map.put(value2, value2);
        }
        return map;
    }

    private static void installField(ThreadContext context, Map<String, String> fieldMap, Field field2, RubyModule module, boolean asReader, boolean asWriter) {
        boolean isFinal = Modifier.isFinal(field2.getModifiers());
        Iterator<Map.Entry<String, String>> iter = fieldMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String key2 = entry.getKey();
            if (!key2.equals(field2.getName())) continue;
            if (Ruby.isSecurityRestricted() && !Modifier.isPublic(field2.getModifiers())) {
                throw context.getRuntime().newSecurityError("Cannot change accessibility on fields in a restricted mode: field '" + field2.getName() + "'");
            }
            String asName = entry.getValue();
            if (asReader) {
                module.addMethod(asName, new InstanceFieldGetter(key2, module, field2));
            }
            if (asWriter) {
                if (isFinal) {
                    throw context.getRuntime().newSecurityError("Cannot change final field '" + field2.getName() + "'");
                }
                module.addMethod(asName + "=", new InstanceFieldSetter(key2, module, field2));
            }
            iter.remove();
            break;
        }
    }

    private static void findFields(ThreadContext context, RubyModule topModule, IRubyObject[] args2, boolean asReader, boolean asWriter) {
        Map<String, String> fieldMap = JavaProxy.getFieldListFromArgs(args2);
        for (RubyModule module = topModule; module != null; module = module.getSuperClass()) {
            Class<?> javaClass = JavaProxy.getJavaClass(context, module);
            if (javaClass == null) continue;
            Field[] fields2 = JavaClass.getDeclaredFields(javaClass);
            for (int j = 0; j < fields2.length; ++j) {
                JavaProxy.installField(context, fieldMap, fields2[j], module, asReader, asWriter);
            }
        }
        if (!fieldMap.isEmpty()) {
            throw JavaClass.undefinedFieldError(context.getRuntime(), topModule.getName(), fieldMap.keySet().iterator().next());
        }
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_accessor(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, true, true);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_reader(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, true, false);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_writer(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, false, true);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject to_java_object(IRubyObject recv2) {
        return recv2.getInstanceVariables().fastGetInstanceVariable("@java_class");
    }

    @Override
    @JRubyMethod(name={"equal?"})
    public IRubyObject equal_p(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (other instanceof JavaProxy) {
            boolean equal = this.getObject() == ((JavaProxy)other).getObject();
            return runtime2.newBoolean(equal);
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName) {
        Class<?> jclass = this.getJavaObject().getJavaClass();
        String name2 = rubyName.asJavaString();
        String prettyName = name2 + "()";
        Ruby runtime2 = context.getRuntime();
        try {
            Method jmethod = jclass.getMethod(name2, new Class[0]);
            JavaMethod method2 = new JavaMethod(runtime2, jmethod);
            return method2.invokeDirect(this.getObject());
        }
        catch (NoSuchMethodException nsme) {
            String errorName = jclass.getName() + "." + prettyName;
            throw runtime2.newNameError("Java method not found", errorName);
        }
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        throw context.getRuntime().newArgumentError(2, 3);
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes, IRubyObject arg0) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime2 = context.getRuntime();
        if (argTypesAry.size() != 1) {
            throw runtime2.newArgumentError("arg type count (" + argTypesAry.size() + ") != arg count (1)");
        }
        Class argTypeClass = (Class)argTypesAry.eltInternal(0).toJava(Class.class);
        Class<?> jclass = this.getJavaObject().getJavaClass();
        String prettyName = name2 + CodegenUtils.prettyParams(argTypeClass);
        try {
            Method jmethod = jclass.getMethod(name2, argTypeClass);
            JavaMethod method2 = new JavaMethod(runtime2, jmethod);
            return method2.invokeDirect(this.getObject(), arg0.toJava(argTypeClass));
        }
        catch (NoSuchMethodException nsme) {
            String errorName = jclass.getName() + "." + prettyName;
            throw runtime2.newNameError("Java method not found: " + errorName, name2);
        }
    }

    @JRubyMethod(required=4, rest=true, backtrace=true)
    public IRubyObject java_send(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        Arity.checkArgumentCount(runtime2, args2, 3, -1);
        String name2 = args2[0].asJavaString();
        RubyArray argTypesAry = args2[1].convertToArray();
        int argsLen = args2.length - 2;
        if (argTypesAry.size() != argsLen) {
            throw runtime2.newArgumentError("arg type count (" + argTypesAry.size() + ") != arg count (" + argsLen + ")");
        }
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argsLen]);
        Object[] argsAry = new Object[argsLen];
        for (int i = 0; i < argsLen; ++i) {
            argsAry[i] = args2[i + 2].toJava(argTypesClasses[i]);
        }
        Class<?> jclass = this.getJavaObject().getJavaClass();
        String prettyName = name2 + CodegenUtils.prettyParams(argTypesClasses);
        try {
            Method jmethod = jclass.getMethod(name2, argTypesClasses);
            JavaMethod method2 = new JavaMethod(runtime2, jmethod);
            return method2.invokeDirect(this.getObject(), argsAry);
        }
        catch (NoSuchMethodException nsme) {
            String errorName = jclass.getName() + "." + prettyName;
            throw runtime2.newNameError("Java method not found: " + errorName, name2);
        }
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        Ruby runtime2 = context.getRuntime();
        Class<?> jclass = this.getJavaObject().getJavaClass();
        String prettyName = name2 + "()";
        try {
            Method jmethod = jclass.getMethod(name2, new Class[0]);
            if (Modifier.isStatic(jmethod.getModifiers())) {
                StaticMethodInvoker invoker = new StaticMethodInvoker(this.metaClass, jmethod);
                return RubyMethod.newMethod(this.metaClass, prettyName, this.metaClass, name2, invoker, this.getMetaClass());
            }
            InstanceMethodInvoker invoker = new InstanceMethodInvoker((RubyModule)this.metaClass, jmethod);
            return RubyMethod.newMethod(this.metaClass, prettyName, this.metaClass, name2, invoker, this);
        }
        catch (NoSuchMethodException nsme) {
            String errorName = jclass.getName() + "." + prettyName;
            throw runtime2.newNameError("Java method not found: " + errorName, name2);
        }
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime2 = context.getRuntime();
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
        Class<?> jclass = this.getJavaObject().getJavaClass();
        String prettyName = name2 + CodegenUtils.prettyParams(argTypesClasses);
        try {
            Method jmethod = jclass.getMethod(name2, argTypesClasses);
            if (Modifier.isStatic(jmethod.getModifiers())) {
                StaticMethodInvoker invoker = new StaticMethodInvoker(this.metaClass, jmethod);
                return RubyMethod.newMethod(this.metaClass, prettyName, this.metaClass, name2, invoker, this.getMetaClass());
            }
            InstanceMethodInvoker invoker = new InstanceMethodInvoker((RubyModule)this.metaClass, jmethod);
            return RubyMethod.newMethod(this.metaClass, prettyName, this.metaClass, name2, invoker, this);
        }
        catch (NoSuchMethodException nsme) {
            String errorName = jclass.getName() + "." + prettyName;
            throw runtime2.newNameError("Java method not found: " + errorName, name2);
        }
    }

    @Override
    public Object toJava(Class type2) {
        this.getRuntime().getJavaSupport().getObjectProxyCache().put(this.getObject(), this);
        return this.getObject();
    }

    public Object unwrap() {
        return this.getObject();
    }
}

