/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jruby.joda.time.DateTime;
import jruby.joda.time.DateTimeZone;
import jruby.joda.time.IllegalFieldValueException;
import jruby.joda.time.format.DateTimeFormat;
import jruby.joda.time.format.DateTimeFormatter;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RubyDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Time"}, include={"Comparable"})
public class RubyTime
extends RubyObject {
    public static final String UTC = "UTC";
    private DateTime dt;
    private long usec;
    private static final DateTimeFormatter ONE_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern("EEE MMM  d HH:mm:ss yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TWO_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern("EEE MMM dd HH:mm:ss yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_FORMATTER = DateTimeFormat.forPattern("EEE MMM dd HH:mm:ss Z yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_UTC_FORMATTER = DateTimeFormat.forPattern("EEE MMM dd HH:mm:ss 'UTC' yyyy").withLocale(Locale.ENGLISH);
    private static final Pattern TZ_PATTERN = Pattern.compile("(\\D+?)([\\+-]?)(\\d+)(:\\d+)?(:\\d+)?");
    private static final ByteList TZ_STRING = ByteList.create("TZ");
    private static ObjectAllocator TIME_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            DateTimeZone dtz = RubyTime.getLocalTimeZone(runtime2);
            DateTime dt = new DateTime(dtz);
            RubyTime rt = new RubyTime(runtime2, klass, dt);
            rt.setUSec(0L);
            return rt;
        }
    };
    private static final String[] MONTHS = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final Map<String, Integer> MONTHS_MAP = new HashMap<String, Integer>();
    private static final int[] time_min;
    private static final int[] time_max;
    private static final int ARG_SIZE = 7;

    public static DateTimeZone getLocalTimeZone(Ruby runtime2) {
        RubyString tzVar = runtime2.newString(TZ_STRING);
        RubyHash h = (RubyHash)runtime2.getObject().fastGetConstant("ENV");
        IRubyObject tz = h.op_aref(runtime2.getCurrentContext(), tzVar);
        if (tz == null || !(tz instanceof RubyString)) {
            return DateTimeZone.getDefault();
        }
        return RubyTime.getTimeZone(runtime2, tz.toString());
    }

    public static DateTimeZone getTimeZone(Ruby runtime2, String zone2) {
        DateTimeZone cachedZone = runtime2.getTimezoneCache().get(zone2);
        if (cachedZone != null) {
            return cachedZone;
        }
        String originalZone = zone2;
        Matcher tzMatcher = TZ_PATTERN.matcher(zone2);
        if (tzMatcher.matches()) {
            String sign2 = tzMatcher.group(2);
            String hours = tzMatcher.group(3);
            String minutes = tzMatcher.group(4);
            if (("00".equals(hours) || "0".equals(hours)) && (minutes == null || ":00".equals(minutes) || ":0".equals(minutes))) {
                zone2 = "Etc/GMT";
            } else {
                sign2 = "-".equals(sign2) ? "+" : "-";
                zone2 = "GMT" + sign2 + hours;
                if (minutes != null) {
                    zone2 = zone2 + minutes;
                }
            }
        }
        if ("GMT".equalsIgnoreCase(zone2) || UTC.equalsIgnoreCase(zone2)) {
            zone2 = "Etc/" + zone2;
        }
        if ("MET".equalsIgnoreCase(zone2)) {
            zone2 = "CET";
        }
        DateTimeZone dtz = DateTimeZone.forTimeZone(TimeZone.getTimeZone(zone2));
        runtime2.getTimezoneCache().put(originalZone, dtz);
        return dtz;
    }

    public RubyTime(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public RubyTime(Ruby runtime2, RubyClass rubyClass, DateTime dt) {
        super(runtime2, rubyClass);
        this.dt = dt;
    }

    public static RubyClass createTimeClass(Ruby runtime2) {
        RubyClass timeClass = runtime2.defineClass("Time", runtime2.getObject(), TIME_ALLOCATOR);
        timeClass.index = 19;
        runtime2.setTime(timeClass);
        timeClass.includeModule(runtime2.getComparable());
        timeClass.defineAnnotatedMethods(RubyTime.class);
        return timeClass;
    }

    public void setUSec(long usec2) {
        this.usec = usec2;
    }

    public long getUSec() {
        return this.usec;
    }

    public void updateCal(DateTime dt) {
        this.dt = dt;
    }

    protected long getTimeInMillis() {
        return this.dt.getMillis();
    }

    public static RubyTime newTime(Ruby runtime2, long milliseconds) {
        return RubyTime.newTime(runtime2, new DateTime(milliseconds));
    }

    public static RubyTime newTime(Ruby runtime2, DateTime dt) {
        return new RubyTime(runtime2, runtime2.getTime(), dt);
    }

    public static RubyTime newTime(Ruby runtime2, DateTime dt, long usec2) {
        RubyTime t = new RubyTime(runtime2, runtime2.getTime(), dt);
        t.setUSec(usec2);
        return t;
    }

    @Override
    public Class<?> getJavaClass() {
        return Date.class;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (!(original instanceof RubyTime)) {
            throw this.getRuntime().newTypeError("Expecting an instance of class Time");
        }
        RubyTime originalTime = (RubyTime)original;
        this.dt = originalTime.dt;
        this.usec = originalTime.usec;
        return this;
    }

    @JRubyMethod(name={"succ"})
    public RubyTime succ() {
        return RubyTime.newTime(this.getRuntime(), this.dt.plusSeconds(1));
    }

    @JRubyMethod(name={"gmtime", "utc"})
    public RubyTime gmtime() {
        this.dt = this.dt.withZone(DateTimeZone.UTC);
        return this;
    }

    @JRubyMethod(name={"localtime"})
    public RubyTime localtime() {
        this.dt = this.dt.withZone(RubyTime.getLocalTimeZone(this.getRuntime()));
        return this;
    }

    @JRubyMethod(name={"gmt?", "utc?", "gmtime?"})
    public RubyBoolean gmt() {
        return this.getRuntime().newBoolean(this.dt.getZone().getID().equals(UTC));
    }

    @JRubyMethod(name={"getgm", "getutc"})
    public RubyTime getgm() {
        return RubyTime.newTime(this.getRuntime(), this.dt.withZone(DateTimeZone.UTC), this.getUSec());
    }

    @JRubyMethod(name={"getlocal"})
    public RubyTime getlocal() {
        return RubyTime.newTime(this.getRuntime(), this.dt.withZone(RubyTime.getLocalTimeZone(this.getRuntime())), this.getUSec());
    }

    @JRubyMethod(name={"strftime"}, required=1)
    public RubyString strftime(IRubyObject format) {
        RubyDateFormat rubyDateFormat = new RubyDateFormat("-", Locale.US, this.getRuntime().is1_9());
        rubyDateFormat.applyPattern(format.convertToString().getUnicodeValue());
        rubyDateFormat.setDateTime(this.dt);
        String result = rubyDateFormat.format(null);
        return this.getRuntime().newString(result);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other.isNil()) {
            return RubyBoolean.newBoolean(this.getRuntime(), false);
        }
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) == 0);
        }
        return RubyComparable.op_equal(context, this, other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    private int cmp(RubyTime other) {
        long millis = this.getTimeInMillis();
        long millis_other = other.getTimeInMillis();
        long usec_other = other.usec;
        if (millis > millis_other || millis == millis_other && this.usec > usec_other) {
            return 1;
        }
        if (millis < millis_other || millis == millis_other && this.usec < usec_other) {
            return -1;
        }
        return 0;
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject other) {
        long time = this.getTimeInMillis();
        if (other instanceof RubyTime) {
            throw this.getRuntime().newTypeError("time + time ?");
        }
        long adjustment = Math.round(RubyNumeric.num2dbl(other) * 1000000.0);
        long micro = adjustment % 1000L;
        time += (adjustment /= 1000L);
        if (this.getUSec() + micro >= 1000L) {
            ++time;
            micro = this.getUSec() + micro - 1000L;
        } else {
            micro = this.getUSec() + micro;
        }
        RubyTime newTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        newTime.dt = new DateTime(time).withZone(this.dt.getZone());
        newTime.setUSec(micro);
        return newTime;
    }

    private IRubyObject opMinus(RubyTime other) {
        long time = this.getTimeInMillis() * 1000L + this.getUSec();
        return RubyFloat.newFloat(this.getRuntime(), (double)(time -= other.getTimeInMillis() * 1000L + other.getUSec()) / 1000000.0);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.opMinus((RubyTime)other);
        }
        long time = this.getTimeInMillis();
        long adjustment = Math.round(RubyNumeric.num2dbl(other) * 1000000.0);
        long micro = adjustment % 1000L;
        time -= (adjustment /= 1000L);
        if (this.getUSec() < micro) {
            --time;
            micro = 1000L - (micro - this.getUSec());
        } else {
            micro = this.getUSec() - micro;
        }
        RubyTime newTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        newTime.dt = new DateTime(time).withZone(this.dt.getZone());
        newTime.setUSec(micro);
        return newTime;
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return RubyNumeric.fix2int(this.callMethod(context, "<=>", other)) == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return context.getRuntime().newFixnum(this.cmp((RubyTime)other));
        }
        return context.getRuntime().getNil();
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyTime) {
            RubyTime otherTime = (RubyTime)other;
            return this.usec == otherTime.usec && this.getTimeInMillis() == otherTime.getTimeInMillis() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"asctime", "ctime"})
    public RubyString asctime() {
        DateTimeFormatter simpleDateFormat = this.dt.getDayOfMonth() < 10 ? ONE_DAY_CTIME_FORMATTER : TWO_DAY_CTIME_FORMATTER;
        String result = simpleDateFormat.print(this.dt);
        return this.getRuntime().newString(result);
    }

    @Override
    @JRubyMethod(name={"to_s", "inspect"})
    public IRubyObject to_s() {
        DateTimeFormatter simpleDateFormat = this.dt.getZone() == DateTimeZone.UTC ? TO_S_UTC_FORMATTER : TO_S_FORMATTER;
        String result = simpleDateFormat.print(this.dt);
        return this.getRuntime().newString(result);
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.getRuntime().newArrayNoCopy(this.sec(), this.min(), this.hour(), this.mday(), this.month(), this.year(), this.wday(), this.yday(), this.isdst(), this.zone());
    }

    @JRubyMethod(name={"to_f"})
    public RubyFloat to_f() {
        long time = this.getTimeInMillis();
        time = time * 1000L + this.usec;
        return RubyFloat.newFloat(this.getRuntime(), (double)time / 1000000.0);
    }

    @JRubyMethod(name={"to_i", "tv_sec"})
    public RubyInteger to_i() {
        return this.getRuntime().newFixnum(this.getTimeInMillis() / 1000L);
    }

    @JRubyMethod(name={"usec", "tv_usec"})
    public RubyInteger usec() {
        return this.getRuntime().newFixnum((long)(this.dt.getMillisOfSecond() * 1000) + this.getUSec());
    }

    public void setMicroseconds(long mic) {
        long millis = this.getTimeInMillis() % 1000L;
        long withoutMillis = this.getTimeInMillis() - millis;
        this.dt = this.dt.withMillis(withoutMillis += mic / 1000L);
        this.usec = mic % 1000L;
    }

    public long microseconds() {
        return this.getTimeInMillis() % 1000L * 1000L + this.usec;
    }

    @JRubyMethod(name={"sec"})
    public RubyInteger sec() {
        return this.getRuntime().newFixnum(this.dt.getSecondOfMinute());
    }

    @JRubyMethod(name={"min"})
    public RubyInteger min() {
        return this.getRuntime().newFixnum(this.dt.getMinuteOfHour());
    }

    @JRubyMethod(name={"hour"})
    public RubyInteger hour() {
        return this.getRuntime().newFixnum(this.dt.getHourOfDay());
    }

    @JRubyMethod(name={"mday", "day"})
    public RubyInteger mday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfMonth());
    }

    @JRubyMethod(name={"month", "mon"})
    public RubyInteger month() {
        return this.getRuntime().newFixnum(this.dt.getMonthOfYear());
    }

    @JRubyMethod(name={"year"})
    public RubyInteger year() {
        return this.getRuntime().newFixnum(this.dt.getYear());
    }

    @JRubyMethod(name={"wday"})
    public RubyInteger wday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfWeek() % 7);
    }

    @JRubyMethod(name={"yday"})
    public RubyInteger yday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfYear());
    }

    @JRubyMethod(name={"gmt_offset", "gmtoff", "utc_offset"})
    public RubyInteger gmt_offset() {
        int offset2 = this.dt.getZone().getOffsetFromLocal(this.dt.getMillis());
        return this.getRuntime().newFixnum(offset2 / 1000);
    }

    @JRubyMethod(name={"isdst", "dst?"})
    public RubyBoolean isdst() {
        return this.getRuntime().newBoolean(!this.dt.getZone().isStandardOffset(this.dt.getMillis()));
    }

    @JRubyMethod(name={"zone"})
    public RubyString zone() {
        String zone2 = this.dt.getZone().getShortName(this.dt.getMillis());
        if (zone2.equals("+00:00")) {
            zone2 = "GMT";
        }
        return this.getRuntime().newString(zone2);
    }

    public void setDateTime(DateTime dt) {
        this.dt = dt;
    }

    public DateTime getDateTime() {
        return this.dt;
    }

    public Date getJavaDate() {
        return this.dt.toDate();
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum((int)((this.dt.getMillis() / 1000L ^ this.microseconds()) << 1) >> 1);
    }

    @JRubyMethod(name={"_dump"}, optional=1, frame=true)
    public RubyString dump(IRubyObject[] args2, Block unusedBlock) {
        RubyString str = (RubyString)this.mdump(new IRubyObject[]{this});
        str.syncVariables(this.getVariableList());
        return str;
    }

    public RubyObject mdump(IRubyObject[] args2) {
        int i;
        RubyTime obj = (RubyTime)args2[0];
        DateTime dateTime = obj.dt;
        byte[] dumpValue = new byte[8];
        int pe = Integer.MIN_VALUE | (obj.gmt().isTrue() ? 1 : 0) << 30 | dateTime.getYear() - 1900 << 14 | dateTime.getMonthOfYear() - 1 << 10 | dateTime.getDayOfMonth() << 5 | dateTime.getHourOfDay();
        int se = dateTime.getMinuteOfHour() << 26 | dateTime.getSecondOfMinute() << 20 | dateTime.getMillisOfSecond() * 1000 + (int)this.usec;
        for (i = 0; i < 4; ++i) {
            dumpValue[i] = (byte)(pe & 0xFF);
            pe >>>= 8;
        }
        for (i = 4; i < 8; ++i) {
            dumpValue[i] = (byte)(se & 0xFF);
            se >>>= 8;
        }
        return RubyString.newString(obj.getRuntime(), new ByteList(dumpValue, false));
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(Block block) {
        return this;
    }

    public static IRubyObject s_new(IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        RubyTime time = new RubyTime(runtime2, (RubyClass)recv2, new DateTime(RubyTime.getLocalTimeZone(runtime2)));
        time.callInit(args2, block);
        return time;
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTime.newInstance(context, recv2);
    }

    @JRubyMethod(name={"times"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject times(ThreadContext context, IRubyObject recv2) {
        context.getRuntime().getWarnings().warn("obsolete method Time::times; use Process::times");
        return RubyProcess.times(context, recv2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"now"}, backtrace=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2) {
        IRubyObject obj = ((RubyClass)recv2).allocate();
        obj.getMetaClass().getBaseCallSites()[0].call(context, recv2, obj);
        return obj;
    }

    @JRubyMethod(name={"at"}, meta=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyTime time;
        Ruby runtime2 = context.getRuntime();
        if (arg2 instanceof RubyTime) {
            RubyTime other = (RubyTime)arg2;
            time = new RubyTime(runtime2, (RubyClass)recv2, other.dt);
            time.setUSec(other.getUSec());
        } else {
            time = new RubyTime(runtime2, (RubyClass)recv2, new DateTime(0L, RubyTime.getLocalTimeZone(runtime2)));
            long seconds = RubyNumeric.num2long(arg2);
            long millisecs = 0L;
            long microsecs = 0L;
            if (arg2 instanceof RubyFloat) {
                double dbl = ((RubyFloat)arg2).getDoubleValue();
                long micro = Math.round((dbl - (double)seconds) * 1000000.0);
                if (dbl < 0.0) {
                    micro += 1000000L;
                }
                millisecs = micro / 1000L;
                microsecs = micro % 1000L;
            }
            time.setUSec(microsecs);
            time.dt = time.dt.withMillis(seconds * 1000L + millisecs);
        }
        time.getMetaClass().getBaseCallSites()[0].call(context, recv2, time);
        return time;
    }

    @JRubyMethod(name={"at"}, meta=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        RubyTime time = new RubyTime(runtime2, (RubyClass)recv2, new DateTime(0L, RubyTime.getLocalTimeZone(runtime2)));
        long seconds = RubyNumeric.num2long(arg1);
        long millisecs = 0L;
        long microsecs = 0L;
        long tmp = RubyNumeric.num2long(arg2);
        millisecs = tmp / 1000L;
        microsecs = tmp % 1000L;
        time.setUSec(microsecs);
        time.dt = time.dt.withMillis(seconds * 1000L + millisecs);
        time.getMetaClass().getBaseCallSites()[0].call(context, recv2, time);
        return time;
    }

    @JRubyMethod(name={"local", "mktime"}, required=1, optional=9, meta=true)
    public static RubyTime new_local(IRubyObject recv2, IRubyObject[] args2) {
        return RubyTime.createTime(recv2, args2, false);
    }

    @JRubyMethod(name={"utc", "gm"}, required=1, optional=9, meta=true)
    public static RubyTime new_utc(IRubyObject recv2, IRubyObject[] args2) {
        return RubyTime.createTime(recv2, args2, true);
    }

    @JRubyMethod(name={"_load"}, required=1, frame=true, meta=true)
    public static RubyTime load(IRubyObject recv2, IRubyObject from, Block block) {
        return RubyTime.s_mload(recv2, (RubyTime)((RubyClass)recv2).allocate(), from);
    }

    @Override
    public Object toJava(Class target) {
        return this.getJavaDate();
    }

    protected static RubyTime s_mload(IRubyObject recv2, RubyTime time, IRubyObject from) {
        int i;
        Ruby runtime2 = recv2.getRuntime();
        DateTime dt = new DateTime(RubyTime.getLocalTimeZone(runtime2));
        byte[] fromAsBytes = null;
        fromAsBytes = from.convertToString().getBytes();
        if (fromAsBytes.length != 8) {
            throw runtime2.newTypeError("marshaled time format differ");
        }
        int p2 = 0;
        int s = 0;
        for (i = 0; i < 4; ++i) {
            p2 |= (fromAsBytes[i] & 0xFF) << 8 * i;
        }
        for (i = 4; i < 8; ++i) {
            s |= (fromAsBytes[i] & 0xFF) << 8 * (i - 4);
        }
        if ((p2 & Integer.MIN_VALUE) == 0) {
            dt = dt.withMillis((long)p2 * 1000L);
            time.setUSec((s & 0xFFFFF) % 1000);
        } else {
            if (((p2 &= Integer.MAX_VALUE) >>> 30 & 1) == 1) {
                dt = dt.withZone(DateTimeZone.UTC);
            }
            dt = dt.withYear((p2 >>> 14 & 0xFFFF) + 1900);
            dt = dt.withMonthOfYear((p2 >>> 10 & 0xF) + 1);
            dt = dt.withDayOfMonth(p2 >>> 5 & 0x1F);
            dt = dt.withHourOfDay(p2 & 0x1F);
            dt = dt.withMinuteOfHour(s >>> 26 & 0x3F);
            dt = dt.withSecondOfMinute(s >>> 20 & 0x3F);
            dt = dt.withMillisOfSecond((s & 0xFFFFF) / 1000);
            time.setUSec((s & 0xFFFFF) % 1000);
        }
        time.setDateTime(dt);
        from.getInstanceVariables().copyInstanceVariablesInto(time);
        return time;
    }

    private static RubyTime createTime(IRubyObject recv2, IRubyObject[] args2, boolean gmt2) {
        DateTime dt;
        Ruby runtime2 = recv2.getRuntime();
        int len = 7;
        Boolean isDst = null;
        DateTimeZone dtz = gmt2 ? DateTimeZone.UTC : (args2.length == 10 && args2[9] instanceof RubyString ? RubyTime.getTimeZone(runtime2, ((RubyString)args2[9]).toString()) : RubyTime.getLocalTimeZone(runtime2));
        if (args2.length == 10) {
            if (args2[8] instanceof RubyBoolean) {
                isDst = ((RubyBoolean)args2[8]).isTrue();
            }
            args2 = new IRubyObject[]{args2[5], args2[4], args2[3], args2[2], args2[1], args2[0], runtime2.getNil()};
        } else {
            len = args2.length;
            if (len < 7) {
                IRubyObject[] newArgs = new IRubyObject[7];
                System.arraycopy(args2, 0, newArgs, 0, args2.length);
                for (int i = len; i < 7; ++i) {
                    newArgs[i] = runtime2.getNil();
                }
                args2 = newArgs;
                len = 7;
            }
        }
        if (args2[0] instanceof RubyString) {
            args2[0] = RubyNumeric.str2inum(runtime2, (RubyString)args2[0], 10, false);
        }
        int year2 = (int)RubyNumeric.num2long(args2[0]);
        int month2 = 1;
        if (len > 1) {
            if (!args2[1].isNil()) {
                IRubyObject tmp = args2[1].checkStringType();
                if (!tmp.isNil()) {
                    String monthString = tmp.toString().toLowerCase();
                    Integer monthInt = MONTHS_MAP.get(monthString);
                    if (monthInt != null) {
                        month2 = monthInt;
                    } else {
                        try {
                            month2 = Integer.parseInt(monthString);
                        }
                        catch (NumberFormatException nfExcptn) {
                            throw runtime2.newArgumentError("Argument out of range.");
                        }
                    }
                } else {
                    month2 = (int)RubyNumeric.num2long(args2[1]);
                }
            }
            if (1 > month2 || month2 > 12) {
                throw runtime2.newArgumentError("Argument out of range: for month: " + month2);
            }
        }
        int[] int_args = new int[]{1, 0, 0, 0, 0, 0};
        int i = 0;
        while (int_args.length >= i + 2) {
            if (!args2[i + 2].isNil()) {
                long value2;
                if (!(args2[i + 2] instanceof RubyNumeric)) {
                    args2[i + 2] = args2[i + 2].callMethod(runtime2.getCurrentContext(), "to_i");
                }
                if ((long)time_min[i] > (value2 = RubyNumeric.num2long(args2[i + 2])) || value2 > (long)time_max[i]) {
                    throw runtime2.newArgumentError("argument out of range.");
                }
                int_args[i] = (int)value2;
            }
            ++i;
        }
        if (0 <= year2 && year2 < 39) {
            year2 += 2000;
        } else if (69 <= year2 && year2 < 139) {
            year2 += 1900;
        }
        try {
            dt = new DateTime(year2, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            dt = dt.plusMonths(month2 - 1).plusDays(int_args[0] - 1).plusHours(int_args[1]).plusMinutes(int_args[2]).plusSeconds(int_args[3]);
            dt = dt.withZoneRetainFields(dtz);
            if (isDst != null) {
                long offsetCalculationInstant = dt.getMillis();
                if (dtz.isStandardOffset(dt.getMillis())) {
                    offsetCalculationInstant = dtz.previousTransition(offsetCalculationInstant);
                }
                int offset2 = dtz.getStandardOffset(offsetCalculationInstant) - dtz.getOffset(offsetCalculationInstant);
                if (!isDst.booleanValue() && !dtz.isStandardOffset(dt.getMillis())) {
                    dt = dt.minusMillis(offset2);
                }
                if (isDst.booleanValue() && dtz.isStandardOffset(dt.getMillis())) {
                    dt = dt.plusMillis(offset2);
                }
            }
        }
        catch (IllegalFieldValueException e) {
            throw runtime2.newArgumentError("time out of range");
        }
        RubyTime time = new RubyTime(runtime2, (RubyClass)recv2, dt);
        if (args2.length != 8 && !args2[6].isNil()) {
            int usec2 = int_args[4] % 1000;
            int msec = int_args[4] / 1000;
            if (int_args[4] < 0) {
                --msec;
                usec2 += 1000;
            }
            time.dt = dt.withMillis(dt.getMillis() + (long)msec);
            time.setUSec(usec2);
        }
        time.callInit(IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        return time;
    }

    static {
        for (int i = 0; i < MONTHS.length; ++i) {
            MONTHS_MAP.put(MONTHS[i], i + 1);
        }
        time_min = new int[]{1, 0, 0, 0, Integer.MIN_VALUE};
        time_max = new int[]{31, 23, 59, 60, Integer.MAX_VALUE};
    }
}

