/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.mop.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.dynalang.mop.MetaobjectProtocol;
import org.dynalang.mop.beans.BeansMetaobjectProtocol;
import org.dynalang.mop.collections.ListMetaobjectProtocol;
import org.dynalang.mop.collections.MapMetaobjectProtocol;
import org.dynalang.mop.impl.AutoDiscovery;
import org.dynalang.mop.impl.BottomMetaobjectProtocol;
import org.dynalang.mop.impl.CompositeClassBasedMetaobjectProtocol;
import org.dynalang.mop.impl.CompositeMetaobjectProtocol;
import org.dynalang.mop.impl.MetaobjectProtocolAdaptor;

public class StandardMetaobjectProtocolFactory {
    private StandardMetaobjectProtocolFactory() {
    }

    public static MetaobjectProtocol createStandardMetaobjectProtocol(boolean elementsShadowMethods, boolean methodsEnumerable) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        return StandardMetaobjectProtocolFactory.createStandardMetaobjectProtocol(Thread.currentThread().getContextClassLoader(), null, StandardMetaobjectProtocolFactory.createStandardFallback(elementsShadowMethods, methodsEnumerable));
    }

    public static MetaobjectProtocol createStandardMetaobjectProtocol(MetaobjectProtocol nativeProtocol, boolean elementsShadowMethods, boolean methodsEnumerable) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        return StandardMetaobjectProtocolFactory.createStandardMetaobjectProtocol(Thread.currentThread().getContextClassLoader(), new MetaobjectProtocol[]{nativeProtocol}, StandardMetaobjectProtocolFactory.createStandardFallback(elementsShadowMethods, methodsEnumerable));
    }

    public static MetaobjectProtocol createStandardMetaobjectProtocol(ClassLoader classLoader, MetaobjectProtocol[] prioritized, MetaobjectProtocol[] fallbacks) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (prioritized == null) {
            prioritized = new MetaobjectProtocol[]{};
        }
        if (fallbacks == null) {
            fallbacks = new MetaobjectProtocol[]{};
        }
        MetaobjectProtocol[] discovered = MetaobjectProtocolAdaptor.toMetaobjectProtocols(AutoDiscovery.discoverBaseMetaobjectProtocols(classLoader));
        HashSet knownMopClasses = new HashSet();
        for (MetaobjectProtocol protocol : prioritized) {
            knownMopClasses.add(protocol.getClass());
        }
        for (MetaobjectProtocol protocol : fallbacks) {
            knownMopClasses.add(protocol.getClass());
        }
        ArrayList<MetaobjectProtocol> mops = new ArrayList<MetaobjectProtocol>(prioritized.length + discovered.length + fallbacks.length);
        mops.addAll(Arrays.asList(prioritized));
        for (int i = 0; i < discovered.length; ++i) {
            MetaobjectProtocol protocol = discovered[i];
            if (knownMopClasses.contains(protocol.getClass())) continue;
            mops.add(protocol);
        }
        mops.addAll(Arrays.asList(fallbacks));
        MetaobjectProtocol[] optimized = CompositeClassBasedMetaobjectProtocol.optimize(mops.toArray(new MetaobjectProtocol[mops.size()]));
        switch (optimized.length) {
            case 0: {
                return new BottomMetaobjectProtocol();
            }
            case 1: {
                return optimized[0];
            }
        }
        return new CompositeMetaobjectProtocol(optimized);
    }

    public static MetaobjectProtocol[] createStandardFallback(boolean elementsShadowMethods, boolean methodsEnumerable) {
        MetaobjectProtocol[] fallback = new MetaobjectProtocol[4];
        ListMetaobjectProtocol listMop = new ListMetaobjectProtocol();
        MapMetaobjectProtocol mapMop = new MapMetaobjectProtocol();
        BeansMetaobjectProtocol beansMop = new BeansMetaobjectProtocol(methodsEnumerable);
        if (elementsShadowMethods) {
            fallback[0] = mapMop;
            fallback[1] = listMop;
            fallback[2] = beansMop;
        } else {
            fallback[0] = beansMop;
            fallback[1] = mapMop;
            fallback[2] = listMop;
        }
        fallback[3] = new BottomMetaobjectProtocol();
        return fallback;
    }
}

