/*
 * Decompiled with CFR 0.152.
 */
package jruby.joda.time.chrono;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jruby.joda.time.Chronology;
import jruby.joda.time.DateTimeFieldType;
import jruby.joda.time.DateTimeZone;
import jruby.joda.time.chrono.AssembledChronology;
import jruby.joda.time.chrono.GregorianChronology;
import jruby.joda.time.chrono.ISOYearOfEraDateTimeField;
import jruby.joda.time.chrono.ZonedChronology;
import jruby.joda.time.field.DividedDateTimeField;
import jruby.joda.time.field.RemainderDateTimeField;

public final class ISOChronology
extends AssembledChronology {
    private static final long serialVersionUID = -6212696554273812441L;
    private static final ISOChronology INSTANCE_UTC;
    private static final int FAST_CACHE_SIZE = 64;
    private static final ISOChronology[] cFastCache;
    private static final Map cCache;

    public static ISOChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static ISOChronology getInstance() {
        return ISOChronology.getInstance(DateTimeZone.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISOChronology getInstance(DateTimeZone dateTimeZone) {
        int n;
        ISOChronology iSOChronology;
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if ((iSOChronology = cFastCache[n = System.identityHashCode(dateTimeZone) & 0x3F]) != null && iSOChronology.getZone() == dateTimeZone) {
            return iSOChronology;
        }
        Map map = cCache;
        synchronized (map) {
            iSOChronology = (ISOChronology)cCache.get(dateTimeZone);
            if (iSOChronology == null) {
                iSOChronology = new ISOChronology(ZonedChronology.getInstance(INSTANCE_UTC, dateTimeZone));
                cCache.put(dateTimeZone, iSOChronology);
            }
        }
        ISOChronology.cFastCache[n] = iSOChronology;
        return iSOChronology;
    }

    private ISOChronology(Chronology chronology) {
        super(chronology, null);
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return ISOChronology.getInstance(dateTimeZone);
    }

    public String toString() {
        String string2 = "ISOChronology";
        DateTimeZone dateTimeZone = this.getZone();
        if (dateTimeZone != null) {
            string2 = string2 + '[' + dateTimeZone.getID() + ']';
        }
        return string2;
    }

    protected void assemble(AssembledChronology.Fields fields2) {
        if (this.getBase().getZone() == DateTimeZone.UTC) {
            fields2.centuryOfEra = new DividedDateTimeField(ISOYearOfEraDateTimeField.INSTANCE, DateTimeFieldType.centuryOfEra(), 100);
            fields2.yearOfCentury = new RemainderDateTimeField((DividedDateTimeField)fields2.centuryOfEra, DateTimeFieldType.yearOfCentury());
            fields2.weekyearOfCentury = new RemainderDateTimeField((DividedDateTimeField)fields2.centuryOfEra, DateTimeFieldType.weekyearOfCentury());
            fields2.centuries = fields2.centuryOfEra.getDurationField();
        }
    }

    private Object writeReplace() {
        return new Stub(this.getZone());
    }

    static {
        cCache = new HashMap();
        cFastCache = new ISOChronology[64];
        INSTANCE_UTC = new ISOChronology(GregorianChronology.getInstanceUTC());
        cCache.put(DateTimeZone.UTC, INSTANCE_UTC);
    }

    private static final class Stub
    implements Serializable {
        private static final long serialVersionUID = -6212696554273812441L;
        private transient DateTimeZone iZone;

        Stub(DateTimeZone dateTimeZone) {
            this.iZone = dateTimeZone;
        }

        private Object readResolve() {
            return ISOChronology.getInstance(this.iZone);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.iZone);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.iZone = (DateTimeZone)objectInputStream.readObject();
        }
    }
}

