/*
 * Decompiled with CFR 0.152.
 */
package jruby.joda.time;

import java.io.Serializable;
import jruby.joda.time.Chronology;
import jruby.joda.time.DateTime;
import jruby.joda.time.DateTimeUtils;
import jruby.joda.time.MutableDateTime;
import jruby.joda.time.ReadableDuration;
import jruby.joda.time.ReadableInstant;
import jruby.joda.time.base.AbstractInstant;
import jruby.joda.time.chrono.ISOChronology;
import jruby.joda.time.convert.ConverterManager;
import jruby.joda.time.convert.InstantConverter;

public final class Instant
extends AbstractInstant
implements ReadableInstant,
Serializable {
    private static final long serialVersionUID = 3299096530934209741L;
    private final long iMillis;

    public Instant() {
        this.iMillis = DateTimeUtils.currentTimeMillis();
    }

    public Instant(long l) {
        this.iMillis = l;
    }

    public Instant(Object object) {
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(object);
        this.iMillis = instantConverter.getInstantMillis(object, ISOChronology.getInstanceUTC());
    }

    public Instant toInstant() {
        return this;
    }

    public Instant withMillis(long l) {
        return l == this.iMillis ? this : new Instant(l);
    }

    public Instant withDurationAdded(long l, int n) {
        if (l == 0L || n == 0) {
            return this;
        }
        long l2 = this.getChronology().add(this.getMillis(), l, n);
        return this.withMillis(l2);
    }

    public Instant withDurationAdded(ReadableDuration readableDuration, int n) {
        if (readableDuration == null || n == 0) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), n);
    }

    public Instant plus(long l) {
        return this.withDurationAdded(l, 1);
    }

    public Instant plus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, 1);
    }

    public Instant minus(long l) {
        return this.withDurationAdded(l, -1);
    }

    public Instant minus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, -1);
    }

    public long getMillis() {
        return this.iMillis;
    }

    public Chronology getChronology() {
        return ISOChronology.getInstanceUTC();
    }

    public DateTime toDateTime() {
        return new DateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    public DateTime toDateTimeISO() {
        return this.toDateTime();
    }

    public MutableDateTime toMutableDateTime() {
        return new MutableDateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    public MutableDateTime toMutableDateTimeISO() {
        return this.toMutableDateTime();
    }
}

