/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.Type;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.util.HandleFactory;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.load.Library;
import org.jruby.util.CodegenUtils;
import org.jruby.util.IdUtil;
import org.jruby.util.JRubyClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniJava
implements Library {
    private static final boolean DEBUG = false;
    static Map<Class, RubyModule> classMap = new HashMap<Class, RubyModule>();
    static final Map<Class, JavaMethodFactory> methodFactories = new HashMap<Class, JavaMethodFactory>();
    static final JavaMethodFactory JAVA_OBJECT_METHOD_FACTORY = new JavaMethodFactory(){

        public DynamicMethod createMethod(RubyClass klazz, Method method2) {
            return new JavaObjectWrapperMethod((RubyModule)klazz, method2);
        }
    };

    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        runtime2.getErr().print("Warning: minijava is experimental and subject to change\n");
        runtime2.getKernel().defineAnnotatedMethods(MiniJava.class);
        RubyModule javaObject = MiniJava.getMirrorForClass(runtime2, Object.class);
        javaObject.addMethod("to_s", new JavaMethod.JavaMethodZero(javaObject, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
                return context.getRuntime().newString(((JavaObjectWrapper)self).object.toString());
            }
        });
        javaObject.addMethod("hash", new JavaMethod.JavaMethodZero(javaObject, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
                return self.getRuntime().newFixnum(((JavaObjectWrapper)self).object.hashCode());
            }
        });
        javaObject.addMethod("==", new JavaMethod.JavaMethodOne(javaObject, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
                if (arg2 instanceof JavaObjectWrapper) {
                    return context.getRuntime().newBoolean(((JavaObjectWrapper)self).object.equals(((JavaObjectWrapper)arg2).object));
                }
                return context.getRuntime().getFalse();
            }
        });
        RubyModule rubyKernel = runtime2.getKernel();
        rubyKernel.addModuleFunction("to_java", new JavaMethod.JavaMethodZeroOrOne(rubyKernel, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
                return ((RubyObject)self).to_java();
            }

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
                return ((RubyObject)self).as(MiniJava.getJavaClassFromObject(arg2));
            }
        });
    }

    @JRubyMethod(name={"new_class"}, rest=true, module=true)
    public static IRubyObject new_class(ThreadContext context, IRubyObject self, IRubyObject[] interfaces2) {
        Class[] javaInterfaces = new Class[interfaces2.length];
        for (int i = 0; i < interfaces2.length; ++i) {
            javaInterfaces[i] = MiniJava.getJavaClassFromObject(interfaces2[i]);
        }
        return MiniJava.createImplClass(javaInterfaces, context.getRuntime(), "I" + System.currentTimeMillis());
    }

    @JRubyMethod(name={"import"}, module=true)
    public static IRubyObject rb_import(ThreadContext context, IRubyObject self, IRubyObject name2) {
        String className = name2.toString();
        try {
            Class cls = MiniJava.findClass(context.getRuntime().getJRubyClassLoader(), className);
            RubyModule namespace = self instanceof RubyModule ? (RubyModule)self : self.getMetaClass().getRealClass();
            namespace.defineConstant(cls.getSimpleName(), MiniJava.getMirrorForClass(context.getRuntime(), cls));
            return context.getRuntime().getNil();
        }
        catch (Exception e) {
            if (context.getRuntime().getDebug().isTrue()) {
                e.printStackTrace();
            }
            throw context.getRuntime().newTypeError("Could not find class " + className + ", exception: " + e);
        }
    }

    @JRubyMethod(name={"import"}, module=true)
    public static IRubyObject rb_import(ThreadContext context, IRubyObject self, IRubyObject name2, IRubyObject as) {
        String className = name2.toString();
        try {
            Class cls = MiniJava.findClass(context.getRuntime().getJRubyClassLoader(), className);
            RubyModule namespace = self instanceof RubyModule ? (RubyModule)self : self.getMetaClass().getRealClass();
            namespace.defineConstant(as.toString(), MiniJava.getMirrorForClass(context.getRuntime(), cls));
            return context.getRuntime().getNil();
        }
        catch (Exception e) {
            if (context.getRuntime().getDebug().isTrue()) {
                e.printStackTrace();
            }
            throw context.getRuntime().newTypeError("Could not find class " + className + ", exception: " + e);
        }
    }

    public static RubyClass createImplClass(Class[] superTypes, Ruby ruby, String name2) {
        String[] superTypeNames = new String[superTypes.length];
        HashMap<String, List<Method>> simpleToAll = new HashMap<String, List<Method>>();
        for (int i = 0; i < superTypes.length; ++i) {
            superTypeNames[i] = CodegenUtils.p(superTypes[i]);
            for (Method method2 : superTypes[i].getMethods()) {
                ArrayList<Method> methods2 = (ArrayList<Method>)simpleToAll.get(method2.getName());
                if (methods2 == null) {
                    methods2 = new ArrayList<Method>();
                    simpleToAll.put(method2.getName(), methods2);
                }
                methods2.add(method2);
            }
        }
        Class newClass = MiniJava.defineImplClass(ruby, name2, superTypeNames, simpleToAll);
        RubyClass rubyCls = MiniJava.populateImplClass(ruby, newClass, simpleToAll);
        return rubyCls;
    }

    public static Class createOldStyleImplClass(Class[] superTypes, RubyClass rubyClass, Ruby ruby, String name2) {
        String[] superTypeNames = new String[superTypes.length];
        HashMap<String, List<Method>> simpleToAll = new HashMap<String, List<Method>>();
        for (int i = 0; i < superTypes.length; ++i) {
            superTypeNames[i] = CodegenUtils.p(superTypes[i]);
            for (Method method2 : superTypes[i].getMethods()) {
                ArrayList<Method> methods2 = (ArrayList<Method>)simpleToAll.get(method2.getName());
                if (methods2 == null) {
                    methods2 = new ArrayList<Method>();
                    simpleToAll.put(method2.getName(), methods2);
                }
                methods2.add(method2);
            }
        }
        Class newClass = MiniJava.defineOldStyleImplClass(ruby, name2, superTypeNames, simpleToAll);
        return newClass;
    }

    public static Class defineImplClass(Ruby ruby, String name2, String[] superTypeNames, Map<String, List<Method>> simpleToAll) {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 33, name2, null, CodegenUtils.p(Object.class), superTypeNames);
        cw.visitField(10, "$ruby", CodegenUtils.ci(Ruby.class), null, null).visitEnd();
        cw.visitField(10, "$rubyClass", CodegenUtils.ci(RubyClass.class), null, null).visitEnd();
        cw.visitField(18, "$self", CodegenUtils.ci(IRubyObject.class), null, null).visitEnd();
        SkinnyMethodAdapter initMethod = new SkinnyMethodAdapter(cw.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
        initMethod.aload(0);
        initMethod.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        initMethod.aload(0);
        initMethod.getstatic(name2, "$ruby", CodegenUtils.ci(Ruby.class));
        initMethod.aload(0);
        initMethod.invokestatic(CodegenUtils.p(MiniJava.class), "javaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
        initMethod.putfield(name2, "$self", CodegenUtils.ci(IRubyObject.class));
        initMethod.voidreturn();
        initMethod.end();
        SkinnyMethodAdapter setupMethod = new SkinnyMethodAdapter(cw.visitMethod(4105, "__setup__", CodegenUtils.sig(Void.TYPE, RubyClass.class), null, null));
        setupMethod.start();
        setupMethod.aload(0);
        setupMethod.dup();
        setupMethod.putstatic(name2, "$rubyClass", CodegenUtils.ci(RubyClass.class));
        setupMethod.invokevirtual(CodegenUtils.p(RubyClass.class), "getClassRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        setupMethod.putstatic(name2, "$ruby", CodegenUtils.ci(Ruby.class));
        for (Map.Entry<String, List<Method>> entry : simpleToAll.entrySet()) {
            String simpleName = entry.getKey();
            cw.visitField(73, simpleName, CodegenUtils.ci(DynamicMethod.class), null, null).visitEnd();
            for (Method method2 : entry.getValue()) {
                Class[] paramTypes = method2.getParameterTypes();
                Class<?> returnType = method2.getReturnType();
                SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(1, simpleName, CodegenUtils.sig(returnType, paramTypes), null, null));
                mv.start();
                String fieldName = MiniJava.mangleMethodFieldName(simpleName, paramTypes);
                Label dispatch = new Label();
                cw.visitField(73, fieldName, CodegenUtils.ci(DynamicMethod.class), null, null).visitEnd();
                mv.getstatic(name2, fieldName, CodegenUtils.ci(DynamicMethod.class));
                mv.dup();
                mv.ifnonnull(dispatch);
                mv.pop();
                mv.getstatic(name2, simpleName, CodegenUtils.ci(DynamicMethod.class));
                mv.dup();
                mv.ifnonnull(dispatch);
                mv.pop();
                mv.getstatic(name2, "$rubyClass", CodegenUtils.ci(RubyClass.class));
                mv.ldc("method_missing");
                mv.invokevirtual(CodegenUtils.p(RubyClass.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, String.class));
                mv.label(dispatch);
                mv.getstatic(name2, "$ruby", CodegenUtils.ci(Ruby.class));
                mv.invokevirtual(CodegenUtils.p(Ruby.class), "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
                mv.aload(0);
                mv.getfield(name2, "$self", CodegenUtils.ci(IRubyObject.class));
                mv.getstatic(name2, "$rubyClass", CodegenUtils.ci(RubyClass.class));
                mv.ldc(simpleName);
                if (method2.getParameterTypes().length != 0) {
                    mv.pushInt(method2.getParameterTypes().length);
                    mv.anewarray(CodegenUtils.p(IRubyObject.class));
                    for (int i = 0; i < paramTypes.length; ++i) {
                        mv.dup();
                        mv.pushInt(i);
                        mv.getstatic(name2, "$ruby", CodegenUtils.ci(Ruby.class));
                        mv.aload(i + 1);
                        mv.invokestatic(CodegenUtils.p(MiniJava.class), "javaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
                        mv.aastore();
                    }
                } else {
                    mv.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                mv.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
                if (method2.getReturnType() != Void.TYPE) {
                    mv.invokestatic(CodegenUtils.p(MiniJava.class), "rubyToJava", CodegenUtils.sig(Object.class, IRubyObject.class));
                    mv.checkcast(CodegenUtils.p(returnType));
                    mv.areturn();
                } else {
                    mv.voidreturn();
                }
                mv.end();
            }
        }
        setupMethod.voidreturn();
        setupMethod.end();
        cw.visitEnd();
        byte[] bytes2 = cw.toByteArray();
        Class<?> newClass = ruby.getJRubyClassLoader().defineClass(name2, cw.toByteArray());
        return newClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class defineOldStyleImplClass(Ruby ruby, String name2, String[] superTypeNames, Map<String, List<Method>> simpleToAll) {
        Class<?> newClass;
        ClassWriter cw = new ClassWriter(1);
        String pathName = name2.replace('.', '/');
        cw.visit(49, 33, pathName, null, CodegenUtils.p(Object.class), superTypeNames);
        cw.visitSource(pathName + ".gen", null);
        cw.visitField(26, "$monitor", CodegenUtils.ci(Object.class), null, null).visitEnd();
        cw.visitField(18, "$self", CodegenUtils.ci(IRubyObject.class), null, null).visitEnd();
        SkinnyMethodAdapter clinitMethod = new SkinnyMethodAdapter(cw.visitMethod(9, "<clinit>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
        clinitMethod.newobj(CodegenUtils.p(Object.class));
        clinitMethod.dup();
        clinitMethod.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        clinitMethod.putstatic(pathName, "$monitor", CodegenUtils.ci(Object.class));
        SkinnyMethodAdapter initMethod = new SkinnyMethodAdapter(cw.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, IRubyObject.class), null, null));
        initMethod.aload(0);
        initMethod.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        initMethod.aload(0);
        initMethod.aload(1);
        initMethod.putfield(pathName, "$self", CodegenUtils.ci(IRubyObject.class));
        initMethod.voidreturn();
        initMethod.end();
        for (Map.Entry<String, List<Method>> entry : simpleToAll.entrySet()) {
            String simpleName = entry.getKey();
            Set<String> nameSet = JavaUtil.getRubyNamesForJavaName(simpleName, entry.getValue());
            cw.visitField(73, simpleName, CodegenUtils.ci(CacheEntry.class), null, null).visitEnd();
            clinitMethod.getstatic(CodegenUtils.p(CacheEntry.class), "NULL_CACHE", CodegenUtils.ci(CacheEntry.class));
            clinitMethod.putstatic(pathName, simpleName, CodegenUtils.ci(CacheEntry.class));
            HashSet<String> implementedNames = new HashSet<String>();
            for (Method method2 : entry.getValue()) {
                Class[] paramTypes = method2.getParameterTypes();
                Class<?> returnType = method2.getReturnType();
                String fullName = simpleName + CodegenUtils.prettyParams(paramTypes);
                if (implementedNames.contains(fullName)) continue;
                implementedNames.add(fullName);
                int baseIndex = 1;
                for (Class paramType : paramTypes) {
                    if (paramType == Double.TYPE || paramType == Long.TYPE) {
                        baseIndex += 2;
                        continue;
                    }
                    ++baseIndex;
                }
                int selfIndex = baseIndex;
                int rubyIndex = selfIndex + 1;
                SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(1, simpleName, CodegenUtils.sig(returnType, paramTypes), null, null));
                mv.start();
                mv.line(1);
                if (simpleName.equals("equals") && paramTypes.length == 1 && paramTypes[0] == Object.class && returnType == Boolean.TYPE) {
                    mv.line(2);
                    mv.aload(0);
                    mv.aload(1);
                    mv.invokespecial(CodegenUtils.p(Object.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                    mv.ireturn();
                } else if (simpleName.equals("hashCode") && paramTypes.length == 0 && returnType == Integer.TYPE) {
                    mv.line(3);
                    mv.aload(0);
                    mv.invokespecial(CodegenUtils.p(Object.class), "hashCode", CodegenUtils.sig(Integer.TYPE, new Class[0]));
                    mv.ireturn();
                } else if (simpleName.equals("toString") && paramTypes.length == 0 && returnType == String.class) {
                    mv.line(4);
                    mv.aload(0);
                    mv.invokespecial(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
                    mv.areturn();
                } else {
                    mv.line(5);
                    Label dispatch = new Label();
                    Label end2 = new Label();
                    Label recheckMethod = new Label();
                    mv.aload(0);
                    mv.getfield(pathName, "$self", CodegenUtils.ci(IRubyObject.class));
                    mv.astore(selfIndex);
                    mv.aload(selfIndex);
                    mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                    mv.astore(rubyIndex);
                    mv.getstatic(pathName, simpleName, CodegenUtils.ci(CacheEntry.class));
                    mv.dup();
                    mv.aload(selfIndex);
                    mv.invokestatic(CodegenUtils.p(MiniJava.class), "isCacheOk", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(CacheEntry.class, IRubyObject.class)));
                    mv.iftrue(dispatch);
                    mv.line(6);
                    mv.pop();
                    mv.getstatic(pathName, "$monitor", CodegenUtils.ci(Object.class));
                    mv.monitorenter();
                    Label tryStart = new Label();
                    Label tryEnd = new Label();
                    Label finallyStart = new Label();
                    Label finallyEnd = new Label();
                    mv.line(7);
                    mv.label(tryStart);
                    mv.aload(selfIndex);
                    for (String eachName : nameSet) {
                        mv.ldc(eachName);
                    }
                    mv.invokestatic(CodegenUtils.p(MiniJava.class), "searchWithCache", CodegenUtils.sig(CacheEntry.class, CodegenUtils.params(IRubyObject.class, String.class, nameSet.size())));
                    mv.putstatic(pathName, simpleName, CodegenUtils.ci(CacheEntry.class));
                    mv.getstatic(pathName, "$monitor", CodegenUtils.ci(Object.class));
                    mv.monitorexit();
                    mv.go_to(recheckMethod);
                    mv.label(tryEnd);
                    mv.label(finallyStart);
                    mv.line(9);
                    mv.getstatic(pathName, "$monitor", CodegenUtils.ci(Object.class));
                    mv.monitorexit();
                    mv.label(finallyEnd);
                    mv.athrow();
                    mv.trycatch(tryStart, tryEnd, finallyStart, null);
                    mv.trycatch(finallyStart, finallyEnd, finallyStart, null);
                    mv.label(recheckMethod);
                    mv.line(10);
                    mv.getstatic(pathName, simpleName, CodegenUtils.ci(CacheEntry.class));
                    mv.dup();
                    mv.getfield(CodegenUtils.p(CacheEntry.class), "method", CodegenUtils.ci(DynamicMethod.class));
                    mv.invokevirtual(CodegenUtils.p(DynamicMethod.class), "isUndefined", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
                    mv.iffalse(dispatch);
                    mv.line(11);
                    mv.pop();
                    mv.aload(selfIndex);
                    mv.ldc(simpleName);
                    MiniJava.coerceArgumentsToRuby(mv, paramTypes, rubyIndex);
                    mv.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "invokeMethodMissing", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class));
                    mv.go_to(end2);
                    mv.label(dispatch);
                    mv.line(12, dispatch);
                    mv.getfield(CodegenUtils.p(CacheEntry.class), "method", CodegenUtils.ci(DynamicMethod.class));
                    mv.aload(rubyIndex);
                    mv.invokevirtual(CodegenUtils.p(Ruby.class), "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
                    mv.aload(selfIndex);
                    mv.aload(selfIndex);
                    mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
                    mv.ldc(simpleName);
                    MiniJava.coerceArgumentsToRuby(mv, paramTypes, rubyIndex);
                    mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                    mv.line(13);
                    mv.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
                    mv.label(end2);
                    MiniJava.coerceResultAndReturn(mv, returnType);
                }
                mv.end();
            }
        }
        clinitMethod.voidreturn();
        clinitMethod.end();
        cw.visitEnd();
        byte[] bytes2 = cw.toByteArray();
        JRubyClassLoader jRubyClassLoader = ruby.getJRubyClassLoader();
        synchronized (jRubyClassLoader) {
            try {
                newClass = ruby.getJRubyClassLoader().loadClass(name2);
            }
            catch (ClassNotFoundException cnfe) {
                newClass = ruby.getJRubyClassLoader().defineClass(name2, cw.toByteArray());
            }
        }
        return newClass;
    }

    public static void coerceArgumentsToRuby(SkinnyMethodAdapter mv, Class[] paramTypes, int rubyIndex) {
        if (paramTypes.length != 0) {
            mv.pushInt(paramTypes.length);
            mv.anewarray(CodegenUtils.p(IRubyObject.class));
            int argIndex = 1;
            for (int i = 0; i < paramTypes.length; ++i) {
                Class paramType = paramTypes[i];
                mv.dup();
                mv.pushInt(i);
                mv.aload(rubyIndex);
                if (paramTypes[i].isPrimitive()) {
                    if (paramType == Byte.TYPE || paramType == Short.TYPE || paramType == Character.TYPE || paramType == Integer.TYPE) {
                        mv.iload(argIndex++);
                        mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Integer.TYPE));
                    } else if (paramType == Long.TYPE) {
                        mv.lload(argIndex);
                        argIndex += 2;
                        mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Long.TYPE));
                    } else if (paramType == Float.TYPE) {
                        mv.fload(argIndex++);
                        mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Float.TYPE));
                    } else if (paramType == Double.TYPE) {
                        mv.dload(argIndex);
                        argIndex += 2;
                        mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Double.TYPE));
                    } else if (paramType == Boolean.TYPE) {
                        mv.iload(argIndex++);
                        mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Boolean.TYPE));
                    }
                } else {
                    mv.aload(argIndex++);
                    mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToUsableRubyObject", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
                }
                mv.aastore();
            }
        } else {
            mv.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        }
    }

    public static void coerceResultAndReturn(SkinnyMethodAdapter mv, Class returnType) {
        if (returnType != Void.TYPE) {
            if (returnType.isPrimitive()) {
                if (returnType == Byte.TYPE) {
                    mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaByte", CodegenUtils.sig(Byte.TYPE, IRubyObject.class));
                    mv.ireturn();
                } else if (returnType == Short.TYPE) {
                    mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaShort", CodegenUtils.sig(Short.TYPE, IRubyObject.class));
                    mv.ireturn();
                } else if (returnType == Character.TYPE) {
                    mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaChar", CodegenUtils.sig(Character.TYPE, IRubyObject.class));
                    mv.ireturn();
                } else if (returnType == Integer.TYPE) {
                    mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaInt", CodegenUtils.sig(Integer.TYPE, IRubyObject.class));
                    mv.ireturn();
                } else if (returnType == Long.TYPE) {
                    mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaLong", CodegenUtils.sig(Long.TYPE, IRubyObject.class));
                    mv.lreturn();
                } else if (returnType == Float.TYPE) {
                    mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaFloat", CodegenUtils.sig(Float.TYPE, IRubyObject.class));
                    mv.freturn();
                } else if (returnType == Double.TYPE) {
                    mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaDouble", CodegenUtils.sig(Double.TYPE, IRubyObject.class));
                    mv.dreturn();
                } else if (returnType == Boolean.TYPE) {
                    mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaBoolean", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class));
                    mv.ireturn();
                }
            } else {
                mv.ldc(Type.getType(returnType));
                mv.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJava", CodegenUtils.sig(Object.class, IRubyObject.class, Class.class));
                mv.checkcast(CodegenUtils.p(returnType));
                mv.areturn();
            }
        } else {
            mv.voidreturn();
        }
    }

    public static RubyClass populateImplClass(Ruby ruby, Class newClass, Map<String, List<Method>> simpleToAll) {
        RubyClass rubyCls = (RubyClass)MiniJava.getMirrorForClass(ruby, newClass);
        try {
            newClass.getMethod("__setup__", RubyClass.class).invoke(null, rubyCls);
        }
        catch (IllegalAccessException ex) {
            throw MiniJava.error(ruby, ex, "Could not setup class: " + newClass);
        }
        catch (IllegalArgumentException ex) {
            throw MiniJava.error(ruby, ex, "Could not setup class: " + newClass);
        }
        catch (InvocationTargetException ex) {
            throw MiniJava.error(ruby, ex, "Could not setup class: " + newClass);
        }
        catch (NoSuchMethodException ex) {
            throw MiniJava.error(ruby, ex, "Could not setup class: " + newClass);
        }
        final HashMap<String, Field> allFields = new HashMap<String, Field>();
        try {
            for (Map.Entry<String, List<Method>> entry : simpleToAll.entrySet()) {
                String simpleName = entry.getKey();
                Field simpleField = newClass.getField(simpleName);
                allFields.put(simpleName, simpleField);
                for (Method method2 : entry.getValue()) {
                    String complexName = simpleName + CodegenUtils.prettyParams(method2.getParameterTypes());
                    String fieldName = MiniJava.mangleMethodFieldName(simpleName, method2.getParameterTypes());
                    allFields.put(complexName, newClass.getField(fieldName));
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw MiniJava.error(ruby, ex, "Could not prepare method fields: " + newClass);
        }
        catch (NoSuchFieldException ex) {
            throw MiniJava.error(ruby, ex, "Could not prepare method fields: " + newClass);
        }
        JavaMethod method_added2 = new JavaMethod((RubyModule)rubyCls.getSingletonClass(), Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                RubyClass selfClass = (RubyClass)self;
                Ruby ruby = selfClass.getClassRuntime();
                String methodName = args2[0].asJavaString();
                Field field2 = (Field)allFields.get(methodName);
                if (field2 != null) {
                    try {
                        field2.set(null, selfClass.searchMethod(methodName));
                    }
                    catch (IllegalAccessException iae) {
                        throw MiniJava.error(ruby, iae, "Could not set new method into field: " + selfClass + "." + methodName);
                    }
                    catch (IllegalArgumentException iae) {
                        throw MiniJava.error(ruby, iae, "Could not set new method into field: " + selfClass + "." + methodName);
                    }
                }
                return context.getRuntime().getNil();
            }
        };
        rubyCls.getSingletonClass().addMethod("method_added", method_added2);
        return rubyCls;
    }

    protected static String mangleMethodFieldName(String baseName, Class[] paramTypes) {
        String fieldName = baseName + CodegenUtils.prettyParams(paramTypes);
        fieldName = fieldName.replace('.', '\\');
        return fieldName;
    }

    protected static Class findClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        if (className.indexOf(46) == -1 && Character.isLowerCase(className.charAt(0))) {
            switch (className.charAt(0)) {
                case 'b': {
                    return Byte.TYPE;
                }
                case 's': {
                    return Short.TYPE;
                }
                case 'c': {
                    return Character.TYPE;
                }
                case 'i': {
                    return Integer.TYPE;
                }
                case 'l': {
                    return Long.TYPE;
                }
                case 'f': {
                    return Float.TYPE;
                }
                case 'd': {
                    return Double.TYPE;
                }
            }
            return classLoader.loadClass(className);
        }
        return classLoader.loadClass(className);
    }

    public static RubyModule getMirrorForClass(Ruby ruby, Class cls) {
        if (cls == null) {
            return ruby.getObject();
        }
        RubyModule rubyCls = classMap.get(cls);
        if (rubyCls == null) {
            rubyCls = MiniJava.createMirrorForClass(ruby, cls);
            classMap.put(cls, rubyCls);
            MiniJava.populateMirrorForClass(rubyCls, cls);
            rubyCls = classMap.get(cls);
        }
        return rubyCls;
    }

    protected static RubyModule createMirrorForClass(Ruby ruby, Class cls) {
        if (cls.isInterface()) {
            RubyModule rubyMod = RubyModule.newModule(ruby);
            return rubyMod;
        }
        RubyClass rubyCls = RubyClass.newClass(ruby, (RubyClass)MiniJava.getMirrorForClass(ruby, cls.getSuperclass()));
        return rubyCls;
    }

    protected static void populateMirrorForClass(RubyModule rubyMod, Class cls) {
        Class<?>[] interfaces2;
        Ruby ruby = rubyMod.getRuntime();
        rubyMod.setBaseName(cls.getCanonicalName());
        for (Class<?> ifc : interfaces2 = cls.getInterfaces()) {
            rubyMod.includeModule(MiniJava.getMirrorForClass(ruby, ifc));
        }
        if (cls.getEnclosingClass() != null && !Modifier.isPublic(cls.getModifiers())) {
            return;
        }
        RubyClass rubySing = rubyMod.getSingletonClass();
        if (cls.isArray()) {
            MiniJava.populateMirrorForArrayClass(rubyMod, cls);
        } else {
            MiniJava.populateDeclaredMethods(rubyMod, cls, true);
            MiniJava.populateConstructors(rubySing, cls);
            MiniJava.populateArrayConstructors(rubySing);
            MiniJava.populateFields(rubyMod, cls);
        }
        MiniJava.populateSpecialMethods(rubyMod, rubySing, cls);
    }

    private static void populateArrayConstructors(RubyModule rubySing) {
        rubySing.addMethod("[]", new JavaMethod.JavaMethodOneOrTwoOrThree(rubySing, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
                Class javaClass = MiniJava.getJavaClassFromObject(self);
                int size2 = RubyFixnum.fix2int(arg2.convertToInteger());
                return MiniJava.javaToRuby(context.getRuntime(), Array.newInstance(javaClass, size2));
            }

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
                Class javaClass = MiniJava.getJavaClassFromObject(self);
                int x = RubyFixnum.fix2int(arg0.convertToInteger());
                int y = RubyFixnum.fix2int(arg1.convertToInteger());
                return MiniJava.javaToRuby(context.getRuntime(), Array.newInstance(javaClass, x, y));
            }

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
                Class javaClass = MiniJava.getJavaClassFromObject(self);
                int x = RubyFixnum.fix2int(arg0.convertToInteger());
                int y = RubyFixnum.fix2int(arg1.convertToInteger());
                int z = RubyFixnum.fix2int(arg2.convertToInteger());
                return MiniJava.javaToRuby(context.getRuntime(), Array.newInstance(javaClass, x, y, z));
            }
        });
    }

    private static void populateConstructors(RubyModule rubySing, final Class cls) {
        Constructor<?>[] constructors2;
        final Ruby ruby = rubySing.getRuntime();
        for (final Constructor<?> constructor2 : constructors2 = cls.getConstructors()) {
            JavaMethod.JavaMethodN dynMethod = constructor2.getParameterTypes().length == 0 ? new JavaMethod.JavaMethodZero(rubySing, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
                    try {
                        return MiniJava.javaToRuby(context.getRuntime(), constructor2.newInstance(new Object[0]));
                    }
                    catch (InstantiationException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor2.getParameterTypes()));
                    }
                    catch (IllegalAccessException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor2.getParameterTypes()));
                    }
                    catch (IllegalArgumentException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor2.getParameterTypes()));
                    }
                    catch (InvocationTargetException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor2.getParameterTypes()));
                    }
                }
            } : new JavaMethod.JavaMethodN(rubySing, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] rubyArgs) {
                    Object[] args2 = new Object[rubyArgs.length];
                    for (int i = 0; i < args2.length; ++i) {
                        args2[i] = MiniJava.rubyToJava(rubyArgs[i]);
                    }
                    try {
                        return MiniJava.javaToRuby(ruby, constructor2.newInstance(args2));
                    }
                    catch (InstantiationException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor2.getParameterTypes()));
                    }
                    catch (IllegalAccessException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor2.getParameterTypes()));
                    }
                    catch (IllegalArgumentException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor2.getParameterTypes()));
                    }
                    catch (InvocationTargetException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor2.getParameterTypes()));
                    }
                }
            };
            if (rubySing.getMethods().get("new") == null) {
                rubySing.addMethod("new", dynMethod);
            }
            rubySing.addMethod("new" + CodegenUtils.prettyParams(constructor2.getParameterTypes()), dynMethod);
        }
    }

    private static void populateDeclaredMethods(RubyModule rubyMod, Class cls, boolean includeStatic) throws SecurityException {
        Method[] methods2;
        for (Method method2 : methods2 = cls.getDeclaredMethods()) {
            RubyModule target;
            String name2 = method2.getName();
            if (!Modifier.isPublic(method2.getModifiers())) continue;
            if (Modifier.isStatic(method2.getModifiers())) {
                if (!includeStatic) continue;
                target = rubyMod.getSingletonClass();
            } else {
                target = rubyMod;
            }
            JavaMethodFactory factory = MiniJava.getMethodFactory(method2.getReturnType());
            DynamicMethod dynMethod = factory.createMethod(target, method2);
            if (target.getMethods().get(name2) == null) {
                target.addMethod(name2, dynMethod);
            }
            name2 = name2 + CodegenUtils.prettyParams(method2.getParameterTypes());
            target.addMethod(name2, dynMethod);
        }
    }

    private static void populateSpecialMethods(RubyModule rubyMod, RubyModule rubySing, final Class cls) {
        final Ruby ruby = rubyMod.getRuntime();
        rubySing.addMethod("java_class", new JavaMethod.JavaMethodZero(rubySing, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
                return MiniJava.javaToRuby(ruby, cls);
            }
        });
    }

    private static void populateFields(RubyModule rubyMod, Class cls) throws RaiseException, SecurityException {
        Field[] fields2;
        Ruby ruby = rubyMod.getRuntime();
        for (Field field2 : fields2 = cls.getDeclaredFields()) {
            if (!Modifier.isStatic(field2.getModifiers()) || !Modifier.isPublic(field2.getModifiers()) || !IdUtil.isConstant(field2.getName())) continue;
            Object value2 = null;
            try {
                value2 = field2.get(null);
            }
            catch (Exception e) {
                throw ruby.newTypeError("Could not access field " + cls.getCanonicalName() + "::" + field2.getName() + " using " + CodegenUtils.ci(field2.getType()));
            }
            rubyMod.defineConstant(field2.getName(), new JavaObjectWrapper((RubyClass)MiniJava.getMirrorForClass(ruby, value2.getClass()), value2));
        }
    }

    protected static void populateMirrorForArrayClass(RubyModule rubyMod, Class cls) {
        final Ruby ruby = rubyMod.getRuntime();
        rubyMod.addMethod("[]", new JavaMethod.JavaMethodOneOrTwo(rubyMod, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
                Object array = MiniJava.rubyToJava(self);
                int x = RubyFixnum.fix2int(arg2.convertToInteger());
                return MiniJava.javaToRuby(ruby, Array.get(array, x));
            }

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
                Object array = MiniJava.rubyToJava(self);
                int x = RubyFixnum.fix2int(arg0.convertToInteger());
                int y = RubyFixnum.fix2int(arg1.convertToInteger());
                return MiniJava.javaToRuby(ruby, Array.get(Array.get(array, x), y));
            }
        });
        rubyMod.addMethod("[]=", new JavaMethod.JavaMethodTwoOrThree(rubyMod, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
                Object array = MiniJava.rubyToJava(self);
                int x = RubyFixnum.fix2int(arg0.convertToInteger());
                Object obj = MiniJava.rubyToJava(arg1);
                Array.set(array, x, obj);
                return arg1;
            }

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
                Object array = MiniJava.rubyToJava(self);
                int x = RubyFixnum.fix2int(arg0.convertToInteger());
                int y = RubyFixnum.fix2int(arg1.convertToInteger());
                Object obj = MiniJava.rubyToJava(arg2);
                Array.set(Array.get(array, x), y, obj);
                return arg2;
            }
        });
        rubyMod.addMethod("length", new JavaMethod.JavaMethodZero(rubyMod, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
                Object array = MiniJava.rubyToJava(self);
                return MiniJava.javaToRuby(ruby, Array.getLength(array));
            }
        });
    }

    protected static JavaMethodFactory getMethodFactory(Class returnType) {
        JavaMethodFactory factory = methodFactories.get(returnType);
        if (factory == null) {
            return JAVA_OBJECT_METHOD_FACTORY;
        }
        return factory;
    }

    protected static RaiseException error(Ruby ruby, Exception e, String message2) throws RaiseException {
        if (ruby.getDebug().isTrue()) {
            e.printStackTrace();
        }
        throw ruby.newTypeError(message2);
    }

    public static Object rubyToJava(IRubyObject object) {
        if (object.isNil()) {
            return null;
        }
        if (object instanceof JavaObjectWrapper) {
            return ((JavaObjectWrapper)object).object;
        }
        return object;
    }

    public static IRubyObject javaToRuby(Ruby ruby, Object object) {
        if (object == null) {
            return ruby.getNil();
        }
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        return new JavaObjectWrapper((RubyClass)MiniJava.getMirrorForClass(ruby, object.getClass()), object);
    }

    public static Class getJavaClassFromObject(IRubyObject obj) {
        if (!obj.respondsTo("java_class")) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass().getBaseName() + " is not a Java type");
        }
        return (Class)MiniJava.rubyToJava(obj.callMethod(obj.getRuntime().getCurrentContext(), "java_class"));
    }

    public static CacheEntry searchWithCache(RubyClass clazz, String name1) {
        return clazz.searchWithCache(name1);
    }

    public static CacheEntry searchWithCache(RubyClass clazz, String name1, String name2) {
        CacheEntry entry = clazz.searchWithCache(name1);
        if (entry.method == UndefinedMethod.INSTANCE) {
            return MiniJava.searchWithCache(clazz, name2);
        }
        return entry;
    }

    public static CacheEntry searchWithCache(RubyClass clazz, String name1, String name2, String name3) {
        CacheEntry entry = clazz.searchWithCache(name1);
        if (entry.method == UndefinedMethod.INSTANCE) {
            return MiniJava.searchWithCache(clazz, name2, name3);
        }
        return entry;
    }

    public static CacheEntry searchWithCache(RubyClass clazz, String name1, String name2, String name3, String name4) {
        CacheEntry entry = clazz.searchWithCache(name1);
        if (entry.method == UndefinedMethod.INSTANCE) {
            return MiniJava.searchWithCache(clazz, name2, name3, name4);
        }
        return entry;
    }

    public static CacheEntry searchWithCache(RubyClass clazz, String name1, String name2, String name3, String name4, String name5) {
        CacheEntry entry = clazz.searchWithCache(name1);
        if (entry.method == UndefinedMethod.INSTANCE) {
            return MiniJava.searchWithCache(clazz, name2, name3, name4, name5);
        }
        return entry;
    }

    public static CacheEntry searchWithCache(RubyClass clazz, String name1, String name2, String name3, String name4, String name5, String name6) {
        CacheEntry entry = clazz.searchWithCache(name1);
        if (entry.method == UndefinedMethod.INSTANCE) {
            return MiniJava.searchWithCache(clazz, name2, name3, name4, name5, name6);
        }
        return entry;
    }

    public static CacheEntry searchWithCache(RubyClass clazz, String name1, String name2, String name3, String name4, String name5, String name6, String name7) {
        CacheEntry entry = clazz.searchWithCache(name1);
        if (entry.method == UndefinedMethod.INSTANCE) {
            return MiniJava.searchWithCache(clazz, name2, name3, name4, name5, name6, name7);
        }
        return entry;
    }

    public static CacheEntry searchWithCache(RubyClass clazz, String name1, String name2, String name3, String name4, String name5, String name6, String name7, String name8) {
        CacheEntry entry = clazz.searchWithCache(name1);
        if (entry.method == UndefinedMethod.INSTANCE) {
            return MiniJava.searchWithCache(clazz, name2, name3, name4, name5, name6, name7, name8);
        }
        return entry;
    }

    public static CacheEntry searchWithCache(IRubyObject obj, String name1) {
        return MiniJava.searchWithCache(obj.getMetaClass(), name1);
    }

    public static CacheEntry searchWithCache(IRubyObject obj, String name1, String name2) {
        return MiniJava.searchWithCache(obj.getMetaClass(), name1, name2);
    }

    public static CacheEntry searchWithCache(IRubyObject obj, String name1, String name2, String name3) {
        return MiniJava.searchWithCache(obj.getMetaClass(), name1, name2, name3);
    }

    public static CacheEntry searchWithCache(IRubyObject obj, String name1, String name2, String name3, String name4) {
        return MiniJava.searchWithCache(obj.getMetaClass(), name1, name2, name3, name4);
    }

    public static CacheEntry searchWithCache(IRubyObject obj, String name1, String name2, String name3, String name4, String name5) {
        return MiniJava.searchWithCache(obj.getMetaClass(), name1, name2, name3, name4, name5);
    }

    public static CacheEntry searchWithCache(IRubyObject obj, String name1, String name2, String name3, String name4, String name5, String name6) {
        return MiniJava.searchWithCache(obj.getMetaClass(), name1, name2, name3, name4, name5, name6);
    }

    public static CacheEntry searchWithCache(IRubyObject obj, String name1, String name2, String name3, String name4, String name5, String name6, String name7) {
        return MiniJava.searchWithCache(obj.getMetaClass(), name1, name2, name3, name4, name5, name6, name7);
    }

    public static CacheEntry searchWithCache(IRubyObject obj, String name1, String name2, String name3, String name4, String name5, String name6, String name7, String name8) {
        return MiniJava.searchWithCache(obj.getMetaClass(), name1, name2, name3, name4, name5, name6, name7, name8);
    }

    public static boolean isCacheOk(CacheEntry entry, IRubyObject self) {
        return entry.typeOk(self.getMetaClass()) && entry.method != UndefinedMethod.INSTANCE;
    }

    static {
        methodFactories.put(Void.TYPE, new JavaMethodFactory(){

            public DynamicMethod createMethod(RubyModule klazz, Method method2) {
                Class<?>[] parameters = method2.getParameterTypes();
                if (parameters.length > 0) {
                    return new JavaVoidWrapperMethod(klazz, method2);
                }
                return new JavaVoidWrapperMethodZero(klazz, method2);
            }
        });
    }

    public static class JavaObjectWrapper
    extends RubyObject {
        Object object;

        public JavaObjectWrapper(RubyClass klazz, Object object) {
            super(klazz.getRuntime(), klazz);
            this.object = object;
        }
    }

    protected static class JavaVoidWrapperMethodZero
    extends AbstractJavaWrapperMethodZero {
        public JavaVoidWrapperMethodZero(RubyModule klazz, Method method2) {
            super(klazz, method2);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return self;
        }
    }

    protected static class JavaVoidWrapperMethod
    extends AbstractJavaWrapperMethod {
        public JavaVoidWrapperMethod(RubyModule klazz, Method method2) {
            super(klazz, method2);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            Object[] newArgs = new Object[args2.length];
            for (int i = 0; i < args2.length; ++i) {
                IRubyObject arg2 = args2[i];
                newArgs[i] = MiniJava.rubyToJava(arg2);
            }
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, newArgs);
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0));
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1));
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1), MiniJava.rubyToJava(arg2));
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            Object[] newArgs = new Object[args2.length];
            for (int i = 0; i < args2.length; ++i) {
                IRubyObject arg2 = args2[i];
                newArgs[i] = MiniJava.rubyToJava(arg2);
            }
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, newArgs);
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0));
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1));
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1), MiniJava.rubyToJava(arg2));
            return self;
        }
    }

    protected static class JavaObjectWrapperMethod
    extends AbstractJavaWrapperMethod {
        public JavaObjectWrapperMethod(RubyModule klazz, Method method2) {
            super(klazz, method2);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            Object[] newArgs = new Object[args2.length];
            for (int i = 0; i < args2.length; ++i) {
                IRubyObject arg2 = args2[i];
                newArgs[i] = MiniJava.rubyToJava(arg2);
            }
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, newArgs);
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0));
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1));
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1), MiniJava.rubyToJava(arg2));
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            Object[] newArgs = new Object[args2.length];
            for (int i = 0; i < args2.length; ++i) {
                IRubyObject arg2 = args2[i];
                newArgs[i] = MiniJava.rubyToJava(arg2);
            }
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, newArgs);
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0));
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1));
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1), MiniJava.rubyToJava(arg2));
            return MiniJava.javaToRuby(this.ruby, result);
        }
    }

    protected static class JavaObjectWrapperMethodZero
    extends AbstractJavaWrapperMethodZero {
        public JavaObjectWrapperMethodZero(RubyModule klazz, Method method2) {
            super(klazz, method2);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return MiniJava.javaToRuby(this.ruby, result);
        }
    }

    public static abstract class AbstractJavaWrapperMethod
    extends JavaMethod {
        protected final HandleFactory.Handle handle;
        protected final boolean isStatic;
        protected final String className;
        protected final String methodName;
        protected final String prettySig;
        protected final Ruby ruby;

        public AbstractJavaWrapperMethod(RubyModule klazz, Method method2) {
            super(klazz, Visibility.PUBLIC);
            this.handle = HandleFactory.createHandle(klazz.getRuntime().getJRubyClassLoader(), method2);
            this.isStatic = Modifier.isStatic(method2.getModifiers());
            this.className = method2.getDeclaringClass().getCanonicalName();
            this.methodName = method2.getName();
            this.prettySig = CodegenUtils.prettyParams(method2.getParameterTypes());
            this.ruby = klazz.getRuntime();
        }

        protected RaiseException error(Exception e) throws RaiseException {
            return MiniJava.error(this.ruby, e, "Could not dispatch to " + this.className + "#" + this.methodName + " using " + this.prettySig);
        }
    }

    public static abstract class AbstractJavaWrapperMethodZero
    extends JavaMethod.JavaMethodZero {
        protected final HandleFactory.Handle handle;
        protected final boolean isStatic;
        protected final String className;
        protected final String methodName;
        protected final String prettySig;
        protected final Ruby ruby;

        public AbstractJavaWrapperMethodZero(RubyModule klazz, Method method2) {
            super(klazz, Visibility.PUBLIC);
            this.handle = HandleFactory.createHandle(klazz.getRuntime().getJRubyClassLoader(), method2);
            this.isStatic = Modifier.isStatic(method2.getModifiers());
            this.className = method2.getDeclaringClass().getCanonicalName();
            this.methodName = method2.getName();
            this.prettySig = CodegenUtils.prettyParams(method2.getParameterTypes());
            this.ruby = klazz.getRuntime();
        }

        protected RaiseException error(ThreadContext context, Exception e) throws RaiseException {
            if (this.ruby.getDebug().isTrue()) {
                e.printStackTrace();
            }
            throw this.ruby.newTypeError("Could not dispatch to " + this.className + "#" + this.methodName + " using " + this.prettySig);
        }
    }

    public static class JavaMethodFactory {
        public DynamicMethod createMethod(RubyModule klazz, Method method2) {
            Class<?>[] params2 = method2.getParameterTypes();
            if (params2.length > 0) {
                return new JavaObjectWrapperMethod(klazz, method2);
            }
            return new JavaObjectWrapperMethodZero(klazz, method2);
        }
    }
}

