/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import org.jruby.compiler.ir.OpType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Operation {
    NOP(OpType.dont_care),
    COPY(OpType.dont_care),
    TYPE_CVT(OpType.dont_care),
    BOX_VAL(OpType.dont_care),
    UNBOX_OBJ(OpType.dont_care),
    ADD(OpType.alu_op),
    SUB(OpType.alu_op),
    MUL(OpType.alu_op),
    DIV(OpType.alu_op),
    OR(OpType.alu_op),
    AND(OpType.alu_op),
    XOR(OpType.alu_op),
    NOT(OpType.alu_op),
    LSHIFT(OpType.alu_op),
    RSHIFT(OpType.alu_op),
    GET_METHOD(OpType.dont_care),
    RETURN(OpType.ret_op),
    CLOSURE_RETURN(OpType.ret_op),
    RECV_ARG(OpType.recv_arg_op),
    RECV_CLOSURE(OpType.recv_arg_op),
    RECV_OPT_ARG(OpType.recv_arg_op),
    RECV_CLOSURE_ARG(OpType.recv_arg_op),
    CALL(OpType.call_op),
    JRUBY_IMPL(OpType.call_op),
    RUBY_INTERNALS(OpType.call_op),
    ATTR_ASSIGN(OpType.call_op),
    DECLARE_TYPE(OpType.declare_type_op),
    YIELD(OpType.dont_care),
    EVAL_OP(OpType.eval_op),
    CLASS_EVAL(OpType.eval_op),
    DEF_INST_METH(OpType.dont_care),
    DEF_CLASS_METH(OpType.dont_care),
    THROW(OpType.dont_care),
    RESCUE(OpType.dont_care),
    RETRY(OpType.dont_care),
    GET_CONST(OpType.load_op),
    GET_GLOBAL_VAR(OpType.load_op),
    GET_FIELD(OpType.load_op),
    GET_CVAR(OpType.load_op),
    GET_ARRAY(OpType.load_op),
    PUT_CONST(OpType.store_op),
    PUT_GLOBAL_VAR(OpType.store_op),
    PUT_FIELD(OpType.store_op),
    PUT_ARRAY(OpType.store_op),
    PUT_CVAR(OpType.store_op),
    BREAK(OpType.branch_op),
    JUMP(OpType.branch_op),
    BEQ(OpType.branch_op),
    BNE(OpType.branch_op),
    BLE(OpType.branch_op),
    BLT(OpType.branch_op),
    BGE(OpType.branch_op),
    BGT(OpType.branch_op),
    LABEL(OpType.dont_care),
    THREAD_POLL(OpType.dont_care),
    IS_TRUE(OpType.dont_care),
    EQQ(OpType.dont_care),
    CASE(OpType.branch_op),
    ASSERT_METHOD_VERSION(OpType.guard_op);

    private OpType _type;

    private Operation(OpType t) {
        this._type = t;
    }

    public boolean isALU() {
        return this._type == OpType.alu_op;
    }

    public boolean isBranch() {
        return this._type == OpType.branch_op;
    }

    public boolean isLoad() {
        return this._type == OpType.load_op;
    }

    public boolean isStore() {
        return this._type == OpType.store_op;
    }

    public boolean isCall() {
        return this._type == OpType.call_op;
    }

    public boolean isEval() {
        return this._type == OpType.eval_op;
    }

    public boolean isReturn() {
        return this._type == OpType.ret_op;
    }

    public boolean startsBasicBlock() {
        return this == LABEL;
    }

    public boolean endsBasicBlock() {
        return this.isBranch();
    }

    public boolean hasSideEffects() {
        return this.isCall() || this.isEval() || this.isStore() || this.isReturn();
    }
}

