/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRunnable
implements Runnable {
    private Ruby runtime;
    private RubyProc proc;
    private IRubyObject[] arguments;
    private RubyThread rubyThread;
    private Frame currentFrame;
    private Thread javaThread;
    private static boolean warnedAboutTC = false;

    public RubyRunnable(RubyThread rubyThread, IRubyObject[] args2, Block currentBlock) {
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        ThreadContext tc = this.runtime.getCurrentContext();
        this.proc = this.runtime.newProc(Block.Type.THREAD, currentBlock);
        this.currentFrame = tc.getCurrentFrame().duplicate();
        this.arguments = args2;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    public Thread getJavaThread() {
        return this.javaThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ClassLoader oldContextClassLoader;
        ThreadContext context;
        block23: {
            this.javaThread = Thread.currentThread();
            context = this.runtime.getThreadService().registerNewThread(this.rubyThread);
            oldContextClassLoader = null;
            try {
                oldContextClassLoader = this.javaThread.getContextClassLoader();
                this.javaThread.setContextClassLoader(this.runtime.getJRubyClassLoader());
            }
            catch (SecurityException se) {
                if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block23;
                System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
            }
        }
        context.preRunThread(this.currentFrame);
        try {
            try {
                IRubyObject result = this.proc.call(context, this.arguments);
                this.rubyThread.cleanTerminate(result);
            }
            catch (JumpException.ReturnJump rj) {
                this.rubyThread.exceptionRaised(this.runtime.newThreadError("return can't jump across threads"));
            }
            catch (RaiseException e) {
                this.rubyThread.exceptionRaised(e);
            }
            catch (MainExitException mee) {
                this.runtime.getThreadService().getMainThread().kill();
            }
            finally {
                block25: {
                    this.rubyThread.beDead();
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    try {
                        this.javaThread.setContextClassLoader(oldContextClassLoader);
                    }
                    catch (SecurityException se) {
                        if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block25;
                        System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                    }
                }
            }
        }
        catch (ThreadKill threadKill) {
            // empty catch block
        }
    }
}

