/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalAsgnNode
extends AssignableNode
implements INameNode {
    private String name;
    private GlobalVariable gvar;

    public GlobalAsgnNode(ISourcePosition position, String name2, Node valueNode) {
        super(position, valueNode);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.GLOBALASGNNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitGlobalAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return GlobalAsgnNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result = this.getValueNode().interpret(runtime2, context, self, aBlock);
        return this.setGlobal(context, this.name, result);
    }

    @Override
    public IRubyObject assign(Ruby runtime2, ThreadContext context, IRubyObject self, IRubyObject value2, Block block, boolean checkArity) {
        return this.setGlobal(context, this.name, value2);
    }

    private IRubyObject setGlobal(ThreadContext context, String name2, IRubyObject value2) {
        Ruby runtime2 = context.getRuntime();
        if (this.gvar == null) {
            this.gvar = runtime2.getGlobalVariables().getVariableForSet(name2);
        }
        this.gvar.getAccessor().setValue(value2);
        this.gvar.trace(value2);
        return value2;
    }
}

