/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.ShellLauncher;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.STDIO;
import org.jruby.util.io.Stream;

@JRubyClass(name={"IO"}, include={"Enumerable"})
public class RubyIO
extends RubyObject {
    protected OpenFile openFile;
    protected List<RubyThread> blockingThreads;
    protected static AtomicInteger filenoIndex = new AtomicInteger(2);
    private static ObjectAllocator IO_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyIO(runtime2, klass);
        }
    };
    private static String vendor;
    private static String msgEINTR;
    private static final ByteList NIL_BYTELIST;
    private static final ByteList RECURSIVE_BYTELIST;

    public void registerDescriptor(ChannelDescriptor descriptor, boolean isRetained) {
        this.getRuntime().registerDescriptor(descriptor, isRetained);
    }

    public void registerDescriptor(ChannelDescriptor descriptor) {
        this.registerDescriptor(descriptor, false);
    }

    public void unregisterDescriptor(int aFileno) {
        this.getRuntime().unregisterDescriptor(aFileno);
    }

    public ChannelDescriptor getDescriptorByFileno(int aFileno) {
        return this.getRuntime().getDescriptorByFileno(aFileno);
    }

    public static int getNewFileno() {
        return filenoIndex.incrementAndGet();
    }

    public RubyIO(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.openFile = new OpenFile();
    }

    public RubyIO(Ruby runtime2, OutputStream outputStream) {
        super(runtime2, runtime2.getIO());
        if (outputStream == null) {
            throw runtime2.newRuntimeError("Opening null stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(runtime2, new ChannelDescriptor(Channels.newChannel(outputStream), RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(66);
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby runtime2, InputStream inputStream) {
        super(runtime2, runtime2.getIO());
        if (inputStream == null) {
            throw runtime2.newRuntimeError("Opening null stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(runtime2, new ChannelDescriptor(Channels.newChannel(inputStream), RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(1);
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby runtime2, Channel channel) {
        super(runtime2, runtime2.getIO());
        if (channel == null) {
            throw runtime2.newRuntimeError("Opening null channelpo");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(runtime2, new ChannelDescriptor(channel, RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby runtime2, ShellLauncher.POpenProcess process, ModeFlags modes) {
        super(runtime2, runtime2.getIO());
        this.openFile = new OpenFile();
        this.openFile.setMode(modes.getOpenFileFlags() | 8);
        this.openFile.setProcess(process);
        try {
            if (this.openFile.isReadable()) {
                ReadableByteChannel inChannel = process.getInput() != null ? process.getInput() : Channels.newChannel(process.getInputStream());
                ChannelDescriptor main2 = new ChannelDescriptor(inChannel, RubyIO.getNewFileno(), new FileDescriptor());
                main2.setCanBeSeekable(false);
                this.openFile.setMainStream(new ChannelStream(this.getRuntime(), main2));
                this.registerDescriptor(main2);
            }
            if (this.openFile.isWritable() && process.hasOutput()) {
                WritableByteChannel outChannel = process.getOutput() != null ? process.getOutput() : Channels.newChannel(process.getOutputStream());
                ChannelDescriptor pipe2 = new ChannelDescriptor(outChannel, RubyIO.getNewFileno(), new FileDescriptor());
                pipe2.setCanBeSeekable(false);
                if (this.openFile.getMainStream() != null) {
                    this.openFile.setPipeStream(new ChannelStream(this.getRuntime(), pipe2));
                } else {
                    this.openFile.setMainStream(new ChannelStream(this.getRuntime(), pipe2));
                }
                this.registerDescriptor(pipe2);
            }
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
    }

    public RubyIO(Ruby runtime2, STDIO stdio) {
        super(runtime2, runtime2.getIO());
        this.openFile = new OpenFile();
        try {
            switch (stdio) {
                case IN: {
                    this.openFile.setMainStream(new ChannelStream(runtime2, new ChannelDescriptor(runtime2.getIn(), 0, new ModeFlags(0L), FileDescriptor.in), FileDescriptor.in));
                    break;
                }
                case OUT: {
                    this.openFile.setMainStream(new ChannelStream(runtime2, new ChannelDescriptor(Channels.newChannel(runtime2.getOut()), 1, new ModeFlags(9L), FileDescriptor.out), FileDescriptor.out));
                    this.openFile.getMainStream().setSync(true);
                    break;
                }
                case ERR: {
                    this.openFile.setMainStream(new ChannelStream(runtime2, new ChannelDescriptor(Channels.newChannel(runtime2.getErr()), 2, new ModeFlags(9L), FileDescriptor.err), FileDescriptor.err));
                    this.openFile.getMainStream().setSync(true);
                }
            }
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public static RubyIO newIO(Ruby runtime2, Channel channel) {
        return new RubyIO(runtime2, channel);
    }

    public OpenFile getOpenFile() {
        return this.openFile;
    }

    protected OpenFile getOpenFileChecked() {
        this.openFile.checkClosed(this.getRuntime());
        return this.openFile;
    }

    public static RubyClass createIOClass(Ruby runtime2) {
        RubyClass ioClass = runtime2.defineClass("IO", runtime2.getObject(), IO_ALLOCATOR);
        ioClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyIO;
            }
        };
        ioClass.includeModule(runtime2.getEnumerable());
        ioClass.defineAnnotatedMethods(RubyIO.class);
        ioClass.fastSetConstant("SEEK_SET", runtime2.newFixnum(0));
        ioClass.fastSetConstant("SEEK_CUR", runtime2.newFixnum(1));
        ioClass.fastSetConstant("SEEK_END", runtime2.newFixnum(2));
        return ioClass;
    }

    public OutputStream getOutStream() {
        return this.getOpenFileChecked().getMainStream().newOutputStream();
    }

    public InputStream getInStream() {
        return this.getOpenFileChecked().getMainStream().newInputStream();
    }

    public Channel getChannel() {
        if (this.getOpenFileChecked().getMainStream() instanceof ChannelStream) {
            return ((ChannelStream)this.openFile.getMainStream()).getDescriptor().getChannel();
        }
        return null;
    }

    public Stream getHandler() {
        return this.getOpenFileChecked().getMainStream();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"reopen"}, required=1, optional=1)
    public IRubyObject reopen(ThreadContext context, IRubyObject[] args2) throws InvalidValueException {
        Ruby runtime2 = context.getRuntime();
        if (args2.length < 1) {
            throw runtime2.newArgumentError("wrong number of arguments");
        }
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(args2[0], runtime2.getIO(), "to_io");
        if (!tmp.isNil()) {
            try {
                RubyIO ios = (RubyIO)tmp;
                if (ios.openFile == this.openFile) {
                    return this;
                }
                OpenFile originalFile = ios.getOpenFileChecked();
                OpenFile selfFile = this.getOpenFileChecked();
                long pos2 = 0L;
                if (originalFile.isReadable()) {
                    pos2 = originalFile.getMainStream().fgetpos();
                }
                if (originalFile.getPipeStream() != null) {
                    originalFile.getPipeStream().fflush();
                } else if (originalFile.isWritable()) {
                    originalFile.getMainStream().fflush();
                }
                if (selfFile.isWritable()) {
                    selfFile.getWriteStream().fflush();
                }
                selfFile.setMode(originalFile.getMode());
                selfFile.setProcess(originalFile.getProcess());
                selfFile.setLineNumber(originalFile.getLineNumber());
                selfFile.setPath(originalFile.getPath());
                selfFile.setFinalizer(originalFile.getFinalizer());
                ChannelDescriptor selfDescriptor = selfFile.getMainStream().getDescriptor();
                ChannelDescriptor originalDescriptor = originalFile.getMainStream().getDescriptor();
                if (selfDescriptor.getChannel() != originalDescriptor.getChannel()) {
                    if (selfDescriptor.getFileno() >= 0 && selfDescriptor.getFileno() <= 2) {
                        selfFile.getMainStream().clearerr();
                        originalDescriptor.dup2Into(selfDescriptor);
                        this.registerDescriptor(selfDescriptor);
                    } else {
                        Stream pipeFile = selfFile.getPipeStream();
                        int mode2 = selfFile.getMode();
                        selfFile.getMainStream().fclose();
                        selfFile.setPipeStream(null);
                        if (pipeFile != null) {
                            selfFile.setMainStream(ChannelStream.fdopen(runtime2, originalDescriptor, new ModeFlags()));
                            selfFile.setPipeStream(pipeFile);
                        } else {
                            selfFile.setMainStream(new ChannelStream(runtime2, originalDescriptor.dup2(selfDescriptor.getFileno())));
                            this.registerDescriptor(selfFile.getMainStream().getDescriptor());
                            selfFile.getMainStream().setSync(selfFile.getMainStream().isSync());
                        }
                        selfFile.setMode(mode2);
                    }
                    if (originalFile.isReadable() && pos2 >= 0L) {
                        selfFile.seek(pos2, 0);
                        originalFile.seek(pos2, 0);
                    }
                }
                if (selfFile.getPipeStream() == null || selfDescriptor.getFileno() == selfFile.getPipeStream().getDescriptor().getFileno()) return this;
                int fd = selfFile.getPipeStream().getDescriptor().getFileno();
                if (originalFile.getPipeStream() == null) {
                    selfFile.getPipeStream().fclose();
                    selfFile.setPipeStream(null);
                    return this;
                }
                if (fd == originalFile.getPipeStream().getDescriptor().getFileno()) return this;
                selfFile.getPipeStream().fclose();
                ChannelDescriptor newFD2 = originalFile.getPipeStream().getDescriptor().dup2(fd);
                selfFile.setPipeStream(ChannelStream.fdopen(runtime2, newFD2, RubyIO.getIOModes(runtime2, "w")));
                this.registerDescriptor(newFD2);
                return this;
            }
            catch (IOException ex) {
                throw runtime2.newIOError("could not reopen: " + ex.getMessage());
            }
            catch (BadDescriptorException ex) {
                throw runtime2.newIOError("could not reopen: " + ex.getMessage());
            }
            catch (PipeException ex) {
                throw runtime2.newIOError("could not reopen: " + ex.getMessage());
            }
        }
        RubyString pathString = args2[0].convertToString();
        if (this.openFile == null) {
            this.openFile = new OpenFile();
        }
        try {
            ModeFlags modes;
            if (args2.length > 1) {
                RubyString modeString = args2[1].convertToString();
                modes = RubyIO.getIOModes(runtime2, ((Object)modeString).toString());
                this.openFile.setMode(modes.getOpenFileFlags());
            } else {
                modes = RubyIO.getIOModes(runtime2, "r");
            }
            String path2 = ((Object)pathString).toString();
            this.openFile.setPath(path2);
            if (this.openFile.getMainStream() == null) {
                try {
                    this.openFile.setMainStream(ChannelStream.fopen(runtime2, path2, modes));
                }
                catch (FileExistsException fee) {
                    throw runtime2.newErrnoEEXISTError(path2);
                }
                this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
                if (this.openFile.getPipeStream() == null) return this;
                this.openFile.getPipeStream().fclose();
                this.unregisterDescriptor(this.openFile.getPipeStream().getDescriptor().getFileno());
                this.openFile.setPipeStream(null);
                return this;
            }
            this.openFile.getMainStream().freopen(runtime2, path2, RubyIO.getIOModes(runtime2, this.openFile.getModeAsString(runtime2)));
            this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
            if (this.openFile.getPipeStream() == null) return this;
        }
        catch (PipeException pe) {
            throw runtime2.newErrnoEPIPEError();
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw runtime2.newErrnoEINVALError();
        }
        return this;
    }

    public static ModeFlags getIOModes(Ruby runtime2, String modesString) throws InvalidValueException {
        return new ModeFlags(RubyIO.getIOModesIntFromString(runtime2, modesString));
    }

    public static int getIOModesIntFromString(Ruby runtime2, String modesString) {
        int modes = 0;
        int length2 = modesString.length();
        if (length2 == 0) {
            throw runtime2.newArgumentError("illegal access mode");
        }
        switch (modesString.charAt(0)) {
            case 'r': {
                modes |= 0;
                break;
            }
            case 'a': {
                modes |= 0x109;
                break;
            }
            case 'w': {
                modes |= 0x301;
                break;
            }
            default: {
                throw runtime2.newArgumentError("illegal access mode " + modes);
            }
        }
        block10: for (int n = 1; n < length2; ++n) {
            switch (modesString.charAt(n)) {
                case 'b': {
                    modes |= 0x8000;
                    continue block10;
                }
                case '+': {
                    modes = modes & 0xFFFEFFFF | 2;
                    continue block10;
                }
                case ':': {
                    break block10;
                }
                default: {
                    throw runtime2.newArgumentError("illegal access mode " + modes);
                }
            }
        }
        return modes;
    }

    private static ByteList getSeparatorFromArgs(Ruby runtime2, IRubyObject[] args2, int idx) {
        ByteList separator;
        IRubyObject sepVal = args2.length > idx ? args2[idx] : runtime2.getRecordSeparatorVar().get();
        ByteList byteList = separator = sepVal.isNil() ? null : sepVal.convertToString().getByteList();
        if (separator != null && separator.realSize == 0) {
            separator = Stream.PARAGRAPH_DELIMETER;
        }
        return separator;
    }

    private ByteList getSeparatorForGets(Ruby runtime2, IRubyObject[] args2) {
        return RubyIO.getSeparatorFromArgs(runtime2, args2, 0);
    }

    public IRubyObject getline(Ruby runtime2, ByteList separator) {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime2);
            myOpenFile.setReadBuffered();
            boolean isParagraph = separator == Stream.PARAGRAPH_DELIMETER;
            ByteList byteList = separator = separator == Stream.PARAGRAPH_DELIMETER ? Stream.PARAGRAPH_SEPARATOR : separator;
            if (isParagraph) {
                this.swallow(10);
            }
            if (separator == null) {
                IRubyObject str = this.readAll(null);
                if (((RubyString)str).getByteList().length() == 0) {
                    return runtime2.getNil();
                }
                this.incrementLineno(runtime2, myOpenFile);
                return str;
            }
            if (separator.length() == 1) {
                return this.getlineFast(runtime2, separator.get(0));
            }
            Stream readStream = myOpenFile.getMainStream();
            int c = -1;
            int n = -1;
            int newline = separator.get(separator.length() - 1) & 0xFF;
            ByteList buf = new ByteList(0);
            boolean update2 = false;
            while (true) {
                block17: {
                    block18: {
                        block16: {
                            this.readCheck(readStream);
                            readStream.clearerr();
                            try {
                                n = readStream.getline(buf, (byte)newline);
                                c = buf.length() > 0 ? buf.get(buf.length() - 1) & 0xFF : -1;
                            }
                            catch (EOFException e) {
                                n = -1;
                            }
                            if (n != -1) break block16;
                            if (readStream.isBlocking() || !(readStream instanceof ChannelStream)) break block17;
                            if (!this.waitReadable(((ChannelStream)readStream).getDescriptor())) {
                                throw runtime2.newIOError("bad file descriptor: " + this.openFile.getPath());
                            }
                            break block18;
                        }
                        update2 = true;
                    }
                    if (c != newline) continue;
                }
                if (n == -1 || c == newline && buf.length() >= separator.length() && 0 == ByteList.memcmp(buf.unsafeBytes(), buf.begin + buf.realSize - separator.length(), separator.unsafeBytes(), separator.begin, separator.realSize)) break;
            }
            if (isParagraph && c != -1) {
                this.swallow(10);
            }
            if (!update2) {
                return runtime2.getNil();
            }
            this.incrementLineno(runtime2, myOpenFile);
            RubyString str = RubyString.newString(runtime2, buf);
            str.setTaint(true);
            return str;
        }
        catch (PipeException ex) {
            throw runtime2.newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (EOFException e) {
            return runtime2.getNil();
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime2.newIOError(e.getMessage());
        }
    }

    private void incrementLineno(Ruby runtime2, OpenFile myOpenFile) {
        int lineno2 = myOpenFile.getLineNumber() + 1;
        myOpenFile.setLineNumber(lineno2);
        runtime2.getGlobalVariables().set("$.", runtime2.newFixnum(lineno2));
        RubyNumeric.int2fix(runtime2, myOpenFile.getLineNumber());
    }

    protected boolean swallow(int term) throws IOException, BadDescriptorException {
        int c;
        Stream readStream = this.openFile.getMainStream();
        do {
            this.readCheck(readStream);
            try {
                c = readStream.fgetc();
            }
            catch (EOFException e) {
                c = -1;
            }
            if (c == term) continue;
            readStream.ungetc(c);
            return true;
        } while (c != -1);
        return false;
    }

    public static boolean restartSystemCall(Exception e) {
        return vendor.startsWith("Apple") && e.getMessage().equals(msgEINTR);
    }

    public IRubyObject getlineFast(Ruby runtime2, int delim) throws IOException, BadDescriptorException {
        Stream readStream = this.openFile.getMainStream();
        int c = -1;
        ByteList buf = new ByteList(0);
        boolean update2 = false;
        do {
            int n;
            this.readCheck(readStream);
            readStream.clearerr();
            try {
                n = readStream.getline(buf, (byte)delim);
                c = buf.length() > 0 ? buf.get(buf.length() - 1) & 0xFF : -1;
            }
            catch (EOFException e) {
                n = -1;
            }
            if (n == -1) {
                if (readStream.isBlocking() || !(readStream instanceof ChannelStream)) break;
                if (this.waitReadable(((ChannelStream)readStream).getDescriptor())) continue;
                throw runtime2.newIOError("bad file descriptor: " + this.openFile.getPath());
            }
            update2 = true;
        } while (c != delim);
        if (!update2) {
            return runtime2.getNil();
        }
        this.incrementLineno(runtime2, this.openFile);
        RubyString str = RubyString.newString(runtime2, buf);
        str.setTaint(true);
        return str;
    }

    @JRubyMethod(name={"new", "for_fd"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        if (block.isGiven()) {
            String className = klass.getName();
            context.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_NOT_ACCEPTED, className + "::new() does not take block; use " + className + "::open() instead", className + "::open()");
        }
        return klass.newInstance(context, args2, block);
    }

    private IRubyObject initializeCommon19(int fileno2, ModeFlags modes) {
        try {
            ChannelDescriptor descriptor = this.getDescriptorByFileno(fileno2);
            if (descriptor == null) {
                throw this.getRuntime().newErrnoEBADFError();
            }
            descriptor.checkOpen();
            if (modes == null) {
                modes = descriptor.getOriginalModes();
            }
            this.openFile.setMode(modes.getOpenFileFlags());
            this.openFile.setMainStream(this.fdopen(descriptor, modes));
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ive) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, Block unusedBlock) {
        return this.initializeCommon19(RubyNumeric.fix2int(fileNumber), null);
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, IRubyObject second, Block unusedBlock) {
        int fileno2 = RubyNumeric.fix2int(fileNumber);
        ModeFlags modes = second instanceof RubyHash ? null : this.parseModes(second);
        return this.initializeCommon19(fileno2, modes);
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject fileNumber, IRubyObject modeValue, IRubyObject options2, Block unusedBlock) {
        int fileno2 = RubyNumeric.fix2int(fileNumber);
        ModeFlags modes = this.parseModes(modeValue);
        return this.initializeCommon19(fileno2, modes);
    }

    private ModeFlags parseModes(IRubyObject arg2) {
        try {
            if (arg2 instanceof RubyFixnum) {
                return new ModeFlags(RubyFixnum.fix2long(arg2));
            }
            return RubyIO.getIOModes(this.getRuntime(), arg2.convertToString().toString());
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        int argCount = args2.length;
        int fileno2 = RubyNumeric.fix2int(args2[0]);
        try {
            ChannelDescriptor descriptor = this.getDescriptorByFileno(fileno2);
            if (descriptor == null) {
                throw this.getRuntime().newErrnoEBADFError();
            }
            descriptor.checkOpen();
            ModeFlags modes = argCount == 2 ? (args2[1] instanceof RubyFixnum ? new ModeFlags(RubyFixnum.fix2long(args2[1])) : RubyIO.getIOModes(this.getRuntime(), args2[1].convertToString().toString())) : descriptor.getOriginalModes();
            this.openFile.setMode(modes.getOpenFileFlags());
            this.openFile.setMainStream(this.fdopen(descriptor, modes));
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ive) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    protected Stream fdopen(ChannelDescriptor existingDescriptor, ModeFlags modes) throws InvalidValueException {
        if (existingDescriptor == null) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return ChannelStream.fdopen(this.getRuntime(), existingDescriptor, modes);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject external_encoding(ThreadContext context) {
        return context.getRuntime().getEncodingService().getEncoding(KCode.NONE.getEncoding()).asString();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject set_encoding(ThreadContext context, IRubyObject encodingString, IRubyObject internalEncoding, IRubyObject options2) {
        return context.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=1, optional=2, frame=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyClass klass = (RubyClass)recv2;
        RubyIO io2 = (RubyIO)klass.newInstance(context, args2, block);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, io2);
                return iRubyObject;
            }
            finally {
                block8: {
                    try {
                        io2.getMetaClass().finvoke(context, (IRubyObject)io2, "close", IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
                    }
                    catch (RaiseException re) {
                        RubyException rubyEx = re.getException();
                        if (rubyEx.kind_of_p(context, runtime2.getStandardError()).isTrue()) break block8;
                        throw re;
                    }
                }
            }
        }
        return io2;
    }

    @JRubyMethod(name={"sysopen"}, required=1, optional=2, frame=true, meta=true)
    public static IRubyObject sysopen(IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        RubyString pathString = args2[0].convertToString();
        runtime2.checkSafeString(pathString);
        String path2 = ((Object)pathString).toString();
        ModeFlags modes = null;
        int perms = -1;
        try {
            if (args2.length > 1) {
                RubyString modeString = args2[1].convertToString();
                modes = RubyIO.getIOModes(runtime2, ((Object)modeString).toString());
            } else {
                modes = RubyIO.getIOModes(runtime2, "r");
            }
            if (args2.length > 2) {
                RubyInteger permsInt = args2.length >= 3 ? args2[2].convertToInteger() : null;
                perms = RubyNumeric.fix2int(permsInt);
            }
        }
        catch (InvalidValueException e) {
            throw runtime2.newErrnoEINVALError();
        }
        int fileno2 = -1;
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.open(runtime2.getCurrentDirectory(), path2, modes, perms, runtime2.getPosix());
            runtime2.registerDescriptor(descriptor, true);
            fileno2 = descriptor.getFileno();
        }
        catch (FileNotFoundException fnfe) {
            throw runtime2.newErrnoENOENTError(path2);
        }
        catch (DirectoryAsFileException dafe) {
            throw runtime2.newErrnoEISDirError(path2);
        }
        catch (FileExistsException fee) {
            throw runtime2.newErrnoEEXISTError(path2);
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
        return runtime2.newFixnum(fileno2);
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        return this;
    }

    protected void checkInitialized() {
        if (this.openFile == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    protected void checkClosed() {
        if (this.openFile.getMainStream() == null && this.openFile.getPipeStream() == null) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        try {
            int read2;
            RubyString string2 = obj.asString();
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(runtime2);
            Stream writeStream = myOpenFile.getWriteStream();
            if (myOpenFile.isWriteBuffered()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.SYSWRITE_BUFFERED_IO, "syswrite for buffered IO", new Object[0]);
            }
            if (!writeStream.getDescriptor().isWritable()) {
                myOpenFile.checkClosed(runtime2);
            }
            if ((read2 = writeStream.getDescriptor().write(string2.getByteList())) == -1) {
                // empty if block
            }
            return runtime2.newFixnum(read2);
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw runtime2.newErrnoEPIPEError();
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime2.newSystemCallError(e.getMessage());
        }
    }

    @JRubyMethod(name={"write_nonblock"}, required=1)
    public IRubyObject write_nonblock(ThreadContext context, IRubyObject obj) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.checkWritable(context.getRuntime());
            RubyString str = obj.asString();
            if (str.getByteList().length() == 0) {
                return context.getRuntime().newFixnum(0);
            }
            if (myOpenFile.isWriteBuffered()) {
                context.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYSWRITE_BUFFERED_IO, "write_nonblock for buffered IO", new Object[0]);
            }
            int written = myOpenFile.getWriteStream().getDescriptor().write(str.getByteList());
            return context.getRuntime().newFixnum(written);
        }
        catch (IOException ex) {
            throw context.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw context.getRuntime().newErrnoEPIPEError();
        }
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        runtime2.secure(4);
        RubyString str = obj.asString();
        if (str.getByteList().length() == 0) {
            return runtime2.newFixnum(0);
        }
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(runtime2);
            int written = this.fwrite(str.getByteList());
            if (written == -1) {
                // empty if block
            }
            if (!myOpenFile.isSync()) {
                myOpenFile.setWriteBuffered();
            }
            return runtime2.newFixnum(written);
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw runtime2.newErrnoEPIPEError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean waitWritable(ChannelDescriptor descriptor) throws IOException {
        Channel channel = descriptor.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        SelectableChannel selectable = (SelectableChannel)channel;
        Selector selector = null;
        Object object = selectable.blockingLock();
        synchronized (object) {
            boolean oldBlocking = selectable.isBlocking();
            try {
                selector = Selector.open();
                selectable.configureBlocking(false);
                int real_ops = selectable.validOps() & 4;
                SelectionKey key2 = selectable.keyFor(selector);
                if (key2 == null) {
                    selectable.register(selector, real_ops, descriptor);
                } else {
                    key2.interestOps(key2.interestOps() | real_ops);
                }
                while (selector.select() == 0) {
                }
                for (SelectionKey skey : selector.selectedKeys()) {
                    if ((skey.interestOps() & skey.readyOps() & 4) == 0 || skey.attachment() != descriptor) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (selector != null) {
                    try {
                        selector.close();
                    }
                    catch (Exception e) {}
                }
                selectable.configureBlocking(oldBlocking);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean waitReadable(ChannelDescriptor descriptor) throws IOException {
        Channel channel = descriptor.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        SelectableChannel selectable = (SelectableChannel)channel;
        Selector selector = null;
        Object object = selectable.blockingLock();
        synchronized (object) {
            boolean oldBlocking = selectable.isBlocking();
            try {
                selector = Selector.open();
                selectable.configureBlocking(false);
                int real_ops = selectable.validOps() & 0x11;
                SelectionKey key2 = selectable.keyFor(selector);
                if (key2 == null) {
                    selectable.register(selector, real_ops, descriptor);
                } else {
                    key2.interestOps(key2.interestOps() | real_ops);
                }
                while (selector.select() == 0) {
                }
                for (SelectionKey skey : selector.selectedKeys()) {
                    if ((skey.interestOps() & skey.readyOps() & 0x11) == 0 || skey.attachment() != descriptor) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (selector != null) {
                    try {
                        selector.close();
                    }
                    catch (Exception e) {}
                }
                selectable.configureBlocking(oldBlocking);
            }
        }
    }

    protected int fwrite(ByteList buffer) {
        int offset2 = 0;
        boolean eagain = false;
        Stream writeStream = this.openFile.getWriteStream();
        int len = buffer.length();
        int n = len;
        if (n <= 0) {
            return n;
        }
        try {
            if (this.openFile.isSync()) {
                this.openFile.fflush(writeStream);
                while (offset2 < len) {
                    int l = n;
                    int r = writeStream.getDescriptor().write(buffer, offset2, l);
                    if (r == len) {
                        return len;
                    }
                    if (0 <= r) {
                        offset2 += r;
                        n -= r;
                        eagain = true;
                    }
                    if (eagain && this.waitWritable(writeStream.getDescriptor())) {
                        this.openFile.checkClosed(this.getRuntime());
                        if (offset2 >= buffer.length()) {
                            return -1;
                        }
                        eagain = false;
                        continue;
                    }
                    return -1;
                }
            }
            return writeStream.fwrite(buffer);
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_append(ThreadContext context, IRubyObject anObject) {
        this.callMethod(context, "write", anObject);
        return this;
    }

    @JRubyMethod(name={"fileno"}, alias={"to_i"})
    public RubyFixnum fileno(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getOpenFileChecked().getMainStream().getDescriptor().getFileno());
    }

    @JRubyMethod(name={"lineno"})
    public RubyFixnum lineno(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public RubyFixnum lineno_set(ThreadContext context, IRubyObject newLineNumber) {
        this.getOpenFileChecked().setLineNumber(RubyNumeric.fix2int(newLineNumber));
        return context.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"sync"})
    public RubyBoolean sync(ThreadContext context) {
        return context.getRuntime().newBoolean(this.getOpenFileChecked().getMainStream().isSync());
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid(ThreadContext context) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (myOpenFile.getProcess() == null) {
            return context.getRuntime().getNil();
        }
        long pid2 = myOpenFile.getPid();
        return context.getRuntime().newFixnum(pid2);
    }

    public boolean writeDataBuffered() {
        return this.openFile.getMainStream().writeDataBuffered();
    }

    @JRubyMethod(name={"pos", "tell"})
    public RubyFixnum pos(ThreadContext context) {
        try {
            return context.getRuntime().newFixnum(this.getOpenFileChecked().getMainStream().fgetpos());
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException bde) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"pos="}, required=1)
    public RubyFixnum pos_set(ThreadContext context, IRubyObject newPosition) {
        long offset2 = RubyNumeric.num2long(newPosition);
        if (offset2 < 0L) {
            throw context.getRuntime().newSystemCallError("Negative seek offset");
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.getMainStream().lseek(offset2, 0);
        }
        catch (BadDescriptorException e) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOError(e.getMessage());
        }
        myOpenFile.getMainStream().clearerr();
        return context.getRuntime().newFixnum(offset2);
    }

    @JRubyMethod(name={"print"}, rest=true, reads={FrameField.LASTLINE})
    public IRubyObject print(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{context.getCurrentScope().getLastLine(context.getRuntime())};
        }
        Ruby runtime2 = context.getRuntime();
        IRubyObject fs = runtime2.getGlobalVariables().get("$,");
        IRubyObject rs = runtime2.getGlobalVariables().get("$\\");
        for (int i = 0; i < args2.length; ++i) {
            if (i > 0 && !fs.isNil()) {
                this.callMethod(context, "write", fs);
            }
            if (args2[i].isNil()) {
                this.callMethod(context, "write", runtime2.newString("nil"));
                continue;
            }
            this.callMethod(context, "write", args2[i]);
        }
        if (!rs.isNil()) {
            this.callMethod(context, "write", rs);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        this.callMethod(context, "write", RubyKernel.sprintf(context, this, args2));
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1, backtrace=true)
    public IRubyObject putc(ThreadContext context, IRubyObject object) {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(context.getRuntime());
            Stream writeStream = myOpenFile.getWriteStream();
            writeStream.fputc(RubyNumeric.num2chr(object));
            if (myOpenFile.isSync()) {
                myOpenFile.fflush(writeStream);
            }
        }
        catch (IOException ex) {
            throw context.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException e) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw context.getRuntime().newErrnoEPIPEError();
        }
        return object;
    }

    public RubyFixnum seek(ThreadContext context, IRubyObject[] args2) {
        long offset2 = RubyNumeric.num2long(args2[0]);
        int whence = 0;
        if (args2.length > 1) {
            whence = RubyNumeric.fix2int(args2[1].convertToInteger());
        }
        return this.doSeek(context, offset2, whence);
    }

    @JRubyMethod(name={"seek"})
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0) {
        long offset2 = RubyNumeric.num2long(arg0);
        int whence = 0;
        return this.doSeek(context, offset2, whence);
    }

    @JRubyMethod(name={"seek"})
    public RubyFixnum seek(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        long offset2 = RubyNumeric.num2long(arg0);
        int whence = RubyNumeric.fix2int(arg1.convertToInteger());
        return this.doSeek(context, offset2, whence);
    }

    private RubyFixnum doSeek(ThreadContext context, long offset2, int whence) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.seek(offset2, whence);
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOError(e.getMessage());
        }
        myOpenFile.getMainStream().clearerr();
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"sysseek"}, required=1, optional=1)
    public RubyFixnum sysseek(ThreadContext context, IRubyObject[] args2) {
        long pos2;
        long offset2 = RubyNumeric.num2long(args2[0]);
        int whence = 0;
        if (args2.length > 1) {
            whence = RubyNumeric.fix2int(args2[1].convertToInteger());
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            if (myOpenFile.isReadable() && myOpenFile.isReadBuffered()) {
                throw context.getRuntime().newIOError("sysseek for buffered IO");
            }
            if (myOpenFile.isWritable() && myOpenFile.isWriteBuffered()) {
                context.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYSSEEK_BUFFERED_IO, "sysseek for buffered IO", new Object[0]);
            }
            pos2 = myOpenFile.getMainStream().getDescriptor().lseek(offset2, whence);
        }
        catch (BadDescriptorException ex) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOError(e.getMessage());
        }
        myOpenFile.getMainStream().clearerr();
        return context.getRuntime().newFixnum(pos2);
    }

    @JRubyMethod(name={"rewind"})
    public RubyFixnum rewind(ThreadContext context) {
        OpenFile myOpenfile = this.getOpenFileChecked();
        try {
            myOpenfile.getMainStream().lseek(0L, 0);
            myOpenfile.getMainStream().clearerr();
        }
        catch (BadDescriptorException e) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw context.getRuntime().newIOError(e.getMessage());
        }
        myOpenfile.setLineNumber(0);
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"fsync"})
    public RubyFixnum fsync(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(runtime2);
            myOpenFile.getWriteStream().sync();
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw runtime2.newErrnoEPIPEError();
        }
        catch (IOException e) {
            throw runtime2.newIOError(e.getMessage());
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        return RubyFixnum.zero(runtime2);
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject sync_set(IRubyObject newSync) {
        this.getOpenFileChecked().setSync(newSync.isTrue());
        this.getOpenFileChecked().getMainStream().setSync(newSync.isTrue());
        return this;
    }

    @JRubyMethod(name={"eof?", "eof"})
    public RubyBoolean eof_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(runtime2);
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStream().feof()) {
                return runtime2.getTrue();
            }
            if (myOpenFile.getMainStream().readDataBuffered()) {
                return runtime2.getFalse();
            }
            this.readCheck(myOpenFile.getMainStream());
            myOpenFile.getMainStream().clearerr();
            int c = myOpenFile.getMainStream().fgetc();
            if (c != -1) {
                myOpenFile.getMainStream().ungetc(c);
                return runtime2.getFalse();
            }
            myOpenFile.checkClosed(runtime2);
            myOpenFile.getMainStream().clearerr();
            return runtime2.getTrue();
        }
        catch (PipeException ex) {
            throw runtime2.newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime2.newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"tty?", "isatty"})
    public RubyBoolean tty_p(ThreadContext context) {
        return context.getRuntime().newBoolean(context.getRuntime().getPosix().isatty(this.getOpenFileChecked().getMainStream().getDescriptor().getFileDescriptor()));
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        Ruby runtime2 = this.getRuntime();
        if (this == original) {
            return this;
        }
        RubyIO originalIO = (RubyIO)TypeConverter.convertToTypeWithCheck(original, runtime2.getIO(), "to_io");
        OpenFile originalFile = originalIO.getOpenFileChecked();
        OpenFile newFile = this.openFile;
        try {
            originalFile.checkClosed(runtime2);
            if (originalFile.getPipeStream() != null) {
                originalFile.getPipeStream().fflush();
                originalFile.getMainStream().lseek(0L, 1);
            } else if (originalFile.isWritable()) {
                originalFile.getMainStream().fflush();
            } else {
                originalFile.getMainStream().lseek(0L, 1);
            }
            newFile.setMode(originalFile.getMode());
            newFile.setProcess(originalFile.getProcess());
            newFile.setLineNumber(originalFile.getLineNumber());
            newFile.setPath(originalFile.getPath());
            newFile.setFinalizer(originalFile.getFinalizer());
            ModeFlags modes = newFile.isReadable() ? (newFile.isWritable() ? (newFile.getPipeStream() != null ? new ModeFlags(0L) : new ModeFlags(2L)) : new ModeFlags(0L)) : (newFile.isWritable() ? new ModeFlags(1L) : originalFile.getMainStream().getModes());
            ChannelDescriptor descriptor = originalFile.getMainStream().getDescriptor().dup();
            newFile.setMainStream(ChannelStream.fdopen(runtime2, descriptor, modes));
            this.registerDescriptor(newFile.getMainStream().getDescriptor());
        }
        catch (IOException ex) {
            throw runtime2.newIOError("could not init copy: " + ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newIOError("could not init copy: " + ex);
        }
        catch (PipeException ex) {
            throw runtime2.newIOError("could not init copy: " + ex);
        }
        catch (InvalidValueException ex) {
            throw runtime2.newIOError("could not init copy: " + ex);
        }
        return this;
    }

    @JRubyMethod(name={"closed?"})
    public RubyBoolean closed_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isClosed());
    }

    public boolean isClosed() {
        return this.openFile.getMainStream() == null && this.openFile.getPipeStream() == null;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        Ruby runtime2 = this.getRuntime();
        if (runtime2.getSafeLevel() >= 4 && this.isTaint()) {
            throw runtime2.newSecurityError("Insecure: can't close");
        }
        this.openFile.checkClosed(runtime2);
        return this.close2(runtime2);
    }

    protected IRubyObject close2(Ruby runtime2) {
        if (this.openFile == null) {
            return runtime2.getNil();
        }
        this.interruptBlockingThreads();
        this.openFile.cleanup(runtime2, true);
        if (this.openFile.getProcess() != null) {
            try {
                this.openFile.getProcess().destroy();
                RubyProcess.RubyStatus processResult = RubyProcess.RubyStatus.newProcessStatus(runtime2, this.openFile.getProcess().waitFor());
                runtime2.getGlobalVariables().set("$?", processResult);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write(ThreadContext context) throws BadDescriptorException {
        try {
            if (context.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
                throw context.getRuntime().newSecurityError("Insecure: can't close");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isReadable()) {
                throw context.getRuntime().newIOError("closing non-duplex IO for writing");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getPipeStream().fclose();
                myOpenFile.setPipeStream(null);
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFD);
            }
        }
        catch (BadDescriptorException bde) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @JRubyMethod(name={"close_read"})
    public IRubyObject close_read(ThreadContext context) throws BadDescriptorException {
        Ruby runtime2 = context.getRuntime();
        try {
            if (runtime2.getSafeLevel() >= 4 && this.isTaint()) {
                throw runtime2.newSecurityError("Insecure: can't close");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isWritable()) {
                throw runtime2.newIOError("closing non-duplex IO for reading");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getMainStream().fclose();
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFE);
                myOpenFile.setMainStream(myOpenFile.getPipeStream());
                myOpenFile.setPipeStream(null);
            }
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
        return this;
    }

    @JRubyMethod(name={"flush"})
    public RubyIO flush() {
        try {
            this.getOpenFileChecked().getWriteStream().fflush();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return this;
    }

    @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        ByteList separator;
        Ruby runtime2 = context.getRuntime();
        IRubyObject result = this.getline(runtime2, separator = this.getSeparatorForGets(runtime2, args2));
        if (!result.isNil()) {
            context.getCurrentScope().setLastLine(result);
        }
        return result;
    }

    public boolean getBlocking() {
        return ((ChannelStream)this.openFile.getMainStream()).isBlocking();
    }

    @JRubyMethod(name={"fcntl"}, required=2)
    public IRubyObject fcntl(ThreadContext context, IRubyObject cmd, IRubyObject arg2) {
        return this.ctl(context.getRuntime(), cmd, arg2);
    }

    @JRubyMethod(name={"ioctl"}, required=1, optional=1)
    public IRubyObject ioctl(ThreadContext context, IRubyObject[] args2) {
        IRubyObject cmd = args2[0];
        IRubyObject arg2 = args2.length == 2 ? args2[1] : context.getRuntime().getNil();
        return this.ctl(context.getRuntime(), cmd, arg2);
    }

    public IRubyObject ctl(Ruby runtime2, IRubyObject cmd, IRubyObject arg2) {
        long realCmd = cmd.convertToInteger().getLongValue();
        long nArg = 0L;
        if (arg2.isNil() || arg2 == runtime2.getFalse()) {
            nArg = 0L;
        } else if (arg2 instanceof RubyFixnum) {
            nArg = RubyFixnum.fix2long(arg2);
        } else if (arg2 == runtime2.getTrue()) {
            nArg = 1L;
        } else {
            throw runtime2.newNotImplementedError("JRuby does not support string for second fcntl/ioctl argument yet");
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (realCmd == 1L) {
            boolean block = true;
            if ((nArg & 4L) == 4L) {
                block = false;
            }
            try {
                myOpenFile.getMainStream().setBlocking(block);
            }
            catch (IOException e) {
                throw runtime2.newIOError(e.getMessage());
            }
        } else {
            throw runtime2.newNotImplementedError("JRuby only supports F_SETFL for fcntl/ioctl currently");
        }
        return runtime2.newFixnum(0);
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        assert (runtime2.getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)runtime2.getGlobalVariables().getDefaultSeparator();
        if (args2.length == 0) {
            this.write(context, separator.getByteList());
            return runtime2.getNil();
        }
        for (int i = 0; i < args2.length; ++i) {
            ByteList line;
            if (args2[i].isNil()) {
                line = NIL_BYTELIST;
            } else if (runtime2.isInspecting(args2[i])) {
                line = RECURSIVE_BYTELIST;
            } else {
                if (args2[i] instanceof RubyArray) {
                    this.inspectPuts(context, (RubyArray)args2[i]);
                    continue;
                }
                line = args2[i].asString().getByteList();
            }
            this.write(context, line);
            if (line.length() != 0 && line.endsWith(separator.getByteList())) continue;
            this.write(context, separator.getByteList());
        }
        return runtime2.getNil();
    }

    protected void write(ThreadContext context, ByteList byteList) {
        this.callMethod(context, "write", RubyString.newStringShared(context.getRuntime(), byteList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectPuts(ThreadContext context, RubyArray array) {
        try {
            context.getRuntime().registerInspecting(array);
            IRubyObject iRubyObject = this.puts(context, array.toJavaArray());
            return iRubyObject;
        }
        finally {
            context.getRuntime().unregisterInspecting(array);
        }
    }

    @JRubyMethod(name={"readline"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line = this.gets(context, args2);
        if (line.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc() {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            myOpenFile.setReadBuffered();
            Stream stream = myOpenFile.getMainStream();
            this.readCheck(stream);
            stream.clearerr();
            int c = myOpenFile.getMainStream().fgetc();
            if (c == -1) {
                return this.getRuntime().getNil();
            }
            return this.getRuntime().newFixnum(c);
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    private void readCheck(Stream stream) {
        if (!stream.readDataBuffered()) {
            this.openFile.checkClosed(this.getRuntime());
        }
    }

    @JRubyMethod(name={"ungetc"}, required=1)
    public IRubyObject ungetc(IRubyObject number) {
        int ch = RubyNumeric.fix2int(number);
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (!myOpenFile.isReadBuffered()) {
            throw this.getRuntime().newIOError("unread stream");
        }
        try {
            myOpenFile.checkReadable(this.getRuntime());
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStream().ungetc(ch) == -1 && ch != -1) {
                throw this.getRuntime().newIOError("ungetc failed");
            }
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"read_nonblock"}, required=1, optional=1)
    public IRubyObject read_nonblock(ThreadContext context, IRubyObject[] args2) {
        IRubyObject value2 = this.getPartial(context, args2, true);
        if (value2.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return value2;
    }

    @JRubyMethod(name={"readpartial"}, required=1, optional=1)
    public IRubyObject readpartial(ThreadContext context, IRubyObject[] args2) {
        IRubyObject value2 = this.getPartial(context, args2, false);
        if (value2.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return value2;
    }

    private IRubyObject getPartial(ThreadContext context, IRubyObject[] args2, boolean isNonblocking) {
        Ruby runtime2 = context.getRuntime();
        int length2 = RubyNumeric.fix2int(args2[0]);
        if (length2 < 0) {
            throw runtime2.newArgumentError("negative length " + length2 + " given");
        }
        IRubyObject stringArg = args2.length > 1 ? args2[1] : RubyString.newEmptyString(runtime2);
        RubyString string2 = stringArg.isNil() ? RubyString.newEmptyString(runtime2) : stringArg.convertToString();
        this.openFile.checkClosed(runtime2);
        if (!(this.openFile.getMainStream() instanceof ChannelStream)) {
            throw runtime2.newNotImplementedError("readpartial only works with Nio based handlers");
        }
        try {
            ChannelStream stream = (ChannelStream)this.openFile.getMainStream();
            ByteList buf = isNonblocking ? stream.readnonblock(length2) : stream.readpartial(length2);
            boolean empty = buf == null || buf.length() == 0;
            string2.view(empty ? ByteList.EMPTY_BYTELIST : buf);
            if (stream.feof() && empty) {
                return runtime2.getNil();
            }
            return string2;
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw runtime2.newEOFError(e.getMessage());
        }
        catch (IOException e) {
            throw runtime2.newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"sysread"}, required=1, optional=1)
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args2) {
        int len = (int)RubyNumeric.num2long(args2[0]);
        if (len < 0) {
            throw this.getRuntime().newArgumentError("Negative size");
        }
        try {
            RubyString str;
            if (args2.length == 1 || args2[1].isNil()) {
                if (len == 0) {
                    RubyString rubyString = RubyString.newEmptyString(this.getRuntime());
                    return rubyString;
                }
                ByteList buffer = new ByteList(len);
                str = RubyString.newString(this.getRuntime(), buffer);
            } else {
                str = args2[1].convertToString();
                str.modify(len);
                if (len == 0) {
                    RubyString rubyString = str;
                    return rubyString;
                }
                ByteList buffer = str.getByteList();
                buffer.length(0);
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            if (myOpenFile.getMainStream().readDataBuffered()) {
                throw this.getRuntime().newIOError("sysread for buffered IO");
            }
            context.getThread().beforeBlockingCall();
            myOpenFile.checkClosed(this.getRuntime());
            int bytesRead = myOpenFile.getMainStream().getDescriptor().read(len, str.getByteList());
            if (bytesRead == -1 || bytesRead == 0 && len > 0) {
                throw this.getRuntime().newEOFError();
            }
            str.setTaint(true);
            RubyString rubyString = str;
            return rubyString;
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            if ("File not open".equals(e.getMessage())) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
            throw this.getRuntime().newSystemCallError(e.getMessage());
        }
        finally {
            context.getThread().afterBlockingCall();
        }
    }

    public IRubyObject read(IRubyObject[] args2) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        switch (args2.length) {
            case 0: {
                return this.read(context);
            }
            case 1: {
                return this.read(context, args2[0]);
            }
            case 2: {
                return this.read(context, args2[0], args2[1]);
            }
        }
        throw this.getRuntime().newArgumentError(args2.length, 2);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.checkReadable(runtime2);
            myOpenFile.setReadBuffered();
            return this.readAll(context.getRuntime().getNil());
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException ex) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject arg0) {
        if (arg0.isNil()) {
            return this.read(context);
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        int length2 = RubyNumeric.num2int(arg0);
        if (length2 < 0) {
            throw this.getRuntime().newArgumentError("negative length " + length2 + " given");
        }
        RubyString str = null;
        return this.readNotAll(context, myOpenFile, length2, str);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (arg0.isNil()) {
            try {
                myOpenFile.checkReadable(this.getRuntime());
                myOpenFile.setReadBuffered();
                return this.readAll(arg1);
            }
            catch (PipeException ex) {
                throw this.getRuntime().newErrnoEPIPEError();
            }
            catch (InvalidValueException ex) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (EOFException ex) {
                throw this.getRuntime().newEOFError();
            }
            catch (IOException ex) {
                throw this.getRuntime().newIOErrorFromException(ex);
            }
            catch (BadDescriptorException ex) {
                throw this.getRuntime().newErrnoEBADFError();
            }
        }
        int length2 = RubyNumeric.num2int(arg0);
        if (length2 < 0) {
            throw this.getRuntime().newArgumentError("negative length " + length2 + " given");
        }
        RubyString str = null;
        if (!arg1.isNil()) {
            str = arg1.convertToString();
            str.modify(length2);
            if (length2 == 0) {
                return str;
            }
        }
        return this.readNotAll(context, myOpenFile, length2, str);
    }

    private IRubyObject readNotAll(ThreadContext context, OpenFile myOpenFile, int length2, RubyString str) {
        Ruby runtime2 = context.getRuntime();
        try {
            myOpenFile.checkReadable(runtime2);
            myOpenFile.setReadBuffered();
            if (myOpenFile.getMainStream().feof()) {
                return runtime2.getNil();
            }
            this.readCheck(myOpenFile.getMainStream());
            ByteList newBuffer = myOpenFile.getMainStream().fread(length2);
            if (newBuffer == null || newBuffer.length() == 0) {
                if (myOpenFile.getMainStream() == null) {
                    return runtime2.getNil();
                }
                if (myOpenFile.getMainStream().feof()) {
                    if (str != null) {
                        str.setValue(ByteList.EMPTY_BYTELIST.dup());
                    }
                    return runtime2.getNil();
                }
            }
            if (str == null) {
                str = newBuffer == null ? RubyString.newEmptyString(runtime2) : RubyString.newString(runtime2, newBuffer);
            } else if (newBuffer == null) {
                str.empty();
            } else {
                str.setValue(newBuffer);
            }
            str.setTaint(true);
            return str;
        }
        catch (EOFException ex) {
            throw runtime2.newEOFError();
        }
        catch (PipeException ex) {
            throw runtime2.newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newErrnoEBADFError();
        }
    }

    protected IRubyObject readAll(IRubyObject buffer) throws BadDescriptorException, EOFException, IOException {
        Ruby runtime2 = this.getRuntime();
        RubyString str = null;
        if (buffer instanceof RubyString) {
            str = (RubyString)buffer;
        }
        if (this.openFile.getMainStream().readDataBuffered()) {
            this.openFile.checkClosed(runtime2);
        }
        ByteList newBuffer = this.openFile.getMainStream().readall();
        if (str == null) {
            str = newBuffer == null ? RubyString.newEmptyString(runtime2) : RubyString.newString(runtime2, newBuffer);
        } else if (newBuffer == null) {
            str.empty();
        } else {
            str.setValue(newBuffer);
        }
        str.taint(runtime2.getCurrentContext());
        return str;
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod
    public IRubyObject stat(ThreadContext context) {
        this.openFile.checkClosed(context.getRuntime());
        return context.getRuntime().newFileStat(this.getOpenFileChecked().getMainStream().getDescriptor().getFileDescriptor());
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public IRubyObject each_byte(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            while (true) {
                myOpenFile.checkReadable(runtime2);
                myOpenFile.setReadBuffered();
                int c = myOpenFile.getMainStream().fgetc();
                if (c == -1) break;
                assert (c < 256);
                block.yield(context, this.getRuntime().newFixnum(c));
            }
            return this;
        }
        catch (PipeException ex) {
            throw runtime2.newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (EOFException e) {
            return runtime2.getNil();
        }
        catch (IOException e) {
            throw runtime2.newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"each_byte"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_byte19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byte(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_byte");
    }

    @JRubyMethod(name={"each_line", "each"}, optional=1, frame=true)
    public RubyIO each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        ByteList separator = this.getSeparatorForGets(runtime2, args2);
        IRubyObject line = this.getline(runtime2, separator);
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.getline(runtime2, separator);
        }
        return this;
    }

    @JRubyMethod(name={"each"}, optional=1, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each19(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.each_line(context, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "each", args2);
    }

    @JRubyMethod(name={"each_line"}, optional=1, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_line19(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? this.each_line(context, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "each_line", args2);
    }

    @JRubyMethod(name={"readlines"}, optional=1)
    public RubyArray readlines(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line;
        IRubyObject[] iRubyObjectArray;
        Ruby runtime2 = context.getRuntime();
        if (args2.length > 0) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args2[0];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArgs = iRubyObjectArray;
        ByteList separator = this.getSeparatorForGets(runtime2, separatorArgs);
        RubyArray result = runtime2.newArray();
        while (!(line = this.getline(runtime2, separator)).isNil()) {
            result.append(line);
        }
        return result;
    }

    @JRubyMethod(name={"to_io"})
    public RubyIO to_io() {
        return this;
    }

    public String toString() {
        return "RubyIO(" + this.openFile.getMode() + ", " + this.openFile.getMainStream().getDescriptor().getFileno() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"foreach"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        int count2 = args2.length;
        RubyString filename2 = args2[0].convertToString();
        runtime2.checkSafeString(filename2);
        ByteList separator = RubyIO.getSeparatorFromArgs(runtime2, args2, 1);
        RubyIO io2 = (RubyIO)RubyFile.open(context, runtime2.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
        if (!io2.isNil()) {
            try {
                IRubyObject str = io2.getline(runtime2, separator);
                while (!str.isNil()) {
                    block.yield(context, str);
                    str = io2.getline(runtime2, separator);
                }
            }
            finally {
                io2.close();
            }
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"foreach"}, required=1, optional=1, frame=true, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject foreach19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyIO.foreach(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "foreach", args2);
    }

    private static RubyIO convertToIO(ThreadContext context, IRubyObject obj) {
        return (RubyIO)TypeConverter.convertToType(obj, context.getRuntime().getIO(), "to_io");
    }

    private static boolean registerSelect(ThreadContext context, Selector selector, IRubyObject obj, RubyIO ioObj, int ops) throws IOException {
        Channel channel = ioObj.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        ((SelectableChannel)channel).configureBlocking(false);
        int real_ops = ((SelectableChannel)channel).validOps() & ops;
        SelectionKey key2 = ((SelectableChannel)channel).keyFor(selector);
        if (key2 == null) {
            ((SelectableChannel)channel).register(selector, real_ops, obj);
        } else {
            key2.interestOps(key2.interestOps() | real_ops);
        }
        return true;
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, meta=true)
    public static IRubyObject select(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.select_static(context, context.getRuntime(), args2);
    }

    private static void checkArrayType(Ruby runtime2, IRubyObject obj) {
        if (!(obj instanceof RubyArray)) {
            throw runtime2.newTypeError("wrong argument type " + obj.getMetaClass().getName() + " (expected Array)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject select_static(ThreadContext context, Ruby runtime2, IRubyObject[] args2) {
        RubyArray rubyArray;
        Selector selector = null;
        try {
            RubyIO ioObj;
            HashSet<IRubyObject> pending = new HashSet<IRubyObject>();
            HashSet<IRubyObject> unselectable_reads = new HashSet<IRubyObject>();
            HashSet<IRubyObject> unselectable_writes = new HashSet<IRubyObject>();
            HashMap<RubyIO, Boolean> blocking = new HashMap<RubyIO, Boolean>();
            selector = Selector.open();
            if (!args2[0].isNil()) {
                RubyIO.checkArrayType(runtime2, args2[0]);
                for (IRubyObject obj : ((RubyArray)args2[0]).getList()) {
                    ioObj = RubyIO.convertToIO(context, obj);
                    if (ioObj.getChannel() instanceof SelectableChannel) {
                        blocking.put(ioObj, ((SelectableChannel)ioObj.getChannel()).isBlocking());
                    }
                    if (RubyIO.registerSelect(context, selector, obj, ioObj, 17)) {
                        if (!ioObj.writeDataBuffered()) continue;
                        pending.add(obj);
                        continue;
                    }
                    if ((ioObj.openFile.getMode() & 1) == 0) continue;
                    unselectable_reads.add(obj);
                }
            }
            if (args2.length > 1 && !args2[1].isNil()) {
                RubyIO.checkArrayType(runtime2, args2[1]);
                for (IRubyObject obj : ((RubyArray)args2[1]).getList()) {
                    ioObj = RubyIO.convertToIO(context, obj);
                    if (!blocking.containsKey(ioObj) && ioObj.getChannel() instanceof SelectableChannel) {
                        blocking.put(ioObj, ((SelectableChannel)ioObj.getChannel()).isBlocking());
                    }
                    if (RubyIO.registerSelect(context, selector, obj, ioObj, 4) || (ioObj.openFile.getMode() & 2) == 0) continue;
                    unselectable_writes.add(obj);
                }
            }
            if (args2.length > 2 && !args2[2].isNil()) {
                RubyIO.checkArrayType(runtime2, args2[2]);
            }
            boolean has_timeout = args2.length > 3 && !args2[3].isNil();
            long timeout2 = 0L;
            if (has_timeout) {
                IRubyObject timeArg = args2[3];
                if (timeArg instanceof RubyFloat) {
                    timeout2 = Math.round(((RubyFloat)timeArg).getDoubleValue() * 1000.0);
                } else if (timeArg instanceof RubyFixnum) {
                    timeout2 = Math.round(((RubyFixnum)timeArg).getDoubleValue() * 1000.0);
                } else {
                    throw runtime2.newTypeError("can't convert " + timeArg.getMetaClass().getName() + " into time interval");
                }
                if (timeout2 < 0L) {
                    throw runtime2.newArgumentError("negative timeout given");
                }
            }
            if (pending.isEmpty() && unselectable_reads.isEmpty() && unselectable_writes.isEmpty()) {
                if (has_timeout) {
                    if (timeout2 == 0L) {
                        selector.selectNow();
                    } else {
                        selector.select(timeout2);
                    }
                } else {
                    selector.select();
                }
            } else {
                selector.selectNow();
            }
            ArrayList<IRubyObject> r = new ArrayList<IRubyObject>();
            ArrayList<IRubyObject> w = new ArrayList<IRubyObject>();
            ArrayList<IRubyObject> e = new ArrayList<IRubyObject>();
            for (SelectionKey key2 : selector.selectedKeys()) {
                try {
                    int interestAndReady = key2.interestOps() & key2.readyOps();
                    if ((interestAndReady & 0x19) != 0) {
                        r.add((IRubyObject)key2.attachment());
                        pending.remove(key2.attachment());
                    }
                    if ((interestAndReady & 4) == 0) continue;
                    w.add((IRubyObject)key2.attachment());
                }
                catch (CancelledKeyException cke) {
                    pending.remove(key2.attachment());
                    e.add((IRubyObject)key2.attachment());
                }
            }
            r.addAll(pending);
            r.addAll(unselectable_reads);
            w.addAll(unselectable_writes);
            selector.close();
            for (Map.Entry blockingEntry : blocking.entrySet()) {
                SelectableChannel channel = (SelectableChannel)((RubyIO)blockingEntry.getKey()).getChannel();
                Object object = channel.blockingLock();
                synchronized (object) {
                    channel.configureBlocking((Boolean)blockingEntry.getValue());
                }
            }
            if (r.size() == 0 && w.size() == 0 && e.size() == 0) {
                IRubyObject i$ = runtime2.getNil();
                return i$;
            }
            ArrayList<IRubyObject> ret = new ArrayList<IRubyObject>();
            ret.add(RubyArray.newArray(runtime2, r));
            ret.add(RubyArray.newArray(runtime2, w));
            ret.add(RubyArray.newArray(runtime2, e));
            rubyArray = RubyArray.newArray(runtime2, ret);
        }
        catch (IOException e) {
            throw runtime2.newIOError(e.getMessage());
        }
        finally {
            if (selector != null) {
                try {
                    selector.close();
                }
                catch (Exception e) {}
            }
        }
        return rubyArray;
    }

    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                throw context.getRuntime().newArgumentError(0, 1);
            }
            case 1: {
                return RubyIO.read(context, recv2, args2[0], Block.NULL_BLOCK);
            }
            case 2: {
                return RubyIO.read(context, recv2, args2[0], args2[1]);
            }
            case 3: {
                return RubyIO.read(context, recv2, args2[0], args2[1], args2[2]);
            }
        }
        throw context.getRuntime().newArgumentError(args2.length, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true)
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block unusedBlock) {
        IRubyObject[] fileArguments = new IRubyObject[]{arg0};
        RubyIO file2 = (RubyIO)RubyKernel.open(context, recv2, fileArguments, Block.NULL_BLOCK);
        try {
            IRubyObject iRubyObject = file2.read(context);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true)
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject[] fileArguments = new IRubyObject[]{arg0};
        RubyIO file2 = (RubyIO)RubyKernel.open(context, recv2, fileArguments, Block.NULL_BLOCK);
        try {
            if (!arg1.isNil()) {
                IRubyObject iRubyObject = file2.read(context, arg1);
                return iRubyObject;
            }
            IRubyObject iRubyObject = file2.read(context);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, meta=true)
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject[] fileArguments = new IRubyObject[]{arg0};
        RubyIO file2 = (RubyIO)RubyKernel.open(context, recv2, fileArguments, Block.NULL_BLOCK);
        if (!arg2.isNil()) {
            file2.seek(context, arg2);
        }
        try {
            if (!arg1.isNil()) {
                IRubyObject iRubyObject = file2.read(context, arg1);
                return iRubyObject;
            }
            IRubyObject iRubyObject = file2.read(context);
            return iRubyObject;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"readlines"}, required=1, optional=1, meta=true)
    public static RubyArray readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        IRubyObject[] iRubyObjectArray;
        int count2 = args2.length;
        IRubyObject[] fileArguments = new IRubyObject[]{args2[0].convertToString()};
        if (count2 >= 2) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args2[1];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArguments = iRubyObjectArray;
        RubyIO file2 = (RubyIO)RubyKernel.open(context, recv2, fileArguments, Block.NULL_BLOCK);
        try {
            RubyArray rubyArray = file2.readlines(context, separatorArguments);
            return rubyArray;
        }
        finally {
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"popen"}, required=1, optional=1, meta=true)
    public static IRubyObject popen(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        ShellLauncher.POpenProcess process;
        Ruby runtime2;
        block9: {
            String[] tokens;
            runtime2 = context.getRuntime();
            RubyString cmdObj = null;
            cmdObj = Platform.IS_WINDOWS ? ((tokens = args2[0].convertToString().toString().split(" ", 2)).length > 1 ? new RubyString(runtime2, (RubyClass)recv2, tokens[0].replace('/', '\\') + tokens[1]) : new RubyString(runtime2, (RubyClass)recv2, tokens[0].replace('/', '\\'))) : args2[0].convertToString();
            runtime2.checkSafeString(cmdObj);
            if ("-".equals(((Object)cmdObj).toString())) {
                throw runtime2.newNotImplementedError("popen(\"-\") is unimplemented");
            }
            int mode2 = args2.length == 1 ? 0 : (args2[1] instanceof RubyFixnum ? RubyFixnum.num2int(args2[1]) : RubyIO.getIOModesIntFromString(runtime2, args2[1].convertToString().toString()));
            ModeFlags modes = new ModeFlags(mode2);
            process = ShellLauncher.popen(runtime2, cmdObj, modes);
            RubyIO io2 = new RubyIO(runtime2, process, modes);
            if (!block.isGiven()) return io2;
            try {
                iRubyObject = block.yield(context, io2);
                if (!io2.openFile.isOpen()) break block9;
                io2.close();
            }
            catch (Throwable throwable) {
                try {
                    if (io2.openFile.isOpen()) {
                        io2.close();
                    }
                    runtime2.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime2, process.waitFor() * 256));
                    throw throwable;
                }
                catch (InvalidValueException ex) {
                    throw runtime2.newErrnoEINVALError();
                }
                catch (IOException e) {
                    throw runtime2.newIOErrorFromException(e);
                }
                catch (InterruptedException e) {
                    throw runtime2.newThreadError("unexpected interrupt");
                }
            }
        }
        runtime2.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime2, process.waitFor() * 256));
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(required=1, rest=true, frame=true, meta=true)
    public static IRubyObject popen3(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        RubyIO error2;
        RubyIO output;
        ShellLauncher.POpenProcess process;
        Ruby runtime2;
        block11: {
            runtime2 = context.getRuntime();
            process = ShellLauncher.popen3(runtime2, args2);
            RubyIO input = process.getInput() != null ? new RubyIO(runtime2, process.getInput()) : new RubyIO(runtime2, process.getInputStream());
            output = process.getOutput() != null ? new RubyIO(runtime2, process.getOutput()) : new RubyIO(runtime2, process.getOutputStream());
            error2 = process.getError() != null ? new RubyIO(runtime2, process.getError()) : new RubyIO(runtime2, process.getErrorStream());
            input.getOpenFile().getMainStream().getDescriptor().setCanBeSeekable(false);
            output.getOpenFile().getMainStream().getDescriptor().setCanBeSeekable(false);
            error2.getOpenFile().getMainStream().getDescriptor().setCanBeSeekable(false);
            RubyArray yieldArgs = RubyArray.newArrayLight(runtime2, output, input, error2);
            if (!block.isGiven()) return yieldArgs;
            try {
                iRubyObject = block.yield(context, yieldArgs);
                if (!input.openFile.isOpen()) break block11;
                input.close();
            }
            catch (Throwable throwable) {
                try {
                    if (input.openFile.isOpen()) {
                        input.close();
                    }
                    if (output.openFile.isOpen()) {
                        output.close();
                    }
                    if (error2.openFile.isOpen()) {
                        error2.close();
                    }
                    runtime2.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime2, process.waitFor() * 256));
                    throw throwable;
                }
                catch (IOException e) {
                    throw runtime2.newIOErrorFromException(e);
                }
                catch (InterruptedException e) {
                    throw runtime2.newThreadError("unexpected interrupt");
                }
            }
        }
        if (output.openFile.isOpen()) {
            output.close();
        }
        if (error2.openFile.isOpen()) {
            error2.close();
        }
        runtime2.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime2, process.waitFor() * 256));
        return iRubyObject;
    }

    @JRubyMethod(name={"pipe"}, meta=true)
    public static IRubyObject pipe(ThreadContext context, IRubyObject recv2) throws Exception {
        Ruby runtime2 = context.getRuntime();
        Pipe pipe2 = Pipe.open();
        RubyIO source2 = new RubyIO(runtime2, pipe2.source());
        RubyIO sink = new RubyIO(runtime2, pipe2.sink());
        sink.openFile.getMainStream().setSync(true);
        return runtime2.newArrayNoCopy(source2, sink);
    }

    @JRubyMethod(name={"copy_stream"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject copy_stream(ThreadContext context, IRubyObject recv2, IRubyObject stream1, IRubyObject stream2) throws IOException {
        RubyIO io1 = (RubyIO)stream1;
        RubyIO io2 = (RubyIO)stream2;
        ChannelDescriptor d1 = io1.openFile.getMainStream().getDescriptor();
        if (!d1.isSeekable()) {
            throw context.getRuntime().newTypeError("only supports file-to-file copy");
        }
        ChannelDescriptor d2 = io2.openFile.getMainStream().getDescriptor();
        if (!d2.isSeekable()) {
            throw context.getRuntime().newTypeError("only supports file-to-file copy");
        }
        FileChannel f1 = (FileChannel)d1.getChannel();
        FileChannel f2 = (FileChannel)d2.getChannel();
        long size2 = f1.size();
        f1.transferTo(f2.position(), size2, f2);
        return context.getRuntime().newFixnum(size2);
    }

    public synchronized void addBlockingThread(RubyThread thread) {
        if (this.blockingThreads == null) {
            this.blockingThreads = new ArrayList<RubyThread>(1);
        }
        this.blockingThreads.add(thread);
    }

    public synchronized void removeBlockingThread(RubyThread thread) {
        if (this.blockingThreads == null) {
            return;
        }
        for (int i = 0; i < this.blockingThreads.size(); ++i) {
            if (this.blockingThreads.get(i) != thread) continue;
            this.blockingThreads.remove(i);
        }
    }

    protected synchronized void interruptBlockingThreads() {
        if (this.blockingThreads == null) {
            return;
        }
        for (int i = 0; i < this.blockingThreads.size(); ++i) {
            RubyThread thread = this.blockingThreads.get(i);
            thread.raise(new IRubyObject[]{this.getRuntime().newIOError("stream closed").getException()}, Block.NULL_BLOCK);
        }
    }

    static {
        String v = System.getProperty("java.vendor");
        vendor = v == null ? "" : v;
        msgEINTR = "Interrupted system call";
        NIL_BYTELIST = ByteList.create("nil");
        RECURSIVE_BYTELIST = ByteList.create("[...]");
    }
}

