/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaMethod
extends DynamicMethod
implements JumpTarget,
Cloneable {
    protected int arityValue;
    protected Arity arity;
    private String javaName;
    private boolean isSingleton;
    protected StaticScope staticScope;
    public static final Class[][] METHODS = new Class[][]{{JavaMethodZero.class, JavaMethodZeroOrOne.class, JavaMethodZeroOrOneOrTwo.class, JavaMethodZeroOrOneOrTwoOrThree.class}, {null, JavaMethodOne.class, JavaMethodOneOrTwo.class, JavaMethodOneOrTwoOrThree.class}, {null, null, JavaMethodTwo.class, JavaMethodTwoOrThree.class}, {null, null, null, JavaMethodThree.class}};
    public static final Class[][] REST_METHODS = new Class[][]{{JavaMethodZeroOrN.class, JavaMethodZeroOrOneOrN.class, JavaMethodZeroOrOneOrTwoOrN.class, JavaMethodZeroOrOneOrTwoOrThreeOrN.class}, {null, JavaMethodOneOrN.class, JavaMethodOneOrTwoOrN.class, JavaMethodOneOrTwoOrThreeOrN.class}, {null, null, JavaMethodTwoOrN.class, JavaMethodTwoOrThreeOrN.class}, {null, null, null, JavaMethodThreeOrN.class}};
    public static final Class[][] BLOCK_METHODS = new Class[][]{{JavaMethodZeroBlock.class, JavaMethodZeroOrOneBlock.class, JavaMethodZeroOrOneOrTwoBlock.class, JavaMethodZeroOrOneOrTwoOrThreeBlock.class}, {null, JavaMethodOneBlock.class, JavaMethodOneOrTwoBlock.class, JavaMethodOneOrTwoOrThreeBlock.class}, {null, null, JavaMethodTwoBlock.class, JavaMethodTwoOrThreeBlock.class}, {null, null, null, JavaMethodThreeBlock.class}};
    public static final Class[][] BLOCK_REST_METHODS = new Class[][]{{JavaMethodZeroOrNBlock.class, JavaMethodZeroOrOneOrNBlock.class, JavaMethodZeroOrOneOrTwoOrNBlock.class, JavaMethodZeroOrOneOrTwoOrThreeOrNBlock.class}, {null, JavaMethodOneOrNBlock.class, JavaMethodOneOrTwoOrNBlock.class, JavaMethodOneOrTwoOrThreeOrNBlock.class}, {null, null, JavaMethodTwoOrNBlock.class, JavaMethodTwoOrThreeOrNBlock.class}, {null, null, null, JavaMethodThreeOrNBlock.class}};

    public JavaMethod(RubyModule implementationClass, Visibility visibility) {
        this(implementationClass, visibility, CallConfiguration.FrameFullScopeNone);
    }

    public JavaMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
        super(implementationClass, visibility, callConfig);
    }

    protected JavaMethod() {
    }

    public void init(RubyModule implementationClass, Arity arity2, Visibility visibility, StaticScope staticScope, CallConfiguration callConfig) {
        this.staticScope = staticScope;
        this.arity = arity2;
        this.arityValue = arity2.getValue();
        super.init(implementationClass, visibility, callConfig);
    }

    public DynamicMethod dup() {
        try {
            JavaMethod msm = (JavaMethod)this.clone();
            return msm;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    protected final void preFrameAndScope(ThreadContext context, IRubyObject self, String name2, Block block) {
        context.preMethodFrameAndScope(this.implementationClass, name2, self, block, this.staticScope);
    }

    protected final void preFrameAndDummyScope(ThreadContext context, IRubyObject self, String name2, Block block) {
        context.preMethodFrameAndDummyScope(this.implementationClass, name2, self, block, this.staticScope);
    }

    protected final void preFrameOnly(ThreadContext context, IRubyObject self, String name2, Block block) {
        context.preMethodFrameOnly(this.implementationClass, name2, self, block);
    }

    protected final void preScopeOnly(ThreadContext context) {
        context.preMethodScopeOnly(this.implementationClass, this.staticScope);
    }

    protected final void preNoFrameDummyScope(ThreadContext context) {
        context.preMethodNoFrameAndDummyScope(this.implementationClass, this.staticScope);
    }

    protected final void preBacktraceOnly(ThreadContext context, String name2) {
        context.preMethodBacktraceOnly(name2);
    }

    protected final void preBacktraceDummyScope(ThreadContext context, String name2) {
        context.preMethodBacktraceDummyScope(this.implementationClass, name2, this.staticScope);
    }

    protected final void preBacktraceAndScope(ThreadContext context, String name2) {
        context.preMethodBacktraceAndScope(name2, this.implementationClass, this.staticScope);
    }

    protected final void preNoop() {
    }

    protected static final void postFrameAndScope(ThreadContext context) {
        context.postMethodFrameAndScope();
    }

    protected static final void postFrameOnly(ThreadContext context) {
        context.postMethodFrameOnly();
    }

    protected static final void postScopeOnly(ThreadContext context) {
        context.postMethodScopeOnly();
    }

    protected static final void postNoFrameDummyScope(ThreadContext context) {
        context.postMethodScopeOnly();
    }

    protected static final void postBacktraceOnly(ThreadContext context) {
        context.postMethodBacktraceOnly();
    }

    protected static final void postBacktraceDummyScope(ThreadContext context) {
        context.postMethodBacktraceDummyScope();
    }

    protected static final void postBacktraceAndScope(ThreadContext context) {
        context.postMethodBacktraceAndScope();
    }

    protected static final void postNoop(ThreadContext context) {
    }

    protected final void callTrace(ThreadContext context, String name2) {
        context.trace(RubyEvent.C_CALL, name2, this.getImplementationClass());
    }

    protected final void returnTrace(ThreadContext context, String name2) {
        context.trace(RubyEvent.C_CALL, name2, this.getImplementationClass());
    }

    public void setArity(Arity arity2) {
        this.arity = arity2;
        this.arityValue = arity2.getValue();
    }

    public Arity getArity() {
        return this.arity;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setSingleton(boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean isNative() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IRubyObject raiseArgumentError(JavaMethod method2, ThreadContext context, String name2, int given, int min2, int max2) {
        try {
            method2.preBacktraceOnly(context, name2);
            Arity.raiseArgumentError(context.getRuntime(), given, min2, max2);
        }
        finally {
            JavaMethod.postBacktraceOnly(context);
        }
        return context.getRuntime().getNil();
    }

    protected static void checkArgumentCount(JavaMethod method2, ThreadContext context, String name2, IRubyObject[] args2, int num) {
        if (args2.length != num) {
            JavaMethod.raiseArgumentError(method2, context, name2, args2.length, num, num);
        }
    }

    public static abstract class JavaMethodThree
    extends JavaMethodThreeOrN {
        public JavaMethodThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            if (args2.length != 3) {
                return JavaMethodThree.raiseArgumentError(this, context, name2, args2.length, 3, 3);
            }
            return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2]);
        }
    }

    public static abstract class JavaMethodTwoOrThree
    extends JavaMethodTwoOrThreeOrN {
        public JavaMethodTwoOrThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwoOrThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            switch (args2.length) {
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2]);
                }
            }
            return JavaMethodTwoOrThree.raiseArgumentError(this, context, name2, args2.length, 2, 3);
        }
    }

    public static abstract class JavaMethodTwo
    extends JavaMethodTwoOrN {
        public JavaMethodTwo(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwo(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            if (args2.length != 2) {
                return JavaMethodTwo.raiseArgumentError(this, context, name2, args2.length, 2, 2);
            }
            return this.call(context, self, clazz, name2, args2[0], args2[1]);
        }
    }

    public static abstract class JavaMethodOneOrTwoOrThree
    extends JavaMethodOneOrTwoOrThreeOrN {
        public JavaMethodOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            switch (args2.length) {
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2]);
                }
            }
            return JavaMethodOneOrTwoOrThree.raiseArgumentError(this, context, name2, args2.length, 1, 3);
        }
    }

    public static abstract class JavaMethodOneOrTwo
    extends JavaMethodOneOrTwoOrN {
        public JavaMethodOneOrTwo(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwo(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            switch (args2.length) {
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
            }
            return JavaMethodOneOrTwo.raiseArgumentError(this, context, name2, args2.length, 1, 2);
        }
    }

    public static abstract class JavaMethodOne
    extends JavaMethodOneOrN {
        public JavaMethodOne(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOne(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            if (args2.length != 1) {
                return JavaMethodOne.raiseArgumentError(this, context, name2, args2.length, 1, 1);
            }
            return this.call(context, self, clazz, name2, args2[0]);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThree
    extends JavaMethodZeroOrOneOrTwoOrThreeOrN {
        public JavaMethodZeroOrOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThree(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2]);
                }
            }
            return JavaMethodZeroOrOneOrTwoOrThree.raiseArgumentError(this, context, name2, args2.length, 0, 3);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwo
    extends JavaMethodZeroOrOneOrTwoOrN {
        public JavaMethodZeroOrOneOrTwo(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwo(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1]);
                }
            }
            return JavaMethodZeroOrOneOrTwo.raiseArgumentError(this, context, name2, args2.length, 0, 2);
        }
    }

    public static abstract class JavaMethodZeroOrOne
    extends JavaMethodZeroOrOneOrN {
        public JavaMethodZeroOrOne(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOne(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0]);
                }
            }
            return JavaMethodZeroOrOne.raiseArgumentError(this, context, name2, args2.length, 0, 1);
        }
    }

    public static abstract class JavaMethodZero
    extends JavaMethodZeroOrN {
        public JavaMethodZero(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZero(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
            if (args2.length != 0) {
                return JavaMethodZero.raiseArgumentError(this, context, name2, args2.length, 0, 0);
            }
            return this.call(context, self, clazz, name2);
        }
    }

    public static abstract class JavaMethodThreeOrN
    extends JavaMethodN {
        public JavaMethodThreeOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodThreeOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.call(context, self, clazz, name2, arg0, arg1, arg2);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);
    }

    public static abstract class JavaMethodTwoOrThreeOrN
    extends JavaMethodTwoOrN {
        public JavaMethodTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.call(context, self, clazz, name2, arg0, arg1, arg2);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);
    }

    public static abstract class JavaMethodTwoOrN
    extends JavaMethodN {
        public JavaMethodTwoOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwoOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return this.call(context, self, clazz, name2, arg0, arg1);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);
    }

    public static abstract class JavaMethodOneOrTwoOrThreeOrN
    extends JavaMethodOneOrTwoOrN {
        public JavaMethodOneOrTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.call(context, self, clazz, name2, arg0, arg1, arg2);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);
    }

    public static abstract class JavaMethodOneOrTwoOrN
    extends JavaMethodOneOrN {
        public JavaMethodOneOrTwoOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return this.call(context, self, clazz, name2, arg0, arg1);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);
    }

    public static abstract class JavaMethodOneOrN
    extends JavaMethodN {
        public JavaMethodOneOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
            return this.call(context, self, clazz, name2, arg0);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeOrN
    extends JavaMethodZeroOrOneOrTwoOrN {
        public JavaMethodZeroOrOneOrTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.call(context, self, clazz, name2, arg0, arg1, arg2);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrN
    extends JavaMethodZeroOrOneOrN {
        public JavaMethodZeroOrOneOrTwoOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return this.call(context, self, clazz, name2, arg0, arg1);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);
    }

    public static abstract class JavaMethodZeroOrOneOrN
    extends JavaMethodZeroOrN {
        public JavaMethodZeroOrOneOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
            return this.call(context, self, clazz, name2, arg0);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);
    }

    public static abstract class JavaMethodZeroOrN
    extends JavaMethodN {
        public JavaMethodZeroOrN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
            return this.call(context, self, clazz, name2);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);
    }

    public static abstract class JavaMethodN
    extends JavaMethodNBlock {
        public JavaMethodN(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodN(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
            return this.call(context, self, clazz, name2, IRubyObject.NULL_ARRAY);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
            return this.call(context, self, clazz, name2, new IRubyObject[]{arg0});
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1});
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.call(context, self, clazz, name2, new IRubyObject[]{arg0, arg1, arg2});
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return this.call(context, self, clazz, name2, args2);
        }
    }

    public static abstract class JavaMethodThreeBlock
    extends JavaMethodThreeOrNBlock {
        public JavaMethodThreeBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodThreeBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 3) {
                return JavaMethodThreeBlock.raiseArgumentError(this, context, name2, args2.length, 3, 3);
            }
            return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2], block);
        }
    }

    public static abstract class JavaMethodTwoOrThreeBlock
    extends JavaMethodTwoOrThreeOrNBlock {
        public JavaMethodTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], block);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2], block);
                }
            }
            return JavaMethodTwoOrThreeBlock.raiseArgumentError(this, context, name2, args2.length, 2, 3);
        }
    }

    public static abstract class JavaMethodTwoBlock
    extends JavaMethodTwoOrNBlock {
        public JavaMethodTwoBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwoBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 2) {
                return JavaMethodTwoBlock.raiseArgumentError(this, context, name2, args2.length, 2, 2);
            }
            return this.call(context, self, clazz, name2, args2[0], args2[1], block);
        }
    }

    public static abstract class JavaMethodOneOrTwoOrThreeBlock
    extends JavaMethodOneOrTwoOrThreeOrNBlock {
        public JavaMethodOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    throw context.getRuntime().newArgumentError(0, 1);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], block);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2], block);
                }
            }
            return JavaMethodOneOrTwoOrThreeBlock.raiseArgumentError(this, context, name2, args2.length, 3, 3);
        }
    }

    public static abstract class JavaMethodOneOrTwoBlock
    extends JavaMethodOneOrTwoOrNBlock {
        public JavaMethodOneOrTwoBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], block);
                }
            }
            return JavaMethodOneOrTwoBlock.raiseArgumentError(this, context, name2, args2.length, 1, 2);
        }
    }

    public static abstract class JavaMethodOneBlock
    extends JavaMethodOneOrNBlock {
        public JavaMethodOneBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 1) {
                return JavaMethodOneBlock.raiseArgumentError(this, context, name2, args2.length, 1, 1);
            }
            return this.call(context, self, clazz, name2, args2[0], block);
        }

        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeBlock
    extends JavaMethodZeroOrOneOrTwoOrThreeOrNBlock {
        public JavaMethodZeroOrOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2, block);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], block);
                }
                case 3: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], args2[2], block);
                }
            }
            return JavaMethodZeroOrOneOrTwoOrThreeBlock.raiseArgumentError(this, context, name2, args2.length, 0, 3);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoBlock
    extends JavaMethodZeroOrOneOrTwoOrNBlock {
        public JavaMethodZeroOrOneOrTwoBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2, block);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0], block);
                }
                case 2: {
                    return this.call(context, self, clazz, name2, args2[0], args2[1], block);
                }
            }
            return JavaMethodZeroOrOneOrTwoBlock.raiseArgumentError(this, context, name2, args2.length, 0, 2);
        }
    }

    public static abstract class JavaMethodZeroOrOneBlock
    extends JavaMethodZeroOrOneOrNBlock {
        public JavaMethodZeroOrOneBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            switch (args2.length) {
                case 0: {
                    return this.call(context, self, clazz, name2, block);
                }
                case 1: {
                    return this.call(context, self, clazz, name2, args2[0], block);
                }
            }
            return JavaMethodZeroOrOneBlock.raiseArgumentError(this, context, name2, args2.length, 0, 1);
        }
    }

    public static abstract class JavaMethodZeroBlock
    extends JavaMethodZeroOrNBlock {
        public JavaMethodZeroBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            if (args2.length != 0) {
                return JavaMethodZeroBlock.raiseArgumentError(this, context, name2, args2.length, 0, 0);
            }
            return this.call(context, self, clazz, name2, block);
        }
    }

    public static abstract class JavaMethodThreeOrNBlock
    extends JavaMethodNBlock {
        public JavaMethodThreeOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodThreeOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.call(context, self, clazz, name2, arg0, arg1, arg2, Block.NULL_BLOCK);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);
    }

    public static abstract class JavaMethodTwoOrThreeOrNBlock
    extends JavaMethodTwoOrNBlock {
        public JavaMethodTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.call(context, self, clazz, name2, arg0, arg1, arg2, Block.NULL_BLOCK);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);
    }

    public static abstract class JavaMethodTwoOrNBlock
    extends JavaMethodNBlock {
        public JavaMethodTwoOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodTwoOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
            return this.call(context, self, clazz, name2, arg0, arg1, Block.NULL_BLOCK);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);
    }

    public static abstract class JavaMethodOneOrTwoOrThreeOrNBlock
    extends JavaMethodOneOrTwoOrNBlock {
        public JavaMethodOneOrTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.call(context, self, clazz, name2, arg0, arg1, arg2, Block.NULL_BLOCK);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);
    }

    public static abstract class JavaMethodOneOrTwoOrNBlock
    extends JavaMethodOneOrNBlock {
        public JavaMethodOneOrTwoOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrTwoOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
            return this.call(context, self, clazz, name2, arg0, arg1, Block.NULL_BLOCK);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);
    }

    public static abstract class JavaMethodOneOrNBlock
    extends JavaMethodNBlock {
        public JavaMethodOneOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodOneOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
            return this.call(context, self, clazz, name2, arg0, Block.NULL_BLOCK);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeOrNBlock
    extends JavaMethodZeroOrOneOrTwoOrNBlock {
        public JavaMethodZeroOrOneOrTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.call(context, self, clazz, name2, arg0, arg1, arg2, Block.NULL_BLOCK);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrNBlock
    extends JavaMethodZeroOrOneOrNBlock {
        public JavaMethodZeroOrOneOrTwoOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
            return this.call(context, self, clazz, name2, arg0, arg1, Block.NULL_BLOCK);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);
    }

    public static abstract class JavaMethodZeroOrOneOrNBlock
    extends JavaMethodZeroOrNBlock {
        public JavaMethodZeroOrOneOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrOneOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
            return this.call(context, self, clazz, name2, arg0, Block.NULL_BLOCK);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);
    }

    public static abstract class JavaMethodZeroOrNBlock
    extends JavaMethodNBlock {
        public JavaMethodZeroOrNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodZeroOrNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
            return this.call(context, self, clazz, name2, Block.NULL_BLOCK);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);
    }

    public static abstract class JavaMethodNBlock
    extends JavaMethod {
        public JavaMethodNBlock(RubyModule implementationClass, Visibility visibility) {
            super(implementationClass, visibility);
        }

        public JavaMethodNBlock(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
            super(implementationClass, visibility, callConfig);
        }
    }
}

