/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Closure;
import com.kenai.jffi.ClosureManager;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.InvalidMemoryIO;
import org.jruby.ext.ffi.NativeParam;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class CallbackManager
extends org.jruby.ext.ffi.CallbackManager {
    private static final MemoryIO IO = MemoryIO.getInstance();
    private final Map<Object, Map<CallbackInfo, Callback>> callbackMap = new WeakHashMap<Object, Map<CallbackInfo, Callback>>();
    private final Map<CallbackInfo, ClosureInfo> infoMap = Collections.synchronizedMap(new WeakHashMap());

    public static RubyClass createCallbackClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("Callback", module.fastGetClass("Pointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(Callback.class);
        result.defineAnnotatedConstants(Callback.class);
        return result;
    }

    public static final CallbackManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Pointer getCallback(Ruby runtime2, CallbackInfo cbInfo, Object proc2) {
        Map<CallbackInfo, Callback> map;
        Map<Object, Map<CallbackInfo, Callback>> map2 = this.callbackMap;
        synchronized (map2) {
            Callback cb;
            map = this.callbackMap.get(proc2);
            if (map != null && (cb = map.get(cbInfo)) != null) {
                return cb;
            }
            map = Collections.synchronizedMap(new HashMap(2));
            this.callbackMap.put(proc2, map);
        }
        ClosureInfo info = this.infoMap.get(cbInfo);
        if (info == null) {
            CallingConvention convention = "stdcall".equals(null) ? CallingConvention.STDCALL : CallingConvention.DEFAULT;
            info = new ClosureInfo(cbInfo, convention);
            this.infoMap.put(cbInfo, info);
        }
        CallbackProxy cbProxy = new CallbackProxy(runtime2, cbInfo, proc2);
        Closure.Handle handle = ClosureManager.getInstance().newClosure(cbProxy, info.ffiReturnType, info.ffiParameterTypes, info.convention);
        Callback cb = new Callback(runtime2, handle, cbInfo, proc2);
        map.put(cbInfo, cb);
        return cb;
    }

    private static final Type getFFIType(NativeType type2) {
        switch (type2) {
            case VOID: {
                return Type.VOID;
            }
            case INT8: {
                return Type.SINT8;
            }
            case UINT8: {
                return Type.UINT8;
            }
            case INT16: {
                return Type.SINT16;
            }
            case UINT16: {
                return Type.UINT16;
            }
            case INT32: {
                return Type.SINT32;
            }
            case UINT32: {
                return Type.UINT32;
            }
            case INT64: {
                return Type.SINT64;
            }
            case UINT64: {
                return Type.UINT64;
            }
            case LONG: {
                return Platform.getPlatform().addressSize() == 32 ? Type.SINT32 : Type.SINT64;
            }
            case ULONG: {
                return Platform.getPlatform().addressSize() == 32 ? Type.UINT32 : Type.UINT64;
            }
            case FLOAT32: {
                return Type.FLOAT;
            }
            case FLOAT64: {
                return Type.DOUBLE;
            }
            case POINTER: {
                return Type.POINTER;
            }
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                return Type.POINTER;
            }
            case STRING: {
                return Type.POINTER;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type2);
    }

    private static final long longValue(IRubyObject value2) {
        if (value2 instanceof RubyNumeric) {
            return ((RubyNumeric)value2).getLongValue();
        }
        if (value2.isNil()) {
            return 0L;
        }
        return 0L;
    }

    private static final long addressValue(IRubyObject value2) {
        if (value2 instanceof RubyNumeric) {
            return ((RubyNumeric)value2).getLongValue();
        }
        if (value2 instanceof BasePointer) {
            return ((BasePointer)value2).getAddress();
        }
        if (value2.isNil()) {
            return 0L;
        }
        return 0L;
    }

    private static final void setReturnValue(Ruby runtime2, NativeType type2, Closure.Buffer buffer, IRubyObject value2) {
        switch (type2) {
            case VOID: {
                break;
            }
            case INT8: {
                buffer.setByteReturn((byte)CallbackManager.longValue(value2));
                break;
            }
            case UINT8: {
                buffer.setByteReturn((byte)CallbackManager.longValue(value2));
                break;
            }
            case INT16: {
                buffer.setShortReturn((short)CallbackManager.longValue(value2));
                break;
            }
            case UINT16: {
                buffer.setShortReturn((short)CallbackManager.longValue(value2));
                break;
            }
            case INT32: {
                buffer.setIntReturn((int)CallbackManager.longValue(value2));
                break;
            }
            case UINT32: {
                buffer.setIntReturn((int)CallbackManager.longValue(value2));
                break;
            }
            case INT64: {
                buffer.setLongReturn(Util.int64Value(value2));
                break;
            }
            case UINT64: {
                buffer.setLongReturn(Util.uint64Value(value2));
                break;
            }
            case FLOAT32: {
                buffer.setFloatReturn((float)RubyNumeric.num2dbl(value2));
                break;
            }
            case FLOAT64: {
                buffer.setDoubleReturn(RubyNumeric.num2dbl(value2));
                break;
            }
            case POINTER: {
                buffer.setAddressReturn(CallbackManager.addressValue(value2));
                break;
            }
        }
    }

    private static final IRubyObject fromNative(Ruby runtime2, NativeType type2, Closure.Buffer buffer, int index2) {
        switch (type2) {
            case VOID: {
                return runtime2.getNil();
            }
            case INT8: {
                return Util.newSigned8(runtime2, buffer.getByte(index2));
            }
            case UINT8: {
                return Util.newUnsigned8(runtime2, buffer.getByte(index2));
            }
            case INT16: {
                return Util.newSigned16(runtime2, buffer.getShort(index2));
            }
            case UINT16: {
                return Util.newUnsigned16(runtime2, buffer.getShort(index2));
            }
            case INT32: {
                return Util.newSigned32(runtime2, buffer.getInt(index2));
            }
            case UINT32: {
                return Util.newUnsigned32(runtime2, buffer.getInt(index2));
            }
            case INT64: {
                return Util.newSigned64(runtime2, buffer.getLong(index2));
            }
            case UINT64: {
                return Util.newUnsigned64(runtime2, buffer.getLong(index2));
            }
            case FLOAT32: {
                return runtime2.newFloat(buffer.getFloat(index2));
            }
            case FLOAT64: {
                return runtime2.newFloat(buffer.getDouble(index2));
            }
            case POINTER: {
                long address2 = buffer.getAddress(index2);
                return new BasePointer(runtime2, address2 != 0L ? new NativeMemoryIO(address2) : new NullMemoryIO(runtime2));
            }
            case STRING: {
                return CallbackManager.getStringParameter(runtime2, buffer, index2);
            }
        }
        throw new IllegalArgumentException("Invalid type " + type2);
    }

    private static final IRubyObject getStringParameter(Ruby runtime2, Closure.Buffer buffer, int index2) {
        long address2 = buffer.getAddress(index2);
        if (address2 == 0L) {
            return runtime2.getNil();
        }
        int len = (int)IO.getStringLength(address2);
        if (len == 0) {
            return RubyString.newEmptyString(runtime2);
        }
        byte[] bytes2 = new byte[len];
        IO.getByteArray(address2, bytes2, 0, len);
        RubyString s = RubyString.newStringShared(runtime2, bytes2);
        s.setTaint(true);
        return s;
    }

    static final class CallbackMemoryIO
    extends InvalidMemoryIO
    implements DirectMemoryIO {
        private final Closure.Handle handle;

        public CallbackMemoryIO(Ruby runtime2, Closure.Handle handle) {
            super(runtime2);
            this.handle = handle;
        }

        public final long getAddress() {
            return this.handle.getAddress();
        }

        public final boolean isNull() {
            return false;
        }

        public final boolean isDirect() {
            return true;
        }
    }

    private static final class CallbackProxy
    implements Closure {
        private final Ruby runtime;
        private final CallbackInfo cbInfo;
        private final WeakReference<Object> proc;
        private final NativeParam[] parameterTypes;
        private final NativeType returnType;

        CallbackProxy(Ruby runtime2, CallbackInfo cbInfo, Object proc2) {
            this.runtime = runtime2;
            this.cbInfo = cbInfo;
            this.proc = new WeakReference<Object>(proc2);
            this.parameterTypes = cbInfo.getParameterTypes();
            this.returnType = cbInfo.getReturnType();
        }

        public void invoke(Closure.Buffer buffer) {
            Object recv2 = this.proc.get();
            if (recv2 == null) {
                buffer.setIntReturn(0);
                return;
            }
            IRubyObject[] params2 = new IRubyObject[this.parameterTypes.length];
            for (int i = 0; i < params2.length; ++i) {
                params2[i] = CallbackManager.fromNative(this.runtime, (NativeType)this.parameterTypes[i], buffer, i);
            }
            IRubyObject retVal = recv2 instanceof RubyProc ? ((RubyProc)recv2).call(this.runtime.getCurrentContext(), params2) : ((Block)recv2).call(this.runtime.getCurrentContext(), params2);
            CallbackManager.setReturnValue(this.runtime, this.cbInfo.getReturnType(), buffer, retVal);
        }
    }

    @JRubyClass(name={"FFI::Callback"}, parent="FFI::BasePointer")
    static class Callback
    extends BasePointer {
        private final CallbackInfo cbInfo;
        private final Object proc;

        Callback(Ruby runtime2, Closure.Handle handle, CallbackInfo cbInfo, Object proc2) {
            super(runtime2, FFIProvider.getModule(runtime2).fastGetClass("Callback"), new CallbackMemoryIO(runtime2, handle), Long.MAX_VALUE);
            this.cbInfo = cbInfo;
            this.proc = proc2;
        }
    }

    private static class ClosureInfo {
        private final CallbackInfo cbInfo;
        private final CallingConvention convention;
        private final NativeType[] parameterTypes;
        private final Type[] ffiParameterTypes;
        private final Type ffiReturnType;

        public ClosureInfo(CallbackInfo cbInfo, CallingConvention convention) {
            this.cbInfo = cbInfo;
            this.convention = convention;
            NativeParam[] nativeParams = cbInfo.getParameterTypes();
            this.ffiParameterTypes = new Type[nativeParams.length];
            this.parameterTypes = new NativeType[nativeParams.length];
            block6: for (int i = 0; i < nativeParams.length; ++i) {
                if (!(nativeParams[i] instanceof NativeType)) {
                    throw new RuntimeException("Invalid callback parameter type: " + nativeParams[i]);
                }
                switch ((NativeType)nativeParams[i]) {
                    case INT8: 
                    case UINT8: 
                    case INT16: 
                    case UINT16: 
                    case INT32: 
                    case UINT32: 
                    case LONG: 
                    case ULONG: 
                    case INT64: 
                    case UINT64: 
                    case FLOAT32: 
                    case FLOAT64: 
                    case POINTER: 
                    case STRING: {
                        this.ffiParameterTypes[i] = CallbackManager.getFFIType((NativeType)nativeParams[i]);
                        this.parameterTypes[i] = (NativeType)nativeParams[i];
                        continue block6;
                    }
                    default: {
                        throw new RuntimeException("Invalid callback parameter type: " + nativeParams[i]);
                    }
                }
            }
            switch (cbInfo.getReturnType()) {
                case INT8: 
                case UINT8: 
                case INT16: 
                case UINT16: 
                case INT32: 
                case UINT32: 
                case LONG: 
                case ULONG: 
                case INT64: 
                case UINT64: 
                case FLOAT32: 
                case FLOAT64: 
                case POINTER: 
                case VOID: {
                    this.ffiReturnType = CallbackManager.getFFIType(cbInfo.getReturnType());
                    break;
                }
                default: {
                    throw cbInfo.getRuntime().newArgumentError("Invalid callback return type: " + cbInfo.getReturnType());
                }
            }
        }
    }

    private static final class SingletonHolder {
        static final CallbackManager INSTANCE = new CallbackManager();

        private SingletonHolder() {
        }
    }
}

